/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.userManagement.persistence.license;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jetbrains.exodus.query.NodeBase;
import jetbrains.jetpass.userManagement.persistence.dnq.XdLicenseSettings;
import jetbrains.jetpass.userManagement.persistence.dnq.XdRoots;
import jetbrains.jetpass.userManagement.persistence.dnq.XdService;
import jetbrains.jetpass.userManagement.persistence.license.HostLicenseChecker;
import jetbrains.jetpass.userManagement.persistence.license.HubApplicationDescriptor;
import jetbrains.jetpass.userManagement.persistence.license.HubLicenseCache$checkUniqueness$1;
import jetbrains.jetpass.userManagement.persistence.license.HubLicenseCache$checkUniqueness$2;
import jetbrains.jetpass.userManagement.persistence.license.NotUniqueLicenseException;
import jetbrains.jetpass.userManagement.persistence.license.ServiceApplicationDescriptor;
import jetbrains.jetpass.userManagement.persistence.license.ServiceLicenseChecker;
import jetbrains.ring.license.InvalidLicenseException;
import jetbrains.ring.license.License;
import jetbrains.ring.license.LicenseType;
import jetbrains.ring.license.reader.EmptyLicenseKeyException;
import jetbrains.ring.license.reader.LicenseReadException;
import jetbrains.ring.license.reader.LicenseReader;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty1;
import kotlinx.dnq.XdEntityType;
import kotlinx.dnq.query.NodeBaseOperationsKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import kotlinx.dnq.util.ReflectionUtilKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J \u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u0012H\u0002J\b\u0010\u001d\u001a\u00020\u0015H\u0002J\u000e\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\u0012J\u0018\u0010 \u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u0012H\u0014J\"\u0010!\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00132\b\u0010\u001c\u001a\u0004\u0018\u00010\u0012J\u0010\u0010\"\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u000e\u0010#\u001a\u00020$2\u0006\u0010\u0019\u001a\u00020\u001aR\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Ljetbrains/jetpass/userManagement/persistence/license/HubLicenseCache;", "", "hubApplicationDescriptor", "Ljetbrains/jetpass/userManagement/persistence/license/HubApplicationDescriptor;", "(Ljetbrains/jetpass/userManagement/persistence/license/HubApplicationDescriptor;)V", "hostLicenseChecker", "Ljetbrains/jetpass/userManagement/persistence/license/HostLicenseChecker;", "getHostLicenseChecker", "()Ljetbrains/jetpass/userManagement/persistence/license/HostLicenseChecker;", "getHubApplicationDescriptor", "()Ljetbrains/jetpass/userManagement/persistence/license/HubApplicationDescriptor;", "isHubLicenseValid", "", "()Z", "licenseReader", "Ljetbrains/ring/license/reader/LicenseReader;", "licenses", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Ljetbrains/ring/license/License;", "applyConstraints", "", "licenseSettings", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdLicenseSettings;", "checkLicense", "service", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdService;", "license", "licenseKey", "checkUniqueness", "clearCache", "id", "createHostLicenseChecker", "getInvalidityReason", "getLicense", "getServiceApplicationDescriptor", "Ljetbrains/jetpass/userManagement/persistence/license/ServiceApplicationDescriptor;", "jetbrains.jetpass.userManagement"})
public class HubLicenseCache {
    private final ConcurrentHashMap<String, License> licenses;
    private final LicenseReader licenseReader;
    @NotNull
    private final HubApplicationDescriptor hubApplicationDescriptor;

    @NotNull
    public HostLicenseChecker getHostLicenseChecker() throws InvalidLicenseException {
        XdLicenseSettings settings = XdRoots.INSTANCE.getHubLicense();
        License license2 = this.getLicense(settings);
        String string = settings.getLicenseKey();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return this.createHostLicenseChecker(license2, string);
    }

    public final boolean isHubLicenseValid() {
        boolean bl;
        try {
            this.getHostLicenseChecker().checkBasicValidity();
            bl = true;
        }
        catch (InvalidLicenseException e) {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public License getLicense(@NotNull XdLicenseSettings licenseSettings) throws LicenseReadException {
        Intrinsics.checkParameterIsNotNull((Object)((Object)licenseSettings), (String)"licenseSettings");
        String id = licenseSettings.getUuid();
        String name2 = licenseSettings.getLicenseName();
        String key2 = licenseSettings.getLicenseKey();
        License license2 = this.licenses.get(id);
        if (license2 == null) {
            HubLicenseCache hubLicenseCache;
            HubLicenseCache $receiver = hubLicenseCache = this;
            License newLicense = $receiver.licenseReader.read(name2, key2);
            License prevLicense = $receiver.licenses.putIfAbsent(id, newLicense);
            License license3 = prevLicense;
            if (license3 == null) {
                license3 = newLicense;
            }
            license2 = license3;
            Intrinsics.checkExpressionValueIsNotNull((Object)license3, (String)"run {\n            val ne\u2026e ?: newLicense\n        }");
        }
        return license2;
    }

    @NotNull
    public final ServiceApplicationDescriptor getServiceApplicationDescriptor(@NotNull XdService service2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)service2), (String)"service");
        return new ServiceApplicationDescriptor(service2, this.hubApplicationDescriptor.isHosted());
    }

    public final void clearCache(@NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        this.licenses.remove(id);
    }

    @Nullable
    public final String getInvalidityReason(@NotNull XdService service2, @NotNull License license2, @Nullable String licenseKey) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)((Object)service2), (String)"service");
        Intrinsics.checkParameterIsNotNull((Object)license2, (String)"license");
        try {
            if (licenseKey == null) {
                throw (Throwable)new EmptyLicenseKeyException();
            }
            this.checkLicense(service2, license2, licenseKey);
            string = null;
        }
        catch (InvalidLicenseException e) {
            string = e.getMessage();
        }
        return string;
    }

    private final void checkLicense(XdService service2, License license2, String licenseKey) throws InvalidLicenseException {
        boolean isHostLicense = Intrinsics.areEqual((Object)((Object)service2), (Object)((Object)XdRoots.INSTANCE.getRootService().getHostService()));
        if (isHostLicense) {
            HostLicenseChecker licenseChecker = this.createHostLicenseChecker(license2, licenseKey);
            licenseChecker.checkBasicValidity();
        } else {
            ServiceApplicationDescriptor descriptor2 = this.getServiceApplicationDescriptor(service2);
            ServiceLicenseChecker licenseChecker = new ServiceLicenseChecker(license2, licenseKey, descriptor2);
            licenseChecker.checkProduct();
            licenseChecker.checkExpiration();
            licenseChecker.checkUpgradeExpiration();
            licenseChecker.checkNumberOfUsersIsNotExceeded();
        }
    }

    public void checkLicense(@NotNull XdLicenseSettings licenseSettings) throws InvalidLicenseException {
        Intrinsics.checkParameterIsNotNull((Object)((Object)licenseSettings), (String)"licenseSettings");
        XdService service2 = licenseSettings.getService();
        String name2 = licenseSettings.getLicenseName();
        String string = licenseSettings.getLicenseKey();
        if (string == null) {
            throw (Throwable)new EmptyLicenseKeyException();
        }
        String key2 = string;
        License license2 = this.licenseReader.read(name2, key2);
        this.checkUniqueness();
        boolean isHostLicense = Intrinsics.areEqual((Object)((Object)service2), (Object)((Object)XdRoots.INSTANCE.getRootService().getHostService()));
        if (isHostLicense) {
            License license3 = license2;
            Intrinsics.checkExpressionValueIsNotNull((Object)license3, (String)"license");
            HostLicenseChecker licenseChecker = this.createHostLicenseChecker(license3, key2);
            licenseChecker.checkProduct();
        } else {
            ServiceApplicationDescriptor descriptor2 = this.getServiceApplicationDescriptor(service2);
            License license4 = license2;
            Intrinsics.checkExpressionValueIsNotNull((Object)license4, (String)"license");
            ServiceLicenseChecker licenseChecker = new ServiceLicenseChecker(license4, key2, descriptor2);
            licenseChecker.checkProduct();
        }
    }

    public void applyConstraints(@NotNull XdLicenseSettings licenseSettings) throws InvalidLicenseException {
        Intrinsics.checkParameterIsNotNull((Object)((Object)licenseSettings), (String)"licenseSettings");
        XdService service2 = licenseSettings.getService();
        String name2 = licenseSettings.getLicenseName();
        String string = licenseSettings.getLicenseKey();
        if (string == null) {
            throw (Throwable)new EmptyLicenseKeyException();
        }
        String key2 = string;
        License license2 = this.licenseReader.read(name2, key2);
        boolean isHostLicense = Intrinsics.areEqual((Object)((Object)service2), (Object)((Object)XdRoots.INSTANCE.getRootService().getHostService()));
        if (isHostLicense) {
            License license3 = license2;
            Intrinsics.checkExpressionValueIsNotNull((Object)license3, (String)"license");
            this.hubApplicationDescriptor.applyConstraints(license3);
        } else {
            ServiceApplicationDescriptor descriptor2 = this.getServiceApplicationDescriptor(service2);
            License license4 = license2;
            Intrinsics.checkExpressionValueIsNotNull((Object)license4, (String)"license");
            descriptor2.applyConstraints(license4);
        }
    }

    private final void checkUniqueness() {
        Comparable value$iv;
        KProperty1 $receiver$iv;
        HashMap key2uuid = new HashMap();
        KProperty1 kProperty1 = (KProperty1)HubLicenseCache$checkUniqueness$1.INSTANCE;
        Iterator iterator = null;
        XdEntityType xdEntityType = (XdEntityType)XdLicenseSettings.Companion;
        NodeBase nodeBase = NodeBaseOperationsKt.ne((String)ReflectionUtilKt.getDBName((KProperty1)$receiver$iv, (KClass)Reflection.getOrCreateKotlinClass(XdLicenseSettings.class)), (Comparable)value$iv);
        $receiver$iv = (KProperty1)HubLicenseCache$checkUniqueness$2.INSTANCE;
        value$iv = null;
        NodeBase nodeBase2 = NodeBaseOperationsKt.ne((String)ReflectionUtilKt.getDBName((KProperty1)$receiver$iv, (KClass)Reflection.getOrCreateKotlinClass(XdLicenseSettings.class)), value$iv);
        $receiver$iv = XdQueryKt.asSequence((XdQuery)XdQueryKt.query((XdEntityType)xdEntityType, (NodeBase)NodeBaseOperationsKt.and((NodeBase)nodeBase, (NodeBase)nodeBase2)));
        for (Object element$iv : $receiver$iv) {
            String key2;
            License info;
            XdLicenseSettings thisLicense = (XdLicenseSettings)((Object)element$iv);
            if (thisLicense.getLicenseKey() == null) {
                Intrinsics.throwNpe();
            }
            License license2 = info = this.licenseReader.read(thisLicense.getLicenseName(), key2);
            Intrinsics.checkExpressionValueIsNotNull((Object)license2, (String)"info");
            if (license2.getLicenseType() == LicenseType.FREE || info.getLicenseType() == LicenseType.TRIAL) continue;
            XdLicenseSettings thatLicense = (XdLicenseSettings)((Object)key2uuid.get(key2));
            if (thatLicense == null) {
                Map map = key2uuid;
                XdLicenseSettings xdLicenseSettings = thisLicense;
                map.put(key2, xdLicenseSettings);
                continue;
            }
            throw (Throwable)((Object)new NotUniqueLicenseException(thisLicense.getService().getName(), thisLicense.getService().getHomeUrl(), thatLicense.getService().getName(), thatLicense.getService().getHomeUrl()));
        }
    }

    @NotNull
    protected HostLicenseChecker createHostLicenseChecker(@NotNull License license2, @NotNull String licenseKey) {
        Intrinsics.checkParameterIsNotNull((Object)license2, (String)"license");
        Intrinsics.checkParameterIsNotNull((Object)licenseKey, (String)"licenseKey");
        return new HostLicenseChecker(license2, licenseKey, this.hubApplicationDescriptor);
    }

    @NotNull
    public final HubApplicationDescriptor getHubApplicationDescriptor() {
        return this.hubApplicationDescriptor;
    }

    public HubLicenseCache(@NotNull HubApplicationDescriptor hubApplicationDescriptor) {
        Intrinsics.checkParameterIsNotNull((Object)hubApplicationDescriptor, (String)"hubApplicationDescriptor");
        this.hubApplicationDescriptor = hubApplicationDescriptor;
        this.licenses = new ConcurrentHashMap();
        this.licenseReader = new LicenseReader();
    }
}

