/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.userManagement.persistence.license;

import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.jetpass.dnq.TransactionKt;
import jetbrains.jetpass.userManagement.persistence.dnq.XdBaseUser;
import jetbrains.jetpass.userManagement.persistence.dnq.XdLicenseSettings;
import jetbrains.jetpass.userManagement.persistence.dnq.XdService;
import jetbrains.jetpass.userManagement.persistence.license.HistoricalReleaseDateUtilKt;
import jetbrains.jetpass.userManagement.persistence.license.LicenseExtensionKt;
import jetbrains.ring.license.BuildStatus;
import jetbrains.ring.license.License;
import jetbrains.ring.license.Product;
import jetbrains.ring.license.checker.ApplicationDescriptor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdEntityType;
import kotlinx.dnq.query.XdMutableQuery;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\u0018\u0000 #2\u00020\u0001:\u0001#B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0010H\u0016J\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017J\b\u0010\u0019\u001a\u00020\u0015H\u0016J\b\u0010\u001a\u001a\u00020\u0010H\u0016J\b\u0010\u001b\u001a\u00020\u0010H\u0016J\n\u0010\u001c\u001a\u0004\u0018\u00010\bH\u0016J\b\u0010\u001d\u001a\u00020\u0010H\u0016J\b\u0010\u001e\u001a\u00020\u0015H\u0016J\b\u0010\u001f\u001a\u00020\u0010H\u0016J\b\u0010 \u001a\u00020\u0005H\u0016J\u0010\u0010!\u001a\u00020\f2\u0006\u0010\"\u001a\u00020\u0010H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006$"}, d2={"Ljetbrains/jetpass/userManagement/persistence/license/ServiceApplicationDescriptor;", "Ljetbrains/ring/license/checker/ApplicationDescriptor;", "service", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdService;", "hosted", "", "(Ljetbrains/jetpass/userManagement/persistence/dnq/XdService;Z)V", "product", "Ljetbrains/ring/license/Product;", "getService", "()Ljetbrains/jetpass/userManagement/persistence/dnq/XdService;", "applyConstraints", "", "license", "Ljetbrains/ring/license/License;", "getBuildNumber", "", "getBuildStatus", "Ljetbrains/ring/license/BuildStatus;", "getDiskUsage", "getHistoricalReleaseDate", "", "licenseName", "", "licenseKey", "getIssueNumber", "getMajorVersion", "getMinorVersion", "getProduct", "getProjectNumber", "getReleaseDate", "getUsersNumber", "isHosted", "revokeExtraLicenses", "allowedUserCount", "Companion", "jetbrains.jetpass.userManagement"})
public final class ServiceApplicationDescriptor
implements ApplicationDescriptor {
    private final Product product;
    @NotNull
    private final XdService service;
    private final boolean hosted;
    public static final Companion Companion = new Companion(null);

    @Nullable
    public Product getProduct() {
        return this.product;
    }

    public long getReleaseDate() {
        return ((Number)TransactionKt.legacyTransactional$default(false, null, false, (Function1)new Function1<TransientStoreSession, Long>(this){
            final /* synthetic */ ServiceApplicationDescriptor this$0;

            public final long invoke(@NotNull TransientStoreSession it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                DateTime dateTime = this.this$0.getService().getReleaseDate();
                return dateTime != null ? dateTime.getMillis() : Long.MAX_VALUE;
            }
            {
                this.this$0 = serviceApplicationDescriptor;
                super(1);
            }
        }, 7, null)).longValue();
    }

    public final long getHistoricalReleaseDate(@NotNull String licenseName, @NotNull String licenseKey) {
        Intrinsics.checkParameterIsNotNull((Object)licenseName, (String)"licenseName");
        Intrinsics.checkParameterIsNotNull((Object)licenseKey, (String)"licenseKey");
        return ((Number)TransactionKt.legacyTransactional$default(false, null, false, (Function1)new Function1<TransientStoreSession, Long>(this, licenseName, licenseKey){
            final /* synthetic */ ServiceApplicationDescriptor this$0;
            final /* synthetic */ String $licenseName;
            final /* synthetic */ String $licenseKey;

            public final long invoke(@NotNull TransientStoreSession it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                DateTime dateTime = HistoricalReleaseDateUtilKt.getHistoricalReleaseDate(this.this$0.getService(), this.$licenseName, this.$licenseKey);
                return dateTime != null ? dateTime.getMillis() : Long.MAX_VALUE;
            }
            {
                this.this$0 = serviceApplicationDescriptor;
                this.$licenseName = string;
                this.$licenseKey = string2;
                super(1);
            }
        }, 7, null)).longValue();
    }

    public int getMajorVersion() {
        return Integer.MAX_VALUE;
    }

    public int getMinorVersion() {
        return Integer.MAX_VALUE;
    }

    @NotNull
    public BuildStatus getBuildStatus() {
        return BuildStatus.RELEASE;
    }

    public int getBuildNumber() {
        return Integer.MAX_VALUE;
    }

    public boolean isHosted() {
        return this.hosted;
    }

    public int getUsersNumber() {
        XdLicenseSettings xdLicenseSettings = this.service.getLicense();
        return xdLicenseSettings != null ? xdLicenseSettings.getUsedLicenses() : 0;
    }

    public int getProjectNumber() {
        return 0;
    }

    public long getIssueNumber() {
        return 0L;
    }

    public int getDiskUsage() {
        return 0;
    }

    public final void applyConstraints(@NotNull License license2) {
        Intrinsics.checkParameterIsNotNull((Object)license2, (String)"license");
        this.revokeExtraLicenses(LicenseExtensionKt.getTotalUserCount(license2));
    }

    private final void revokeExtraLicenses(int allowedUserCount) {
        LicenseExtensionKt.banExtraUsers((Function0<? extends XdQuery<? extends XdBaseUser>>)((Function0)new Function0<XdQuery<? extends XdBaseUser>>(this){
            final /* synthetic */ ServiceApplicationDescriptor this$0;

            @NotNull
            public final XdQuery<XdBaseUser> invoke() {
                XdMutableQuery<XdBaseUser> xdMutableQuery = this.this$0.getService().getLicense();
                return xdMutableQuery != null && (xdMutableQuery = xdMutableQuery.getUsers()) != null ? (XdQuery)xdMutableQuery : XdQueryKt.emptyQuery((XdEntityType)((XdEntityType)XdBaseUser.Companion));
            }
            {
                this.this$0 = serviceApplicationDescriptor;
                super(0);
            }
        }), allowedUserCount, (Function1<? super XdBaseUser, Unit>)((Function1)new Function1<XdBaseUser, Unit>(this){
            final /* synthetic */ ServiceApplicationDescriptor this$0;

            public final void invoke(@NotNull XdBaseUser it) {
                block0: {
                    Intrinsics.checkParameterIsNotNull((Object)((Object)it), (String)"it");
                    XdMutableQuery<XdBaseUser> xdMutableQuery = this.this$0.getService().getLicense();
                    if (xdMutableQuery == null || (xdMutableQuery = xdMutableQuery.getUsers()) == null) break block0;
                    xdMutableQuery.remove((XdEntity)it);
                }
            }
            {
                this.this$0 = serviceApplicationDescriptor;
                super(1);
            }
        }), "Revoked " + this.service.getName() + " license from %d users due to license limitations");
    }

    @NotNull
    public final XdService getService() {
        return this.service;
    }

    public ServiceApplicationDescriptor(@NotNull XdService service2, boolean hosted) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)service2), (String)"service");
        this.service = service2;
        this.hosted = hosted;
        this.product = Companion.toProduct(this.service.getApplicationName());
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a8\u0006\u0007"}, d2={"Ljetbrains/jetpass/userManagement/persistence/license/ServiceApplicationDescriptor$Companion;", "", "()V", "toProduct", "Ljetbrains/ring/license/Product;", "applicationName", "", "jetbrains.jetpass.userManagement"})
    public static final class Companion {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Nullable
        public final Product toProduct(@Nullable String applicationName) {
            String string = applicationName;
            if (string == null) return null;
            switch (string) {
                case "YouTrack": {
                    Product product = Product.YOUTRACK;
                    return product;
                }
                case "Upsource": {
                    Product product = Product.UPSOURCE;
                    return product;
                }
                case "Hub": {
                    Product product = Product.HUB;
                    return product;
                }
                default: {
                    return null;
                }
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

