/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.userManagement.persistence.license;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import jetbrains.exodus.query.NodeBase;
import jetbrains.jetpass.userManagement.persistence.dnq.XdLicenseSettings;
import jetbrains.jetpass.userManagement.persistence.dnq.XdService;
import jetbrains.jetpass.userManagement.persistence.dnq.event.XdEvent;
import jetbrains.jetpass.userManagement.persistence.dnq.event.XdEventType;
import jetbrains.jetpass.userManagement.persistence.event.change.EntityData;
import jetbrains.jetpass.userManagement.persistence.event.change.FieldChangeData;
import jetbrains.jetpass.userManagement.persistence.event.change.IdEntityData;
import jetbrains.jetpass.userManagement.persistence.event.change.LinkChangeData;
import jetbrains.jetpass.userManagement.persistence.event.change.PropertyChangeData;
import jetbrains.jetpass.userManagement.persistence.license.ServiceHistorySnapshot;
import jetbrains.jetpass.userManagement.persistence.license.ServiceHistorySnapshot$Companion$relevantLicenseUpdates$relevantLicenseUpdates$4;
import jetbrains.jetpass.userManagement.persistence.license.ServiceHistorySnapshot$Companion$relevantServiceUpdates$events$1;
import jetbrains.jetpass.userManagement.persistence.license.ServiceHistorySnapshot$Companion$relevantServiceUpdates$events$2;
import jetbrains.jetpass.userManagement.persistence.license.ServiceHistorySnapshot$Companion$relevantServiceUpdates$events$3;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty1;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdEntityType;
import kotlinx.dnq.query.NodeBaseOperationsKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import kotlinx.dnq.util.ReflectionUtilKt;
import mu.KLogging;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0016\u0018\u0000 \u00182\u00020\u0001:\u0003\u0018\u0019\u001aBK\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0017\u001a\u00020\u0003H\u0016R\u0013\u0010\t\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0013\u0010\n\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0010R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0010R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\r\u00a8\u0006\u001b"}, d2={"Ljetbrains/jetpass/userManagement/persistence/license/ServiceHistorySnapshot;", "", "version", "", "releaseDate", "Lorg/joda/time/DateTime;", "serviceTimestamp", "snapshotTimestamp", "licenseName", "licenseKey", "licenseTimestamp", "(Ljava/lang/String;Lorg/joda/time/DateTime;Lorg/joda/time/DateTime;Lorg/joda/time/DateTime;Ljava/lang/String;Ljava/lang/String;Lorg/joda/time/DateTime;)V", "getLicenseKey", "()Ljava/lang/String;", "getLicenseName", "getLicenseTimestamp", "()Lorg/joda/time/DateTime;", "getReleaseDate", "releaseDateWithFallback", "getReleaseDateWithFallback", "getServiceTimestamp", "getSnapshotTimestamp", "getVersion", "toString", "Companion", "LicenseSnapshot", "ServiceSnapshot", "jetbrains.jetpass.userManagement"})
public final class ServiceHistorySnapshot {
    @Nullable
    private final String version;
    @Nullable
    private final DateTime releaseDate;
    @Nullable
    private final DateTime serviceTimestamp;
    @Nullable
    private final DateTime snapshotTimestamp;
    @Nullable
    private final String licenseName;
    @Nullable
    private final String licenseKey;
    @Nullable
    private final DateTime licenseTimestamp;
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final DateTime getReleaseDateWithFallback() {
        DateTime dateTime = this.releaseDate;
        if (dateTime == null) {
            dateTime = this.snapshotTimestamp;
        }
        return dateTime;
    }

    @NotNull
    public String toString() {
        String string;
        StringBuilder stringBuilder;
        Object[] objectArray;
        String string2;
        StringCompanionObject stringCompanionObject;
        String timestampes = "";
        if (this.serviceTimestamp != null || this.licenseTimestamp != null) {
            stringCompanionObject = StringCompanionObject.INSTANCE;
            string2 = "%1$13s";
            objectArray = new Object[]{this.licenseTimestamp};
            stringBuilder = new StringBuilder().append("license\\service: ");
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(format, *args)");
            string = string3;
            stringCompanionObject = StringCompanionObject.INSTANCE;
            string2 = "%1$13s";
            objectArray = new Object[]{this.serviceTimestamp};
            stringBuilder = stringBuilder.append(string).append(" \\ ");
            String string4 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"java.lang.String.format(format, *args)");
            string = string4;
            timestampes = stringBuilder.append(string).toString();
        }
        stringCompanionObject = StringCompanionObject.INSTANCE;
        string2 = "[%1$13s]";
        objectArray = new Object[]{this.snapshotTimestamp};
        stringBuilder = new StringBuilder();
        String string5 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"java.lang.String.format(format, *args)");
        string = string5;
        stringCompanionObject = StringCompanionObject.INSTANCE;
        string2 = "%1$35s";
        objectArray = new Object[]{this.licenseName + "/" + StringUtils.substring((String)this.licenseKey, (int)0, (int)10)};
        stringBuilder = stringBuilder.append(string);
        String string6 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"java.lang.String.format(format, *args)");
        string = string6;
        stringCompanionObject = StringCompanionObject.INSTANCE;
        string2 = "%1$30s";
        Object[] objectArray2 = new Object[1];
        DateTime dateTime = this.releaseDate;
        objectArray2[0] = dateTime != null ? dateTime.toDate() : null;
        objectArray = objectArray2;
        stringBuilder = stringBuilder.append(string).append(", released: ");
        String string7 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"java.lang.String.format(format, *args)");
        string = string7;
        return stringBuilder.append(string).append(", version: ").append(this.version).append("\t\t ").append(timestampes).toString();
    }

    @Nullable
    public final String getVersion() {
        return this.version;
    }

    @Nullable
    public final DateTime getReleaseDate() {
        return this.releaseDate;
    }

    @Nullable
    public final DateTime getServiceTimestamp() {
        return this.serviceTimestamp;
    }

    @Nullable
    public final DateTime getSnapshotTimestamp() {
        return this.snapshotTimestamp;
    }

    @Nullable
    public final String getLicenseName() {
        return this.licenseName;
    }

    @Nullable
    public final String getLicenseKey() {
        return this.licenseKey;
    }

    @Nullable
    public final DateTime getLicenseTimestamp() {
        return this.licenseTimestamp;
    }

    public ServiceHistorySnapshot(@Nullable String version, @Nullable DateTime releaseDate, @Nullable DateTime serviceTimestamp, @Nullable DateTime snapshotTimestamp, @Nullable String licenseName, @Nullable String licenseKey, @Nullable DateTime licenseTimestamp) {
        this.version = version;
        this.releaseDate = releaseDate;
        this.serviceTimestamp = serviceTimestamp;
        this.snapshotTimestamp = snapshotTimestamp;
        this.licenseName = licenseName;
        this.licenseKey = licenseKey;
        this.licenseTimestamp = licenseTimestamp;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B#\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\r\u001a\u00020\u0003H\u0016R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000e"}, d2={"Ljetbrains/jetpass/userManagement/persistence/license/ServiceHistorySnapshot$LicenseSnapshot;", "", "name", "", "key", "timestamp", "Lorg/joda/time/DateTime;", "(Ljava/lang/String;Ljava/lang/String;Lorg/joda/time/DateTime;)V", "getKey", "()Ljava/lang/String;", "getName", "getTimestamp", "()Lorg/joda/time/DateTime;", "toString", "jetbrains.jetpass.userManagement"})
    public static final class LicenseSnapshot {
        @Nullable
        private final String name;
        @Nullable
        private final String key;
        @Nullable
        private final DateTime timestamp;

        @NotNull
        public String toString() {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "Name: " + this.name + " | Key: %.30s | Timestamp: " + this.timestamp;
            Object[] objectArray = new Object[]{this.key};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
            return string2;
        }

        @Nullable
        public final String getName() {
            return this.name;
        }

        @Nullable
        public final String getKey() {
            return this.key;
        }

        @Nullable
        public final DateTime getTimestamp() {
            return this.timestamp;
        }

        public LicenseSnapshot(@Nullable String name2, @Nullable String key2, @Nullable DateTime timestamp) {
            this.name = name2;
            this.key = key2;
            this.timestamp = timestamp;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B-\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000f\u001a\u00020\u0003H\u0016R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u0010"}, d2={"Ljetbrains/jetpass/userManagement/persistence/license/ServiceHistorySnapshot$ServiceSnapshot;", "", "version", "", "releaseDate", "Lorg/joda/time/DateTime;", "oldLicenseID", "timestamp", "(Ljava/lang/String;Lorg/joda/time/DateTime;Ljava/lang/String;Lorg/joda/time/DateTime;)V", "getOldLicenseID", "()Ljava/lang/String;", "getReleaseDate", "()Lorg/joda/time/DateTime;", "getTimestamp", "getVersion", "toString", "jetbrains.jetpass.userManagement"})
    public static final class ServiceSnapshot {
        @Nullable
        private final String version;
        @Nullable
        private final DateTime releaseDate;
        @Nullable
        private final String oldLicenseID;
        @Nullable
        private final DateTime timestamp;

        @NotNull
        public String toString() {
            DateTime dateTime = this.timestamp;
            return "Version: " + this.version + " | Release Date: " + this.releaseDate + " | Old License ID: " + this.oldLicenseID + " | Timestamp: " + (dateTime != null ? Long.valueOf(dateTime.getMillis()) : null);
        }

        @Nullable
        public final String getVersion() {
            return this.version;
        }

        @Nullable
        public final DateTime getReleaseDate() {
            return this.releaseDate;
        }

        @Nullable
        public final String getOldLicenseID() {
            return this.oldLicenseID;
        }

        @Nullable
        public final DateTime getTimestamp() {
            return this.timestamp;
        }

        public ServiceSnapshot(@Nullable String version, @Nullable DateTime releaseDate, @Nullable String oldLicenseID, @Nullable DateTime timestamp) {
            this.version = version;
            this.releaseDate = releaseDate;
            this.oldLicenseID = oldLicenseID;
            this.timestamp = timestamp;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001c\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u001c\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rJ\"\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00042\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0004J\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\u0014"}, d2={"Ljetbrains/jetpass/userManagement/persistence/license/ServiceHistorySnapshot$Companion;", "Lmu/KLogging;", "()V", "getHistory", "", "Ljetbrains/jetpass/userManagement/persistence/license/ServiceHistorySnapshot;", "service", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdService;", "logDebugItems", "", "title", "", "items", "", "", "relevantLicenseUpdates", "Ljetbrains/jetpass/userManagement/persistence/license/ServiceHistorySnapshot$LicenseSnapshot;", "serviceSnapshots", "Ljetbrains/jetpass/userManagement/persistence/license/ServiceHistorySnapshot$ServiceSnapshot;", "relevantServiceUpdates", "jetbrains.jetpass.userManagement"})
    public static final class Companion
    extends KLogging {
        @NotNull
        public final List<ServiceHistorySnapshot> getHistory(@NotNull XdService service2) {
            LicenseSnapshot currentLicense;
            Intrinsics.checkParameterIsNotNull((Object)((Object)service2), (String)"service");
            List<ServiceSnapshot> services = this.relevantServiceUpdates(service2);
            this.logDebugItems("Service history:", (Iterable<? extends Object>)services);
            List<LicenseSnapshot> licenses2 = this.relevantLicenseUpdates(service2, services);
            this.logDebugItems("License history:", (Iterable<? extends Object>)licenses2);
            ArrayList<ServiceHistorySnapshot> snapshots = new ArrayList<ServiceHistorySnapshot>();
            Iterator<ServiceSnapshot> serviceItr = services.iterator();
            Iterator<LicenseSnapshot> licenseItr = licenses2.iterator();
            XdLicenseSettings xdLicenseSettings = service2.getLicense();
            XdLicenseSettings xdLicenseSettings2 = service2.getLicense();
            ServiceHistorySnapshot recentSnapshot = new ServiceHistorySnapshot(service2.getVersion(), service2.getReleaseDate(), DateTime.now(), DateTime.now(), xdLicenseSettings != null ? xdLicenseSettings.getLicenseName() : null, xdLicenseSettings2 != null ? xdLicenseSettings2.getLicenseKey() : null, DateTime.now());
            snapshots.add(recentSnapshot);
            ServiceSnapshot currentService = serviceItr.hasNext() ? serviceItr.next() : null;
            LicenseSnapshot licenseSnapshot = currentLicense = licenseItr.hasNext() ? licenseItr.next() : null;
            while (true) {
                boolean bl;
                if (currentService != null && currentLicense != null) {
                    DateTime ts = currentService.getTimestamp();
                    bl = ts != null ? ts.compareTo((ReadableInstant)currentLicense.getTimestamp()) > 0 : false;
                } else if (currentService != null) {
                    bl = true;
                } else {
                    if (currentLicense == null) break;
                    bl = false;
                }
                boolean moveService = bl;
                if (moveService) {
                    ServiceSnapshot serviceSnapshot = currentService;
                    ServiceSnapshot serviceSnapshot2 = currentService;
                    ServiceSnapshot serviceSnapshot3 = currentService;
                    ServiceSnapshot serviceSnapshot4 = currentService;
                    recentSnapshot = new ServiceHistorySnapshot(serviceSnapshot != null ? serviceSnapshot.getVersion() : null, (DateTime)(serviceSnapshot2 != null ? serviceSnapshot2.getReleaseDate() : null), (DateTime)(serviceSnapshot3 != null ? serviceSnapshot3.getTimestamp() : null), (DateTime)(serviceSnapshot4 != null ? serviceSnapshot4.getTimestamp() : null), recentSnapshot.getLicenseName(), recentSnapshot.getLicenseKey(), recentSnapshot.getLicenseTimestamp());
                    currentService = serviceItr.hasNext() ? serviceItr.next() : null;
                    snapshots.add(recentSnapshot);
                    continue;
                }
                LicenseSnapshot licenseSnapshot2 = currentLicense;
                snapshots.add(new ServiceHistorySnapshot(recentSnapshot.getVersion(), recentSnapshot.getReleaseDate(), recentSnapshot.getServiceTimestamp(), (DateTime)(licenseSnapshot2 != null ? licenseSnapshot2.getTimestamp() : null), recentSnapshot.getLicenseName(), recentSnapshot.getLicenseKey(), recentSnapshot.getLicenseTimestamp()));
                LicenseSnapshot licenseSnapshot3 = currentLicense;
                LicenseSnapshot licenseSnapshot4 = currentLicense;
                LicenseSnapshot licenseSnapshot5 = currentLicense;
                LicenseSnapshot licenseSnapshot6 = currentLicense;
                recentSnapshot = new ServiceHistorySnapshot(recentSnapshot.getVersion(), recentSnapshot.getReleaseDate(), recentSnapshot.getServiceTimestamp(), (DateTime)(licenseSnapshot3 != null ? licenseSnapshot3.getTimestamp() : null), licenseSnapshot4 != null ? licenseSnapshot4.getName() : null, licenseSnapshot5 != null ? licenseSnapshot5.getKey() : null, (DateTime)(licenseSnapshot6 != null ? licenseSnapshot6.getTimestamp() : null));
                snapshots.add(recentSnapshot);
                currentLicense = licenseItr.hasNext() ? licenseItr.next() : null;
            }
            return snapshots;
        }

        @NotNull
        public final List<ServiceSnapshot> relevantServiceUpdates(@NotNull XdService service2) {
            XdEntity value$iv;
            KProperty1 $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)((Object)service2), (String)"service");
            KProperty1 kProperty1 = (KProperty1)ServiceHistorySnapshot$Companion$relevantServiceUpdates$events$1.INSTANCE;
            Comparable comparable = (Comparable)((Object)service2.getUuid());
            XdEntityType xdEntityType = (XdEntityType)XdEvent.Companion;
            NodeBase nodeBase = NodeBaseOperationsKt.eq((String)ReflectionUtilKt.getDBName((KProperty1)$receiver$iv, (KClass)Reflection.getOrCreateKotlinClass(XdEvent.class)), (Comparable)value$iv);
            $receiver$iv = (KProperty1)ServiceHistorySnapshot$Companion$relevantServiceUpdates$events$2.INSTANCE;
            value$iv = (XdEntity)XdEventType.Companion.getCREATE();
            NodeBase nodeBase2 = NodeBaseOperationsKt.ne((KProperty1)$receiver$iv, (KClass)Reflection.getOrCreateKotlinClass(XdEvent.class), (XdEntity)value$iv);
            XdQuery events2 = XdQueryKt.sortedBy((XdQuery)XdQueryKt.query((XdEntityType)xdEntityType, (NodeBase)NodeBaseOperationsKt.and((NodeBase)nodeBase, (NodeBase)nodeBase2)), (KProperty1)((KProperty1)ServiceHistorySnapshot$Companion$relevantServiceUpdates$events$3.INSTANCE), (boolean)false);
            ArrayList<ServiceSnapshot> serviceSnapshots = new ArrayList<ServiceSnapshot>();
            XdLicenseSettings xdLicenseSettings = service2.getLicense();
            ServiceSnapshot recentSnapshot = new ServiceSnapshot(service2.getVersion(), service2.getReleaseDate(), xdLicenseSettings != null ? xdLicenseSettings.getUuid() : null, DateTime.now());
            Iterator iterator = XdQueryKt.iterator((XdQuery)events2);
            while (iterator.hasNext()) {
                XdEvent event2 = (XdEvent)((Object)iterator.next());
                String prevVersion = null;
                DateTime prevReleaseDate = null;
                String prevLicenseID = null;
                boolean versionChanged = false;
                boolean releaseDateChanged = false;
                boolean licenseIDChanged = false;
                for (FieldChangeData change : event2.getApiChanges()) {
                    FieldChangeData fieldChangeData = change;
                    if (fieldChangeData instanceof PropertyChangeData) {
                        DateTime dateTime;
                        if (Intrinsics.areEqual((Object)change.getFieldName(), (Object)"version")) {
                            prevVersion = (String)((Object)((PropertyChangeData)change).getOldValue());
                            versionChanged = true;
                            continue;
                        }
                        if (!Intrinsics.areEqual((Object)change.getFieldName(), (Object)"releaseDate")) continue;
                        if ((Long)((PropertyChangeData)change).getOldValue() != null) {
                            Long l;
                            long p1 = ((Number)l).longValue();
                            dateTime = new DateTime(p1);
                        } else {
                            dateTime = null;
                        }
                        prevReleaseDate = dateTime;
                        releaseDateChanged = true;
                        continue;
                    }
                    if (!(fieldChangeData instanceof LinkChangeData) || !Intrinsics.areEqual((Object)change.getFieldName(), (Object)"license")) continue;
                    EntityData removedLicense = (EntityData)CollectionsKt.firstOrNull(((LinkChangeData)change).getRemoved());
                    if (removedLicense instanceof IdEntityData) {
                        prevLicenseID = ((IdEntityData)removedLicense).getId();
                    }
                    licenseIDChanged = true;
                }
                if (!versionChanged && !releaseDateChanged && !licenseIDChanged) continue;
                recentSnapshot = new ServiceSnapshot(versionChanged ? prevVersion : recentSnapshot.getVersion(), releaseDateChanged ? prevReleaseDate : recentSnapshot.getReleaseDate(), licenseIDChanged ? prevLicenseID : recentSnapshot.getOldLicenseID(), event2.getTimestamp());
                serviceSnapshots.add(recentSnapshot);
            }
            return serviceSnapshots;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<LicenseSnapshot> relevantLicenseUpdates(@NotNull XdService service2, @NotNull List<ServiceSnapshot> serviceSnapshots) {
            void $receiver$iv;
            XdQuery initial$iv;
            Intrinsics.checkParameterIsNotNull((Object)((Object)service2), (String)"service");
            Intrinsics.checkParameterIsNotNull(serviceSnapshots, (String)"serviceSnapshots");
            XdLicenseSettings xdLicenseSettings = service2.getLicense();
            Sequence sequence = SequencesKt.map((Sequence)SequencesKt.distinct((Sequence)SequencesKt.plus((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)serviceSnapshots), (Function1)relevantLicenseUpdates.relevantLicenseUpdates.1.INSTANCE), (Object)(xdLicenseSettings != null ? xdLicenseSettings.getUuid() : null))), (Function1)relevantLicenseUpdates.relevantLicenseUpdates.2.INSTANCE);
            XdQuery accumulator$iv = initial$iv = XdQueryKt.emptyQuery((XdEntityType)((XdEntityType)XdEvent.Companion));
            for (Object element$iv : $receiver$iv) {
                void it;
                XdQuery xdQuery = (XdQuery)element$iv;
                XdQuery acc = accumulator$iv;
                accumulator$iv = XdQueryKt.union((XdQuery)acc, (XdQuery)it);
            }
            XdQuery relevantLicenseUpdates2 = XdQueryKt.sortedBy((XdQuery)accumulator$iv, (KProperty1)((KProperty1)ServiceHistorySnapshot$Companion$relevantLicenseUpdates$relevantLicenseUpdates$4.INSTANCE), (boolean)false);
            ArrayList<LicenseSnapshot> licenseSnapshots = new ArrayList<LicenseSnapshot>();
            XdLicenseSettings xdLicenseSettings2 = service2.getLicense();
            XdLicenseSettings xdLicenseSettings3 = service2.getLicense();
            LicenseSnapshot recentSnapshot = new LicenseSnapshot(xdLicenseSettings2 != null ? xdLicenseSettings2.getLicenseName() : null, xdLicenseSettings3 != null ? xdLicenseSettings3.getLicenseKey() : null, DateTime.now());
            Iterator iterator = XdQueryKt.iterator((XdQuery)relevantLicenseUpdates2);
            while (iterator.hasNext()) {
                DateTime dateTime;
                LicenseSnapshot licenseSnapshot;
                Iterator $receiver$iv$iv;
                Iterable $receiver$iv2;
                XdEvent licenseUpdate = (XdEvent)((Object)iterator.next());
                String prevName = null;
                String prevKey = null;
                boolean nameChanged = false;
                boolean keyChanged = false;
                Iterable<FieldChangeData> $i$f$fold = licenseUpdate.getApiChanges();
                void var13_14 = $receiver$iv2;
                Collection destination$iv$iv = new ArrayList();
                Iterator iterator2 = $receiver$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv$iv = iterator2.next();
                    if (!(element$iv$iv instanceof PropertyChangeData)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $receiver$iv2 = (List)destination$iv$iv;
                $receiver$iv$iv = $receiver$iv2.iterator();
                while ($receiver$iv$iv.hasNext()) {
                    Object element$iv = $receiver$iv$iv.next();
                    PropertyChangeData change = (PropertyChangeData)element$iv;
                    if (Intrinsics.areEqual((Object)change.getFieldName(), (Object)"licenseName")) {
                        prevName = (String)((Object)change.getOldValue());
                        nameChanged = true;
                        continue;
                    }
                    if (!Intrinsics.areEqual((Object)change.getFieldName(), (Object)"licenseKey")) continue;
                    prevKey = (String)((Object)change.getOldValue());
                    keyChanged = true;
                }
                if (!nameChanged && !keyChanged) continue;
                LicenseSnapshot licenseSnapshot2 = licenseSnapshot;
                LicenseSnapshot licenseSnapshot3 = licenseSnapshot;
                String string = nameChanged ? prevName : recentSnapshot.getName();
                String string2 = keyChanged ? prevKey : recentSnapshot.getKey();
                if (licenseUpdate.getTimestamp() != null) {
                    DateTime dateTime2;
                    String string3 = string2;
                    String string4 = string;
                    LicenseSnapshot licenseSnapshot4 = licenseSnapshot2;
                    LicenseSnapshot licenseSnapshot5 = licenseSnapshot3;
                    DateTime p1 = dateTime2;
                    DateTime dateTime3 = new DateTime((Object)p1);
                    licenseSnapshot3 = licenseSnapshot5;
                    licenseSnapshot2 = licenseSnapshot4;
                    string = string4;
                    string2 = string3;
                    dateTime = dateTime3;
                } else {
                    dateTime = null;
                }
                licenseSnapshot2(string, string2, dateTime);
                recentSnapshot = licenseSnapshot3;
                licenseSnapshots.add(recentSnapshot);
            }
            return licenseSnapshots;
        }

        public final void logDebugItems(@NotNull String title, @NotNull Iterable<? extends Object> items) {
            Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
            Intrinsics.checkParameterIsNotNull(items, (String)"items");
            this.getLogger().debug((Function0)new Function0<String>(title, items){
                final /* synthetic */ String $title;
                final /* synthetic */ Iterable $items;

                @NotNull
                public final String invoke() {
                    return '\n' + this.$title + '\n' + CollectionsKt.joinToString$default((Iterable)this.$items, (CharSequence)"\n", null, null, (int)0, null, (Function1)logDebugItems.1.INSTANCE, (int)30, null);
                }
                {
                    this.$title = string;
                    this.$items = iterable;
                    super(0);
                }
            });
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

