/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.userManagement.persistence.license;

import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.jetpass.dnq.TransactionKt;
import jetbrains.jetpass.userManagement.persistence.license.LicenseExtensionKt;
import jetbrains.jetpass.userManagement.persistence.license.ServiceApplicationDescriptor;
import jetbrains.ring.license.License;
import jetbrains.ring.license.checker.ApplicationDescriptor;
import jetbrains.ring.license.checker.LicenseCheckerImpl;
import jetbrains.ring.license.checker.LicenseUserNumberExceededException;
import jetbrains.ring.license.checker.UpgradeExpiredException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\t\u001a\u00020\nJ\b\u0010\u000b\u001a\u00020\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Ljetbrains/jetpass/userManagement/persistence/license/ServiceLicenseChecker;", "Ljetbrains/ring/license/checker/LicenseCheckerImpl;", "license", "Ljetbrains/ring/license/License;", "licenseKey", "", "serviceApplicationDescriptor", "Ljetbrains/jetpass/userManagement/persistence/license/ServiceApplicationDescriptor;", "(Ljetbrains/ring/license/License;Ljava/lang/String;Ljetbrains/jetpass/userManagement/persistence/license/ServiceApplicationDescriptor;)V", "checkNumberOfUsersIsNotExceeded", "", "checkUpgradeExpiration", "jetbrains.jetpass.userManagement"})
public final class ServiceLicenseChecker
extends LicenseCheckerImpl {
    private final String licenseKey;
    private final ServiceApplicationDescriptor serviceApplicationDescriptor;

    public void checkUpgradeExpiration() throws UpgradeExpiredException {
        TransactionKt.legacyTransactional$default(false, null, false, (Function1)new Function1<TransientStoreSession, Unit>(this){
            final /* synthetic */ ServiceLicenseChecker this$0;

            public final void invoke(@NotNull TransientStoreSession it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                ApplicationDescriptor applicationDescriptor = this.this$0.getApplicationDescriptor();
                Intrinsics.checkExpressionValueIsNotNull((Object)applicationDescriptor, (String)"applicationDescriptor");
                long releaseDate = applicationDescriptor.getReleaseDate();
                if (releaseDate != Long.MAX_VALUE) {
                    License license2 = this.this$0.getLicense();
                    Intrinsics.checkExpressionValueIsNotNull((Object)license2, (String)"license");
                    long upgradeExpirationTime = license2.getUpgradeExpirationTime();
                    if (upgradeExpirationTime < releaseDate) {
                        ServiceApplicationDescriptor serviceApplicationDescriptor = ServiceLicenseChecker.access$getServiceApplicationDescriptor$p(this.this$0);
                        License license3 = this.this$0.getLicense();
                        Intrinsics.checkExpressionValueIsNotNull((Object)license3, (String)"license");
                        String string = license3.getName();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"license.name");
                        long histReleaseDate = serviceApplicationDescriptor.getHistoricalReleaseDate(string, ServiceLicenseChecker.access$getLicenseKey$p(this.this$0));
                        if (histReleaseDate == Long.MAX_VALUE || upgradeExpirationTime < histReleaseDate) {
                            throw (Throwable)new UpgradeExpiredException(this.this$0.getLicense());
                        }
                    }
                }
            }
            {
                this.this$0 = serviceLicenseChecker;
                super(1);
            }
        }, 7, null);
    }

    public final void checkNumberOfUsersIsNotExceeded() throws LicenseUserNumberExceededException {
        License license2 = this.getLicense();
        Intrinsics.checkExpressionValueIsNotNull((Object)license2, (String)"license");
        int licenseUserCount = LicenseExtensionKt.getTotalUserCount(license2);
        if (licenseUserCount != Integer.MAX_VALUE) {
            ApplicationDescriptor applicationDescriptor = this.getApplicationDescriptor();
            Intrinsics.checkExpressionValueIsNotNull((Object)applicationDescriptor, (String)"applicationDescriptor");
            if (applicationDescriptor.getUsersNumber() > licenseUserCount) {
                throw (Throwable)new LicenseUserNumberExceededException(this.getLicense());
            }
        }
    }

    public ServiceLicenseChecker(@NotNull License license2, @NotNull String licenseKey, @NotNull ServiceApplicationDescriptor serviceApplicationDescriptor) {
        Intrinsics.checkParameterIsNotNull((Object)license2, (String)"license");
        Intrinsics.checkParameterIsNotNull((Object)licenseKey, (String)"licenseKey");
        Intrinsics.checkParameterIsNotNull((Object)serviceApplicationDescriptor, (String)"serviceApplicationDescriptor");
        super(license2, (ApplicationDescriptor)serviceApplicationDescriptor);
        this.licenseKey = licenseKey;
        this.serviceApplicationDescriptor = serviceApplicationDescriptor;
    }

    @NotNull
    public static final /* synthetic */ ServiceApplicationDescriptor access$getServiceApplicationDescriptor$p(ServiceLicenseChecker $this) {
        return $this.serviceApplicationDescriptor;
    }

    @NotNull
    public static final /* synthetic */ String access$getLicenseKey$p(ServiceLicenseChecker $this) {
        return $this.licenseKey;
    }
}

