/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.userManagement.persistence.license;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import jetbrains.exodus.query.NodeBase;
import jetbrains.jetpass.api.authority.AuthorityHolder;
import jetbrains.jetpass.service.api.HubPrincipalManager;
import jetbrains.jetpass.service.api.JetPassMainApp;
import jetbrains.jetpass.userManagement.persistence.BaseConstraints;
import jetbrains.jetpass.userManagement.persistence.dnq.XdAllUsersGroup;
import jetbrains.jetpass.userManagement.persistence.dnq.XdAuthorityHolder;
import jetbrains.jetpass.userManagement.persistence.dnq.XdBaseUser;
import jetbrains.jetpass.userManagement.persistence.dnq.XdBaseUserGroup;
import jetbrains.jetpass.userManagement.persistence.dnq.XdLicenseSettings;
import jetbrains.jetpass.userManagement.persistence.dnq.XdRoots;
import jetbrains.jetpass.userManagement.persistence.dnq.XdService;
import jetbrains.jetpass.userManagement.persistence.license.HubApplicationDescriptor;
import jetbrains.jetpass.userManagement.persistence.license.HubLicenseCache;
import jetbrains.jetpass.userManagement.persistence.license.LicenseExtensionKt;
import jetbrains.jetpass.userManagement.persistence.license.ServiceApplicationDescriptor;
import jetbrains.jetpass.userManagement.persistence.license.ServiceLicenseChecker;
import jetbrains.jetpass.userManagement.persistence.license.ServiceLicenseConstraints;
import jetbrains.jetpass.userManagement.persistence.license.ServiceLicenseConstraints$GroupListener$updatedSync$addedUsers$1;
import jetbrains.jetpass.userManagement.persistence.license.ServiceLicenseConstraints$GroupListener$updatedSync$removedUsers$1;
import jetbrains.jetpass.userManagement.persistence.license.ServiceLicenseConstraints$LicenseListener$addedSync$principalOrAdmin$1;
import jetbrains.jetpass.userManagement.persistence.license.ServiceLicenseConstraints$LicenseListener$addedSync$principalOrAdmin$2;
import jetbrains.jetpass.userManagement.persistence.license.ServiceLicenseConstraints$LicenseListener$updatedSync$1;
import jetbrains.jetpass.userManagement.persistence.license.ServiceLicenseConstraints$LicenseListener$updatedSync$2;
import jetbrains.jetpass.userManagement.persistence.license.ServiceLicenseConstraints$LicenseListener$updatedSyncAfterConstraints$1;
import jetbrains.jetpass.userManagement.persistence.license.ServiceLicenseConstraints$LicenseListener$updatedSyncAfterConstraints$2;
import jetbrains.jetpass.userManagement.persistence.license.ServiceLicenseConstraints$LicenseListener$updatedSyncBeforeConstraints$1;
import jetbrains.jetpass.userManagement.persistence.license.ServiceLicenseConstraints$syncLicenseAutoJoinGroups$2$1;
import jetbrains.jetpass.userManagement.persistence.license.ServiceLicenseConstraints$syncLicenseAutoJoinGroups$currentUserNumber$1;
import jetbrains.mps.webr.runtime.listeners.EventsMultiplexerProxy;
import jetbrains.ring.license.InvalidLicenseException;
import jetbrains.ring.license.License;
import jetbrains.ring.license.checker.LicenseUserNumberExceededException;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty1;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdEntityType;
import kotlinx.dnq.listener.XdEntityListener;
import kotlinx.dnq.query.NodeBaseOperationsKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import kotlinx.dnq.util.ReflectionUtilKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.annotation.Scope;

@Named(value="serviceLicenseConstraints")
@Scope(value="local")
@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0017\u0018\u0000 \u001d2\u00020\u0001:\u0004\u001d\u001e\u001f B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0007J\b\u0010\u0018\u001a\u00020\u0017H\u0007J,\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00122\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0012H\u0002R\u0012\u0010\u000b\u001a\u00060\fR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00060\u000eR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u00060\u0010R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Ljetbrains/jetpass/userManagement/persistence/license/ServiceLicenseConstraints;", "Ljetbrains/jetpass/userManagement/persistence/BaseConstraints;", "eventsMultiplexerProxy", "Ljetbrains/mps/webr/runtime/listeners/EventsMultiplexerProxy;", "licenseCache", "Ljetbrains/jetpass/userManagement/persistence/license/HubLicenseCache;", "jetPass", "Ljetbrains/jetpass/service/api/JetPassMainApp;", "hubPrincipalManager", "Ljetbrains/jetpass/service/api/HubPrincipalManager;", "(Ljetbrains/mps/webr/runtime/listeners/EventsMultiplexerProxy;Ljetbrains/jetpass/userManagement/persistence/license/HubLicenseCache;Ljetbrains/jetpass/service/api/JetPassMainApp;Ljetbrains/jetpass/service/api/HubPrincipalManager;)V", "groupListener", "Ljetbrains/jetpass/userManagement/persistence/license/ServiceLicenseConstraints$GroupListener;", "licenseListener", "Ljetbrains/jetpass/userManagement/persistence/license/ServiceLicenseConstraints$LicenseListener;", "userListener", "Ljetbrains/jetpass/userManagement/persistence/license/ServiceLicenseConstraints$UserListener;", "getRelatedLicenses", "", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdLicenseSettings;", "group", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdBaseUserGroup;", "startListen", "", "stopListen", "syncLicenseAutoJoinGroups", "addedUsers", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdBaseUser;", "removedUsers", "Companion", "GroupListener", "LicenseListener", "UserListener", "jetbrains.jetpass.userManagement"})
public class ServiceLicenseConstraints
extends BaseConstraints {
    private final UserListener userListener;
    private final LicenseListener licenseListener;
    private final GroupListener groupListener;
    private final HubLicenseCache licenseCache;
    private final JetPassMainApp jetPass;
    private final HubPrincipalManager hubPrincipalManager;
    public static final Companion Companion = new Companion(null);

    @PostConstruct
    public final void startListen() {
        this.subscribe((XdEntityType)XdLicenseSettings.Companion, this.licenseListener);
        this.subscribe((XdEntityType)XdBaseUser.Companion, this.userListener);
        this.subscribe((XdEntityType)XdBaseUserGroup.Companion, this.groupListener);
    }

    @PreDestroy
    public final void stopListen() {
        this.unsubscribe((XdEntityType)XdLicenseSettings.Companion, this.licenseListener);
        this.unsubscribe((XdEntityType)XdBaseUser.Companion, this.userListener);
        this.unsubscribe((XdEntityType)XdBaseUserGroup.Companion, this.groupListener);
    }

    /*
     * WARNING - void declaration
     */
    private final void syncLicenseAutoJoinGroups(XdBaseUserGroup group2, List<? extends XdBaseUser> addedUsers2, List<? extends XdBaseUser> removedUsers2) {
        Collection collection = addedUsers2;
        if (!collection.isEmpty() || !(collection = (Collection)removedUsers2).isEmpty()) {
            block0: for (XdLicenseSettings licenseSettings : this.getRelatedLicenses(group2)) {
                void value$iv;
                boolean bl;
                XdAuthorityHolder it;
                Sequence $receiver$iv2;
                XdQuery otherAutoJoinGroups;
                block7: {
                    otherAutoJoinGroups = XdQueryKt.exclude((XdQuery)((XdQuery)licenseSettings.getAutoJoinGroups()), (XdEntity)group2);
                    $receiver$iv2 = XdQueryKt.asSequence((XdQuery)otherAutoJoinGroups);
                    for (Object element$iv : $receiver$iv2) {
                        it = (XdBaseUserGroup)((Object)element$iv);
                        if (!(it instanceof XdAllUsersGroup)) continue;
                        bl = false;
                        break block7;
                    }
                    bl = true;
                }
                if (bl) {
                    void $receiver$iv;
                    $receiver$iv2 = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)removedUsers2), (Function1)((Function1)new Function1<XdBaseUser, Boolean>(otherAutoJoinGroups){
                        final /* synthetic */ XdQuery $otherAutoJoinGroups;

                        /*
                         * WARNING - void declaration
                         */
                        public final boolean invoke(@NotNull XdBaseUser it) {
                            void $receiver$iv;
                            Intrinsics.checkParameterIsNotNull((Object)((Object)it), (String)"it");
                            KProperty1 kProperty1 = ServiceLicenseConstraints$syncLicenseAutoJoinGroups$2$1.INSTANCE;
                            XdQuery xdQuery = this.$otherAutoJoinGroups;
                            NodeBase nodeBase = NodeBaseOperationsKt.contains((KProperty1)$receiver$iv, (KClass)Reflection.getOrCreateKotlinClass(XdBaseUserGroup.class), (XdEntity)it);
                            return XdQueryKt.none((XdQuery)xdQuery, (NodeBase)nodeBase);
                        }
                        {
                            this.$otherAutoJoinGroups = xdQuery;
                            super(1);
                        }
                    }));
                    for (Object element$iv : $receiver$iv) {
                        it = (XdBaseUser)((Object)element$iv);
                        licenseSettings.getUsers().remove((XdEntity)it);
                    }
                }
                int allowedUserNumber = Integer.MAX_VALUE;
                String licenseName = licenseSettings.getLicenseName();
                String licenseKey = licenseSettings.getLicenseKey();
                if (licenseName != null && licenseKey != null) {
                    License license2 = this.licenseCache.getLicense(licenseSettings);
                    allowedUserNumber = LicenseExtensionKt.getTotalUserCount(license2);
                }
                KProperty1 kProperty1 = (KProperty1)ServiceLicenseConstraints$syncLicenseAutoJoinGroups$currentUserNumber$1.INSTANCE;
                Comparable $i$f$forEach = Boolean.valueOf(true);
                XdQuery xdQuery = (XdQuery)licenseSettings.getUsers();
                NodeBase nodeBase = NodeBaseOperationsKt.ne((String)ReflectionUtilKt.getDBName((KProperty1)kProperty1, (KClass)Reflection.getOrCreateKotlinClass(XdBaseUser.class)), (Comparable)value$iv);
                int currentUserNumber2 = XdQueryKt.size((XdQuery)xdQuery, (NodeBase)nodeBase);
                for (XdBaseUser xdBaseUser : addedUsers2) {
                    if (currentUserNumber2 >= allowedUserNumber) continue block0;
                    if (XdQueryKt.contains((XdQuery)((XdQuery)licenseSettings.getUsers()), (XdEntity)xdBaseUser)) continue;
                    licenseSettings.getUsers().add((XdEntity)xdBaseUser);
                    ++currentUserNumber2;
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<XdLicenseSettings> getRelatedLicenses(XdBaseUserGroup group2) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)XdQueryKt.toList((XdQuery)XdLicenseSettings.Companion.all());
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            XdLicenseSettings it = (XdLicenseSettings)((Object)element$iv$iv);
            if (!XdQueryKt.isNotEmpty((XdQuery)XdQueryKt.intersect((XdQuery)((XdQuery)it.getAutoJoinGroups()), group2.getAncestorGroups()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Inject
    public ServiceLicenseConstraints(@NotNull EventsMultiplexerProxy eventsMultiplexerProxy, @NotNull HubLicenseCache licenseCache, @NotNull JetPassMainApp jetPass, @NotNull HubPrincipalManager hubPrincipalManager) {
        Intrinsics.checkParameterIsNotNull((Object)eventsMultiplexerProxy, (String)"eventsMultiplexerProxy");
        Intrinsics.checkParameterIsNotNull((Object)licenseCache, (String)"licenseCache");
        Intrinsics.checkParameterIsNotNull((Object)jetPass, (String)"jetPass");
        Intrinsics.checkParameterIsNotNull((Object)hubPrincipalManager, (String)"hubPrincipalManager");
        super(eventsMultiplexerProxy);
        this.licenseCache = licenseCache;
        this.jetPass = jetPass;
        this.hubPrincipalManager = hubPrincipalManager;
        this.userListener = new UserListener();
        this.licenseListener = new LicenseListener();
        this.groupListener = new GroupListener();
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0010\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0018\u0010\u000b\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\f"}, d2={"Ljetbrains/jetpass/userManagement/persistence/license/ServiceLicenseConstraints$UserListener;", "Lkotlinx/dnq/listener/XdEntityListener;", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdBaseUser;", "(Ljetbrains/jetpass/userManagement/persistence/license/ServiceLicenseConstraints;)V", "addedSync", "", "added", "checkAndBanExtraUsers", "current", "revokeExtraLicensesOfUnbannedUsers", "old", "updatedSync", "jetbrains.jetpass.userManagement"})
    private final class UserListener
    implements XdEntityListener<XdBaseUser> {
        public void addedSync(@NotNull XdBaseUser added2) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)added2), (String)"added");
            this.checkAndBanExtraUsers(added2);
            ServiceLicenseConstraints.this.syncLicenseAutoJoinGroups(XdRoots.INSTANCE.getRootUserGroup(), CollectionsKt.listOf((Object)((Object)added2)), CollectionsKt.emptyList());
        }

        public void updatedSync(@NotNull XdBaseUser old, @NotNull XdBaseUser current) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)old), (String)"old");
            Intrinsics.checkParameterIsNotNull((Object)((Object)current), (String)"current");
            this.checkAndBanExtraUsers(current);
            this.revokeExtraLicensesOfUnbannedUsers(old, current);
        }

        private final void checkAndBanExtraUsers(XdBaseUser current) {
            try {
                ServiceLicenseConstraints.this.licenseCache.getHostLicenseChecker().checkUsersLimitNotExceeded();
            }
            catch (LicenseUserNumberExceededException e) {
                if (Intrinsics.areEqual((Object)current.getLogin(), (Object)ServiceLicenseConstraints.this.jetPass.getAuth().getAdminLogin()) ^ true) {
                    HubApplicationDescriptor.Companion.banDueToLicenseLimitation(current);
                    Companion.getLogger().info((Function0)new Function0<String>(current){
                        final /* synthetic */ XdBaseUser $current;

                        @NotNull
                        public final String invoke() {
                            return "Banned user " + this.$current.getLogin() + " to meet license limitation";
                        }
                        {
                            this.$current = xdBaseUser;
                            super(0);
                        }
                    });
                }
                DnqUtils.getCurrentTransientSession().flush();
            }
            catch (InvalidLicenseException e) {
                Companion.getLogger().debug((Throwable)e, (Function0)checkAndBanExtraUsers.2.INSTANCE);
            }
        }

        private final void revokeExtraLicensesOfUnbannedUsers(XdBaseUser old, XdBaseUser current) {
            if (old.getBanned() && !current.getBanned()) {
                for (XdLicenseSettings licenseSettings : XdQueryKt.toList((XdQuery)((XdQuery)current.getLicenses()))) {
                    int allowedNumberOfUsers;
                    String licenseKey = licenseSettings.getLicenseKey();
                    String licenseName = licenseSettings.getLicenseName();
                    if (licenseKey == null || licenseName == null || (allowedNumberOfUsers = LicenseExtensionKt.getTotalUserCount(ServiceLicenseConstraints.this.licenseCache.getLicense(licenseSettings))) == Integer.MAX_VALUE || licenseSettings.getUsedLicenses() <= allowedNumberOfUsers) continue;
                    current.getLicenses().remove((XdEntity)licenseSettings);
                    Companion.getLogger().info((Function0)new Function0<String>(licenseSettings, current){
                        final /* synthetic */ XdLicenseSettings $licenseSettings;
                        final /* synthetic */ XdBaseUser $current;

                        @NotNull
                        public final String invoke() {
                            return "Revoked license for " + this.$licenseSettings.getService().getName() + " from user " + this.$current.getLogin() + " to meet the license limitation";
                        }
                        {
                            this.$licenseSettings = xdLicenseSettings;
                            this.$current = xdBaseUser;
                            super(0);
                        }
                    });
                }
            }
        }

        public void addedAsync(@NotNull XdBaseUser added2) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)added2), (String)"added");
            XdEntityListener.DefaultImpls.addedAsync((XdEntityListener)this, (XdEntity)added2);
        }

        public void addedSyncAfterConstraints(@NotNull XdBaseUser added2) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)added2), (String)"added");
            XdEntityListener.DefaultImpls.addedSyncAfterConstraints((XdEntityListener)this, (XdEntity)added2);
        }

        public void addedSyncBeforeConstraints(@NotNull XdBaseUser added2) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)added2), (String)"added");
            XdEntityListener.DefaultImpls.addedSyncBeforeConstraints((XdEntityListener)this, (XdEntity)added2);
        }

        @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="addedSyncAfterConstraints"), message="Use addedSyncAfterConstraints instead")
        public void addedSyncBeforeFlush(@NotNull XdBaseUser added2) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)added2), (String)"added");
            XdEntityListener.DefaultImpls.addedSyncBeforeFlush((XdEntityListener)this, (XdEntity)added2);
        }

        public void removedAsync(@NotNull XdBaseUser removed) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)removed), (String)"removed");
            XdEntityListener.DefaultImpls.removedAsync((XdEntityListener)this, (XdEntity)removed);
        }

        public void removedSync(@NotNull XdBaseUser removed) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)removed), (String)"removed");
            XdEntityListener.DefaultImpls.removedSync((XdEntityListener)this, (XdEntity)removed);
        }

        public void removedSyncAfterConstraints(@NotNull XdBaseUser removed) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)removed), (String)"removed");
            XdEntityListener.DefaultImpls.removedSyncAfterConstraints((XdEntityListener)this, (XdEntity)removed);
        }

        public void removedSyncBeforeConstraints(@NotNull XdBaseUser removed) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)removed), (String)"removed");
            XdEntityListener.DefaultImpls.removedSyncBeforeConstraints((XdEntityListener)this, (XdEntity)removed);
        }

        @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="removedSyncAfterConstraints"), message="Use removedSyncAfterConstraints instead")
        public void removedSyncBeforeFlush(@NotNull XdBaseUser added2) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)added2), (String)"added");
            XdEntityListener.DefaultImpls.removedSyncBeforeFlush((XdEntityListener)this, (XdEntity)added2);
        }

        public void updatedAsync(@NotNull XdBaseUser old, @NotNull XdBaseUser current) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)old), (String)"old");
            Intrinsics.checkParameterIsNotNull((Object)((Object)current), (String)"current");
            XdEntityListener.DefaultImpls.updatedAsync((XdEntityListener)this, (XdEntity)old, (XdEntity)current);
        }

        public void updatedSyncAfterConstraints(@NotNull XdBaseUser old, @NotNull XdBaseUser current) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)old), (String)"old");
            Intrinsics.checkParameterIsNotNull((Object)((Object)current), (String)"current");
            XdEntityListener.DefaultImpls.updatedSyncAfterConstraints((XdEntityListener)this, (XdEntity)old, (XdEntity)current);
        }

        public void updatedSyncBeforeConstraints(@NotNull XdBaseUser old, @NotNull XdBaseUser current) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)old), (String)"old");
            Intrinsics.checkParameterIsNotNull((Object)((Object)current), (String)"current");
            XdEntityListener.DefaultImpls.updatedSyncBeforeConstraints((XdEntityListener)this, (XdEntity)old, (XdEntity)current);
        }

        @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="updatedSyncAfterConstraints"), message="Use updatedSyncAfterConstraints instead")
        public void updatedSyncBeforeFlush(@NotNull XdBaseUser old, @NotNull XdBaseUser current) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)old), (String)"old");
            Intrinsics.checkParameterIsNotNull((Object)((Object)current), (String)"current");
            XdEntityListener.DefaultImpls.updatedSyncBeforeFlush((XdEntityListener)this, (XdEntity)old, (XdEntity)current);
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u001e\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00022\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0018\u0010\u000e\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0018\u0010\u000f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\u0010"}, d2={"Ljetbrains/jetpass/userManagement/persistence/license/ServiceLicenseConstraints$LicenseListener;", "Lkotlinx/dnq/listener/XdEntityListener;", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdLicenseSettings;", "(Ljetbrains/jetpass/userManagement/persistence/license/ServiceLicenseConstraints;)V", "addedSync", "", "added", "syncAutoJoinUsers", "current", "newGroups", "Lkotlin/sequences/Sequence;", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdBaseUserGroup;", "updatedSync", "old", "updatedSyncAfterConstraints", "updatedSyncBeforeConstraints", "jetbrains.jetpass.userManagement"})
    private final class LicenseListener
    implements XdEntityListener<XdLicenseSettings> {
        public void updatedSyncAfterConstraints(@NotNull XdLicenseSettings old, @NotNull XdLicenseSettings current) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)old), (String)"old");
            Intrinsics.checkParameterIsNotNull((Object)((Object)current), (String)"current");
            if (ReflectionUtilKt.hasChanges((XdEntity)old, (KProperty1)((KProperty1)ServiceLicenseConstraints$LicenseListener$updatedSyncAfterConstraints$1.INSTANCE)) || ReflectionUtilKt.hasChanges((XdEntity)old, (KProperty1)((KProperty1)ServiceLicenseConstraints$LicenseListener$updatedSyncAfterConstraints$2.INSTANCE))) {
                ServiceLicenseConstraints.this.licenseCache.clearCache(current.getUuid());
            }
        }

        public void updatedSyncBeforeConstraints(@NotNull XdLicenseSettings old, @NotNull XdLicenseSettings current) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)old), (String)"old");
            Intrinsics.checkParameterIsNotNull((Object)((Object)current), (String)"current");
            if (XdQueryKt.any((XdQuery)ReflectionUtilKt.getAddedLinks((XdEntity)current, (KProperty1)ServiceLicenseConstraints$LicenseListener$updatedSyncBeforeConstraints$1.INSTANCE)) && Intrinsics.areEqual((Object)((Object)current.getService()), (Object)((Object)XdRoots.INSTANCE.getRootService().getHostService())) ^ true) {
                String licenseKey = current.getLicenseKey();
                String licenseName = current.getLicenseName();
                if (licenseKey != null && licenseName != null) {
                    XdService service2 = current.getService();
                    License license2 = ServiceLicenseConstraints.this.licenseCache.getLicense(current);
                    ServiceApplicationDescriptor applicationDescriptor = ServiceLicenseConstraints.this.licenseCache.getServiceApplicationDescriptor(service2);
                    ServiceLicenseChecker licenseChecker = new ServiceLicenseChecker(license2, licenseKey, applicationDescriptor);
                    licenseChecker.checkNumberOfUsersIsNotExceeded();
                }
            }
        }

        public void addedSync(@NotNull XdLicenseSettings added2) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)added2), (String)"added");
            String licenseKey = added2.getLicenseKey();
            String licenseName = added2.getLicenseName();
            if (licenseKey != null && licenseName != null && Intrinsics.areEqual((Object)((Object)added2.getService()), (Object)((Object)XdRoots.INSTANCE.getRootService().getHostService())) ^ true) {
                if (XdQueryKt.isEmpty((XdQuery)((XdQuery)added2.getUsers())) && XdQueryKt.isEmpty((XdQuery)((XdQuery)added2.getAutoJoinGroups()))) {
                    License license2 = ServiceLicenseConstraints.this.licenseCache.getLicense(added2);
                    if (LicenseExtensionKt.getTotalUserCount(license2) < Integer.MAX_VALUE) {
                        if (XdQueryKt.size((XdQuery)XdBaseUser.Companion.all()) <= LicenseExtensionKt.getTotalUserCount(license2)) {
                            added2.getAutoJoinGroups().add((XdEntity)XdRoots.INSTANCE.getRootUserGroup());
                        } else {
                            XdBaseUser principalOrAdmin2;
                            Comparable value$iv;
                            KProperty1 $receiver$iv;
                            NodeBase nodeBase;
                            KProperty1 kProperty1 = (KProperty1)ServiceLicenseConstraints$LicenseListener$addedSync$principalOrAdmin$1.INSTANCE;
                            AuthorityHolder authorityHolder = ServiceLicenseConstraints.this.hubPrincipalManager.getCurrentPrincipal();
                            Comparable comparable = (Comparable)((Object)(authorityHolder != null ? authorityHolder.getId() : null));
                            XdQuery xdQuery = XdBaseUser.Companion.all();
                            XdBaseUser xdBaseUser = (XdBaseUser)XdQueryKt.firstOrNull((XdQuery)xdQuery, (NodeBase)(nodeBase = NodeBaseOperationsKt.eq((String)ReflectionUtilKt.getDBName((KProperty1)$receiver$iv, (KClass)Reflection.getOrCreateKotlinClass(XdBaseUser.class)), (Comparable)value$iv)));
                            if (xdBaseUser == null) {
                                $receiver$iv = (KProperty1)ServiceLicenseConstraints$LicenseListener$addedSync$principalOrAdmin$2.INSTANCE;
                                value$iv = (Comparable)((Object)ServiceLicenseConstraints.this.jetPass.getAuth().getAdminLogin());
                                xdQuery = XdBaseUser.Companion.all();
                                nodeBase = NodeBaseOperationsKt.eq((String)ReflectionUtilKt.getDBName((KProperty1)$receiver$iv, (KClass)Reflection.getOrCreateKotlinClass(XdBaseUser.class)), (Comparable)value$iv);
                                xdBaseUser = principalOrAdmin2 = (XdBaseUser)XdQueryKt.firstOrNull((XdQuery)xdQuery, (NodeBase)nodeBase);
                            }
                            if (principalOrAdmin2 != null) {
                                added2.getUsers().add((XdEntity)principalOrAdmin2);
                            }
                        }
                    }
                } else if (XdQueryKt.isNotEmpty((XdQuery)((XdQuery)added2.getAutoJoinGroups()))) {
                    this.syncAutoJoinUsers(added2, (Sequence<? extends XdBaseUserGroup>)XdQueryKt.asSequence((XdQuery)((XdQuery)added2.getAutoJoinGroups())));
                }
            }
        }

        public void updatedSync(@NotNull XdLicenseSettings old, @NotNull XdLicenseSettings current) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)old), (String)"old");
            Intrinsics.checkParameterIsNotNull((Object)((Object)current), (String)"current");
            String licenseKey = current.getLicenseKey();
            String licenseName = current.getLicenseName();
            if (licenseKey != null && licenseName != null && Intrinsics.areEqual((Object)((Object)current.getService()), (Object)((Object)XdRoots.INSTANCE.getRootService().getHostService())) ^ true && XdQueryKt.isNotEmpty((XdQuery)ReflectionUtilKt.getAddedLinks((XdEntity)old, (KProperty1)ServiceLicenseConstraints$LicenseListener$updatedSync$1.INSTANCE))) {
                this.syncAutoJoinUsers(current, (Sequence<? extends XdBaseUserGroup>)XdQueryKt.asSequence((XdQuery)ReflectionUtilKt.getAddedLinks((XdEntity)old, (KProperty1)ServiceLicenseConstraints$LicenseListener$updatedSync$2.INSTANCE)));
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void syncAutoJoinUsers(XdLicenseSettings current, Sequence<? extends XdBaseUserGroup> newGroups) {
            License license2 = ServiceLicenseConstraints.this.licenseCache.getLicense(current);
            int totalAllowed = LicenseExtensionKt.getTotalUserCount(license2);
            if (totalAllowed < Integer.MAX_VALUE) {
                void $receiver$iv;
                XdQuery initial$iv;
                Sequence<? extends XdBaseUserGroup> sequence = newGroups;
                XdQuery accumulator$iv = initial$iv = XdQueryKt.emptyQuery((XdEntityType)((XdEntityType)XdBaseUser.Companion));
                for (Object element$iv : $receiver$iv) {
                    void autoJoinGroup;
                    XdBaseUserGroup xdBaseUserGroup = (XdBaseUserGroup)((Object)element$iv);
                    XdQuery acc = accumulator$iv;
                    accumulator$iv = XdQueryKt.union((XdQuery)acc, autoJoinGroup.getTransitiveUsers());
                }
                List usersToAdd = XdQueryKt.toList((XdQuery)XdQueryKt.exclude((XdQuery)accumulator$iv, (XdQuery)((XdQuery)current.getUsers())));
                int usedLicenses2 = XdQueryKt.size((XdQuery)((XdQuery)current.getUsers()));
                Iterator iterator = usersToAdd.iterator();
                while (iterator.hasNext() && usedLicenses2 < totalAllowed) {
                    XdBaseUser user2 = (XdBaseUser)((Object)iterator.next());
                    current.getUsers().add((XdEntity)user2);
                    if (user2.getBanned()) continue;
                    ++usedLicenses2;
                }
            }
        }

        public void addedAsync(@NotNull XdLicenseSettings added2) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)added2), (String)"added");
            XdEntityListener.DefaultImpls.addedAsync((XdEntityListener)this, (XdEntity)added2);
        }

        public void addedSyncAfterConstraints(@NotNull XdLicenseSettings added2) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)added2), (String)"added");
            XdEntityListener.DefaultImpls.addedSyncAfterConstraints((XdEntityListener)this, (XdEntity)added2);
        }

        public void addedSyncBeforeConstraints(@NotNull XdLicenseSettings added2) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)added2), (String)"added");
            XdEntityListener.DefaultImpls.addedSyncBeforeConstraints((XdEntityListener)this, (XdEntity)added2);
        }

        @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="addedSyncAfterConstraints"), message="Use addedSyncAfterConstraints instead")
        public void addedSyncBeforeFlush(@NotNull XdLicenseSettings added2) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)added2), (String)"added");
            XdEntityListener.DefaultImpls.addedSyncBeforeFlush((XdEntityListener)this, (XdEntity)added2);
        }

        public void removedAsync(@NotNull XdLicenseSettings removed) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)removed), (String)"removed");
            XdEntityListener.DefaultImpls.removedAsync((XdEntityListener)this, (XdEntity)removed);
        }

        public void removedSync(@NotNull XdLicenseSettings removed) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)removed), (String)"removed");
            XdEntityListener.DefaultImpls.removedSync((XdEntityListener)this, (XdEntity)removed);
        }

        public void removedSyncAfterConstraints(@NotNull XdLicenseSettings removed) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)removed), (String)"removed");
            XdEntityListener.DefaultImpls.removedSyncAfterConstraints((XdEntityListener)this, (XdEntity)removed);
        }

        public void removedSyncBeforeConstraints(@NotNull XdLicenseSettings removed) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)removed), (String)"removed");
            XdEntityListener.DefaultImpls.removedSyncBeforeConstraints((XdEntityListener)this, (XdEntity)removed);
        }

        @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="removedSyncAfterConstraints"), message="Use removedSyncAfterConstraints instead")
        public void removedSyncBeforeFlush(@NotNull XdLicenseSettings added2) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)added2), (String)"added");
            XdEntityListener.DefaultImpls.removedSyncBeforeFlush((XdEntityListener)this, (XdEntity)added2);
        }

        public void updatedAsync(@NotNull XdLicenseSettings old, @NotNull XdLicenseSettings current) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)old), (String)"old");
            Intrinsics.checkParameterIsNotNull((Object)((Object)current), (String)"current");
            XdEntityListener.DefaultImpls.updatedAsync((XdEntityListener)this, (XdEntity)old, (XdEntity)current);
        }

        @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="updatedSyncAfterConstraints"), message="Use updatedSyncAfterConstraints instead")
        public void updatedSyncBeforeFlush(@NotNull XdLicenseSettings old, @NotNull XdLicenseSettings current) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)old), (String)"old");
            Intrinsics.checkParameterIsNotNull((Object)((Object)current), (String)"current");
            XdEntityListener.DefaultImpls.updatedSyncBeforeFlush((XdEntityListener)this, (XdEntity)old, (XdEntity)current);
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Ljetbrains/jetpass/userManagement/persistence/license/ServiceLicenseConstraints$GroupListener;", "Lkotlinx/dnq/listener/XdEntityListener;", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdBaseUserGroup;", "(Ljetbrains/jetpass/userManagement/persistence/license/ServiceLicenseConstraints;)V", "updatedSync", "", "old", "current", "jetbrains.jetpass.userManagement"})
    private final class GroupListener
    implements XdEntityListener<XdBaseUserGroup> {
        public void updatedSync(@NotNull XdBaseUserGroup old, @NotNull XdBaseUserGroup current) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)old), (String)"old");
            Intrinsics.checkParameterIsNotNull((Object)((Object)current), (String)"current");
            List addedUsers2 = XdQueryKt.toList((XdQuery)ReflectionUtilKt.getAddedLinks((XdEntity)old, (KProperty1)ServiceLicenseConstraints$GroupListener$updatedSync$addedUsers$1.INSTANCE));
            List removedUsers2 = XdQueryKt.toList((XdQuery)ReflectionUtilKt.getRemovedLinks((XdEntity)old, (KProperty1)ServiceLicenseConstraints$GroupListener$updatedSync$removedUsers$1.INSTANCE));
            ServiceLicenseConstraints.this.syncLicenseAutoJoinGroups(current, addedUsers2, removedUsers2);
        }

        public void addedAsync(@NotNull XdBaseUserGroup added2) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)added2), (String)"added");
            XdEntityListener.DefaultImpls.addedAsync((XdEntityListener)this, (XdEntity)added2);
        }

        public void addedSync(@NotNull XdBaseUserGroup added2) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)added2), (String)"added");
            XdEntityListener.DefaultImpls.addedSync((XdEntityListener)this, (XdEntity)added2);
        }

        public void addedSyncAfterConstraints(@NotNull XdBaseUserGroup added2) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)added2), (String)"added");
            XdEntityListener.DefaultImpls.addedSyncAfterConstraints((XdEntityListener)this, (XdEntity)added2);
        }

        public void addedSyncBeforeConstraints(@NotNull XdBaseUserGroup added2) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)added2), (String)"added");
            XdEntityListener.DefaultImpls.addedSyncBeforeConstraints((XdEntityListener)this, (XdEntity)added2);
        }

        @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="addedSyncAfterConstraints"), message="Use addedSyncAfterConstraints instead")
        public void addedSyncBeforeFlush(@NotNull XdBaseUserGroup added2) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)added2), (String)"added");
            XdEntityListener.DefaultImpls.addedSyncBeforeFlush((XdEntityListener)this, (XdEntity)added2);
        }

        public void removedAsync(@NotNull XdBaseUserGroup removed) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)removed), (String)"removed");
            XdEntityListener.DefaultImpls.removedAsync((XdEntityListener)this, (XdEntity)removed);
        }

        public void removedSync(@NotNull XdBaseUserGroup removed) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)removed), (String)"removed");
            XdEntityListener.DefaultImpls.removedSync((XdEntityListener)this, (XdEntity)removed);
        }

        public void removedSyncAfterConstraints(@NotNull XdBaseUserGroup removed) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)removed), (String)"removed");
            XdEntityListener.DefaultImpls.removedSyncAfterConstraints((XdEntityListener)this, (XdEntity)removed);
        }

        public void removedSyncBeforeConstraints(@NotNull XdBaseUserGroup removed) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)removed), (String)"removed");
            XdEntityListener.DefaultImpls.removedSyncBeforeConstraints((XdEntityListener)this, (XdEntity)removed);
        }

        @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="removedSyncAfterConstraints"), message="Use removedSyncAfterConstraints instead")
        public void removedSyncBeforeFlush(@NotNull XdBaseUserGroup added2) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)added2), (String)"added");
            XdEntityListener.DefaultImpls.removedSyncBeforeFlush((XdEntityListener)this, (XdEntity)added2);
        }

        public void updatedAsync(@NotNull XdBaseUserGroup old, @NotNull XdBaseUserGroup current) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)old), (String)"old");
            Intrinsics.checkParameterIsNotNull((Object)((Object)current), (String)"current");
            XdEntityListener.DefaultImpls.updatedAsync((XdEntityListener)this, (XdEntity)old, (XdEntity)current);
        }

        public void updatedSyncAfterConstraints(@NotNull XdBaseUserGroup old, @NotNull XdBaseUserGroup current) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)old), (String)"old");
            Intrinsics.checkParameterIsNotNull((Object)((Object)current), (String)"current");
            XdEntityListener.DefaultImpls.updatedSyncAfterConstraints((XdEntityListener)this, (XdEntity)old, (XdEntity)current);
        }

        public void updatedSyncBeforeConstraints(@NotNull XdBaseUserGroup old, @NotNull XdBaseUserGroup current) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)old), (String)"old");
            Intrinsics.checkParameterIsNotNull((Object)((Object)current), (String)"current");
            XdEntityListener.DefaultImpls.updatedSyncBeforeConstraints((XdEntityListener)this, (XdEntity)old, (XdEntity)current);
        }

        @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="updatedSyncAfterConstraints"), message="Use updatedSyncAfterConstraints instead")
        public void updatedSyncBeforeFlush(@NotNull XdBaseUserGroup old, @NotNull XdBaseUserGroup current) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)old), (String)"old");
            Intrinsics.checkParameterIsNotNull((Object)((Object)current), (String)"current");
            XdEntityListener.DefaultImpls.updatedSyncBeforeFlush((XdEntityListener)this, (XdEntity)old, (XdEntity)current);
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/jetpass/userManagement/persistence/license/ServiceLicenseConstraints$Companion;", "Lmu/KLogging;", "()V", "jetbrains.jetpass.userManagement"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

