/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.userManagement.persistence.migration;

import java.net.URI;
import java.util.HashSet;
import java.util.Iterator;
import javax.ws.rs.core.UriBuilder;
import jetbrains.jetpass.userManagement.persistence.dnq.module.XdAuthModule;
import jetbrains.jetpass.userManagement.persistence.dnq.module.XdExternalAuthModule;
import jetbrains.jetpass.userManagement.persistence.migration.MigrationImpl;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\b\u0010\f\u001a\u00020\u0004H\u0002J\b\u0010\r\u001a\u00020\u0004H\u0002\u00a8\u0006\u000f"}, d2={"Ljetbrains/jetpass/userManagement/persistence/migration/FixNotUniqueAuthModuleNameAndName;", "Ljetbrains/jetpass/userManagement/persistence/migration/MigrationImpl;", "()V", "apply", "", "incrementName", "", "name", "inc", "", "incrementUrl", "url", "makeUniqueName", "makeUniqueUrl", "Companion", "jetbrains.jetpass.userManagement"})
public final class FixNotUniqueAuthModuleNameAndName
extends MigrationImpl {
    private static final Regex NAME_PATTERN;
    public static final Companion Companion;

    @Override
    public void apply() {
        this.makeUniqueName();
        this.makeUniqueUrl();
    }

    private final void makeUniqueName() {
        HashSet<String> uniqueAuthModuleNames = new HashSet<String>();
        Iterator iterator = XdQueryKt.iterator((XdQuery)XdAuthModule.Companion.all());
        while (iterator.hasNext()) {
            String string;
            HashSet<String> hashSet;
            String string2;
            XdAuthModule authModule2 = (XdAuthModule)((Object)iterator.next());
            String name2 = authModule2.getName();
            int increment = 0;
            while (true) {
                string2 = name2;
                hashSet = uniqueAuthModuleNames;
                String string3 = string2;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string3.toLowerCase(), (String)"(this as java.lang.String).toLowerCase()");
                if (!hashSet.contains(string)) break;
                name2 = this.incrementName(name2, ++increment);
            }
            if (increment > 0) {
                authModule2.setName(name2);
            }
            string2 = name2;
            hashSet = uniqueAuthModuleNames;
            String string4 = string2;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).toLowerCase()");
            string = string5;
            hashSet.add(string);
        }
    }

    private final String incrementName(String name2, int inc) {
        Object object;
        block3: {
            block2: {
                String base;
                Object object2;
                Object it;
                Object object3;
                object = NAME_PATTERN.matchEntire((CharSequence)name2);
                if (object == null || (object = object.getDestructured()) == null) break block2;
                Object object4 = object3 = (it = (object2 = object));
                String string = base = (String)object4.getMatch().getGroupValues().get(1);
                object = string;
                if (string != null) break block3;
            }
            object = name2;
        }
        Object nameBase = object;
        return (String)nameBase + " (" + inc + ')';
    }

    private final void makeUniqueUrl() {
        HashSet<String> uniqueAuthModuleNames = new HashSet<String>();
        Iterator iterator = XdQueryKt.iterator((XdQuery)XdExternalAuthModule.Companion.all());
        while (iterator.hasNext()) {
            String string;
            HashSet<String> hashSet;
            String string2;
            XdExternalAuthModule authSetting = (XdExternalAuthModule)((Object)iterator.next());
            String url2 = authSetting.getUrl();
            int increment = 0;
            while (true) {
                string2 = url2;
                hashSet = uniqueAuthModuleNames;
                String string3 = string2;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string3.toLowerCase(), (String)"(this as java.lang.String).toLowerCase()");
                if (!hashSet.contains(string)) break;
                url2 = this.incrementUrl(url2, ++increment);
            }
            if (increment > 0) {
                authSetting.setUrl(url2);
            }
            string2 = url2;
            hashSet = uniqueAuthModuleNames;
            String string4 = string2;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).toLowerCase()");
            string = string5;
            hashSet.add(string);
        }
    }

    private final String incrementUrl(String url2, int inc) {
        UriBuilder uriBuilder;
        try {
            uriBuilder = UriBuilder.fromUri((String)url2);
        }
        catch (Exception e) {
            UriBuilder uriBuilder2;
            try {
                uriBuilder2 = UriBuilder.fromUri((URI)URI.create(url2));
            }
            catch (Exception e2) {
                uriBuilder2 = UriBuilder.fromUri((String)"http://localhost");
            }
            uriBuilder = uriBuilder2;
        }
        UriBuilder builder = uriBuilder;
        return builder.queryParam("unique", new Object[]{inc}).toString();
    }

    static {
        Companion = new Companion(null);
        NAME_PATTERN = new Regex("(.*)\\s\\(\\d+\\)");
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ljetbrains/jetpass/userManagement/persistence/migration/FixNotUniqueAuthModuleNameAndName$Companion;", "", "()V", "NAME_PATTERN", "Lkotlin/text/Regex;", "jetbrains.jetpass.userManagement"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

