/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.userManagement.persistence.migration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jetbrains.exodus.database.TransientEntityStore;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.exodus.query.NodeBase;
import jetbrains.jetpass.dnq.SpringStoreContainer;
import jetbrains.jetpass.dnq.TransactionKt;
import jetbrains.jetpass.userManagement.persistence.InitializationUtilKt;
import jetbrains.jetpass.userManagement.persistence.migration.ClearAuthEvents;
import jetbrains.jetpass.userManagement.persistence.migration.Migration;
import jetbrains.jetpass.userManagement.persistence.migration.MigrationContainer;
import jetbrains.jetpass.userManagement.persistence.migration.MigrationContainer$isApplied$1$1;
import jetbrains.jetpass.userManagement.persistence.migration.MigrationContainer$reapply$1$jetPassMigration$1;
import jetbrains.jetpass.userManagement.persistence.migration.PluggedMigration;
import jetbrains.jetpass.userManagement.persistence.migration.RefactoringUtil;
import jetbrains.jetpass.userManagement.persistence.migration.XdDatabaseMigration;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty1;
import kotlinx.dnq.XdEntityType;
import kotlinx.dnq.query.NodeBaseOperationsKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import kotlinx.dnq.util.ReflectionUtilKt;
import mu.KLogger;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u001d2\u00020\u0001:\u0002\u001d\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u0016\u0010\u0018\u001a\u00020\u00132\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00190\u0004H\u0002J\u000e\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u0017H\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R \u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR \u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u000b\"\u0004\b\u0011\u0010\r\u00a8\u0006\u001f"}, d2={"Ljetbrains/jetpass/userManagement/persistence/migration/MigrationContainer;", "", "()V", "allMigrations", "", "Ljetbrains/jetpass/userManagement/persistence/migration/Migration;", "getAllMigrations", "()Ljava/lang/Iterable;", "migrations", "", "getMigrations", "()Ljava/util/List;", "setMigrations", "(Ljava/util/List;)V", "pluggedMigrations", "Ljetbrains/jetpass/userManagement/persistence/migration/PluggedMigration;", "getPluggedMigrations", "setPluggedMigrations", "applyAll", "", "isApplied", "", "migrationName", "", "printMigrationInfo", "Ljetbrains/jetpass/userManagement/persistence/migration/MigrationContainer$MigrationInfo;", "reapply", "saveAsApplied", "name", "Companion", "MigrationInfo", "jetbrains.jetpass.userManagement"})
public final class MigrationContainer {
    @NotNull
    private List<? extends Migration> migrations = CollectionsKt.emptyList();
    @NotNull
    private List<? extends PluggedMigration> pluggedMigrations = CollectionsKt.emptyList();
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final List<Migration> getMigrations() {
        return this.migrations;
    }

    public final void setMigrations(@NotNull List<? extends Migration> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"<set-?>");
        this.migrations = list;
    }

    @NotNull
    public final List<PluggedMigration> getPluggedMigrations() {
        return this.pluggedMigrations;
    }

    public final void setPluggedMigrations(@NotNull List<? extends PluggedMigration> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"<set-?>");
        this.pluggedMigrations = list;
    }

    @NotNull
    public final Iterable<Migration> getAllMigrations() {
        Migration it;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)this.pluggedMigrations;
        Object destination$iv$iv = new LinkedHashMap();
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object $receiver$iv$iv$iv = destination$iv$iv;
            Object element$iv$iv = iterator.next();
            it = (PluggedMigration)element$iv$iv;
            Migration key$iv$iv = it.getPreviousMigration();
            Object value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                ArrayList answer$iv$iv$iv = new ArrayList();
                $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map plugged = destination$iv$iv;
        $receiver$iv$iv = $receiver$iv = (Iterable)this.migrations;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (Migration)element$iv$iv;
            List list = (List)plugged.get(it);
            Collection collection = CollectionsKt.listOf((Object)it);
            List list2 = list;
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
            List list3 = list2;
            Iterable list$iv$iv = CollectionsKt.plus((Collection)collection, (Iterable)list3);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    public final void applyAll() {
        void total;
        Ref.IntRef intRef = new Ref.IntRef();
        intRef.element = 0;
        TransientEntityStore transientEntityStore = SpringStoreContainer.INSTANCE.getStore();
        long start$iv = System.currentTimeMillis();
        Companion.getLogger().info((Function0)applyAll.totalDuration.1.1.INSTANCE);
        InitializationUtilKt.removeUniquePropertyIndexes(transientEntityStore);
        List allMigrations = (List)TransactionKt.legacyTransactional$default(false, null, false, (Function1)new Function1<TransientStoreSession, List<? extends MigrationInfo>>(this, transientEntityStore, (Ref.IntRef)total){
            final /* synthetic */ MigrationContainer this$0;
            final /* synthetic */ TransientEntityStore $transientEntityStore$inlined;
            final /* synthetic */ Ref.IntRef $total$inlined;
            {
                this.this$0 = migrationContainer;
                this.$transientEntityStore$inlined = transientEntityStore;
                this.$total$inlined = intRef;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<MigrationInfo> invoke(@NotNull TransientStoreSession it) {
                void $receiver$iv$iv;
                Iterable<Migration> $receiver$iv;
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                Iterable<Migration> iterable = $receiver$iv = this.this$0.getAllMigrations();
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($receiver$iv, (int)10));
                for (T item$iv$iv : $receiver$iv$iv) {
                    void it2;
                    Migration migration = (Migration)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    MigrationInfo migrationInfo = new MigrationInfo((Migration)it2, !it2.isRepairMigration() && this.this$0.isApplied(it2.getName()));
                    collection.add(migrationInfo);
                }
                return (List)destination$iv$iv;
            }
        }, 7, null);
        this.printMigrationInfo(allMigrations);
        for (MigrationInfo migrationInfo : allMigrations) {
            String name2 = migrationInfo.getMigration().getName();
            if (migrationInfo.getMigration().isRepairMigration() || !migrationInfo.isApplied()) {
                try {
                    TransactionKt.legacyTransactional$default(false, null, false, (Function1)new Function1<TransientStoreSession, Integer>(name2, migrationInfo, this, transientEntityStore, (Ref.IntRef)total){
                        final /* synthetic */ String $name;
                        final /* synthetic */ MigrationInfo $migrationInfo;
                        final /* synthetic */ MigrationContainer this$0;
                        final /* synthetic */ TransientEntityStore $transientEntityStore$inlined;
                        final /* synthetic */ Ref.IntRef $total$inlined;
                        {
                            this.$name = string;
                            this.$migrationInfo = migrationInfo;
                            this.this$0 = migrationContainer;
                            this.$transientEntityStore$inlined = transientEntityStore;
                            this.$total$inlined = intRef;
                            super(1);
                        }

                        public final int invoke(@NotNull TransientStoreSession txn) {
                            Intrinsics.checkParameterIsNotNull((Object)txn, (String)"txn");
                            RefactoringUtil.INSTANCE.forceTxnUpgrade();
                            MigrationContainer.Companion.getLogger().info("   Migration: " + this.$name + " - started!");
                            long start$iv = System.currentTimeMillis();
                            this.$migrationInfo.getMigration().apply();
                            if (!this.$migrationInfo.getMigration().isRepairMigration()) {
                                MigrationContainer.access$saveAsApplied(this.this$0, this.$name);
                            }
                            txn.flush();
                            long duration = System.currentTimeMillis() - start$iv;
                            MigrationContainer.Companion.getLogger().info("   Migration: " + this.$name + " - applied in " + duration + "ms!");
                            int n = this.$total$inlined.element;
                            this.$total$inlined.element = n + 1;
                            return n;
                        }
                    }, 7, null);
                    continue;
                }
                catch (Throwable ex) {
                    Companion.getLogger().error("   Migration: " + name2 + " - aborted!", ex);
                    Companion.getLogger().error("All sequential migration abort!");
                    throw (Throwable)new RuntimeException("Fail on jetPass migration! See logs for errors!");
                }
            }
            Companion.getLogger().debug("   Migration: " + name2 + " - Already applied.");
        }
        long totalDuration2 = System.currentTimeMillis() - start$iv;
        Companion.getLogger().info("Total migrations applied: " + total.element + " in " + totalDuration2 + "ms.");
        Companion.getLogger().info((Function0)applyAll.1.INSTANCE);
        long start$iv2 = System.currentTimeMillis();
        InitializationUtilKt.initUniqueProperties(transientEntityStore);
        long reindexDuration = System.currentTimeMillis() - start$iv2;
        Companion.getLogger().info((Function0)new Function0<String>(reindexDuration){
            final /* synthetic */ long $reindexDuration;

            @NotNull
            public final String invoke() {
                return "Reindex completed in " + this.$reindexDuration + " ms";
            }
            {
                this.$reindexDuration = l;
                super(0);
            }
        });
        TransactionKt.legacyTransactional$default(false, null, false, (Function1)new Function1<TransientStoreSession, Unit>(this){
            final /* synthetic */ MigrationContainer this$0;

            public final void invoke(@NotNull TransientStoreSession it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                String string = ClearAuthEvents.class.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ClearAuthEvents::class.java.name");
                if (!this.this$0.isApplied(string)) {
                    ClearAuthEvents.INSTANCE.start((Function0<Unit>)((Function0)new Function0<Unit>(this){
                        final /* synthetic */ applyAll.3 this$0;

                        public final void invoke() {
                            TransactionKt.legacyTransactional$default(false, null, false, (Function1)new Function1<TransientStoreSession, Unit>(this){
                                final /* synthetic */ applyAll.1 this$0;

                                public final void invoke(@NotNull TransientStoreSession it) {
                                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                                    MigrationContainer migrationContainer = this.this$0.this$0.this$0;
                                    String string = ClearAuthEvents.class.getName();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ClearAuthEvents::class.java.name");
                                    MigrationContainer.access$saveAsApplied(migrationContainer, string);
                                }
                                {
                                    this.this$0 = var1_1;
                                    super(1);
                                }
                            }, 7, null);
                        }
                        {
                            this.this$0 = var1_1;
                            super(0);
                        }
                    }));
                }
            }
            {
                this.this$0 = migrationContainer;
                super(1);
            }
        }, 7, null);
    }

    public final boolean isApplied(@NotNull String migrationName) {
        Intrinsics.checkParameterIsNotNull((Object)migrationName, (String)"migrationName");
        return (Boolean)TransactionKt.legacyTransactional$default(false, null, false, (Function1)new Function1<TransientStoreSession, Boolean>(migrationName){
            final /* synthetic */ String $migrationName;

            /*
             * WARNING - void declaration
             */
            public final boolean invoke(@NotNull TransientStoreSession it) {
                void value$iv;
                void $receiver$iv;
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                KProperty1 kProperty1 = (KProperty1)MigrationContainer$isApplied$1$1.INSTANCE;
                Comparable comparable = (Comparable)((Object)this.$migrationName);
                XdEntityType xdEntityType = (XdEntityType)XdDatabaseMigration.Companion;
                NodeBase nodeBase = NodeBaseOperationsKt.eq((String)ReflectionUtilKt.getDBName((KProperty1)$receiver$iv, (KClass)Reflection.getOrCreateKotlinClass(XdDatabaseMigration.class)), (Comparable)value$iv);
                return XdQueryKt.isNotEmpty((XdQuery)XdQueryKt.query((XdEntityType)xdEntityType, (NodeBase)nodeBase));
            }
            {
                this.$migrationName = string;
                super(1);
            }
        }, 7, null);
    }

    public final void reapply(@NotNull String migrationName) {
        Intrinsics.checkParameterIsNotNull((Object)migrationName, (String)"migrationName");
        TransactionKt.legacyTransactional$default(false, null, false, (Function1)new Function1<TransientStoreSession, Unit>(migrationName){
            final /* synthetic */ String $migrationName;

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final Unit invoke(@NotNull TransientStoreSession it) {
                Unit unit;
                XdDatabaseMigration jetPassMigration2;
                void value$iv;
                void $receiver$iv;
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                KProperty1 kProperty1 = (KProperty1)MigrationContainer$reapply$1$jetPassMigration$1.INSTANCE;
                Comparable comparable = (Comparable)((Object)this.$migrationName);
                XdEntityType xdEntityType = (XdEntityType)XdDatabaseMigration.Companion;
                NodeBase nodeBase = NodeBaseOperationsKt.eq((String)ReflectionUtilKt.getDBName((KProperty1)$receiver$iv, (KClass)Reflection.getOrCreateKotlinClass(XdDatabaseMigration.class)), (Comparable)value$iv);
                XdDatabaseMigration xdDatabaseMigration = jetPassMigration2 = (XdDatabaseMigration)XdQueryKt.firstOrNull((XdQuery)XdQueryKt.query((XdEntityType)xdEntityType, (NodeBase)nodeBase));
                if (xdDatabaseMigration != null) {
                    xdDatabaseMigration.delete();
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                return unit;
            }
            {
                this.$migrationName = string;
                super(1);
            }
        }, 7, null);
    }

    private final void saveAsApplied(String name2) {
        XdDatabaseMigration.Companion.new(name2);
    }

    private final void printMigrationInfo(Iterable<MigrationInfo> migrations) {
        StringBuilder stringBuilder;
        KLogger kLogger = Companion.getLogger();
        StringBuilder $receiver = stringBuilder = new StringBuilder();
        $receiver.append("List of all available data migrations (R - repair, A - applied, tab - plugin):\n");
        for (MigrationInfo it : migrations) {
            if (it.getMigration().isRepairMigration()) {
                $receiver.append(" R \t");
            } else if (it.isApplied()) {
                $receiver.append(" A \t");
            } else {
                $receiver.append("\t");
            }
            if (it.getMigration() instanceof PluggedMigration) {
                $receiver.append("  ");
            }
            $receiver.append(it.getMigration().getName());
            $receiver.append('\n');
        }
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        String string2 = string;
        kLogger.info(string2);
    }

    public static final /* synthetic */ void access$saveAsApplied(MigrationContainer $this, @NotNull String name2) {
        $this.saveAsApplied(name2);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Ljetbrains/jetpass/userManagement/persistence/migration/MigrationContainer$MigrationInfo;", "", "migration", "Ljetbrains/jetpass/userManagement/persistence/migration/Migration;", "isApplied", "", "(Ljetbrains/jetpass/userManagement/persistence/migration/Migration;Z)V", "()Z", "getMigration", "()Ljetbrains/jetpass/userManagement/persistence/migration/Migration;", "jetbrains.jetpass.userManagement"})
    public static final class MigrationInfo {
        @NotNull
        private final Migration migration;
        private final boolean isApplied;

        @NotNull
        public final Migration getMigration() {
            return this.migration;
        }

        public final boolean isApplied() {
            return this.isApplied;
        }

        public MigrationInfo(@NotNull Migration migration, boolean isApplied2) {
            Intrinsics.checkParameterIsNotNull((Object)migration, (String)"migration");
            this.migration = migration;
            this.isApplied = isApplied2;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/jetpass/userManagement/persistence/migration/MigrationContainer$Companion;", "Lmu/KLogging;", "()V", "jetbrains.jetpass.userManagement"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

