/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.userManagement.persistence.migration;

import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.Certificate;
import jetbrains.exodus.database.exceptions.UserConstraintValidationException;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.jetpass.userManagement.persistence.dnq.XdCertificate;
import jetbrains.jetpass.userManagement.persistence.dnq.XdTrustStore;
import jetbrains.jetpass.userManagement.persistence.migration.MigrationImpl;
import jetbrains.jetpass.userManagement.persistence.migration.MoveTrustStoreCertificateDataToTrustStoreEntry;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u001c\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002\u00a8\u0006\f"}, d2={"Ljetbrains/jetpass/userManagement/persistence/migration/MoveTrustStoreCertificateDataToTrustStoreEntry;", "Ljetbrains/jetpass/userManagement/persistence/migration/MigrationImpl;", "()V", "apply", "", "deserializeKeyStore", "Ljava/security/KeyStore;", "input", "Ljava/io/InputStream;", "password", "", "Companion", "jetbrains.jetpass.userManagement"})
public final class MoveTrustStoreCertificateDataToTrustStoreEntry
extends MigrationImpl {
    public static final Companion Companion = new Companion(null);

    @Override
    public void apply() {
        KeyStore keyStore2;
        XdTrustStore trustStore = XdTrustStore.Companion.getInstance();
        try {
            keyStore2 = this.deserializeKeyStore(PrimitiveAssociationSemantics.getBlob((Entity)trustStore.getEntity(), (String)"store"), (String)PrimitiveAssociationSemantics.get((Entity)trustStore.getEntity(), (String)"password", String.class, null));
        }
        catch (Exception e) {
            Companion.getLogger().warn((Throwable)e, (Function0)apply.keyStore.1.INSTANCE);
            trustStore.getEntries().clear();
            return;
        }
        KeyStore keyStore3 = keyStore2;
        for (XdCertificate trustStoreEntry : XdQueryKt.toList((XdQuery)((XdQuery)trustStore.getEntries()))) {
            try {
                Certificate certificate;
                Certificate certificate2 = certificate = keyStore3.getCertificate(trustStoreEntry.getUuid());
                Intrinsics.checkExpressionValueIsNotNull((Object)certificate2, (String)"certificate");
                byte[] certificateBytes = certificate2.getEncoded();
                trustStoreEntry.setCertificate(new ByteArrayInputStream(certificateBytes));
            }
            catch (GeneralSecurityException e) {
                Companion.getLogger().warn((Throwable)e, (Function0)new Function0<String>(trustStoreEntry){
                    final /* synthetic */ XdCertificate $trustStoreEntry;

                    @NotNull
                    public final String invoke() {
                        return "Trusted certificate " + this.$trustStoreEntry.getName() + " is corrupted and will removed";
                    }
                    {
                        this.$trustStoreEntry = xdCertificate;
                        super(0);
                    }
                });
                trustStoreEntry.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final KeyStore deserializeKeyStore(InputStream input, String password) {
        try {
            KeyStore store2 = KeyStore.getInstance(XdTrustStore.Companion.getJKS_STORE_TYPE());
            try {
                char[] cArray;
                KeyStore keyStore2 = store2;
                InputStream inputStream = input;
                String string = password;
                if (string != null) {
                    String string2 = string;
                    InputStream inputStream2 = inputStream;
                    KeyStore keyStore3 = keyStore2;
                    String string3 = string2;
                    if (string3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    char[] cArray2 = string3.toCharArray();
                    Intrinsics.checkExpressionValueIsNotNull((Object)cArray2, (String)"(this as java.lang.String).toCharArray()");
                    char[] cArray3 = cArray2;
                    keyStore2 = keyStore3;
                    inputStream = inputStream2;
                    cArray = cArray3;
                } else {
                    cArray = null;
                }
                keyStore2.load(inputStream, cArray);
            }
            catch (Exception cause) {
                UserConstraintValidationException userConstraintValidationException;
                UserConstraintValidationException $receiver = userConstraintValidationException = new UserConstraintValidationException("Cannot load KeyStore: " + cause.getMessage(), null, 2, null);
                $receiver.initCause((Throwable)cause);
                throw (Throwable)userConstraintValidationException;
            }
            KeyStore keyStore4 = store2;
            Intrinsics.checkExpressionValueIsNotNull((Object)keyStore4, (String)"store");
            KeyStore cause = keyStore4;
            return cause;
        }
        finally {
            try {
                InputStream inputStream = input;
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                Companion.getLogger().warn("Cannot close stream", (Throwable)e);
            }
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/jetpass/userManagement/persistence/migration/MoveTrustStoreCertificateDataToTrustStoreEntry$Companion;", "Lmu/KLogging;", "()V", "jetbrains.jetpass.userManagement"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

