/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.userManagement.persistence.migration;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import jetbrains.jetpass.core.net.NetUtilsKt;
import jetbrains.jetpass.userManagement.persistence.UriConcatenatorKt;
import jetbrains.jetpass.userManagement.persistence.dnq.XdService;
import jetbrains.jetpass.userManagement.persistence.migration.MigrationImpl;
import jetbrains.jetpass.userManagement.persistence.migration.NormalizeServiceRedirectURIs;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00052\u00020\u0001:\u0002\u0005\u0006B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0007"}, d2={"Ljetbrains/jetpass/userManagement/persistence/migration/NormalizeServiceRedirectURIs;", "Ljetbrains/jetpass/userManagement/persistence/migration/MigrationImpl;", "()V", "apply", "", "Companion", "NormalizeUriResult", "jetbrains.jetpass.userManagement"})
public final class NormalizeServiceRedirectURIs
extends MigrationImpl {
    public static final Companion Companion = new Companion(null);

    @Override
    public void apply() {
        Sequence $receiver$iv = SequencesKt.filter((Sequence)SequencesKt.filterNot((Sequence)XdQueryKt.asSequence((XdQuery)XdService.Companion.all()), (Function1)apply.1.INSTANCE), (Function1)apply.2.INSTANCE);
        for (Object element$iv : $receiver$iv) {
            NormalizeUriResult normalizeUriResult;
            XdService service2 = (XdService)((Object)element$iv);
            String string = service2.getHomeUrl();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            if (Companion.normalizeUris(string, service2.getRedirectURIs()) == null) continue;
            NormalizeUriResult $baseUrls_redirectUris = normalizeUriResult;
            Iterable<String> baseUrls = $baseUrls_redirectUris.component1();
            Iterable<String> redirectUris = $baseUrls_redirectUris.component2();
            service2.setBaseURLs(baseUrls);
            service2.setRedirectURIs(redirectUris);
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001c\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0006J\u000f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J)\u0010\f\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0004H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Ljetbrains/jetpass/userManagement/persistence/migration/NormalizeServiceRedirectURIs$NormalizeUriResult;", "", "baseURLs", "", "", "redirectURIs", "(Ljava/lang/Iterable;Ljava/lang/Iterable;)V", "getBaseURLs", "()Ljava/lang/Iterable;", "getRedirectURIs", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "jetbrains.jetpass.userManagement"})
    public static final class NormalizeUriResult {
        @NotNull
        private final Iterable<String> baseURLs;
        @NotNull
        private final Iterable<String> redirectURIs;

        @NotNull
        public final Iterable<String> getBaseURLs() {
            return this.baseURLs;
        }

        @NotNull
        public final Iterable<String> getRedirectURIs() {
            return this.redirectURIs;
        }

        public NormalizeUriResult(@NotNull Iterable<String> baseURLs, @NotNull Iterable<String> redirectURIs) {
            Intrinsics.checkParameterIsNotNull(baseURLs, (String)"baseURLs");
            Intrinsics.checkParameterIsNotNull(redirectURIs, (String)"redirectURIs");
            this.baseURLs = baseURLs;
            this.redirectURIs = redirectURIs;
        }

        @NotNull
        public final Iterable<String> component1() {
            return this.baseURLs;
        }

        @NotNull
        public final Iterable<String> component2() {
            return this.redirectURIs;
        }

        @NotNull
        public final NormalizeUriResult copy(@NotNull Iterable<String> baseURLs, @NotNull Iterable<String> redirectURIs) {
            Intrinsics.checkParameterIsNotNull(baseURLs, (String)"baseURLs");
            Intrinsics.checkParameterIsNotNull(redirectURIs, (String)"redirectURIs");
            return new NormalizeUriResult(baseURLs, redirectURIs);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ NormalizeUriResult copy$default(NormalizeUriResult normalizeUriResult, Iterable iterable, Iterable iterable2, int n, Object object) {
            if ((n & 1) != 0) {
                iterable = normalizeUriResult.baseURLs;
            }
            if ((n & 2) != 0) {
                iterable2 = normalizeUriResult.redirectURIs;
            }
            return normalizeUriResult.copy(iterable, iterable2);
        }

        public String toString() {
            return "NormalizeUriResult(baseURLs=" + this.baseURLs + ", redirectURIs=" + this.redirectURIs + ")";
        }

        public int hashCode() {
            Iterable<String> iterable = this.baseURLs;
            Iterable<String> iterable2 = this.redirectURIs;
            return (iterable != null ? iterable.hashCode() : 0) * 31 + (iterable2 != null ? iterable2.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof NormalizeUriResult)) break block3;
                    NormalizeUriResult normalizeUriResult = (NormalizeUriResult)object;
                    if (!Intrinsics.areEqual(this.baseURLs, normalizeUriResult.baseURLs) || !Intrinsics.areEqual(this.redirectURIs, normalizeUriResult.redirectURIs)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002J\u001c\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002J6\u0010\n\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00070\u000b2\u0006\u0010\f\u001a\u00020\u00052\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002J\u001e\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0004J,\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u00a8\u0006\u0016"}, d2={"Ljetbrains/jetpass/userManagement/persistence/migration/NormalizeServiceRedirectURIs$Companion;", "", "()V", "extractBaseURLs", "", "Ljava/net/URI;", "absoluteURIs", "", "relativeURIs", "getPotentialBaseURLs", "getRelativeAndAbsoluteURIs", "Lkotlin/Pair;", "homeURL", "redirectURIs", "normalizeUris", "Ljetbrains/jetpass/userManagement/persistence/migration/NormalizeServiceRedirectURIs$NormalizeUriResult;", "serviceHomeUrl", "", "serviceRedirectURIs", "tryNewBaseURL", "", "baseURL", "jetbrains.jetpass.userManagement"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @Nullable
        public final NormalizeUriResult normalizeUris(@NotNull String serviceHomeUrl, @NotNull Iterable<String> serviceRedirectURIs) {
            NormalizeUriResult normalizeUriResult;
            void relativeURIs;
            Object it;
            Object element$iv$iv2;
            Iterable $receiver$iv$iv;
            Iterable $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)serviceHomeUrl, (String)"serviceHomeUrl");
            Intrinsics.checkParameterIsNotNull(serviceRedirectURIs, (String)"serviceRedirectURIs");
            URI uRI = URI.create(serviceHomeUrl);
            Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"URI.create(serviceHomeUrl)");
            URI homeURL = UriConcatenatorKt.appendSlash(uRI).normalize();
            Iterable<String> iterable = serviceRedirectURIs;
            void var6_5 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv2 : $receiver$iv$iv) {
                it = (String)element$iv$iv2;
                if (!NetUtilsKt.isURI((String)it)) continue;
                destination$iv$iv.add(element$iv$iv2);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                it = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                URI uRI2 = URI.create((String)it).normalize();
                collection.add(uRI2);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList();
            for (Object element$iv$iv2 : $receiver$iv$iv) {
                Object object = it = (URI)element$iv$iv2;
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"it");
                if (!(!((URI)object).isOpaque())) continue;
                destination$iv$iv.add(element$iv$iv2);
            }
            List redirectURIs = (List)destination$iv$iv;
            URI uRI3 = homeURL;
            Intrinsics.checkExpressionValueIsNotNull((Object)uRI3, (String)"homeURL");
            Pair<Set<URI>, Set<URI>> pair = this.getRelativeAndAbsoluteURIs(uRI3, redirectURIs);
            $receiver$iv = (Set)pair.component1();
            Set absoluteURIs = (Set)pair.component2();
            Pair<Set<URI>, Set<URI>> it2 = pair = relativeURIs;
            element$iv$iv2 = (Collection)relativeURIs;
            Object object = !element$iv$iv2.isEmpty() ? pair : null;
            if (object != null) {
                it2 = pair = object;
                Iterable<URI> baseURLs = Companion.extractBaseURLs(absoluteURIs, (Iterable)relativeURIs);
                Iterable<URI> iterable2 = baseURLs;
                Iterable<URI> it3 = iterable2;
                Iterable<URI> iterable3 = CollectionsKt.any(it3) ? iterable2 : null;
                if (iterable3 != null) {
                    URI it4;
                    Iterable $receiver$iv$iv2;
                    Object object2;
                    Collection collection;
                    void $receiver$iv$iv3;
                    Iterable<URI> $receiver$iv2;
                    it3 = iterable2 = iterable3;
                    Iterable<URI> $i$f$filter = $receiver$iv2 = baseURLs;
                    Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv2, (int)10));
                    for (Object item$iv$iv : $receiver$iv$iv3) {
                        void it5;
                        URI uRI4 = (URI)item$iv$iv;
                        collection = destination$iv$iv2;
                        object2 = it5.toString();
                        collection.add(object2);
                    }
                    List newBaseURLs = CollectionsKt.sorted((Iterable)((List)destination$iv$iv2));
                    Iterable $receiver$iv3 = (Iterable)relativeURIs;
                    destination$iv$iv2 = $receiver$iv3;
                    Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv3, (int)10));
                    for (Object item$iv$iv : $receiver$iv$iv2) {
                        URI $i$a$1$map = (URI)item$iv$iv;
                        collection = destination$iv$iv3;
                        object2 = "./" + it4;
                        collection.add(object2);
                    }
                    $receiver$iv3 = absoluteURIs;
                    collection = (List)destination$iv$iv3;
                    $receiver$iv$iv2 = $receiver$iv3;
                    destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv3, (int)10));
                    for (Object item$iv$iv : $receiver$iv$iv2) {
                        it4 = (URI)item$iv$iv;
                        object2 = destination$iv$iv3;
                        String string = it4.toString();
                        object2.add(string);
                    }
                    object2 = (List)destination$iv$iv3;
                    List newRedirectURIs = CollectionsKt.plus((Collection)collection, (Iterable)CollectionsKt.sorted((Iterable)((Iterable)object2)));
                    normalizeUriResult = new NormalizeUriResult(newBaseURLs, newRedirectURIs);
                } else {
                    normalizeUriResult = null;
                }
            } else {
                normalizeUriResult = null;
            }
            return normalizeUriResult;
        }

        private final Pair<Set<URI>, Set<URI>> getRelativeAndAbsoluteURIs(URI homeURL, Iterable<URI> redirectURIs) {
            URI it;
            HashSet<URI> relativeURIs = new HashSet<URI>();
            HashSet<URI> absoluteURIs = new HashSet<URI>();
            Iterable<URI> $receiver$iv = redirectURIs;
            for (URI element$iv : $receiver$iv) {
                it = element$iv;
                if (!(!it.isAbsolute())) continue;
                ((Collection)relativeURIs).add(element$iv);
            }
            if (!relativeURIs.isEmpty()) {
                $receiver$iv = redirectURIs;
                for (URI element$iv : $receiver$iv) {
                    it = element$iv;
                    if (!it.isAbsolute()) continue;
                    ((Collection)absoluteURIs).add(element$iv);
                }
            } else {
                $receiver$iv = redirectURIs;
                for (URI element$iv : $receiver$iv) {
                    URI redirectURI = element$iv;
                    URI uri = homeURL.relativize(redirectURI);
                    if (Intrinsics.areEqual((Object)uri, (Object)redirectURI) ^ true) {
                        relativeURIs.add(uri);
                        continue;
                    }
                    URI redirectURIWithSlash = UriConcatenatorKt.appendSlash(redirectURI);
                    uri = homeURL.relativize(redirectURIWithSlash);
                    if (Intrinsics.areEqual((Object)uri, (Object)redirectURIWithSlash) ^ true) {
                        relativeURIs.add(uri);
                        continue;
                    }
                    absoluteURIs.add(redirectURI);
                }
            }
            return TuplesKt.to(relativeURIs, absoluteURIs);
        }

        /*
         * WARNING - void declaration
         */
        private final Iterable<URI> extractBaseURLs(Set<URI> absoluteURIs, Iterable<URI> relativeURIs) {
            void $receiver$iv$iv;
            Iterable<URI> $receiver$iv = this.getPotentialBaseURLs((Iterable<URI>)absoluteURIs);
            Iterable<URI> iterable = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                URI it = (URI)element$iv$iv;
                if (!Companion.tryNewBaseURL(it, absoluteURIs, relativeURIs)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        private final Iterable<URI> getPotentialBaseURLs(Iterable<URI> absoluteURIs) {
            HashSet<URI> result2 = new HashSet<URI>();
            block0: for (URI absoluteURI : absoluteURIs) {
                URI uri = UriConcatenatorKt.appendSlash(absoluteURI);
                while (true) {
                    result2.add(uri);
                    if (Intrinsics.areEqual((Object)uri.getRawPath(), (Object)"/")) continue block0;
                    Intrinsics.checkExpressionValueIsNotNull((Object)uri.resolve(".."), (String)"uri.resolve(\"..\")");
                }
            }
            return result2;
        }

        private final boolean tryNewBaseURL(URI baseURL, Set<URI> absoluteURIs, Iterable<URI> relativeURIs) {
            Object it;
            boolean bl;
            Set absoluteURIsWithSlash;
            URI uRI;
            URI it2;
            Collection collection;
            Object item$iv$iv;
            Iterator $receiver$iv$iv;
            Collection destination$iv$iv;
            Iterable $receiver$iv;
            block9: {
                Iterable iterable = absoluteURIs;
                void var6_5 = $receiver$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                Iterator<Object> iterator = $receiver$iv$iv.iterator();
                while (iterator.hasNext()) {
                    item$iv$iv = iterator.next();
                    URI uRI2 = (URI)item$iv$iv;
                    collection = destination$iv$iv;
                    uRI = UriConcatenatorKt.appendSlash(it2);
                    collection.add(uRI);
                }
                absoluteURIsWithSlash = CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv));
                $receiver$iv = relativeURIs;
                $receiver$iv$iv = $receiver$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, (int)10));
                iterator = $receiver$iv$iv.iterator();
                while (iterator.hasNext()) {
                    item$iv$iv = iterator.next();
                    it2 = (URI)item$iv$iv;
                    collection = destination$iv$iv;
                    URI uRI3 = baseURL.resolve(it2);
                    Intrinsics.checkExpressionValueIsNotNull((Object)uRI3, (String)"baseURL.resolve(it)");
                    uRI = UriConcatenatorKt.appendSlash(uRI3);
                    collection.add(uRI);
                }
                $receiver$iv = (List)destination$iv$iv;
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $receiver$iv) {
                        it = (URI)element$iv;
                        if (!(!absoluteURIsWithSlash.contains(it))) continue;
                        bl = true;
                        break block9;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return false;
            }
            $receiver$iv = relativeURIs;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            it = $receiver$iv$iv.iterator();
            while (it.hasNext()) {
                item$iv$iv = it.next();
                URI $i$f$any = (URI)item$iv$iv;
                collection = destination$iv$iv;
                URI uRI4 = baseURL.resolve(it2);
                Intrinsics.checkExpressionValueIsNotNull((Object)uRI4, (String)"baseURL.resolve(it)");
                uRI = UriConcatenatorKt.appendSlash(uRI4);
                collection.add(uRI);
            }
            $receiver$iv = (List)destination$iv$iv;
            for (Object element$iv : $receiver$iv) {
                it = (URI)element$iv;
                absoluteURIsWithSlash.remove(it);
            }
            Iterator<URI> it3 = absoluteURIs.iterator();
            while (it3.hasNext()) {
                URI uri = UriConcatenatorKt.appendSlash(it3.next());
                if (absoluteURIsWithSlash.contains(uri)) continue;
                it3.remove();
            }
            return true;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

