/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.userManagement.persistence.password;

import com.nulabinc.zxcvbn.Strength;
import com.nulabinc.zxcvbn.Zxcvbn;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import jetbrains.exodus.core.crypto.MessageDigestUtil;
import jetbrains.jetpass.core.security.SecureRandomSingleton;
import jetbrains.jetpass.spring.SpringUtils;
import jetbrains.jetpass.userManagement.persistence.authmodule.CoreAuthModuleHolder;
import jetbrains.jetpass.userManagement.persistence.dnq.XdBaseUser;
import jetbrains.jetpass.userManagement.persistence.password.WeakPasswordException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.dnq.XdEntity;
import org.apache.commons.lang.RandomStringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000b2\b\u0010\u0012\u001a\u0004\u0018\u00010\fJ\u0006\u0010\u0013\u001a\u00020\u000bJ\"\u0010\u0014\u001a\u00020\u000b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0015\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0016\u001a\u00020\u0017J&\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u000b2\b\u0010\u0012\u001a\u0004\u0018\u00010\f2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001bR\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n*\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001c"}, d2={"Ljetbrains/jetpass/userManagement/persistence/password/PasswordHashier;", "", "()V", "coreAuthModuleHolder", "Ljetbrains/jetpass/userManagement/persistence/authmodule/CoreAuthModuleHolder;", "getCoreAuthModuleHolder", "()Ljetbrains/jetpass/userManagement/persistence/authmodule/CoreAuthModuleHolder;", "coreAuthModuleHolder$delegate", "Lkotlin/properties/ReadOnlyProperty;", "sanitizedNames", "Lkotlin/sequences/Sequence;", "", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdBaseUser;", "getSanitizedNames", "(Ljetbrains/jetpass/userManagement/persistence/dnq/XdBaseUser;)Lkotlin/sequences/Sequence;", "checkPasswordStrength", "", "plainPassword", "user", "generateSaltDefault", "hash", "salt", "md5", "", "measure", "Lcom/nulabinc/zxcvbn/Strength;", "usernames", "", "jetbrains.jetpass.userManagement"})
public final class PasswordHashier {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private static final ReadOnlyProperty coreAuthModuleHolder$delegate;
    public static final PasswordHashier INSTANCE;

    static {
        PasswordHashier passwordHashier;
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(PasswordHashier.class), "coreAuthModuleHolder", "getCoreAuthModuleHolder()Ljetbrains/jetpass/userManagement/persistence/authmodule/CoreAuthModuleHolder;"))};
        INSTANCE = passwordHashier = new PasswordHashier();
        String name$iv = null;
        coreAuthModuleHolder$delegate = SpringUtils.bean(name$iv, false);
    }

    private final CoreAuthModuleHolder getCoreAuthModuleHolder() {
        return (CoreAuthModuleHolder)coreAuthModuleHolder$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    public final void checkPasswordStrength(@NotNull String plainPassword, @Nullable XdBaseUser user2) throws WeakPasswordException {
        Strength strength;
        Intrinsics.checkParameterIsNotNull((Object)plainPassword, (String)"plainPassword");
        int referenceScore = this.getCoreAuthModuleHolder().getPasswordStrengthPolicy();
        if (referenceScore > 0 && (strength = this.measure(plainPassword, user2, CollectionsKt.emptyList())).getScore() < referenceScore) {
            throw (Throwable)new WeakPasswordException(referenceScore, strength);
        }
    }

    @NotNull
    public final Strength measure(@NotNull String plainPassword, @Nullable XdBaseUser user2, @NotNull List<String> usernames) {
        Intrinsics.checkParameterIsNotNull((Object)plainPassword, (String)"plainPassword");
        Intrinsics.checkParameterIsNotNull(usernames, (String)"usernames");
        Zxcvbn zxcvbn = new Zxcvbn();
        Sequence<String> sequence = user2;
        List list = sequence != null && (sequence = this.getSanitizedNames((XdBaseUser)sequence)) != null ? SequencesKt.toList(sequence) : null;
        String string = plainPassword;
        Zxcvbn zxcvbn2 = zxcvbn;
        List list2 = list;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        List list3 = list2;
        Strength strength = zxcvbn2.measure(string, CollectionsKt.distinct((Iterable)CollectionsKt.plus((Collection)list3, (Iterable)usernames)));
        Intrinsics.checkExpressionValueIsNotNull((Object)strength, (String)"zxcvbn.measure(plainPass\u2026 + usernames).distinct())");
        return strength;
    }

    private final Sequence<String> getSanitizedNames(@NotNull XdBaseUser $receiver) {
        XdEntity xdEntity;
        return SequencesKt.filterNotNull((Sequence)SequencesKt.sequenceOf((Object[])new String[]{$receiver.getLogin(), (xdEntity = $receiver.getProfile()) != null && (xdEntity = xdEntity.getEmail()) != null ? xdEntity.getEmail() : null, $receiver.getVisibleName()}));
    }

    @NotNull
    public final String generateSaltDefault() {
        String string = RandomStringUtils.random((int)42, (int)0, (int)0, (boolean)true, (boolean)true, null, (Random)SecureRandomSingleton.get());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"RandomStringUtils.random\u2026ureRandomSingleton.get())");
        return string;
    }

    @NotNull
    public final String hash(@Nullable String plainPassword, @Nullable String salt, boolean md5) {
        String string;
        String plainWithSalt;
        String string2;
        CharSequence charSequence;
        if (plainPassword == null || (charSequence = (CharSequence)plainPassword).length() == 0) {
            throw (Throwable)new IllegalArgumentException("Password should not be empty");
        }
        if (md5) {
            StringBuilder stringBuilder = new StringBuilder();
            String string3 = salt;
            if (string3 == null) {
                string3 = "";
            }
            string2 = stringBuilder.append(string3).append(plainPassword).toString();
        } else {
            StringBuilder stringBuilder = new StringBuilder().append(plainPassword);
            String string4 = salt;
            if (string4 == null) {
                string4 = "";
            }
            string2 = plainWithSalt = stringBuilder.append((Object)string4).toString();
        }
        if (md5) {
            String string5 = MessageDigestUtil.MD5((String)plainWithSalt);
            string = string5;
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"MessageDigestUtil.MD5(plainWithSalt)");
        } else {
            String string6 = MessageDigestUtil.sha256((String)plainWithSalt);
            string = string6;
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"MessageDigestUtil.sha256(plainWithSalt)");
        }
        return string;
    }

    private PasswordHashier() {
    }
}

