/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.userManagement.persistence.ssl;

import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Calendar;
import java.util.Date;
import javax.xml.bind.DatatypeConverter;
import jetbrains.jetpass.api.ssl.CertificateInfo;
import jetbrains.jetpass.api.ssl.Fingerprint;
import jetbrains.jetpass.userManagement.persistence.ssl.CertificateData;
import jetbrains.jetpass.userManagement.persistence.ssl.FingerprintImpl;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 !2\u00020\u0001:\u0001!B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0006H\u0016J\u0010\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0003H\u0002J\b\u0010\u0017\u001a\u00020\u0006H\u0016J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0006H\u0016J\b\u0010\u001b\u001a\u00020\u0006H\u0016J\b\u0010\u001c\u001a\u00020\u0006H\u0016J\b\u0010\u001d\u001a\u00020\fH\u0016J\b\u0010\u001e\u001a\u00020\fH\u0016J\b\u0010\u001f\u001a\u00020\u000fH\u0016J\b\u0010 \u001a\u0004\u0018\u00010\u0006R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Ljetbrains/jetpass/userManagement/persistence/ssl/CertificateData;", "Ljetbrains/jetpass/api/ssl/CertificateInfo;", "certificate", "Ljava/security/cert/Certificate;", "(Ljava/security/cert/Certificate;)V", "algorithm", "", "issuedBy", "issuedTo", "serialNumber", "type", "validFrom", "Ljava/util/Calendar;", "validTo", "version", "", "cal", "date", "Ljava/util/Date;", "timeInMillis", "", "getAlgorithm", "cert", "getCertificateType", "getFingerprint", "Ljetbrains/jetpass/api/ssl/Fingerprint;", "getIssuedBy", "getIssuedTo", "getSerialNumber", "getValidFrom", "getValidTo", "getVersion", "printBase64", "Companion", "jetbrains.jetpass.userManagement"})
public final class CertificateData
implements CertificateInfo {
    private final String type;
    private final String algorithm;
    private int version;
    private String serialNumber;
    private String issuedBy;
    private String issuedTo;
    private Calendar validFrom;
    private Calendar validTo;
    private final Certificate certificate;
    private static final String UNKNOWN = "Unknown";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getCertificateType() {
        return this.type;
    }

    public int getVersion() {
        return this.version;
    }

    @NotNull
    public String getSerialNumber() {
        return this.serialNumber;
    }

    @NotNull
    public String getIssuedBy() {
        return this.issuedBy;
    }

    @NotNull
    public String getIssuedTo() {
        return this.issuedTo;
    }

    @NotNull
    public Calendar getValidFrom() {
        return this.validFrom;
    }

    @NotNull
    public Calendar getValidTo() {
        return this.validTo;
    }

    @NotNull
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Nullable
    public Fingerprint getFingerprint() {
        FingerprintImpl fingerprintImpl;
        try {
            byte[] byArray = this.certificate.getEncoded();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"certificate.encoded");
            fingerprintImpl = new FingerprintImpl(byArray);
        }
        catch (CertificateEncodingException e) {
            Companion.getLogger().error((Throwable)e, (Function0)getFingerprint.1.INSTANCE);
            fingerprintImpl = null;
        }
        return fingerprintImpl;
    }

    @Nullable
    public final String printBase64() {
        String string;
        try {
            byte[] bytes = this.certificate.getEncoded();
            string = DatatypeConverter.printBase64Binary((byte[])bytes);
        }
        catch (CertificateEncodingException ex) {
            Companion.getLogger().error((Throwable)ex, (Function0)printBase64.1.INSTANCE);
            string = null;
        }
        return string;
    }

    /*
     * Unable to fully structure code
     */
    private final String getAlgorithm(Certificate cert) {
        block5: {
            v0 = key = cert.getPublicKey();
            Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"key");
            v1 = v0.getAlgorithm();
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"key.algorithm");
            v2 = var4_3 = v1;
            if (v2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            v3 = v2.toUpperCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"(this as java.lang.String).toUpperCase()");
            var5_6 = alg = v3;
            switch (var5_6.hashCode()) {
                case 81440: {
                    if (!var5_6.equals("RSA")) ** break;
                    break;
                }
                case 67986: {
                    if (!var5_6.equals("DSA")) ** break;
                    v4 = ((DSAPublicKey)key).getY().bitLength();
                    break block5;
                }
            }
            v4 = ((RSAPublicKey)key).getModulus().bitLength();
            break block5;
            v4 = 0;
        }
        length = v4;
        return alg + (length != 0 ? "" + '(' + length + ')' : "");
    }

    private final Calendar cal(long timeInMillis) {
        Calendar calendar;
        Calendar $receiver;
        Calendar calendar2 = $receiver = (calendar = Calendar.getInstance());
        Intrinsics.checkExpressionValueIsNotNull((Object)calendar2, (String)"this");
        calendar2.setTimeInMillis(timeInMillis);
        Calendar calendar3 = calendar;
        Intrinsics.checkExpressionValueIsNotNull((Object)calendar3, (String)"Calendar.getInstance().a\u2026 = timeInMillis\n        }");
        return calendar3;
    }

    private final Calendar cal(Date date) {
        Calendar calendar;
        Calendar $receiver;
        Calendar calendar2 = $receiver = (calendar = Calendar.getInstance());
        Intrinsics.checkExpressionValueIsNotNull((Object)calendar2, (String)"this");
        calendar2.setTime(date);
        Calendar calendar3 = calendar;
        Intrinsics.checkExpressionValueIsNotNull((Object)calendar3, (String)"Calendar.getInstance().a\u2026his.time = date\n        }");
        return calendar3;
    }

    public CertificateData(@NotNull Certificate certificate) {
        Intrinsics.checkParameterIsNotNull((Object)certificate, (String)"certificate");
        this.certificate = certificate;
        String string = this.certificate.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"certificate.type");
        this.type = string;
        this.algorithm = this.getAlgorithm(this.certificate);
        this.version = -1;
        this.serialNumber = UNKNOWN;
        this.issuedBy = UNKNOWN;
        this.issuedTo = UNKNOWN;
        this.validFrom = this.cal(0L);
        this.validTo = this.cal(0L);
        if (this.certificate instanceof X509Certificate) {
            Certificate c = this.certificate;
            this.version = ((X509Certificate)c).getVersion();
            String string2 = Long.toHexString(((X509Certificate)c).getSerialNumber().longValue());
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.Long.toHexStri\u2026(c.serialNumber.toLong())");
            this.serialNumber = string2;
            Principal principal = ((X509Certificate)c).getIssuerDN();
            Intrinsics.checkExpressionValueIsNotNull((Object)principal, (String)"c.issuerDN");
            String string3 = principal.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"c.issuerDN.name");
            this.issuedBy = string3;
            Principal principal2 = ((X509Certificate)c).getSubjectDN();
            Intrinsics.checkExpressionValueIsNotNull((Object)principal2, (String)"c.subjectDN");
            String string4 = principal2.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"c.subjectDN.name");
            this.issuedTo = string4;
            Date date = ((X509Certificate)c).getNotBefore();
            Intrinsics.checkExpressionValueIsNotNull((Object)date, (String)"c.notBefore");
            this.validFrom = this.cal(date);
            Date date2 = ((X509Certificate)c).getNotAfter();
            Intrinsics.checkExpressionValueIsNotNull((Object)date2, (String)"c.notAfter");
            this.validTo = this.cal(date2);
        }
    }

    static {
        UNKNOWN = UNKNOWN;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ljetbrains/jetpass/userManagement/persistence/ssl/CertificateData$Companion;", "Lmu/KLogging;", "()V", "UNKNOWN", "", "jetbrains.jetpass.userManagement"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

