/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.userManagement.persistence.ssl;

import jetbrains.jetpass.api.ssl.Fingerprint;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.codec.digest.DigestUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\b\u0010\b\u001a\u00020\u0006H\u0016J\b\u0010\t\u001a\u00020\u0006H\u0016J\b\u0010\n\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Ljetbrains/jetpass/userManagement/persistence/ssl/FingerprintImpl;", "Ljetbrains/jetpass/api/ssl/Fingerprint;", "certificateData", "", "([B)V", "getMd5", "", "getSha1", "getSha256", "getSha384", "getSha512", "jetbrains.jetpass.userManagement"})
public final class FingerprintImpl
implements Fingerprint {
    private final byte[] certificateData;

    @NotNull
    public String getMd5() {
        String string = DigestUtils.md5Hex((byte[])this.certificateData);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"DigestUtils.md5Hex(certificateData)");
        return string;
    }

    @NotNull
    public String getSha1() {
        String string = DigestUtils.sha1Hex((byte[])this.certificateData);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"DigestUtils.sha1Hex(certificateData)");
        return string;
    }

    @NotNull
    public String getSha256() {
        String string = DigestUtils.sha256Hex((byte[])this.certificateData);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"DigestUtils.sha256Hex(certificateData)");
        return string;
    }

    @NotNull
    public String getSha384() {
        String string = DigestUtils.sha384Hex((byte[])this.certificateData);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"DigestUtils.sha384Hex(certificateData)");
        return string;
    }

    @NotNull
    public String getSha512() {
        String string = DigestUtils.sha512Hex((byte[])this.certificateData);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"DigestUtils.sha512Hex(certificateData)");
        return string;
    }

    public FingerprintImpl(@NotNull byte[] certificateData) {
        Intrinsics.checkParameterIsNotNull((Object)certificateData, (String)"certificateData");
        this.certificateData = certificateData;
    }
}

