/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.userManagement.persistence.ssl;

import java.security.SecureRandom;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import jetbrains.exodus.database.IEventsMultiplexer;
import jetbrains.exodus.entitystore.EventsMultiplexer;
import jetbrains.jetpass.userManagement.persistence.dnq.XdCertificate;
import jetbrains.jetpass.userManagement.persistence.dnq.XdKeyStore;
import jetbrains.jetpass.userManagement.persistence.dnq.XdTrustStore;
import jetbrains.jetpass.userManagement.persistence.ssl.SSLContextFactory$TrustStoreEntryListener$updatedSync$1;
import jetbrains.jetpass.userManagement.persistence.ssl.SSLContextFactory$TrustStoreEntryListener$updatedSync$2;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty1;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdEntityType;
import kotlinx.dnq.listener.LegacyEventMultiplexerUtilsKt;
import kotlinx.dnq.listener.XdEntityListener;
import kotlinx.dnq.util.ReflectionUtilKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.annotation.Scope;

@Named(value="sslContextFactory")
@Scope(value="local")
@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 #2\u00020\u0001:\u0003#$%B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J+\u0010\u0013\u001a\u00020\b2\u000e\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0015H\u0002\u00a2\u0006\u0002\u0010\u0019J\u0012\u0010\u001a\u001a\u00020\u00072\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\b2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cJ\u0012\u0010\u001e\u001a\u00020\u001f2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J\b\u0010 \u001a\u00020\u001fH\u0002J\b\u0010!\u001a\u00020\u001fH\u0007J\b\u0010\"\u001a\u00020\u001fH\u0007R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00060\nR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0012\u0010\u0011\u001a\u00060\u0012R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Ljetbrains/jetpass/userManagement/persistence/ssl/SSLContextFactory;", "", "eventsMultiplexer", "Ljetbrains/exodus/entitystore/EventsMultiplexer;", "(Ljetbrains/exodus/entitystore/EventsMultiplexer;)V", "cache", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Ljavax/net/ssl/SSLContext;", "keyStoreListener", "Ljetbrains/jetpass/userManagement/persistence/ssl/SSLContextFactory$KeyStoreListener;", "protocol", "", "getProtocol", "()Ljava/lang/String;", "setProtocol", "(Ljava/lang/String;)V", "trustStoreStoreListener", "Ljetbrains/jetpass/userManagement/persistence/ssl/SSLContextFactory$TrustStoreEntryListener;", "create", "keyManagers", "", "Ljavax/net/ssl/KeyManager;", "trustManagers", "Ljavax/net/ssl/TrustManager;", "([Ljavax/net/ssl/KeyManager;[Ljavax/net/ssl/TrustManager;)Ljavax/net/ssl/SSLContext;", "getLocalId", "store", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdKeyStore;", "getSSLContext", "invalidate", "", "invalidateAll", "startListen", "stopListen", "Companion", "KeyStoreListener", "TrustStoreEntryListener", "jetbrains.jetpass.userManagement"})
public final class SSLContextFactory {
    private final ConcurrentHashMap<Long, SSLContext> cache;
    private final KeyStoreListener keyStoreListener;
    private final TrustStoreEntryListener trustStoreStoreListener;
    @NotNull
    private String protocol;
    private final EventsMultiplexer eventsMultiplexer;
    private static final SecureRandom SECURE_RANDOM;
    public static final Companion Companion;

    @NotNull
    public final String getProtocol() {
        return this.protocol;
    }

    public final void setProtocol(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.protocol = string;
    }

    @PostConstruct
    public final void startListen() {
        LegacyEventMultiplexerUtilsKt.addListener((IEventsMultiplexer)((IEventsMultiplexer)this.eventsMultiplexer), (XdEntityType)((XdEntityType)XdKeyStore.Companion), (XdEntityListener)this.keyStoreListener);
        LegacyEventMultiplexerUtilsKt.addListener((IEventsMultiplexer)((IEventsMultiplexer)this.eventsMultiplexer), (XdEntityType)((XdEntityType)XdCertificate.Companion), (XdEntityListener)this.trustStoreStoreListener);
    }

    @PreDestroy
    public final void stopListen() {
        LegacyEventMultiplexerUtilsKt.removeListener((IEventsMultiplexer)((IEventsMultiplexer)this.eventsMultiplexer), (XdEntityType)((XdEntityType)XdKeyStore.Companion), (XdEntityListener)this.keyStoreListener);
        LegacyEventMultiplexerUtilsKt.removeListener((IEventsMultiplexer)((IEventsMultiplexer)this.eventsMultiplexer), (XdEntityType)((XdEntityType)XdCertificate.Companion), (XdEntityListener)this.trustStoreStoreListener);
    }

    @NotNull
    public final SSLContext getSSLContext(@Nullable XdKeyStore store2) {
        long key2 = this.getLocalId(store2);
        SSLContext sSLContext = this.cache.get(key2);
        if (sSLContext == null) {
            SSLContextFactory sSLContextFactory;
            SSLContextFactory $receiver = sSLContextFactory = this;
            XdKeyStore xdKeyStore = store2;
            KeyManager[] keyManagers = xdKeyStore != null ? xdKeyStore.loadKeyManagers() : null;
            TrustManager[] trustManagers = XdTrustStore.Companion.loadTrustManagers();
            SSLContext newCachedContext = $receiver.create(keyManagers, trustManagers);
            SSLContext sSLContext2 = $receiver.cache.putIfAbsent(key2, newCachedContext);
            if (sSLContext2 == null) {
                sSLContext2 = newCachedContext;
            }
            sSLContext = sSLContext2;
            Intrinsics.checkExpressionValueIsNotNull((Object)sSLContext2, (String)"run {\n            val ke\u2026ewCachedContext\n        }");
        }
        return sSLContext;
    }

    private final void invalidateAll() {
        this.cache.clear();
    }

    private final void invalidate(XdKeyStore store2) {
        this.cache.remove(this.getLocalId(store2));
    }

    private final long getLocalId(XdKeyStore store2) {
        XdKeyStore xdKeyStore = store2;
        return xdKeyStore != null && (xdKeyStore = xdKeyStore.getEntityId()) != null ? xdKeyStore.getLocalId() : Long.MIN_VALUE;
    }

    private final SSLContext create(KeyManager[] keyManagers, TrustManager[] trustManagers) {
        SSLContext sSLContext;
        SSLContext $receiver = sSLContext = SSLContext.getInstance(this.protocol);
        $receiver.init(keyManagers, trustManagers, SECURE_RANDOM);
        SSLContext sSLContext2 = sSLContext;
        Intrinsics.checkExpressionValueIsNotNull((Object)sSLContext2, (String)"SSLContext.getInstance(p\u2026 SECURE_RANDOM)\n        }");
        return sSLContext2;
    }

    @Inject
    public SSLContextFactory(@NotNull EventsMultiplexer eventsMultiplexer) {
        Intrinsics.checkParameterIsNotNull((Object)eventsMultiplexer, (String)"eventsMultiplexer");
        this.eventsMultiplexer = eventsMultiplexer;
        this.cache = new ConcurrentHashMap();
        this.keyStoreListener = new KeyStoreListener();
        this.trustStoreStoreListener = new TrustStoreEntryListener();
        this.protocol = "TLS";
    }

    static {
        Companion = new Companion(null);
        SECURE_RANDOM = new SecureRandom();
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0018\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a8\u0006\n"}, d2={"Ljetbrains/jetpass/userManagement/persistence/ssl/SSLContextFactory$KeyStoreListener;", "Lkotlinx/dnq/listener/XdEntityListener;", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdKeyStore;", "(Ljetbrains/jetpass/userManagement/persistence/ssl/SSLContextFactory;)V", "removedSync", "", "removed", "updatedSync", "old", "current", "jetbrains.jetpass.userManagement"})
    private final class KeyStoreListener
    implements XdEntityListener<XdKeyStore> {
        public void updatedSync(@NotNull XdKeyStore old, @NotNull XdKeyStore current) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)old), (String)"old");
            Intrinsics.checkParameterIsNotNull((Object)((Object)current), (String)"current");
            SSLContextFactory.this.invalidate(old);
        }

        public void removedSync(@NotNull XdKeyStore removed) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)removed), (String)"removed");
            SSLContextFactory.this.invalidate(removed);
        }

        public void addedAsync(@NotNull XdKeyStore added2) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)added2), (String)"added");
            XdEntityListener.DefaultImpls.addedAsync((XdEntityListener)this, (XdEntity)added2);
        }

        public void addedSync(@NotNull XdKeyStore added2) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)added2), (String)"added");
            XdEntityListener.DefaultImpls.addedSync((XdEntityListener)this, (XdEntity)added2);
        }

        public void addedSyncAfterConstraints(@NotNull XdKeyStore added2) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)added2), (String)"added");
            XdEntityListener.DefaultImpls.addedSyncAfterConstraints((XdEntityListener)this, (XdEntity)added2);
        }

        public void addedSyncBeforeConstraints(@NotNull XdKeyStore added2) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)added2), (String)"added");
            XdEntityListener.DefaultImpls.addedSyncBeforeConstraints((XdEntityListener)this, (XdEntity)added2);
        }

        @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="addedSyncAfterConstraints"), message="Use addedSyncAfterConstraints instead")
        public void addedSyncBeforeFlush(@NotNull XdKeyStore added2) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)added2), (String)"added");
            XdEntityListener.DefaultImpls.addedSyncBeforeFlush((XdEntityListener)this, (XdEntity)added2);
        }

        public void removedAsync(@NotNull XdKeyStore removed) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)removed), (String)"removed");
            XdEntityListener.DefaultImpls.removedAsync((XdEntityListener)this, (XdEntity)removed);
        }

        public void removedSyncAfterConstraints(@NotNull XdKeyStore removed) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)removed), (String)"removed");
            XdEntityListener.DefaultImpls.removedSyncAfterConstraints((XdEntityListener)this, (XdEntity)removed);
        }

        public void removedSyncBeforeConstraints(@NotNull XdKeyStore removed) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)removed), (String)"removed");
            XdEntityListener.DefaultImpls.removedSyncBeforeConstraints((XdEntityListener)this, (XdEntity)removed);
        }

        @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="removedSyncAfterConstraints"), message="Use removedSyncAfterConstraints instead")
        public void removedSyncBeforeFlush(@NotNull XdKeyStore added2) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)added2), (String)"added");
            XdEntityListener.DefaultImpls.removedSyncBeforeFlush((XdEntityListener)this, (XdEntity)added2);
        }

        public void updatedAsync(@NotNull XdKeyStore old, @NotNull XdKeyStore current) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)old), (String)"old");
            Intrinsics.checkParameterIsNotNull((Object)((Object)current), (String)"current");
            XdEntityListener.DefaultImpls.updatedAsync((XdEntityListener)this, (XdEntity)old, (XdEntity)current);
        }

        public void updatedSyncAfterConstraints(@NotNull XdKeyStore old, @NotNull XdKeyStore current) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)old), (String)"old");
            Intrinsics.checkParameterIsNotNull((Object)((Object)current), (String)"current");
            XdEntityListener.DefaultImpls.updatedSyncAfterConstraints((XdEntityListener)this, (XdEntity)old, (XdEntity)current);
        }

        public void updatedSyncBeforeConstraints(@NotNull XdKeyStore old, @NotNull XdKeyStore current) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)old), (String)"old");
            Intrinsics.checkParameterIsNotNull((Object)((Object)current), (String)"current");
            XdEntityListener.DefaultImpls.updatedSyncBeforeConstraints((XdEntityListener)this, (XdEntity)old, (XdEntity)current);
        }

        @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="updatedSyncAfterConstraints"), message="Use updatedSyncAfterConstraints instead")
        public void updatedSyncBeforeFlush(@NotNull XdKeyStore old, @NotNull XdKeyStore current) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)old), (String)"old");
            Intrinsics.checkParameterIsNotNull((Object)((Object)current), (String)"current");
            XdEntityListener.DefaultImpls.updatedSyncBeforeFlush((XdEntityListener)this, (XdEntity)old, (XdEntity)current);
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0010\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a8\u0006\f"}, d2={"Ljetbrains/jetpass/userManagement/persistence/ssl/SSLContextFactory$TrustStoreEntryListener;", "Lkotlinx/dnq/listener/XdEntityListener;", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdCertificate;", "(Ljetbrains/jetpass/userManagement/persistence/ssl/SSLContextFactory;)V", "addedSync", "", "added", "removedSync", "removed", "updatedSync", "old", "current", "jetbrains.jetpass.userManagement"})
    private final class TrustStoreEntryListener
    implements XdEntityListener<XdCertificate> {
        public void addedSync(@NotNull XdCertificate added2) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)added2), (String)"added");
            if (!added2.getDisabled()) {
                SSLContextFactory.this.invalidateAll();
            }
        }

        public void updatedSync(@NotNull XdCertificate old, @NotNull XdCertificate current) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)old), (String)"old");
            Intrinsics.checkParameterIsNotNull((Object)((Object)current), (String)"current");
            if (ReflectionUtilKt.hasChanges((XdEntity)old, (KProperty1)((KProperty1)SSLContextFactory$TrustStoreEntryListener$updatedSync$1.INSTANCE)) || ReflectionUtilKt.hasChanges((XdEntity)old, (KProperty1)((KProperty1)SSLContextFactory$TrustStoreEntryListener$updatedSync$2.INSTANCE))) {
                SSLContextFactory.this.invalidateAll();
            }
        }

        public void removedSync(@NotNull XdCertificate removed) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)removed), (String)"removed");
            if (!removed.getDisabled()) {
                SSLContextFactory.this.invalidateAll();
            }
        }

        public void addedAsync(@NotNull XdCertificate added2) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)added2), (String)"added");
            XdEntityListener.DefaultImpls.addedAsync((XdEntityListener)this, (XdEntity)added2);
        }

        public void addedSyncAfterConstraints(@NotNull XdCertificate added2) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)added2), (String)"added");
            XdEntityListener.DefaultImpls.addedSyncAfterConstraints((XdEntityListener)this, (XdEntity)added2);
        }

        public void addedSyncBeforeConstraints(@NotNull XdCertificate added2) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)added2), (String)"added");
            XdEntityListener.DefaultImpls.addedSyncBeforeConstraints((XdEntityListener)this, (XdEntity)added2);
        }

        @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="addedSyncAfterConstraints"), message="Use addedSyncAfterConstraints instead")
        public void addedSyncBeforeFlush(@NotNull XdCertificate added2) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)added2), (String)"added");
            XdEntityListener.DefaultImpls.addedSyncBeforeFlush((XdEntityListener)this, (XdEntity)added2);
        }

        public void removedAsync(@NotNull XdCertificate removed) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)removed), (String)"removed");
            XdEntityListener.DefaultImpls.removedAsync((XdEntityListener)this, (XdEntity)removed);
        }

        public void removedSyncAfterConstraints(@NotNull XdCertificate removed) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)removed), (String)"removed");
            XdEntityListener.DefaultImpls.removedSyncAfterConstraints((XdEntityListener)this, (XdEntity)removed);
        }

        public void removedSyncBeforeConstraints(@NotNull XdCertificate removed) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)removed), (String)"removed");
            XdEntityListener.DefaultImpls.removedSyncBeforeConstraints((XdEntityListener)this, (XdEntity)removed);
        }

        @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="removedSyncAfterConstraints"), message="Use removedSyncAfterConstraints instead")
        public void removedSyncBeforeFlush(@NotNull XdCertificate added2) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)added2), (String)"added");
            XdEntityListener.DefaultImpls.removedSyncBeforeFlush((XdEntityListener)this, (XdEntity)added2);
        }

        public void updatedAsync(@NotNull XdCertificate old, @NotNull XdCertificate current) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)old), (String)"old");
            Intrinsics.checkParameterIsNotNull((Object)((Object)current), (String)"current");
            XdEntityListener.DefaultImpls.updatedAsync((XdEntityListener)this, (XdEntity)old, (XdEntity)current);
        }

        public void updatedSyncAfterConstraints(@NotNull XdCertificate old, @NotNull XdCertificate current) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)old), (String)"old");
            Intrinsics.checkParameterIsNotNull((Object)((Object)current), (String)"current");
            XdEntityListener.DefaultImpls.updatedSyncAfterConstraints((XdEntityListener)this, (XdEntity)old, (XdEntity)current);
        }

        public void updatedSyncBeforeConstraints(@NotNull XdCertificate old, @NotNull XdCertificate current) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)old), (String)"old");
            Intrinsics.checkParameterIsNotNull((Object)((Object)current), (String)"current");
            XdEntityListener.DefaultImpls.updatedSyncBeforeConstraints((XdEntityListener)this, (XdEntity)old, (XdEntity)current);
        }

        @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="updatedSyncAfterConstraints"), message="Use updatedSyncAfterConstraints instead")
        public void updatedSyncBeforeFlush(@NotNull XdCertificate old, @NotNull XdCertificate current) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)old), (String)"old");
            Intrinsics.checkParameterIsNotNull((Object)((Object)current), (String)"current");
            XdEntityListener.DefaultImpls.updatedSyncBeforeFlush((XdEntityListener)this, (XdEntity)old, (XdEntity)current);
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ljetbrains/jetpass/userManagement/persistence/ssl/SSLContextFactory$Companion;", "", "()V", "SECURE_RANDOM", "Ljava/security/SecureRandom;", "jetbrains.jetpass.userManagement"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

