/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.userManagement.persistence.text.processor;

import com.jetbrains.teamsys.dnq.database.TransientSessionImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import jetbrains.exodus.bindings.ComparableSet;
import jetbrains.exodus.database.EntityChangeType;
import jetbrains.exodus.database.TransientEntity;
import jetbrains.exodus.database.TransientEntityChange;
import jetbrains.exodus.database.TransientEntityStore;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.exodus.database.TransientStoreSessionListener;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.PersistentEntity;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.PropertyEqual;
import jetbrains.exodus.query.PropertyStartsWith;
import jetbrains.exodus.query.metadata.EntityMetaData;
import jetbrains.exodus.query.metadata.ModelMetaData;
import jetbrains.jetpass.dnq.TransactionKt;
import jetbrains.jetpass.dnq.TransientStoreSessionAdapter;
import jetbrains.jetpass.spring.SpringUtils;
import jetbrains.jetpass.userManagement.persistence.dnq.event.XdEvent;
import jetbrains.jetpass.userManagement.persistence.text.processor.HubTextProcessor;
import jetbrains.jetpass.userManagement.persistence.text.processor.HubTextProcessor$WhenMappings;
import jetbrains.jetpass.userManagement.persistence.text.processor.HubTextProcessor$rebuildIndex$;
import jetbrains.jetpass.userManagement.persistence.text.processor.HubTextProcessorKt;
import jetbrains.jetpass.userManagement.persistence.text.processor.IndexProperty;
import jetbrains.jetpass.userManagement.persistence.text.processor.TextExtractor;
import jetbrains.jetpass.userManagement.persistence.text.processor.Tokenizer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdEntityType;
import kotlinx.dnq.XdExtensionsKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="textProcessor")
@Scope(value="local")
@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 Y2\u00020\u0001:\u0002YZB\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00072\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00070\u001aH\u0002J$\u0010\u0016\u001a\u00020\u00172\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00070\u001c2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00070\u001aH\u0002J\u001e\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!H\u0016J\\\u0010#\u001a\u00020\u0017\"\b\b\u0000\u0010$*\u00020%2\u0006\u0010&\u001a\u00020\u001f2\f\u0010'\u001a\b\u0012\u0004\u0012\u0002H$0(2\u0006\u0010)\u001a\u00020\u00132*\u0010*\u001a&\u0012\u0004\u0012\u0002H$\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020-\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u001a0,\u0012\u0004\u0012\u00020\u00170+H\u0002J>\u0010.\u001a\b\u0012\u0004\u0012\u0002H$0/\"\b\b\u0000\u0010$*\u00020%2\f\u0010'\u001a\b\u0012\u0004\u0012\u0002H$0(2\u0006\u00100\u001a\u00020\u00072\u0006\u00101\u001a\u0002022\b\b\u0002\u00103\u001a\u000204J6\u00105\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H7\u0012\u0004\u0012\u0002H80\t06\"\b\b\u0000\u00107*\u00020%\"\b\b\u0001\u00108*\u00020%2\u0006\u00109\u001a\u00020\"H\u0002J\u0012\u0010:\u001a\u0002022\n\u0010'\u001a\u0006\u0012\u0002\b\u00030(J\u0006\u0010;\u001a\u00020\u0017J\u001e\u0010;\u001a\u00020\u0017\"\b\b\u0000\u0010$*\u00020%2\f\u0010<\u001a\b\u0012\u0004\u0012\u0002H$0(JW\u0010=\u001a\u00020\u0017\"\b\b\u0000\u00107*\u00020%\"\b\b\u0001\u00108*\u00020%2\u0006\u0010>\u001a\u0002H82\u0012\u0010?\u001a\u000e\u0012\u0004\u0012\u0002H7\u0012\u0004\u0012\u0002H80\t2\u0018\u0010@\u001a\u0014\u0012\u0004\u0012\u00020-\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u001a0,H\u0002\u00a2\u0006\u0002\u0010AJ\u001e\u0010B\u001a\u0002022\u0006\u0010\u0018\u001a\u00020\u00072\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00070\u001aH\u0002J*\u0010C\u001a\u00020\u00172\u0006\u0010D\u001a\u00020\u001f2\u0018\u0010E\u001a\u0014\u0012\u0004\u0012\u00020-\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u001a0\u0006H\u0002J\u0016\u0010F\u001a\u0002022\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00070\u001aH\u0002J\b\u0010G\u001a\u00020\u0017H\u0007J\b\u0010H\u001a\u00020\u0017H\u0007J\b\u0010I\u001a\u00020\u0017H\u0002JU\u0010J\u001a\u00020\u0017\"\b\b\u0000\u00108*\u00020%2\u0006\u0010K\u001a\u0002H82\f\u0010L\u001a\b\u0012\u0004\u0012\u00020\u00070\u001a2\f\u0010E\u001a\b\u0012\u0004\u0012\u00020M0\b2\u0018\u0010@\u001a\u0014\u0012\u0004\u0012\u00020-\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u001a0,H\u0002\u00a2\u0006\u0002\u0010NJ(\u0010O\u001a\b\u0012\u0004\u0012\u00020P0\b*\b\u0012\u0004\u0012\u00020P0\b2\u000e\u0010Q\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010!H\u0002J\u001c\u0010R\u001a\u0004\u0018\u00010\u0007*\b\u0012\u0004\u0012\u00020\u00070\u001a2\u0006\u0010\u0018\u001a\u00020\u0007H\u0002J&\u0010;\u001a\u00020\u0017*\u00020%2\u0018\u0010@\u001a\u0014\u0012\u0004\u0012\u00020-\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u001a0,H\u0002J\u001e\u0010S\u001a\b\u0012\u0004\u0012\u00020\u000706*\u0006\u0012\u0002\b\u00030(2\u0006\u0010T\u001a\u00020UH\u0002JZ\u0010V\u001a\u00020\u0017*\u00020%2\f\u0010L\u001a\b\u0012\u0004\u0012\u00020\u00070\u001a2$\u0010W\u001a \u0012\u001c\u0012\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020%0\t\u0012\u0004\u0012\u00020\"0X062\u0018\u0010@\u001a\u0014\u0012\u0004\u0012\u00020-\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u001a0,H\u0002R(\u0010\u0005\u001a\u001c\u0012\u0004\u0012\u00020\u0007\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\t0\b0\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\n\u001a\u001c\u0012\u0004\u0012\u00020\u0007\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\t0\b0\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR,\u0010\r\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\t0\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0018\u0010\u0012\u001a\u00020\u0013*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006["}, d2={"Ljetbrains/jetpass/userManagement/persistence/text/processor/HubTextProcessor;", "Ljetbrains/jetpass/dnq/TransientStoreSessionAdapter;", "store", "Ljetbrains/exodus/database/TransientEntityStore;", "(Ljetbrains/exodus/database/TransientEntityStore;)V", "perListenTypeExtractors", "", "", "", "Ljetbrains/jetpass/userManagement/persistence/text/processor/TextExtractor;", "perTargetTypeExtractors", "getStore", "()Ljetbrains/exodus/database/TransientEntityStore;", "textExtractors", "getTextExtractors", "()Ljava/util/List;", "setTextExtractors", "(Ljava/util/List;)V", "tokenMultiplier", "", "getTokenMultiplier", "(Ljava/lang/String;)I", "addToIndex", "", "token", "index", "Ljetbrains/exodus/bindings/ComparableSet;", "tokens", "", "beforeFlushBeforeConstraints", "session", "Ljetbrains/exodus/database/TransientStoreSession;", "changedEntities", "", "Ljetbrains/exodus/database/TransientEntityChange;", "bulkIndexOperation", "XD", "Lkotlinx/dnq/XdEntity;", "txn", "entityType", "Lkotlinx/dnq/XdEntityType;", "packSize", "body", "Lkotlin/Function2;", "", "Ljetbrains/exodus/entitystore/EntityId;", "find", "Lkotlinx/dnq/query/XdQuery;", "query", "matchPrefix", "", "tokenizer", "Ljetbrains/jetpass/userManagement/persistence/text/processor/Tokenizer;", "getListenTypeExtractors", "Lkotlin/sequences/Sequence;", "ListenXD", "TargetXD", "change", "hasIndexFor", "rebuildIndex", "targetType", "reindexEntity", "xdTarget", "textExtractor", "indexChanges", "(Lkotlinx/dnq/XdEntity;Ljetbrains/jetpass/userManagement/persistence/text/processor/TextExtractor;Ljava/util/Map;)V", "removeFromIndex", "saveChanges", "transientSession", "changes", "shouldRebuildIndex", "startListen", "stopListen", "updateExtractors", "updateIndexChanges", "target", "originalTextIndex", "Ljetbrains/jetpass/userManagement/persistence/text/processor/HubTextProcessor$PropertyChange;", "(Lkotlinx/dnq/XdEntity;Ljetbrains/exodus/bindings/ComparableSet;Ljava/util/List;Ljava/util/Map;)V", "filterNames", "Ljetbrains/jetpass/userManagement/persistence/text/processor/IndexProperty;", "allowedNames", "findTokenMultiplier", "thisAndAllSubTypeNames", "modelMetaData", "Ljetbrains/exodus/query/metadata/ModelMetaData;", "updateIndex", "sources", "Lkotlin/Pair;", "Companion", "PropertyChange", "jetbrains.jetpass.userManagement"})
public class HubTextProcessor
extends TransientStoreSessionAdapter {
    @Autowired
    @NotNull
    private List<? extends TextExtractor<?, ?>> textExtractors;
    private Map<String, ? extends List<? extends TextExtractor<?, ?>>> perListenTypeExtractors;
    private Map<String, ? extends List<? extends TextExtractor<?, ?>>> perTargetTypeExtractors;
    @NotNull
    private final TransientEntityStore store;
    @NotNull
    public static final String TEXT_INDEX_PROPERTY_NAME = "$text_index$";
    private static final String TOKEN_MULTIPLIER_SEPARATOR = "\u2aff\u2aff*";
    private static final String TOKEN_MULTIPLIER_SYMBOL = "\u2981";
    @NotNull
    public static final String MARKER = "7b56ae39-a92e-474b-845a-ee7eea995a39-marker";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final List<TextExtractor<?, ?>> getTextExtractors() {
        return this.textExtractors;
    }

    public final void setTextExtractors(@NotNull List<? extends TextExtractor<?, ?>> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"<set-?>");
        this.textExtractors = list;
    }

    @Override
    public void beforeFlushBeforeConstraints(@NotNull TransientStoreSession session2, @NotNull Set<TransientEntityChange> changedEntities) {
        XdEntity target;
        Map $receiver$iv$iv;
        Map $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
        Intrinsics.checkParameterIsNotNull(changedEntities, (String)"changedEntities");
        HashMap indexChanges = new HashMap();
        Sequence sequence = SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)changedEntities), (Function1)((Function1)new Function1<TransientEntityChange, Sequence<? extends Triple<? extends XdEntity, ? extends TextExtractor<XdEntity, XdEntity>, ? extends TransientEntityChange>>>(this){
            final /* synthetic */ HubTextProcessor this$0;

            @NotNull
            public final Sequence<Triple<XdEntity, TextExtractor<XdEntity, XdEntity>, TransientEntityChange>> invoke(@NotNull TransientEntityChange change) {
                Intrinsics.checkParameterIsNotNull((Object)change, (String)"change");
                return SequencesKt.map((Sequence)HubTextProcessor.access$getListenTypeExtractors(this.this$0, change), (Function1)((Function1)new Function1<TextExtractor<XdEntity, XdEntity>, Triple<? extends XdEntity, ? extends TextExtractor<XdEntity, XdEntity>, ? extends TransientEntityChange>>(change){
                    final /* synthetic */ TransientEntityChange $change;

                    @NotNull
                    public final Triple<XdEntity, TextExtractor<XdEntity, XdEntity>, TransientEntityChange> invoke(@NotNull TextExtractor<XdEntity, XdEntity> extractor) {
                        Intrinsics.checkParameterIsNotNull(extractor, (String)"extractor");
                        TransientEntity entity = this.$change.getChangeType() == EntityChangeType.REMOVE ? this.$change.getSnapshotEntity() : this.$change.getTransientEntity();
                        XdEntity xdChange = XdExtensionsKt.toXd((Entity)((Entity)entity));
                        return new Triple((Object)extractor.getIndexTarget(xdChange), extractor, (Object)this.$change);
                    }
                    {
                        this.$change = transientEntityChange;
                        super(1);
                    }
                }));
            }
            {
                this.this$0 = hubTextProcessor;
                super(1);
            }
        }));
        Map map = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap();
        Object object = $receiver$iv$iv.iterator();
        while (object.hasNext()) {
            Object object2;
            Map $receiver$iv$iv$iv = destination$iv$iv;
            Object element$iv$iv = object.next();
            Triple $target = (Triple)element$iv$iv;
            target = (XdEntity)$target.component1();
            XdEntity key$iv$iv = target;
            Object value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                ArrayList answer$iv$iv$iv = new ArrayList();
                $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new LinkedHashMap();
        object = $receiver$iv$iv;
        for (Map.Entry element$iv$iv : object.entrySet()) {
            Map.Entry $target = element$iv$iv;
            Map.Entry $i$a$2$groupBy = $target;
            XdEntity target2 = (XdEntity)$i$a$2$groupBy.getKey();
            if (target2.isRemoved()) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        $receiver$iv = destination$iv$iv;
        map = $receiver$iv;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry $target_changes;
            Map.Entry element$iv$iv;
            element$iv$iv = $target_changes = (element$iv = iterator.next());
            target = (XdEntity)element$iv$iv.getKey();
            element$iv$iv = $target_changes;
            List changes2 = (List)element$iv$iv.getValue();
            ComparableSet<String> currentTextIndex = HubTextProcessorKt.getTextIndex(target);
            if (this.shouldRebuildIndex(currentTextIndex)) {
                this.rebuildIndex(target, indexChanges);
                continue;
            }
            this.updateIndex(target, currentTextIndex, (Sequence<? extends Pair<? extends TextExtractor<XdEntity, XdEntity>, TransientEntityChange>>)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)changes2), (Function1)beforeFlushBeforeConstraints.4.1.INSTANCE), indexChanges);
        }
        this.saveChanges(session2, indexChanges);
    }

    private final void updateIndex(@NotNull XdEntity $receiver, ComparableSet<String> originalTextIndex, Sequence<? extends Pair<? extends TextExtractor<XdEntity, XdEntity>, TransientEntityChange>> sources2, Map<EntityId, ComparableSet<String>> indexChanges) {
        Sequence<? extends Pair<? extends TextExtractor<XdEntity, XdEntity>, TransientEntityChange>> $receiver$iv = sources2;
        for (Object element$iv : $receiver$iv) {
            List list;
            Pair $extractor_change = (Pair)element$iv;
            TextExtractor extractor = (TextExtractor)$extractor_change.component1();
            TransientEntityChange change = (TransientEntityChange)$extractor_change.component2();
            switch (HubTextProcessor$WhenMappings.$EnumSwitchMapping$0[change.getChangeType().ordinal()]) {
                case 1: {
                    PropertyChange propertyChange;
                    IndexProperty it;
                    Collection collection;
                    Iterable $receiver$iv$iv;
                    Iterable $receiver$iv2;
                    Iterable iterable = this.filterNames(extractor.getProperties(), change.getChangedProperties());
                    Iterable iterable2 = $receiver$iv2;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
                    for (Object item$iv$iv : $receiver$iv$iv) {
                        IndexProperty indexProperty = (IndexProperty)item$iv$iv;
                        collection = destination$iv$iv;
                        propertyChange = new PropertyChange(SetsKt.emptySet(), it.getValue((Entity)change.getTransientEntity()));
                        collection.add(propertyChange);
                    }
                    list = (List)destination$iv$iv;
                    break;
                }
                case 2: {
                    PropertyChange propertyChange;
                    IndexProperty it;
                    Collection collection;
                    Iterable $receiver$iv2;
                    Iterable $receiver$iv$iv = $receiver$iv2 = (Iterable)extractor.getProperties();
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
                    for (Object item$iv$iv : $receiver$iv$iv) {
                        it = (IndexProperty)item$iv$iv;
                        collection = destination$iv$iv;
                        propertyChange = new PropertyChange(it.getValue((Entity)change.getSnapshotEntity()), SetsKt.emptySet());
                        collection.add(propertyChange);
                    }
                    list = (List)destination$iv$iv;
                    break;
                }
                case 3: {
                    PropertyChange propertyChange;
                    IndexProperty it;
                    Collection collection;
                    Iterable $receiver$iv2 = this.filterNames(extractor.getProperties(), change.getChangedProperties());
                    Iterable $receiver$iv$iv = $receiver$iv2;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
                    for (Object item$iv$iv : $receiver$iv$iv) {
                        it = (IndexProperty)item$iv$iv;
                        collection = destination$iv$iv;
                        propertyChange = new PropertyChange(it.getValue((Entity)change.getSnapshotEntity()), it.getValue((Entity)change.getTransientEntity()));
                        collection.add(propertyChange);
                    }
                    list = (List)destination$iv$iv;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            List changes2 = list;
            this.updateIndexChanges($receiver, originalTextIndex, changes2, indexChanges);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<IndexProperty> filterNames(@NotNull List<IndexProperty> $receiver, Set<String> allowedNames) {
        List list;
        if (allowedNames == null || allowedNames.isEmpty()) {
            list = CollectionsKt.emptyList();
        } else {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)$receiver;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                IndexProperty it = (IndexProperty)element$iv$iv;
                if (!allowedNames.contains(it.getPropertyName())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final void rebuildIndex(@NotNull XdEntity $receiver, Map<EntityId, ComparableSet<String>> indexChanges) {
        List<? extends TextExtractor<?, ?>> list = this.perTargetTypeExtractors.get($receiver.getEntity().getType());
        if (list != null) {
            void $receiver$iv$iv;
            Iterable $receiver$iv = list;
            Iterable iterable = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                if (!(element$iv$iv instanceof TextExtractor)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            for (Object element$iv : $receiver$iv) {
                TextExtractor extractor = (TextExtractor)element$iv;
                this.reindexEntity($receiver, extractor, indexChanges);
            }
        }
    }

    private final boolean shouldRebuildIndex(ComparableSet<String> index) {
        return !index.isEmpty() && !index.containsItem((Comparable)((Object)MARKER));
    }

    private final int getTokenMultiplier(@NotNull String $receiver) {
        Integer n = StringsKt.substringBefore$default((String)$receiver, (String)TOKEN_MULTIPLIER_SEPARATOR, null, (int)2, null).length();
        int it = ((Number)n).intValue();
        Integer n2 = it > 0 ? n : null;
        return n2 != null ? n2 : 1;
    }

    private final <TargetXD extends XdEntity> void updateIndexChanges(TargetXD target, ComparableSet<String> originalTextIndex, List<PropertyChange> changes2, Map<EntityId, ComparableSet<String>> indexChanges) {
        ComparableSet<String> comparableSet = indexChanges.get(target.getEntityId());
        if (comparableSet == null) {
            comparableSet = originalTextIndex;
        }
        ComparableSet<String> currentIndexValues = comparableSet;
        Iterable $receiver$iv = changes2;
        for (Object element$iv : $receiver$iv) {
            PropertyChange $tokensBefore_tokensAfter = (PropertyChange)element$iv;
            Set<String> tokensBefore = $tokensBefore_tokensAfter.component1();
            Set<String> tokensAfter = $tokensBefore_tokensAfter.component2();
            Set removeDelta = SetsKt.minus(tokensBefore, (Iterable)tokensAfter);
            Iterable $receiver$iv2 = removeDelta;
            for (Object element$iv2 : $receiver$iv2) {
                String token2 = (String)element$iv2;
                if (this.removeFromIndex(token2, currentIndexValues)) continue;
                Companion.getLogger().warn((Function0)new Function0<String>(token2, this, currentIndexValues, target){
                    final /* synthetic */ String $token;
                    final /* synthetic */ HubTextProcessor this$0;
                    final /* synthetic */ ComparableSet $currentIndexValues$inlined;
                    final /* synthetic */ XdEntity $target$inlined;
                    {
                        this.$token = string;
                        this.this$0 = hubTextProcessor;
                        this.$currentIndexValues$inlined = comparableSet;
                        this.$target$inlined = xdEntity;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "The value [" + this.$token + "] was expected to be in the text index of [" + this.$target$inlined + " | " + this.$target$inlined.getEntity() + "] but it is absent";
                    }
                });
            }
            Set addDelta = SetsKt.minus(tokensAfter, (Iterable)tokensBefore);
            Iterable $receiver$iv3 = addDelta;
            for (Object element$iv3 : $receiver$iv3) {
                String token3 = (String)element$iv3;
                this.addToIndex(token3, currentIndexValues);
            }
        }
        Map<EntityId, ComparableSet<String>> map = indexChanges;
        EntityId entityId = target.getEntityId();
        ComparableSet<String> comparableSet2 = currentIndexValues;
        map.put(entityId, comparableSet2);
    }

    private final void addToIndex(String token2, ComparableSet<String> index) {
        if (index.containsItem((Comparable)((Object)token2))) {
            String tokenMultiplier;
            String string = tokenMultiplier = this.findTokenMultiplier(index, token2);
            if (string != null) {
                String string2;
                String it = string2 = string;
                index.removeItem((Comparable)((Object)tokenMultiplier));
            }
            String string3 = tokenMultiplier;
            int multiplier = string3 != null ? this.getTokenMultiplier(string3) : 1;
            index.addItem((Comparable)((Object)HubTextProcessor.Companion.multiply(token2, multiplier + 1)));
        } else {
            index.addItem((Comparable)((Object)token2));
        }
    }

    private final void addToIndex(Iterable<String> tokens, ComparableSet<String> index) {
        Iterable<String> $receiver$iv = tokens;
        Iterator<String> iterator = $receiver$iv.iterator();
        while (iterator.hasNext()) {
            String element$iv;
            String it = element$iv = iterator.next();
            this.addToIndex(it, index);
        }
    }

    private final boolean removeFromIndex(String token2, ComparableSet<String> index) {
        boolean bl;
        if (index.containsItem((Comparable)((Object)token2))) {
            String tokenMultiplier;
            String string = tokenMultiplier = this.findTokenMultiplier(index, token2);
            if (string != null) {
                String string2;
                String it = string2 = string;
                index.removeItem((Comparable)((Object)tokenMultiplier));
            }
            String string3 = tokenMultiplier;
            int multiplier = string3 != null ? this.getTokenMultiplier(string3) : 1;
            int nextMultiplier = multiplier - 1;
            if (nextMultiplier == 0) {
                index.removeItem((Comparable)((Object)token2));
            } else if (nextMultiplier > 1) {
                index.addItem((Comparable)((Object)HubTextProcessor.Companion.multiply(token2, nextMultiplier)));
            }
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private final String findTokenMultiplier(@NotNull ComparableSet<String> $receiver, String token2) {
        Object v1;
        block1: {
            Iterable iterable;
            Iterable iterable2 = iterable = (Iterable)$receiver;
            for (Object t : iterable2) {
                String it;
                String string = it = (String)t;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it");
                if (!StringsKt.endsWith$default((String)string, (String)(TOKEN_MULTIPLIER_SEPARATOR + token2), (boolean)false, (int)2, null)) continue;
                v1 = t;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    private final <ListenXD extends XdEntity, TargetXD extends XdEntity> Sequence<TextExtractor<ListenXD, TargetXD>> getListenTypeExtractors(TransientEntityChange change) {
        TransientEntity listenEntity = change.getTransientEntity();
        if (change.getChangeType() == EntityChangeType.REMOVE) {
            List list = this.perListenTypeExtractors.get(listenEntity.getType());
            List list2 = list;
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
            return CollectionsKt.asSequence((Iterable)list2);
        }
        Set changedPropertyNames = change.getChangedProperties();
        if (changedPropertyNames == null || changedPropertyNames.isEmpty()) {
            return SequencesKt.emptySequence();
        }
        List list = this.perListenTypeExtractors.get(listenEntity.getType());
        List list3 = list;
        if (list3 == null) {
            list3 = CollectionsKt.emptyList();
        }
        return SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)list3), (Function1)new Function1<TextExtractor<ListenXD, TargetXD>, Boolean>(changedPropertyNames){
            final /* synthetic */ Set $changedPropertyNames;

            public final boolean invoke(@NotNull TextExtractor<ListenXD, TargetXD> extractor) {
                boolean bl;
                block3: {
                    Intrinsics.checkParameterIsNotNull(extractor, (String)"extractor");
                    Iterable $receiver$iv = extractor.getProperties();
                    if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $receiver$iv) {
                            IndexProperty it = (IndexProperty)element$iv;
                            if (!this.$changedPropertyNames.contains(it.getPropertyName())) continue;
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                }
                return bl;
            }
            {
                this.$changedPropertyNames = set;
                super(1);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public final void rebuildIndex() {
        void $receiver$iv$iv;
        Iterable $receiver$iv = this.textExtractors;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            TextExtractor textExtractor = (TextExtractor)item$iv$iv;
            Collection collection = destination$iv$iv;
            XdEntityType xdEntityType = it.getTargetEntityType();
            collection.add(xdEntityType);
        }
        $receiver$iv = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        for (Object element$iv : $receiver$iv) {
            XdEntityType it = (XdEntityType)element$iv;
            this.rebuildIndex(it);
        }
    }

    public final <XD extends XdEntity> void rebuildIndex(@NotNull XdEntityType<? extends XD> targetType) {
        Intrinsics.checkParameterIsNotNull(targetType, (String)"targetType");
        Companion.getLogger().info((Function0)new Function0<String>(targetType){
            final /* synthetic */ XdEntityType $targetType;

            @NotNull
            public final String invoke() {
                return "Text index rebuild for " + this.$targetType.getEntityType() + " is about to start...";
            }
            {
                this.$targetType = xdEntityType;
                super(0);
            }
        });
        long start$iv = System.currentTimeMillis();
        TransactionKt.legacyTransactional$default(false, null, false, (Function1)new Function1<TransientStoreSession, Unit>(this, targetType){
            final /* synthetic */ HubTextProcessor this$0;
            final /* synthetic */ XdEntityType $targetType$inlined;
            {
                this.this$0 = hubTextProcessor;
                this.$targetType$inlined = xdEntityType;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull TransientStoreSession txn) {
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                Intrinsics.checkParameterIsNotNull((Object)txn, (String)"txn");
                Iterable iterable = $receiver$iv = (Iterable)this.this$0.getTextExtractors();
                Collection destination$iv$iv = new ArrayList<E>();
                for (T element$iv$iv : $receiver$iv$iv) {
                    TextExtractor it = (TextExtractor)element$iv$iv;
                    if (!Intrinsics.areEqual(it.getTargetEntityType(), (Object)this.$targetType$inlined)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List textExtractors = (List)destination$iv$iv;
                HubTextProcessor.access$bulkIndexOperation(this.this$0, txn, this.$targetType$inlined, 3000, (Function2)new Function2<XD, Map<EntityId, ComparableSet<String>>, Unit>(this, textExtractors){
                    final /* synthetic */ rebuildIndex$$inlined$measureTimeMillis$lambda$1 this$0;
                    final /* synthetic */ List $textExtractors;
                    {
                        this.this$0 = var1_1;
                        this.$textExtractors = list;
                        super(2);
                    }

                    public final void invoke(@NotNull XD xdTarget, @NotNull Map<EntityId, ComparableSet<String>> indexChanges) {
                        Intrinsics.checkParameterIsNotNull(xdTarget, (String)"xdTarget");
                        Intrinsics.checkParameterIsNotNull(indexChanges, (String)"indexChanges");
                        Iterable $receiver$iv = this.$textExtractors;
                        for (T element$iv : $receiver$iv) {
                            TextExtractor it;
                            TextExtractor textExtractor = it = (TextExtractor)element$iv;
                            if (textExtractor == null) {
                                throw new TypeCastException("null cannot be cast to non-null type jetbrains.jetpass.userManagement.persistence.text.processor.TextExtractor<*, kotlinx.dnq.XdEntity>");
                            }
                            HubTextProcessor.access$reindexEntity(this.this$0.this$0, xdTarget, textExtractor, indexChanges);
                        }
                    }
                });
            }
        }, 7, null);
        long time = System.currentTimeMillis() - start$iv;
        Companion.getLogger().info((Function0)new Function0<String>(targetType, time){
            final /* synthetic */ XdEntityType $targetType;
            final /* synthetic */ long $time;

            @NotNull
            public final String invoke() {
                return "Text index rebuild for " + this.$targetType.getEntityType() + " completed in " + this.$time + " ms";
            }
            {
                this.$targetType = xdEntityType;
                this.$time = l;
                super(0);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final <XD extends XdEntity> void bulkIndexOperation(TransientStoreSession txn, XdEntityType<? extends XD> entityType, int packSize, Function2<? super XD, ? super Map<EntityId, ComparableSet<String>>, Unit> body) {
        Ref.IntRef intRef = new Ref.IntRef();
        intRef.element = 0;
        while (true) {
            void time;
            void processed;
            Ref.LongRef longRef = new Ref.LongRef();
            longRef.element = System.currentTimeMillis();
            XdQuery entitiesToIndex = XdQueryKt.take((XdQuery)XdQueryKt.drop((XdQuery)entityType.all(), (int)processed.element), (int)packSize);
            int inc = 0;
            HashMap changesTracker = new HashMap();
            Iterator iterator = XdQueryKt.iterator((XdQuery)entitiesToIndex);
            while (iterator.hasNext()) {
                XdEntity entity = (XdEntity)iterator.next();
                ++inc;
                body.invoke((Object)entity, changesTracker);
            }
            if (inc <= 0) break;
            this.saveChanges(txn, changesTracker);
            txn.flush();
            processed.element += inc;
            time.element = System.currentTimeMillis() - time.element;
            Companion.getLogger().trace((Function0)new Function0<String>((Ref.IntRef)processed, entityType, (Ref.LongRef)time){
                final /* synthetic */ Ref.IntRef $processed;
                final /* synthetic */ XdEntityType $entityType;
                final /* synthetic */ Ref.LongRef $time;

                @NotNull
                public final String invoke() {
                    return "Indexed " + this.$processed.element + ' ' + this.$entityType.getEntityType() + " in " + this.$time.element + "ms";
                }
                {
                    this.$processed = intRef;
                    this.$entityType = xdEntityType;
                    this.$time = longRef;
                    super(0);
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    private final <ListenXD extends XdEntity, TargetXD extends XdEntity> void reindexEntity(TargetXD xdTarget, TextExtractor<ListenXD, TargetXD> textExtractor, Map<EntityId, ComparableSet<String>> indexChanges) {
        Sequence sources2;
        Sequence $receiver$iv = sources2 = SequencesKt.filterNot(textExtractor.getIndexSources(xdTarget), (Function1)reindexEntity.sources.1.INSTANCE);
        for (Object element$iv : $receiver$iv) {
            void $receiver$iv2;
            XdEntity xdSource = (XdEntity)element$iv;
            Iterable iterable = textExtractor.getProperties();
            for (Object element$iv2 : $receiver$iv2) {
                Object object;
                void $receiver$iv3;
                IndexProperty indexProperty = (IndexProperty)element$iv2;
                Map<EntityId, ComparableSet<String>> map = indexChanges;
                EntityId key$iv = xdTarget.getEntityId();
                Object value$iv = $receiver$iv3.get(key$iv);
                if (value$iv == null) {
                    ComparableSet answer$iv = new ComparableSet();
                    $receiver$iv3.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ComparableSet targetIndex = (ComparableSet)object;
                this.addToIndex((Iterable<String>)indexProperty.getValue(xdSource.getEntity()), (ComparableSet<String>)targetIndex);
            }
        }
    }

    private final void saveChanges(TransientStoreSession transientSession, Map<EntityId, ? extends ComparableSet<String>> changes2) {
        if (!(transientSession instanceof TransientSessionImpl)) {
            throw (Throwable)new IllegalStateException("Cannot update text index because transientSession is not an instance of TransientSessionImpl");
        }
        Map<EntityId, ? extends ComparableSet<String>> map = changes2;
        if (!map.isEmpty()) {
            ((TransientSessionImpl)transientSession).addChangeAndRun((Function0)new Function0<Boolean>(transientSession, changes2){
                final /* synthetic */ TransientStoreSession $transientSession;
                final /* synthetic */ Map $changes;

                public final boolean invoke() {
                    PersistentStoreTransaction persistentTransaction = ((TransientSessionImpl)this.$transientSession).getPersistentTransaction();
                    Map map = this.$changes;
                    Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
                    while (iterator.hasNext()) {
                        boolean bl;
                        PersistentEntity persistentEntity;
                        PersistentEntity persistentEntity2 = persistentEntity = iterator.next();
                        EntityId entityId = (EntityId)persistentEntity2.getKey();
                        persistentEntity2 = persistentEntity;
                        ComparableSet index = (ComparableSet)persistentEntity2.getValue();
                        PersistentEntity persistentEntity3 = persistentEntity2 = persistentTransaction.getStore().getEntity(entityId);
                        if (!index.isEmpty()) {
                            index.addItem((Comparable)((Object)"7b56ae39-a92e-474b-845a-ee7eea995a39-marker"));
                            bl = persistentEntity3.setProperty("$text_index$", (Comparable)index);
                            continue;
                        }
                        bl = persistentEntity3.deleteProperty("$text_index$");
                    }
                    return true;
                }
                {
                    this.$transientSession = transientStoreSession;
                    this.$changes = map;
                    super(0);
                }
            });
        }
    }

    @PostConstruct
    public final void startListen() {
        this.updateExtractors();
        this.store.addListener((TransientStoreSessionListener)this, Integer.MAX_VALUE);
    }

    private final void updateExtractors() {
        ModelMetaData modelMetaData = this.store.getModelMetaData();
        if (modelMetaData == null) {
            throw (Throwable)new IllegalStateException("Cannot set up text index because model meta-data is not set up");
        }
        ModelMetaData modelMetaData2 = modelMetaData;
        HashMap perListenTypeExtractors = new HashMap();
        HashMap perTargetTypeExtractors = new HashMap();
        for (TextExtractor<?, ?> textExtractor : this.textExtractors) {
            List extractors;
            Sequence $receiver$iv;
            Sequence sequence = SequencesKt.map(this.thisAndAllSubTypeNames(textExtractor.getListenEntityType(), modelMetaData2), (Function1)new Function1<String, List<TextExtractor<?, ?>>>(perListenTypeExtractors){
                final /* synthetic */ HashMap $perListenTypeExtractors;

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final List<TextExtractor<?, ?>> invoke(@NotNull String entityTypeName) {
                    ArrayList<E> arrayList;
                    Intrinsics.checkParameterIsNotNull((Object)entityTypeName, (String)"entityTypeName");
                    Map $receiver$iv = this.$perListenTypeExtractors;
                    V value$iv = $receiver$iv.get(entityTypeName);
                    if (value$iv == null) {
                        ArrayList<E> answer$iv = new ArrayList<E>(1);
                        $receiver$iv.put(entityTypeName, answer$iv);
                        arrayList = answer$iv;
                    } else {
                        void var3_3;
                        arrayList = var3_3;
                    }
                    return arrayList;
                }
                {
                    this.$perListenTypeExtractors = hashMap;
                    super(1);
                }
            });
            for (Object element$iv : $receiver$iv) {
                extractors = (List)element$iv;
                extractors.add(textExtractor);
            }
            $receiver$iv = SequencesKt.map(this.thisAndAllSubTypeNames(textExtractor.getTargetEntityType(), modelMetaData2), (Function1)new Function1<String, List<TextExtractor<?, ?>>>(perTargetTypeExtractors){
                final /* synthetic */ HashMap $perTargetTypeExtractors;

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final List<TextExtractor<?, ?>> invoke(@NotNull String entityTypeName) {
                    ArrayList<E> arrayList;
                    Intrinsics.checkParameterIsNotNull((Object)entityTypeName, (String)"entityTypeName");
                    Map $receiver$iv = this.$perTargetTypeExtractors;
                    V value$iv = $receiver$iv.get(entityTypeName);
                    if (value$iv == null) {
                        ArrayList<E> answer$iv = new ArrayList<E>(1);
                        $receiver$iv.put(entityTypeName, answer$iv);
                        arrayList = answer$iv;
                    } else {
                        void var3_3;
                        arrayList = var3_3;
                    }
                    return arrayList;
                }
                {
                    this.$perTargetTypeExtractors = hashMap;
                    super(1);
                }
            });
            for (Object element$iv : $receiver$iv) {
                extractors = (List)element$iv;
                extractors.add(textExtractor);
            }
        }
        this.perListenTypeExtractors = perListenTypeExtractors;
        this.perTargetTypeExtractors = perTargetTypeExtractors;
    }

    private final Sequence<String> thisAndAllSubTypeNames(@NotNull XdEntityType<?> $receiver, ModelMetaData modelMetaData) {
        String entityTypeName = $receiver.getEntityType();
        EntityMetaData entityMetaData = modelMetaData.getEntityMetaData(entityTypeName);
        if (entityMetaData == null) {
            throw (Throwable)new IllegalStateException("Cannot set up text index for " + entityTypeName + " because entity meta-data is not defined for this type ");
        }
        EntityMetaData entityMetaData2 = entityMetaData;
        Sequence sequence = SequencesKt.sequenceOf((Object[])new String[]{entityTypeName});
        EntityMetaData entityMetaData3 = entityMetaData2;
        Intrinsics.checkExpressionValueIsNotNull((Object)entityMetaData3, (String)"entityMetaData");
        Collection collection = entityMetaData3.getAllSubTypes();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"entityMetaData.allSubTypes");
        return SequencesKt.plus((Sequence)sequence, (Sequence)CollectionsKt.asSequence((Iterable)collection));
    }

    @PreDestroy
    public final void stopListen() {
        this.store.removeListener((TransientStoreSessionListener)this);
    }

    public final boolean hasIndexFor(@NotNull XdEntityType<?> entityType) {
        Intrinsics.checkParameterIsNotNull(entityType, (String)"entityType");
        Map<String, List<TextExtractor<?, ?>>> map = this.perTargetTypeExtractors;
        String string = entityType.getEntityType();
        Map<String, List<TextExtractor<?, ?>>> map2 = map;
        return map2.containsKey(string);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <XD extends XdEntity> XdQuery<XD> find(@NotNull XdEntityType<? extends XD> entityType, @NotNull String query2, boolean matchPrefix, @NotNull Tokenizer tokenizer) {
        Object object;
        block6: {
            block5: {
                void $receiver$iv;
                Intrinsics.checkParameterIsNotNull(entityType, (String)"entityType");
                Intrinsics.checkParameterIsNotNull((Object)query2, (String)"query");
                Intrinsics.checkParameterIsNotNull((Object)tokenizer, (String)"tokenizer");
                Sequence sequence = entityType;
                String propertyName = Intrinsics.areEqual(sequence, (Object)((Object)XdEvent.Companion)) ? "presentation" : TEXT_INDEX_PROPERTY_NAME;
                Sequence queryTokens = sequence = SequencesKt.filter(tokenizer.tokenize(query2), (Function1)find.1.INSTANCE);
                object = SequencesKt.any((Sequence)queryTokens) ? sequence : null;
                if (object == null || (object = SequencesKt.map((Sequence)object, (Function1)new Function1<String, XdQuery<? extends XD>>((XdEntityType)entityType, matchPrefix, propertyName){
                    final /* synthetic */ XdEntityType $entityType;
                    final /* synthetic */ boolean $matchPrefix;
                    final /* synthetic */ String $propertyName;

                    @NotNull
                    public final XdQuery<XD> invoke(@NotNull String queryToken) {
                        Intrinsics.checkParameterIsNotNull((Object)queryToken, (String)"queryToken");
                        return XdQueryKt.query((XdEntityType)this.$entityType, (NodeBase)(this.$matchPrefix ? (NodeBase)new PropertyStartsWith(this.$propertyName, queryToken) : (NodeBase)new PropertyEqual(this.$propertyName, (Comparable)((Object)queryToken))));
                    }
                    {
                        this.$entityType = xdEntityType;
                        this.$matchPrefix = bl;
                        this.$propertyName = string;
                        super(1);
                    }
                })) == null) break block5;
                sequence = object;
                Iterator iterator$iv = $receiver$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    throw (Throwable)new UnsupportedOperationException("Empty sequence can't be reduced.");
                }
                Object accumulator$iv = iterator$iv.next();
                while (iterator$iv.hasNext()) {
                    void xdQueryB;
                    XdQuery xdQuery = (XdQuery)iterator$iv.next();
                    XdQuery xdQueryA = (XdQuery)accumulator$iv;
                    accumulator$iv = XdQueryKt.intersect((XdQuery)xdQueryA, (XdQuery)xdQueryB);
                }
                object = (XdQuery)accumulator$iv;
                if (object != null && (object = XdQueryKt.distinct((XdQuery)object)) != null) break block6;
            }
            object = XdQueryKt.emptyQuery((XdEntityType)entityType);
        }
        return object;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ XdQuery find$default(HubTextProcessor hubTextProcessor, XdEntityType xdEntityType, String string, boolean bl, Tokenizer tokenizer, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: find");
        }
        if ((n & 8) != 0) {
            tokenizer = Tokenizer.Companion.getSPACE_TOKENIZER();
        }
        return hubTextProcessor.find(xdEntityType, string, bl, tokenizer);
    }

    @NotNull
    public final TransientEntityStore getStore() {
        return this.store;
    }

    @Inject
    public HubTextProcessor(@NotNull TransientEntityStore store2) {
        Intrinsics.checkParameterIsNotNull((Object)store2, (String)"store");
        this.store = store2;
        this.textExtractors = CollectionsKt.emptyList();
        this.perListenTypeExtractors = MapsKt.emptyMap();
        this.perTargetTypeExtractors = MapsKt.emptyMap();
    }

    @NotNull
    public static final /* synthetic */ Sequence access$getListenTypeExtractors(HubTextProcessor $this, @NotNull TransientEntityChange change) {
        return $this.getListenTypeExtractors(change);
    }

    public static final /* synthetic */ void access$bulkIndexOperation(HubTextProcessor $this, @NotNull TransientStoreSession txn, @NotNull XdEntityType entityType, int packSize, @NotNull Function2 body) {
        $this.bulkIndexOperation(txn, entityType, packSize, body);
    }

    public static final /* synthetic */ void access$reindexEntity(HubTextProcessor $this, @NotNull XdEntity xdTarget, @NotNull TextExtractor textExtractor, @NotNull Map indexChanges) {
        $this.reindexEntity(xdTarget, textExtractor, indexChanges);
    }

    @JvmStatic
    @NotNull
    public static final HubTextProcessor get() {
        return Companion.get();
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0006J\u000f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J)\u0010\f\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0004H\u00d6\u0001R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Ljetbrains/jetpass/userManagement/persistence/text/processor/HubTextProcessor$PropertyChange;", "", "tokensBefore", "", "", "tokensAfter", "(Ljava/util/Set;Ljava/util/Set;)V", "getTokensAfter", "()Ljava/util/Set;", "getTokensBefore", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "jetbrains.jetpass.userManagement"})
    public static final class PropertyChange {
        @NotNull
        private final Set<String> tokensBefore;
        @NotNull
        private final Set<String> tokensAfter;

        @NotNull
        public final Set<String> getTokensBefore() {
            return this.tokensBefore;
        }

        @NotNull
        public final Set<String> getTokensAfter() {
            return this.tokensAfter;
        }

        public PropertyChange(@NotNull Set<String> tokensBefore, @NotNull Set<String> tokensAfter) {
            Intrinsics.checkParameterIsNotNull(tokensBefore, (String)"tokensBefore");
            Intrinsics.checkParameterIsNotNull(tokensAfter, (String)"tokensAfter");
            this.tokensBefore = tokensBefore;
            this.tokensAfter = tokensAfter;
        }

        @NotNull
        public final Set<String> component1() {
            return this.tokensBefore;
        }

        @NotNull
        public final Set<String> component2() {
            return this.tokensAfter;
        }

        @NotNull
        public final PropertyChange copy(@NotNull Set<String> tokensBefore, @NotNull Set<String> tokensAfter) {
            Intrinsics.checkParameterIsNotNull(tokensBefore, (String)"tokensBefore");
            Intrinsics.checkParameterIsNotNull(tokensAfter, (String)"tokensAfter");
            return new PropertyChange(tokensBefore, tokensAfter);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ PropertyChange copy$default(PropertyChange propertyChange, Set set, Set set2, int n, Object object) {
            if ((n & 1) != 0) {
                set = propertyChange.tokensBefore;
            }
            if ((n & 2) != 0) {
                set2 = propertyChange.tokensAfter;
            }
            return propertyChange.copy(set, set2);
        }

        public String toString() {
            return "PropertyChange(tokensBefore=" + this.tokensBefore + ", tokensAfter=" + this.tokensAfter + ")";
        }

        public int hashCode() {
            Set<String> set = this.tokensBefore;
            Set<String> set2 = this.tokensAfter;
            return (set != null ? ((Object)set).hashCode() : 0) * 31 + (set2 != null ? ((Object)set2).hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof PropertyChange)) break block3;
                    PropertyChange propertyChange = (PropertyChange)object;
                    if (!Intrinsics.areEqual(this.tokensBefore, propertyChange.tokensBefore) || !Intrinsics.areEqual(this.tokensAfter, propertyChange.tokensAfter)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\tH\u0007J\u0016\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rJ\u0014\u0010\u000e\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Ljetbrains/jetpass/userManagement/persistence/text/processor/HubTextProcessor$Companion;", "Lmu/KLogging;", "()V", "MARKER", "", "TEXT_INDEX_PROPERTY_NAME", "TOKEN_MULTIPLIER_SEPARATOR", "TOKEN_MULTIPLIER_SYMBOL", "get", "Ljetbrains/jetpass/userManagement/persistence/text/processor/HubTextProcessor;", "multiplyToken", "token", "multiplier", "", "multiply", "jetbrains.jetpass.userManagement"})
    public static final class Companion
    extends KLogging {
        @JvmStatic
        @NotNull
        public final HubTextProcessor get() {
            String name$iv = "textProcessor";
            return SpringUtils.resolveBean(HubTextProcessor.class, name$iv);
        }

        private final String multiply(@NotNull String $receiver, int multiplier) {
            return StringsKt.repeat((CharSequence)HubTextProcessor.TOKEN_MULTIPLIER_SYMBOL, (int)multiplier) + HubTextProcessor.TOKEN_MULTIPLIER_SEPARATOR + $receiver;
        }

        @NotNull
        public final String multiplyToken(@NotNull String token2, int multiplier) {
            Intrinsics.checkParameterIsNotNull((Object)token2, (String)"token");
            return this.multiply(token2, multiplier);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

