/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.userManagement.settings;

import java.time.LocalDate;
import jetbrains.jetpass.notification.NotificationException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\t\u001a\u00020\bH\u0002J\b\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\u000bH\u0002J\b\u0010\r\u001a\u00020\u000bH\u0002J\u0006\u0010\u000e\u001a\u00020\bR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Ljetbrains/jetpass/userManagement/settings/HubInstanceCache;", "", "()V", "mailCount", "Lkotlin/Pair;", "Ljava/time/LocalDate;", "", "cleanMailCount", "", "incrementMailCount", "isCountUpdatedToday", "", "isMailCountOverflow", "isMailCountOverflowToday", "verifyMailCount", "jetbrains.jetpass.userManagement"})
public final class HubInstanceCache {
    private Pair<LocalDate, Integer> mailCount;

    private final boolean isCountUpdatedToday() {
        return Intrinsics.areEqual((Object)((LocalDate)this.mailCount.getFirst()), (Object)LocalDate.now()) ^ true;
    }

    private final void cleanMailCount() {
        LocalDate localDate = LocalDate.now();
        Intrinsics.checkExpressionValueIsNotNull((Object)localDate, (String)"LocalDate.now()");
        this.mailCount = new Pair((Object)localDate, (Object)0);
    }

    private final void incrementMailCount() {
        LocalDate localDate = LocalDate.now();
        Intrinsics.checkExpressionValueIsNotNull((Object)localDate, (String)"LocalDate.now()");
        this.mailCount = new Pair((Object)localDate, (Object)(((Number)this.mailCount.getSecond()).intValue() + 1));
    }

    private final boolean isMailCountOverflow() {
        return ((Number)this.mailCount.getSecond()).intValue() < 10;
    }

    private final boolean isMailCountOverflowToday() {
        return Intrinsics.areEqual((Object)((LocalDate)this.mailCount.getFirst()), (Object)LocalDate.now()) && ((Number)this.mailCount.getSecond()).intValue() >= 10;
    }

    public final void verifyMailCount() {
        if (this.isMailCountOverflowToday()) {
            throw (Throwable)NotificationException.Companion.notificationNumberEmails();
        }
        if (this.isCountUpdatedToday()) {
            this.cleanMailCount();
        }
        if (this.isMailCountOverflow()) {
            this.incrementMailCount();
        }
    }

    public HubInstanceCache() {
        LocalDate localDate = LocalDate.now();
        Intrinsics.checkExpressionValueIsNotNull((Object)localDate, (String)"LocalDate.now()");
        this.mailCount = new Pair((Object)localDate, (Object)0);
    }
}

