/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.userManagement.usage;

import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001:\u0001\u001dB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\rJ\u000e\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\rR\u0018\u0010\u0003\u001a\u00060\u0004R\u00020\u00008BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00060\u0004R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0012\u0010\u0014\u001a\u00060\u0004R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0017\u001a\u00060\u0004R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Ljetbrains/jetpass/userManagement/usage/UserCountStore;", "", "()V", "activeSample", "Ljetbrains/jetpass/userManagement/usage/UserCountStore$Sample;", "getActiveSample", "()Ljetbrains/jetpass/userManagement/usage/UserCountStore$Sample;", "debouncePeriod", "Lorg/joda/time/Duration;", "getDebouncePeriod", "()Lorg/joda/time/Duration;", "lastSample", "maxUserCountToday", "", "getMaxUserCountToday", "()I", "now", "Lorg/joda/time/DateTime;", "getNow", "()Lorg/joda/time/DateTime;", "prevSample", "rwl", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "startChangesSample", "init", "", "count", "update", "newCount", "Sample", "jetbrains.jetpass.userManagement"})
public class UserCountStore {
    private Sample prevSample = new Sample(new DateTime(0L, DateTimeZone.UTC), 0, 0);
    private Sample startChangesSample = new Sample(new DateTime(0L, DateTimeZone.UTC), 0, 0);
    private Sample lastSample = new Sample(new DateTime(0L, DateTimeZone.UTC), 0, 0);
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();

    @NotNull
    public DateTime getNow() {
        DateTime dateTime = DateTime.now();
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"DateTime.now()");
        return dateTime;
    }

    @NotNull
    public Duration getDebouncePeriod() {
        Duration duration = Duration.standardMinutes((long)5L);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.standardMinutes(5)");
        return duration;
    }

    private final Sample getActiveSample() {
        return this.getNow().compareTo((ReadableInstant)this.lastSample.getTimestamp().plus((ReadableDuration)this.getDebouncePeriod())) >= 0 ? this.lastSample : (this.getNow().compareTo((ReadableInstant)this.startChangesSample.getTimestamp().plus((ReadableDuration)this.getDebouncePeriod())) >= 0 ? this.startChangesSample : this.prevSample);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getMaxUserCountToday() {
        int n;
        ReentrantReadWriteLock reentrantReadWriteLock = this.rwl;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            n = this.getActiveSample().getMaxCountToday();
        }
        finally {
            readLock.unlock();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void init(int count) {
        int n;
        ReentrantReadWriteLock reentrantReadWriteLock = this.rwl;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n2 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        int n3 = 0;
        int n4 = n2;
        while (n3 < n4) {
            n = n3++;
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            Sample initialSample;
            this.prevSample = initialSample = new Sample(this.getNow(), count, count);
            this.startChangesSample = initialSample;
            this.lastSample = initialSample;
            Unit unit = Unit.INSTANCE;
        }
        finally {
            n = 0;
            int n5 = n2;
            while (n < n5) {
                int n6 = n++;
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void update(int newCount) {
        int n;
        ReentrantReadWriteLock reentrantReadWriteLock = this.rwl;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n2 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        int n3 = 0;
        int n4 = n2;
        while (n3 < n4) {
            n = n3++;
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            DateTime now = this.getNow();
            Sample activeSample = this.getActiveSample();
            Sample newSample = new Sample(now, newCount, Math.max(newCount, activeSample.getMaxCountToday()));
            Sample sample = activeSample;
            if (Intrinsics.areEqual((Object)sample, (Object)this.lastSample)) {
                this.prevSample = this.lastSample;
                this.startChangesSample = newSample;
            } else if (Intrinsics.areEqual((Object)sample, (Object)this.startChangesSample)) {
                this.prevSample = this.startChangesSample;
                this.startChangesSample = newSample;
            }
            this.lastSample = newSample;
            Unit unit = Unit.INSTANCE;
        }
        finally {
            n = 0;
            int n5 = n2;
            while (n < n5) {
                int n6 = n++;
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0003H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u000b\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0012"}, d2={"Ljetbrains/jetpass/userManagement/usage/UserCountStore$Sample;", "", "timestamp", "Lorg/joda/time/DateTime;", "count", "", "maxCount", "(Ljetbrains/jetpass/userManagement/usage/UserCountStore;Lorg/joda/time/DateTime;II)V", "getCount", "()I", "getMaxCount", "maxCountToday", "getMaxCountToday", "getTimestamp", "()Lorg/joda/time/DateTime;", "isToday", "", "instant", "jetbrains.jetpass.userManagement"})
    private final class Sample {
        @NotNull
        private final DateTime timestamp;
        private final int count;
        private final int maxCount;

        public final int getMaxCountToday() {
            return this.isToday(this.timestamp) ? this.maxCount : this.count;
        }

        private final boolean isToday(DateTime instant) {
            Comparable comparable = (Comparable)instant;
            DateTime.Property today = UserCountStore.this.getNow().withZone(DateTimeZone.UTC).millisOfDay();
            return comparable.compareTo((Comparable)today.withMinimumValue()) >= 0 && comparable.compareTo((Comparable)today.withMaximumValue()) <= 0;
        }

        @NotNull
        public final DateTime getTimestamp() {
            return this.timestamp;
        }

        public final int getCount() {
            return this.count;
        }

        public final int getMaxCount() {
            return this.maxCount;
        }

        public Sample(DateTime timestamp, int count, int maxCount) {
            Intrinsics.checkParameterIsNotNull((Object)timestamp, (String)"timestamp");
            this.timestamp = timestamp;
            this.count = count;
            this.maxCount = maxCount;
        }
    }
}

