/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore;

import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.core.dataStructures.hash.IntHashMap;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityIterable;
import jetbrains.exodus.entitystore.EntityStore;
import jetbrains.exodus.entitystore.PersistentEntityId;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.ReadOnlyPersistentEntity;
import jetbrains.exodus.entitystore.TxnProvider;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.util.StringBuilderSpinAllocator;
import jetbrains.exodus.util.StringInterner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PersistentEntity
implements Entity,
TxnProvider {
    @NotNull
    private final PersistentEntityStoreImpl store;
    @NotNull
    private final PersistentEntityId id;

    public PersistentEntity(@NotNull PersistentEntityStoreImpl store, @NotNull PersistentEntityId id) {
        this.store = store;
        this.id = id;
    }

    public ReadOnlyPersistentEntity getSnapshot(@NotNull PersistentStoreTransaction txn) {
        if (txn.store != this.store) {
            throw new IllegalArgumentException("Can't get entity snapshot against transaction from another store!");
        }
        return new ReadOnlyPersistentEntity(txn, this.id);
    }

    @Override
    @NotNull
    public PersistentStoreTransaction getTransaction() {
        return this.store.getAndCheckCurrentTransaction();
    }

    protected void assertWritable() {
    }

    public String toString() {
        StringBuilder builder = StringBuilderSpinAllocator.alloc();
        try {
            builder.append(this.getType());
            builder.append(": id = ");
            this.id.toString(builder);
            String string = builder.toString();
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)builder);
        }
    }

    @NotNull
    public EntityStore getStore() {
        return this.store;
    }

    @NotNull
    public PersistentEntityId getId() {
        return this.id;
    }

    @NotNull
    public String toIdString() {
        return this.id.toString();
    }

    @NotNull
    public String getType() {
        return this.store.getEntityType(this, this.id.getTypeId());
    }

    public boolean delete() {
        this.assertWritable();
        return this.store.deleteEntity(this.getTransaction(), this);
    }

    @Nullable
    public ByteIterable getRawProperty(@NotNull String propertyName) {
        PersistentStoreTransaction txn = this.getTransaction();
        int propertyId = this.store.getPropertyId(txn, propertyName, false);
        return propertyId < 0 ? null : this.store.getRawProperty(txn, this.id, propertyId);
    }

    @Nullable
    public Comparable getProperty(@NotNull String propertyName) {
        return this.store.getProperty(this.getTransaction(), this, propertyName);
    }

    public boolean setProperty(@NotNull String propertyName, @NotNull Comparable value) {
        this.assertWritable();
        return this.store.setProperty(this.getTransaction(), this, propertyName, value);
    }

    public boolean deleteProperty(@NotNull String propertyName) {
        this.assertWritable();
        return this.store.deleteProperty(this.getTransaction(), this, propertyName);
    }

    @NotNull
    public List<String> getPropertyNames() {
        return this.store.getPropertyNames(this.getTransaction(), this);
    }

    public boolean hasBlob(@NotNull String blobName) {
        try {
            return this.store.getBlobHandleAndValue(this.getTransaction(), this, blobName) != null;
        }
        catch (Exception e) {
            throw ExodusException.toEntityStoreException((Throwable)e);
        }
    }

    @Nullable
    public InputStream getBlob(@NotNull String blobName) {
        try {
            return this.store.getBlob(this.getTransaction(), this, blobName);
        }
        catch (Exception e) {
            throw ExodusException.toEntityStoreException((Throwable)e);
        }
    }

    public long getBlobSize(@NotNull String blobName) {
        try {
            return this.store.getBlobSize(this.getTransaction(), this, blobName);
        }
        catch (Exception e) {
            throw ExodusException.toEntityStoreException((Throwable)e);
        }
    }

    @Nullable
    public String getBlobString(@NotNull String blobName) {
        try {
            return this.store.getBlobString(this.getTransaction(), this, blobName);
        }
        catch (Exception e) {
            throw ExodusException.toEntityStoreException((Throwable)e);
        }
    }

    public void setBlob(@NotNull String blobName, @NotNull InputStream blob) {
        this.assertWritable();
        try {
            this.store.setBlob(this.getTransaction(), this, blobName, blob);
        }
        catch (Exception e) {
            throw ExodusException.toEntityStoreException((Throwable)e);
        }
    }

    public void setBlob(@NotNull String blobName, @NotNull File file) {
        this.assertWritable();
        try {
            this.store.setBlob(this.getTransaction(), this, blobName, file);
        }
        catch (Exception e) {
            throw ExodusException.toEntityStoreException((Throwable)e);
        }
    }

    public boolean setBlobString(@NotNull String blobName, @NotNull String blobString) {
        String oldValue = this.getBlobString(blobName);
        if (blobString.equals(oldValue)) {
            return false;
        }
        try {
            this.store.setBlobString(this.getTransaction(), this, blobName, blobString);
        }
        catch (Exception e) {
            throw ExodusException.toEntityStoreException((Throwable)e);
        }
        return true;
    }

    public boolean deleteBlob(@NotNull String blobName) {
        this.assertWritable();
        return this.store.deleteBlob(this.getTransaction(), this, blobName);
    }

    @NotNull
    public List<String> getBlobNames() {
        return this.store.getBlobNames(this.getTransaction(), this);
    }

    public boolean addLink(@NotNull String linkName, @NotNull Entity target) {
        this.assertWritable();
        PersistentStoreTransaction txn = this.getTransaction();
        int linkId = this.store.getLinkId(txn, linkName, true);
        return this.store.addLink(txn, this, (PersistentEntity)target, linkId);
    }

    @Nullable
    public Entity getLink(@NotNull String linkName) {
        PersistentStoreTransaction txn = this.getTransaction();
        int linkId = this.store.getLinkId(txn, linkName, false);
        return linkId < 0 ? null : this.store.getLink(txn, this, linkId);
    }

    public boolean setLink(@NotNull String linkName, @Nullable Entity target) {
        this.assertWritable();
        PersistentStoreTransaction txn = this.getTransaction();
        int linkId = this.store.getLinkId(txn, linkName, true);
        return this.store.setLink(txn, this, linkId, (PersistentEntity)target);
    }

    @NotNull
    public EntityIterable getLinks(@NotNull String linkName) {
        PersistentStoreTransaction txn = this.getTransaction();
        int linkId = this.store.getLinkId(txn, linkName, false);
        if (linkId < 0) {
            return EntityIterableBase.EMPTY;
        }
        return this.store.getLinks(txn, this, linkId);
    }

    @NotNull
    public EntityIterable getLinks(@NotNull Collection<String> linkNames) {
        IntHashMap linkIds = new IntHashMap(linkNames.size());
        PersistentStoreTransaction txn = this.getTransaction();
        for (String linkName : linkNames) {
            int linkId = this.store.getLinkId(txn, linkName, false);
            if (linkId < 0) continue;
            linkIds.put(linkId, (Object)StringInterner.intern((String)linkName));
        }
        return this.store.getLinks(txn, this, (IntHashMap<String>)linkIds);
    }

    public boolean deleteLink(@NotNull String linkName, @NotNull Entity target) {
        this.assertWritable();
        PersistentStoreTransaction txn = this.getTransaction();
        int linkId = this.store.getLinkId(txn, linkName, false);
        if (linkId < 0) {
            return false;
        }
        return this.store.deleteLinkInternal(txn, this, linkId, (PersistentEntity)target);
    }

    public void deleteLinks(@NotNull String linkName) {
        this.assertWritable();
        PersistentStoreTransaction txn = this.getTransaction();
        int linkId = this.store.getLinkId(txn, linkName, false);
        if (linkId < 0) {
            return;
        }
        this.store.deleteAllLinks(txn, this, linkId, this.store.getLinks(txn, this, linkId));
    }

    @NotNull
    public List<String> getLinkNames() {
        return this.store.getLinkNames(this.getTransaction(), this);
    }

    public int hashCode() {
        return this.store.hashCode() + this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PersistentEntity)) {
            return false;
        }
        PersistentEntity that = (PersistentEntity)obj;
        return this.id.equals(that.id) && this.store == that.store;
    }

    public int compareTo(@NotNull Entity o) {
        return this.id.compareTo(o.getId());
    }
}

