/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.backup.BackupStrategy;
import jetbrains.exodus.bindings.IntegerBinding;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.core.dataStructures.hash.LongHashMap;
import jetbrains.exodus.core.dataStructures.hash.LongIterator;
import jetbrains.exodus.core.dataStructures.hash.LongSet;
import jetbrains.exodus.core.dataStructures.hash.ObjectProcedureThrows;
import jetbrains.exodus.core.dataStructures.hash.PackedLongHashSet;
import jetbrains.exodus.entitystore.BlobHandleGenerator;
import jetbrains.exodus.entitystore.BlobVault;
import jetbrains.exodus.entitystore.BlobVaultItem;
import jetbrains.exodus.entitystore.EntityStoreException;
import jetbrains.exodus.entitystore.FileSystemBlobVaultOld;
import jetbrains.exodus.entitystore.PersistentEntityStoreConfig;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.StoreTransaction;
import jetbrains.exodus.entitystore.StoreTransactionalComputable;
import jetbrains.exodus.entitystore.tables.BlobsTable;
import jetbrains.exodus.env.Cursor;
import jetbrains.exodus.env.Environment;
import jetbrains.exodus.env.Store;
import jetbrains.exodus.env.Transaction;
import jetbrains.exodus.util.ByteArraySpinAllocator;
import jetbrains.exodus.util.IOUtil;
import jetbrains.exodus.vfs.ClusteringStrategy;
import jetbrains.exodus.vfs.VfsConfig;
import jetbrains.exodus.vfs.VfsException;
import jetbrains.exodus.vfs.VirtualFileSystem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VFSBlobVault
extends BlobVault {
    private static final VfsConfig BLOB_VAULT_VFS_CONFIG = new VfsConfig();
    @NotNull
    private final VirtualFileSystem fs;

    public VFSBlobVault(@NotNull PersistentEntityStoreConfig config, @NotNull Environment env) {
        this(config, new VirtualFileSystem(env, BLOB_VAULT_VFS_CONFIG));
    }

    public VFSBlobVault(@NotNull PersistentEntityStoreConfig config, @NotNull VirtualFileSystem fs) {
        super(config);
        this.fs = fs;
    }

    public long nextHandle(@NotNull Transaction txn) {
        return this.fs.createFile(txn, "blob.%d").getDescriptor();
    }

    public void setContent(long blobHandle, @NotNull InputStream content, @NotNull Transaction txn) throws Exception {
        try (OutputStream blobOutput = this.fs.writeFile(txn, blobHandle);){
            IOUtil.copyStreams((InputStream)content, (OutputStream)blobOutput, (ByteArraySpinAllocator)bufferAllocator);
        }
    }

    public void setContent(long blobHandle, @NotNull File file, @NotNull Transaction txn) throws Exception {
        try (OutputStream blobOutput = this.fs.writeFile(txn, blobHandle);){
            IOUtil.copyStreams((InputStream)new FileInputStream(file), (OutputStream)blobOutput, (ByteArraySpinAllocator)bufferAllocator);
        }
    }

    public String getBlobKey(long blobHandle) {
        return "blob." + blobHandle;
    }

    @NotNull
    public BlobVaultItem getBlob(long blobHandle) {
        throw new VfsException("Can't get blob without a transaction");
    }

    public boolean delete(long blobHandle) {
        throw new VfsException("Can't delete blob without a transaction");
    }

    @NotNull
    public InputStream getContent(long blobHandle, @NotNull Transaction txn) {
        return this.fs.readFile(txn, blobHandle);
    }

    public long getSize(long blobHandle, @NotNull Transaction txn) {
        return this.fs.getFileLength(txn, blobHandle);
    }

    public boolean delete(long blobHandle, @NotNull Transaction txn) {
        return this.fs.deleteFile(txn, "blob." + blobHandle) != null;
    }

    public boolean requiresTxn() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushBlobs(@Nullable LongHashMap<InputStream> blobStreams, @Nullable LongHashMap<File> blobFiles, @Nullable LongSet deferredBlobsToDelete, final @NotNull Transaction txn) throws Exception {
        if (blobStreams != null) {
            blobStreams.forEachEntry((ObjectProcedureThrows)new ObjectProcedureThrows<Map.Entry<Long, InputStream>, Exception>(){

                public boolean execute(Map.Entry<Long, InputStream> object) throws Exception {
                    InputStream stream = object.getValue();
                    stream.reset();
                    VFSBlobVault.this.setContent((long)object.getKey(), stream, txn);
                    return true;
                }
            });
        }
        if (blobFiles != null) {
            blobFiles.forEachEntry((ObjectProcedureThrows)new ObjectProcedureThrows<Map.Entry<Long, File>, Exception>(){

                public boolean execute(Map.Entry<Long, File> object) throws Exception {
                    VFSBlobVault.this.setContent((long)object.getKey(), object.getValue(), txn);
                    return true;
                }
            });
        }
        if (deferredBlobsToDelete != null) {
            try {
                LongIterator it = deferredBlobsToDelete.iterator();
                while (it.hasNext()) {
                    this.delete(it.nextLong(), txn);
                }
            }
            finally {
                txn.abort();
            }
        }
    }

    public long size() {
        return 0L;
    }

    public void clear() {
    }

    public void close() {
        this.fs.shutdown();
    }

    @NotNull
    public BackupStrategy getBackupStrategy() {
        return BackupStrategy.EMPTY;
    }

    public void refactorFromFS(final @NotNull PersistentEntityStoreImpl store) throws IOException {
        FileSystemBlobVaultOld sourceVault = new FileSystemBlobVaultOld(store.getConfig(), store.getLocation(), "blobs", ".blob", BlobHandleGenerator.IMMUTABLE);
        LongSet allBlobs = store.computeInReadonlyTransaction(new StoreTransactionalComputable<LongSet>(){

            public LongSet compute(@NotNull StoreTransaction txn) {
                return VFSBlobVault.loadAllBlobs(store, (PersistentStoreTransaction)txn);
            }
        });
        Environment env = this.fs.getEnvironment();
        Transaction txn = env.beginTransaction();
        try {
            int i = 0;
            LongIterator longIterator = allBlobs.iterator();
            while (longIterator.hasNext()) {
                InputStream content;
                long blobId = (Long)longIterator.next();
                if (i++ % 100 == 0) {
                    txn.flush();
                }
                if ((content = sourceVault.getContent(blobId, txn)) == null) continue;
                this.importBlob(txn, blobId, content);
            }
            txn.flush();
        }
        catch (IOException ioe) {
            throw new EntityStoreException((Throwable)ioe);
        }
        finally {
            txn.abort();
        }
    }

    private void importBlob(Transaction txn, long blobHandle, @NotNull InputStream content) throws IOException {
        if (txn == null) {
            throw new VfsException("Can't import blob without a transaction");
        }
        this.fs.createFile(txn, blobHandle, "blob." + blobHandle);
        try (OutputStream blobOutput = this.fs.writeFile(txn, blobHandle);){
            IOUtil.copyStreams((InputStream)content, (OutputStream)blobOutput, (ByteArraySpinAllocator)bufferAllocator);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private static LongSet loadAllBlobs(@NotNull PersistentEntityStoreImpl store, @NotNull PersistentStoreTransaction txn) {
        PackedLongHashSet result = new PackedLongHashSet();
        Transaction envTxn = txn.getEnvironmentTransaction();
        try (Cursor entityTypesCursor = store.getEntityTypesTable().getSecondIndexCursor(envTxn);){
            while (entityTypesCursor.getNext()) {
                Cursor blobsCursor;
                block23: {
                    int entityTypeId = IntegerBinding.compressedEntryToInt((ByteIterable)entityTypesCursor.getKey());
                    BlobsTable blobs = store.getBlobsTable(txn, entityTypeId);
                    Store primary = blobs.getPrimaryIndex();
                    blobsCursor = primary.openCursor(envTxn);
                    Throwable throwable = null;
                    try {
                        while (blobsCursor.getNext()) {
                            long blobId = LongBinding.compressedEntryToLong((ByteIterable)blobsCursor.getValue());
                            result.add(blobId);
                        }
                        if (blobsCursor == null) continue;
                        if (throwable == null) break block23;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (blobsCursor == null) throw throwable3;
                            if (throwable == null) {
                                blobsCursor.close();
                                throw throwable3;
                            }
                            try {
                                blobsCursor.close();
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                                throw throwable3;
                            }
                        }
                    }
                    try {
                        blobsCursor.close();
                        continue;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        continue;
                    }
                }
                blobsCursor.close();
            }
            PackedLongHashSet packedLongHashSet = result;
            return packedLongHashSet;
        }
    }

    static {
        BLOB_VAULT_VFS_CONFIG.setClusteringStrategy(ClusteringStrategy.EXPONENTIAL);
    }
}

