/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import jetbrains.exodus.core.dataStructures.hash.HashMap;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterable;
import jetbrains.exodus.entitystore.EntityIterableCache;
import jetbrains.exodus.entitystore.EntityIterableHandle;
import jetbrains.exodus.entitystore.EntityIterableType;
import jetbrains.exodus.entitystore.EntityIterator;
import jetbrains.exodus.entitystore.Explainer;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.iterate.CachedInstanceIterable;
import jetbrains.exodus.entitystore.iterate.ConstantEntityIterableHandle;
import jetbrains.exodus.entitystore.iterate.DistinctIterable;
import jetbrains.exodus.entitystore.iterate.EntityIdArrayCachedInstanceIterableFactory;
import jetbrains.exodus.entitystore.iterate.EntityIdSet;
import jetbrains.exodus.entitystore.iterate.EntityIdSetIterable;
import jetbrains.exodus.entitystore.iterate.EntityIterableDecoratorBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableHandleBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableInstantiator;
import jetbrains.exodus.entitystore.iterate.EntityIteratorBase;
import jetbrains.exodus.entitystore.iterate.EntityReverseIterable;
import jetbrains.exodus.entitystore.iterate.FilterLinksIterable;
import jetbrains.exodus.entitystore.iterate.SelectDistinctIterable;
import jetbrains.exodus.entitystore.iterate.SelectManyDistinctIterable;
import jetbrains.exodus.entitystore.iterate.SkipEntityIterable;
import jetbrains.exodus.entitystore.iterate.SortIndirectIterable;
import jetbrains.exodus.entitystore.iterate.SortIterable;
import jetbrains.exodus.entitystore.iterate.SortResultIterable;
import jetbrains.exodus.entitystore.iterate.TakeEntityIterable;
import jetbrains.exodus.entitystore.iterate.TxnGetterStrategy;
import jetbrains.exodus.entitystore.iterate.binop.ConcatenationIterable;
import jetbrains.exodus.entitystore.iterate.binop.IntersectionIterable;
import jetbrains.exodus.entitystore.iterate.binop.MinusIterable;
import jetbrains.exodus.entitystore.iterate.binop.UnionIterable;
import jetbrains.exodus.entitystore.util.EntityIdSetFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EntityIterableBase
implements EntityIterable {
    public static final EntityIterableBase EMPTY;
    public static final int NULL_TYPE_ID = Integer.MIN_VALUE;
    private static final Map<EntityIterableType, EntityIterableInstantiator> INSTANTIATORS;
    private static final String INDENT = "|   ";
    static final int[] fields;
    static final int[] children;
    @Nullable
    private final PersistentEntityStoreImpl store;
    private EntityIterableHandle cachedHandle;
    private Object origin;
    @NotNull
    protected TxnGetterStrategy txnGetter = TxnGetterStrategy.DEFAULT;

    protected EntityIterableBase(@Nullable PersistentStoreTransaction txn) {
        if (txn == null) {
            this.store = null;
        } else {
            this.store = txn.getStore();
            if (!txn.isCurrent()) {
                this.txnGetter = txn;
            }
        }
    }

    @NotNull
    public PersistentEntityStoreImpl getStore() {
        if (this.store == null) {
            throw new RuntimeException("EntityIterableBase: entity store is not set.");
        }
        return this.store;
    }

    public int getEntityTypeId() {
        return Integer.MIN_VALUE;
    }

    public EntityIterator iterator() {
        if (this.store == null) {
            return EntityIteratorBase.EMPTY;
        }
        PersistentStoreTransaction txn = this.getTransaction();
        return this.store.getEntityIterableCache().putIfNotCached(this).getIteratorImpl(txn);
    }

    @NotNull
    public abstract EntityIterator getIteratorImpl(@NotNull PersistentStoreTransaction var1);

    public EntityIterator getIteratorImpl() {
        return this.getIteratorImpl(this.getTransaction());
    }

    @NotNull
    public PersistentStoreTransaction getTransaction() {
        return this.txnGetter.getTxn(this);
    }

    public boolean isEmpty() {
        if (this.store == null) {
            return true;
        }
        PersistentStoreTransaction txn = this.getTransaction();
        EntityIterableBase it = this.store.getEntityIterableCache().putIfNotCached(this);
        return it.isEmptyImpl(txn);
    }

    public boolean nonCachedHasFastCountAndIsEmpty() {
        return false;
    }

    public long size() {
        if (this.store == null) {
            return 0L;
        }
        PersistentStoreTransaction txn = this.getTransaction();
        EntityIterableBase it = this.store.getEntityIterableCache().putIfNotCached(this);
        EntityIterableBase cached = it.nonCachedHasFastCountAndIsEmpty() ? it : this.getOrCreateCachedInstance(txn);
        return cached.countImpl(txn);
    }

    public long count() {
        if (this.store == null) {
            return 0L;
        }
        EntityIterableBase it = this.store.getEntityIterableCache().putIfNotCached(this);
        return it.isCachedInstance() ? it.countImpl(this.getTransaction()) : -1L;
    }

    public long getRoughCount() {
        if (this.store == null) {
            return 0L;
        }
        return this.store.getEntityIterableCache().getCachedCount(this);
    }

    public long getRoughSize() {
        if (this.store == null) {
            return 0L;
        }
        EntityIterableCache cache = this.store.getEntityIterableCache();
        long result = cache.getCachedCount(this);
        if (result < 0L) {
            result = this.size();
            cache.setCachedCount(this.getHandle(), result);
        }
        return result;
    }

    public int indexOf(@NotNull Entity entity) {
        if (this.store == null) {
            return -1;
        }
        EntityId entityId = entity.getId();
        EntityIterableBase it = this.store.getEntityIterableCache().putIfNotCached(this);
        EntityIterableBase cached = it.isCachedInstance() ? it : this.getOrCreateCachedInstance(this.getTransaction());
        return cached.indexOfImpl(entityId);
    }

    public boolean contains(@NotNull Entity entity) {
        if (this.store == null) {
            return false;
        }
        EntityId entityId = entity.getId();
        EntityIterableBase it = this.store.getEntityIterableCache().putIfNotCached(this);
        EntityIterableBase cached = it.isCachedInstance() ? it : this.getOrCreateCachedInstance(this.getTransaction());
        return cached.containsImpl(entityId);
    }

    @NotNull
    public final EntityIterableHandle getHandle() {
        if (this.cachedHandle == null) {
            this.cachedHandle = this.getHandleImpl();
        }
        return this.cachedHandle;
    }

    @NotNull
    protected abstract EntityIterableHandle getHandleImpl();

    public Object getOrigin() {
        return this.origin;
    }

    public boolean setOrigin(Object origin) {
        if (this.getStore().getExplainer().isExplainOn() && this.origin == null) {
            this.origin = origin;
            return true;
        }
        return false;
    }

    @NotNull
    public EntityIterable intersect(@NotNull EntityIterable right) {
        if (this == EMPTY || right == EMPTY) {
            return EMPTY;
        }
        return new IntersectionIterable(this.getTransaction(), this, (EntityIterableBase)right);
    }

    @NotNull
    public EntityIterable intersectSavingOrder(@NotNull EntityIterable right) {
        if (this == EMPTY || right == EMPTY) {
            return EMPTY;
        }
        return new IntersectionIterable(this.getTransaction(), this, (EntityIterableBase)right, true);
    }

    @NotNull
    public EntityIterable union(@NotNull EntityIterable right) {
        if (this == EMPTY) {
            return right;
        }
        if (right == EMPTY) {
            return this;
        }
        return new UnionIterable(this.getTransaction(), this, (EntityIterableBase)right);
    }

    @NotNull
    public EntityIterable minus(@NotNull EntityIterable right) {
        if (this == EMPTY) {
            return EMPTY;
        }
        if (right == EMPTY) {
            return this;
        }
        return new MinusIterable(this.getTransaction(), this, (EntityIterableBase)right);
    }

    @NotNull
    public EntityIterable concat(@NotNull EntityIterable right) {
        if (this == EMPTY) {
            return right;
        }
        if (right == EMPTY) {
            return this;
        }
        PersistentStoreTransaction txn = this.getTransaction();
        if (this instanceof ConcatenationIterable) {
            ConcatenationIterable thisConcat = (ConcatenationIterable)this;
            return new ConcatenationIterable(txn, thisConcat.getLeft(), new ConcatenationIterable(txn, thisConcat.getRight(), (EntityIterableBase)right));
        }
        return new ConcatenationIterable(txn, this, (EntityIterableBase)right);
    }

    @NotNull
    public final EntityIterableBase skip(int number) {
        if (number <= 0 || this.store == null) {
            return this;
        }
        return new SkipEntityIterable(this.getTransaction(), this, number);
    }

    @NotNull
    public EntityIterable take(int number) {
        if (number <= 0 || this.store == null) {
            return EMPTY;
        }
        return new TakeEntityIterable(this.getTransaction(), this, number);
    }

    @NotNull
    public EntityIterable distinct() {
        if (this.store == null) {
            return EMPTY;
        }
        return new DistinctIterable(this.getTransaction(), this);
    }

    @NotNull
    public EntityIterable selectDistinct(@NotNull String linkName) {
        if (EntityIterableBase.isDecoratorForSelectDistinct(this)) {
            EntityIterableDecoratorBase decorator = (EntityIterableDecoratorBase)this;
            return decorator.getDecorated().selectDistinct(linkName);
        }
        if (this.store == null) {
            return EMPTY;
        }
        PersistentStoreTransaction txn = this.getTransaction();
        return new SelectDistinctIterable(txn, this, this.store.getLinkId(txn, linkName, false));
    }

    @NotNull
    public EntityIterable selectManyDistinct(@NotNull String linkName) {
        if (EntityIterableBase.isDecoratorForSelectDistinct(this)) {
            EntityIterableDecoratorBase decorator = (EntityIterableDecoratorBase)this;
            return decorator.getDecorated().selectManyDistinct(linkName);
        }
        if (this.store == null) {
            return EMPTY;
        }
        PersistentStoreTransaction txn = this.getTransaction();
        return new SelectManyDistinctIterable(txn, this, this.store.getLinkId(txn, linkName, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Entity getFirst() {
        EntityIterator it = this.iterator();
        if (it.hasNext()) {
            try {
                EntityId id = it.nextId();
                if (id != null) {
                    Entity entity = this.getEntity(id);
                    return entity;
                }
            }
            finally {
                if (it instanceof EntityIteratorBase) {
                    ((EntityIteratorBase)it).disposeIfShouldBe();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Entity getLast() {
        EntityIteratorBase it = (EntityIteratorBase)this.iterator();
        try {
            EntityId id = it.getLast();
            Entity entity = id == null ? null : this.getEntity(id);
            return entity;
        }
        finally {
            it.disposeIfShouldBe();
        }
    }

    @NotNull
    public EntityIterable reverse() {
        if (this.store == null) {
            return EMPTY;
        }
        return new EntityReverseIterable(this.getTransaction(), this);
    }

    public boolean isSortResult() {
        return this == EMPTY || this instanceof SortResultIterable;
    }

    @NotNull
    public EntityIterable asSortResult() {
        return this.store == null ? this : new SortResultIterable(this.getTransaction(), this);
    }

    @NotNull
    public EntityIterableBase getSource() {
        return this;
    }

    public boolean isSortedById() {
        return true;
    }

    public boolean canBeReordered() {
        return false;
    }

    public int depth() {
        return 1;
    }

    public boolean canBeCached() {
        return this.isThreadSafe();
    }

    public boolean isThreadSafe() {
        return this.txnGetter == TxnGetterStrategy.DEFAULT;
    }

    public boolean isCachedInstance() {
        return false;
    }

    public boolean isCached() {
        return this.canBeCached() && this.getTransaction().getCachedInstanceFast(this) != null;
    }

    @NotNull
    public final Entity getEntity(@NotNull EntityId id) {
        return this.getStore().getEntity(id);
    }

    public EntityIterable findLinks(@NotNull Iterable<Entity> entities, @NotNull String linkName) {
        if (entities instanceof EntityIterable) {
            return this.findLinks((EntityIterable)entities, linkName);
        }
        if (this.store == null) {
            return EMPTY;
        }
        EntityIdSetIterable idSetIterable = new EntityIdSetIterable(this.getTransaction());
        for (Entity entity : entities) {
            idSetIterable.addTarget(entity.getId());
        }
        return this.findLinks(idSetIterable, linkName);
    }

    public EntityIterable findLinks(@NotNull EntityIterable entities, @NotNull String linkName) {
        if (this.store == null || ((EntityIterableBase)entities).store == null) {
            return EMPTY;
        }
        PersistentStoreTransaction txn = this.getTransaction();
        int linkId = this.store.getLinkId(txn, linkName, false);
        if (linkId < 0) {
            return EMPTY;
        }
        return new FilterLinksIterable(txn, linkId, this, entities);
    }

    @NotNull
    public final CachedInstanceIterable getOrCreateCachedInstance(@NotNull PersistentStoreTransaction txn) {
        return this.getOrCreateCachedInstance(txn, false);
    }

    @NotNull
    public final CachedInstanceIterable getOrCreateCachedInstance(@NotNull PersistentStoreTransaction txn, boolean forceCount) {
        if (this.store == null) {
            throw new NullPointerException("Can't create cached instance for EMPTY iterable");
        }
        EntityIterableCache cache = this.store.getEntityIterableCache();
        boolean canBeCached = !cache.isCachingDisabled && this.canBeCached();
        CachedInstanceIterable cached = null;
        if (canBeCached) {
            cached = txn.getCachedInstance(this);
        }
        if (cached == null || cached.getHandle().isExpired()) {
            cached = this.createCachedInstance(txn);
            if (this.canBeReordered() && !this.store.getConfig().isReorderingDisabled() && !cached.isSortedById()) {
                cached = cached.orderById();
            }
            if (canBeCached) {
                txn.addCachedInstance(cached);
            } else {
                cache.setCachedCount(this.getHandle(), cached.size());
            }
        } else if (forceCount) {
            cache.setCachedCount(this.getHandle(), cached.size());
        }
        return cached;
    }

    @NotNull
    public EntityIdSet toSet(@NotNull PersistentStoreTransaction txn) {
        return this.getOrCreateCachedInstance(txn).toSet(txn);
    }

    @NotNull
    public EntityIterator getReverseIteratorImpl(@NotNull PersistentStoreTransaction txn) {
        throw new UnsupportedOperationException("getReverseIterator not implemented");
    }

    protected long countImpl(@NotNull PersistentStoreTransaction txn) {
        EntityIterator it = this.getIteratorImpl(txn);
        long result = 0L;
        while (it.hasNext()) {
            ++result;
            it.nextId();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmptyImpl(@NotNull PersistentStoreTransaction txn) {
        EntityIteratorBase it = (EntityIteratorBase)this.getIteratorImpl();
        try {
            boolean bl = !it.hasNext();
            return bl;
        }
        finally {
            it.disposeIfShouldBe();
        }
    }

    protected boolean isEmptyFast(@NotNull PersistentStoreTransaction txn) {
        CachedInstanceIterable cached = txn.getCachedInstanceFast(this);
        return cached != null && cached.isEmpty();
    }

    protected int indexOfImpl(@NotNull EntityId entityId) {
        int result = 0;
        EntityIteratorBase it = (EntityIteratorBase)this.getIteratorImpl();
        while (it.hasNext()) {
            EntityId nextId = it.nextId();
            if (nextId != null && nextId.equals(entityId)) {
                it.disposeIfShouldBe();
                return result;
            }
            ++result;
        }
        return -1;
    }

    protected boolean containsImpl(@NotNull EntityId entityId) {
        return this.indexOfImpl(entityId) >= 0;
    }

    protected CachedInstanceIterable createCachedInstance(@NotNull PersistentStoreTransaction txn) {
        return EntityIdArrayCachedInstanceIterableFactory.createInstance(txn, this);
    }

    public static String getHumanReadablePresentation(@NotNull EntityIterableHandle handle) {
        return EntityIterableBase.getHumanReadablePresentation(handle.toString());
    }

    public static String getHumanReadablePresentation(@NotNull String handle) {
        try {
            String[] types = handle.split("-");
            int minus = 0;
            for (int i = 0; i < types.length; ++i) {
                if (types[i].isEmpty()) {
                    ++minus;
                    types[i + 1] = '-' + types[i + 1];
                    continue;
                }
                types[i - minus] = types[i];
            }
            types = Arrays.copyOf(types, types.length - minus);
            int[] pos = new int[]{0};
            StringBuilder presentation = new StringBuilder();
            EntityIterableBase.getHumanReadablePresentation(presentation, types, pos, "");
            if (pos[0] < types.length - 1) {
                throw new RuntimeException("Whole handle not read.\n" + presentation);
            }
            return presentation.toString();
        }
        catch (Exception exception) {
            return handle;
        }
    }

    private static void getHumanReadablePresentation(StringBuilder presentation, String[] types, int[] pos, String indent) {
        int i;
        int count;
        int type = Integer.valueOf(types[pos[0]]);
        pos[0] = pos[0] + 1;
        if (type < 0 || type >= children.length) {
            throw new RuntimeException("New EntityIterable added: " + type);
        }
        presentation.append(indent).append(EntityIterableType.values()[type].getDescription());
        for (int i2 = 0; i2 < fields[type]; ++i2) {
            presentation.append(' ').append(types[pos[0]]);
            if (type == EntityIterableType.SINGLE_ENTITY.getType() && "null".equals(types[pos[0]])) break;
            pos[0] = pos[0] + 1;
        }
        StringBuilder tmp = new StringBuilder();
        for (int i3 = 0; i3 < children[type]; ++i3) {
            tmp.append('\n');
            EntityIterableBase.getHumanReadablePresentation(tmp, types, pos, indent + INDENT);
        }
        if (type == EntityIterableType.SELECT_DISTINCT.getType() || type == EntityIterableType.SELECTMANY_DISTINCT.getType() || type == EntityIterableType.SORTING.getType()) {
            presentation.append(' ').append(types[pos[0]]);
            pos[0] = pos[0] + 1;
        }
        presentation.append((CharSequence)tmp);
        if (type == EntityIterableType.MERGE_SORTED.getType()) {
            count = Integer.valueOf(types[pos[0]]);
            presentation.append(' ').append(count);
            pos[0] = pos[0] + 1;
            for (i = 0; i < count; ++i) {
                pos[0] = pos[0] + 1;
                presentation.append('\n');
                EntityIterableBase.getHumanReadablePresentation(presentation, types, pos, indent + INDENT);
            }
        }
        if (type == EntityIterableType.ENTITY_FROM_LINKS_SET.getType()) {
            count = Integer.valueOf(types[pos[0]]);
            presentation.append("  ").append(count).append(" links:");
            pos[0] = pos[0] + 1;
            for (i = 0; i < count; ++i) {
                presentation.append(' ').append(types[pos[0]]);
                pos[0] = pos[0] + 1;
            }
        }
    }

    protected static void registerType(EntityIterableType type, EntityIterableInstantiator instantiator) {
        INSTANTIATORS.put(type, instantiator);
    }

    private static boolean isDecoratorForSelectDistinct(@NotNull EntityIterable source) {
        return source instanceof SortIterable || source instanceof SortIndirectIterable || source instanceof EntityReverseIterable || source instanceof DistinctIterable || source instanceof SortResultIterable;
    }

    public static EntityIterableBase instantiate(PersistentStoreTransaction txn, PersistentEntityStoreImpl store, String presentation) {
        return EntityIterableBase.instantiate(txn, store, presentation.split("\n"), 0);
    }

    private static EntityIterableBase instantiate(PersistentStoreTransaction txn, PersistentEntityStoreImpl store, String[] presentation, int line) {
        int i;
        Integer[] childrenLines = EntityIterableBase.getChildren(presentation, line);
        String s = presentation[line].substring(EntityIterableBase.getIndent(presentation[line]));
        EntityIterableType type = EntityIterableBase.getTypeByDescription(s);
        s = s.substring(type.getDescription().length());
        String[] parameters = EntityIterableBase.getParameters(s);
        Object[] constructorParameters = new Object[parameters.length + childrenLines.length];
        for (i = 0; i < parameters.length; ++i) {
            constructorParameters[i] = parameters[i];
        }
        for (i = 0; i < childrenLines.length; ++i) {
            constructorParameters[i + parameters.length] = EntityIterableBase.instantiate(txn, store, presentation, childrenLines[i]);
        }
        return INSTANTIATORS.get((Object)type).instantiate(txn, store, constructorParameters);
    }

    private static String[] getParameters(String s) {
        String[] result = s.trim().split(" ");
        int empty = 0;
        for (int i = 0; i < result.length; ++i) {
            if (result[i].isEmpty()) {
                ++empty;
                continue;
            }
            result[i - empty] = result[i];
        }
        return Arrays.copyOf(result, result.length - empty);
    }

    private static EntityIterableType getTypeByDescription(String s) {
        EntityIterableType result = null;
        int length = 0;
        for (EntityIterableType type : EntityIterableType.values()) {
            String description = type.getDescription();
            if (!s.startsWith(description) || description.length() <= length) continue;
            length = description.length();
            result = type;
        }
        return result;
    }

    private static Integer[] getChildren(String[] presentation, int line) {
        int indent = EntityIterableBase.getIndent(presentation[line]);
        int childIndent = indent + INDENT.length();
        ArrayList<Integer> result = new ArrayList<Integer>();
        while (++line < presentation.length) {
            int lineIndent = EntityIterableBase.getIndent(presentation[line]);
            if (lineIndent == childIndent) {
                result.add(line);
                continue;
            }
            if (lineIndent >= childIndent) continue;
            break;
        }
        return result.toArray(new Integer[result.size()]);
    }

    private static int getIndent(String s) {
        int indent = 0;
        while (s.substring(indent).startsWith(INDENT)) {
            indent += INDENT.length();
        }
        return indent;
    }

    public void explain(EntityIterableType type) {
        if (this.getOrigin() != null) {
            Explainer explainer = this.getStore().getExplainer();
            explainer.explain(this.getOrigin(), "cursor advances");
            explainer.explain(this.getOrigin(), "#cursor advances by type " + type.name());
            explainer.explain(this.getOrigin(), "#cursor advances by handle " + this.getHandle().toString());
        }
    }

    static {
        INSTANTIATORS = new HashMap();
        EMPTY = new EntityIterableBase(null){

            @Override
            @NotNull
            public EntityIteratorBase getIteratorImpl(@NotNull PersistentStoreTransaction txn) {
                return EntityIteratorBase.EMPTY;
            }

            @Override
            public boolean setOrigin(Object origin) {
                return true;
            }

            @Override
            @NotNull
            protected EntityIterableHandle getHandleImpl() {
                return new ConstantEntityIterableHandle(null, EntityIterableType.EMPTY){

                    @Override
                    public void hashCode(@NotNull EntityIterableHandleBase.EntityIterableHandleHash hash) {
                    }
                };
            }

            @Override
            @NotNull
            public EntityIdSet toSet(@NotNull PersistentStoreTransaction txn) {
                return EntityIdSetFactory.newSet();
            }

            @Override
            public int indexOf(@NotNull Entity entity) {
                return -1;
            }

            @Override
            protected long countImpl(@NotNull PersistentStoreTransaction txn) {
                return 0L;
            }

            @Override
            public boolean canBeCached() {
                return false;
            }
        };
        EntityIterableBase.registerType(EntityIterableType.EMPTY, new EntityIterableInstantiator(){

            @Override
            public EntityIterableBase instantiate(PersistentStoreTransaction txn, PersistentEntityStoreImpl store, Object[] parameters) {
                return EMPTY;
            }
        });
        fields = new int[]{0, 1, 2, 3, 4, 2, 2, 2, 3, 4, 2, 0, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, 1, 1, 2, 2, 0, 0, 1, 1, 2, 3};
        children = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 1, 1, 2, 0, 1, 1, 1, 1, 1, 0, 0, 2, 1, 1, 2, 0, 0};
    }
}

