/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.util;

import java.util.Iterator;
import jetbrains.exodus.core.dataStructures.hash.LongHashSet;
import jetbrains.exodus.core.dataStructures.hash.LongIterator;
import jetbrains.exodus.core.dataStructures.hash.LongSet;
import jetbrains.exodus.core.dataStructures.hash.PackedLongHashSet;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.PersistentEntityId;
import jetbrains.exodus.entitystore.iterate.EntityIdSet;
import jetbrains.exodus.entitystore.util.MultiTypeEntityIdSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SingleTypeEntityIdSet
implements EntityIdSet {
    private final int singleTypeId;
    @NotNull
    private final LongSet singleTypeLocalIds = new PackedLongHashSet();
    private boolean holdsNull;

    SingleTypeEntityIdSet(@Nullable EntityId id) {
        this.holdsNull = id == null;
        if (this.holdsNull) {
            this.singleTypeId = -1;
        } else {
            this.singleTypeId = id.getTypeId();
            this.singleTypeLocalIds.add(id.getLocalId());
        }
    }

    SingleTypeEntityIdSet(int singleTypeId, long localId) {
        this.singleTypeId = singleTypeId;
        this.holdsNull = false;
        this.singleTypeLocalIds.add(localId);
    }

    public EntityIdSet add(@Nullable EntityId id) {
        if (id == null) {
            this.holdsNull = true;
            return this;
        }
        int typeId = id.getTypeId();
        long localId = id.getLocalId();
        return this.add(typeId, localId);
    }

    public EntityIdSet add(int typeId, long localId) {
        if (typeId == this.singleTypeId) {
            this.singleTypeLocalIds.add(localId);
            return this;
        }
        PackedLongHashSet moreLocalIds = new PackedLongHashSet();
        moreLocalIds.add(localId);
        return new MultiTypeEntityIdSet(typeId, (LongSet)moreLocalIds, this.singleTypeId, this.singleTypeLocalIds, this.holdsNull);
    }

    public boolean contains(@Nullable EntityId id) {
        if (id == null) {
            return this.holdsNull;
        }
        return this.contains(id.getTypeId(), id.getLocalId());
    }

    public boolean contains(int typeId, long localId) {
        return this.singleTypeId == typeId && this.singleTypeLocalIds.contains(localId);
    }

    public boolean remove(@Nullable EntityId id) {
        if (id == null) {
            boolean result = this.holdsNull;
            this.holdsNull = false;
            return result;
        }
        return this.remove(id.getTypeId(), id.getLocalId());
    }

    public boolean remove(int typeId, long localId) {
        return this.singleTypeId == typeId && this.singleTypeLocalIds.remove(localId);
    }

    public int count() {
        return this.singleTypeLocalIds.size();
    }

    @NotNull
    public LongSet getTypeSetSnapshot(int typeId) {
        if (typeId == this.singleTypeId) {
            return new LongHashSet(this.singleTypeLocalIds);
        }
        return LongSet.EMPTY;
    }

    public boolean isEmpty() {
        return !this.holdsNull && this.singleTypeLocalIds.isEmpty();
    }

    public Iterator<EntityId> iterator() {
        return new Iterator<EntityId>(){
            @NotNull
            private final LongIterator it;
            private boolean hasNull;
            {
                this.it = SingleTypeEntityIdSet.this.singleTypeLocalIds.iterator();
                this.hasNull = SingleTypeEntityIdSet.this.holdsNull;
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext() || this.hasNull;
            }

            @Override
            public EntityId next() {
                if (!this.it.hasNext()) {
                    if (!this.hasNull) {
                        throw new IllegalStateException();
                    }
                    this.hasNull = false;
                    return null;
                }
                return new PersistentEntityId(SingleTypeEntityIdSet.this.singleTypeId, (Long)this.it.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

