/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.hub2hub.rest;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.GET;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.exodus.database.exceptions.ConstraintsValidationException;
import jetbrains.exodus.database.exceptions.DataIntegrityViolationException;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.StoreTransaction;
import jetbrains.exodus.env.Environment;
import jetbrains.exodus.env.HubEnvironment;
import jetbrains.exodus.env.Transaction;
import jetbrains.exodus.query.NodeBase;
import jetbrains.jetpass.dao.dnq.api.DataAccessExceptionUtilKt;
import jetbrains.jetpass.dao.dnq.api.JetPassDAOContainer;
import jetbrains.jetpass.dao.dnq.api.security.CreateGlobalSecurity;
import jetbrains.jetpass.dao.dnq.api.security.Security;
import jetbrains.jetpass.dnq.TransactionKt;
import jetbrains.jetpass.hub2hub.ResolutionType;
import jetbrains.jetpass.hub2hub.dnq.Info;
import jetbrains.jetpass.hub2hub.dnq.MigrationException;
import jetbrains.jetpass.hub2hub.dnq.XdConflictReport;
import jetbrains.jetpass.hub2hub.dnq.XdConflictResolution;
import jetbrains.jetpass.hub2hub.dnq.XdEntityConflict;
import jetbrains.jetpass.hub2hub.dnq.XdHubMigration;
import jetbrains.jetpass.hub2hub.dnq.stateMachine.HubMigrationSM;
import jetbrains.jetpass.hub2hub.dnq.stateMachine.StateMachineUtils;
import jetbrains.jetpass.hub2hub.dto.CountersJSON;
import jetbrains.jetpass.hub2hub.dto.ImportJSON;
import jetbrains.jetpass.hub2hub.dto.ResolutionJSON;
import jetbrains.jetpass.hub2hub.rest.ConflictsSequence;
import jetbrains.jetpass.hub2hub.rest.ImportSerializers;
import jetbrains.jetpass.hub2hub.rest.ImportsResource;
import jetbrains.jetpass.hub2hub.rest.ImportsResource$ImportSubresource$ImportLinkSubresource$findConflict$1;
import jetbrains.jetpass.oauth2.rest.security.OAuth;
import jetbrains.jetpass.oauth2.rest.security.OAuthResourceFilter;
import jetbrains.jetpass.oauth2.rest.security.SecurityContext;
import jetbrains.jetpass.rest.api.resource.DynamicServerPage;
import jetbrains.jetpass.rest.api.resource.DynamicServerPageKt;
import jetbrains.jetpass.rest.api.resource.ResourceUtilKt;
import jetbrains.jetpass.rest.api.serialization.impl.SerializationExtKt;
import jetbrains.jetpass.rest.common.ConflictException;
import jetbrains.jetpass.rest.common.Transactional;
import jetbrains.jetpass.sequence.Sequence;
import jetbrains.jetpass.sequence.impl.IterableSequence;
import jetbrains.jetpass.service.api.JetPassMainApp;
import jetbrains.jetpass.spring.SpringUtils;
import jetbrains.jetpass.userManagement.persistence.dnq.XdSettings;
import jetbrains.mps.webr.rpc.rest.json.runtime.fieldQuery.FieldQuery;
import jetbrains.mps.webr.rpc.rest.json.runtime.fieldQuery.RequestFieldQuery;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KClass;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.reflect.KProperty1;
import kotlin.sequences.SequencesKt;
import kotlinx.dnq.XdEntityType;
import kotlinx.dnq.query.NodeBaseOperationsKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import kotlinx.dnq.util.ReflectionUtilKt;
import mu.KLogging;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@javax.ws.rs.Path(value="/imports")
@OAuth
@Transactional
@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 (2\u00020\u0001:\u0002()B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0018\u001a\u00060\u0019R\u00020\u00002\b\b\u0001\u0010\u001a\u001a\u00020\u001bH\u0007J2\u0010\u001c\u001a\u00020\u001d2\b\b\u0001\u0010\u001e\u001a\u00020\u001f2\n\b\u0001\u0010 \u001a\u0004\u0018\u00010\u001b2\n\b\u0001\u0010!\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\"\u001a\u00020#H\u0007J\u001c\u0010$\u001a\u00020%2\b\b\u0001\u0010\u001e\u001a\u00020\u001f2\b\b\u0001\u0010&\u001a\u00020'H\u0007R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\b\u001a\u0004\b\u000b\u0010\fR\u001b\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\b\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006*"}, d2={"Ljetbrains/jetpass/hub2hub/rest/ImportsResource;", "", "()V", "daoContainer", "Ljetbrains/jetpass/dao/dnq/api/JetPassDAOContainer;", "getDaoContainer", "()Ljetbrains/jetpass/dao/dnq/api/JetPassDAOContainer;", "daoContainer$delegate", "Lkotlin/properties/ReadOnlyProperty;", "jetPass", "Ljetbrains/jetpass/service/api/JetPassMainApp;", "getJetPass", "()Ljetbrains/jetpass/service/api/JetPassMainApp;", "jetPass$delegate", "persistentDataEnvironment", "Ljetbrains/exodus/env/Environment;", "getPersistentDataEnvironment", "()Ljetbrains/exodus/env/Environment;", "persistentDataEnvironment$delegate", "security", "Ljetbrains/jetpass/dao/dnq/api/security/CreateGlobalSecurity;", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdSettings;", "getSecurity", "()Ljetbrains/jetpass/dao/dnq/api/security/CreateGlobalSecurity;", "byID", "Ljetbrains/jetpass/hub2hub/rest/ImportsResource$ImportSubresource;", "id", "", "create", "Ljetbrains/jetpass/hub2hub/dto/ImportJSON;", "request", "Ljavax/servlet/http/HttpServletRequest;", "remoteUrl", "adminConsoleUrl", "requestBody", "Ljava/io/InputStream;", "getAll", "Ljavax/ws/rs/core/Response;", "info", "Ljavax/ws/rs/core/UriInfo;", "Companion", "ImportSubresource", "jetbrains.jetpass.hub2hub.rest"})
public final class ImportsResource {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final ReadOnlyProperty daoContainer$delegate;
    private final ReadOnlyProperty jetPass$delegate;
    private final ReadOnlyProperty persistentDataEnvironment$delegate;
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(ImportsResource.class), "daoContainer", "getDaoContainer()Ljetbrains/jetpass/dao/dnq/api/JetPassDAOContainer;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(ImportsResource.class), "jetPass", "getJetPass()Ljetbrains/jetpass/service/api/JetPassMainApp;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(ImportsResource.class), "persistentDataEnvironment", "getPersistentDataEnvironment()Ljetbrains/exodus/env/Environment;"))};
        Companion = new Companion(null);
    }

    private final JetPassDAOContainer getDaoContainer() {
        return (JetPassDAOContainer)this.daoContainer$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    private final JetPassMainApp getJetPass() {
        return (JetPassMainApp)this.jetPass$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    private final Environment getPersistentDataEnvironment() {
        return (Environment)this.persistentDataEnvironment$delegate.getValue((Object)this, $$delegatedProperties[2]);
    }

    private final CreateGlobalSecurity<XdSettings> getSecurity() {
        return this.getDaoContainer().getJetPassSettingsDAO().getSecurity();
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @NotNull
    public final Response getAll(@Context @NotNull HttpServletRequest request, @Context @NotNull UriInfo info) {
        IterableSequence iterableSequence;
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
        if (!Security.DefaultImpls.canRead$default(this.getSecurity(), null, (boolean)false, (int)2, null)) {
            throw (Throwable)new ForbiddenException("Read import status is forbidden");
        }
        try {
            iterableSequence = new IterableSequence(SequencesKt.asIterable((kotlin.sequences.Sequence)XdQueryKt.asSequence((XdQuery)XdHubMigration.Companion.all())));
        }
        catch (Exception e) {
            throw (Throwable)new InternalServerErrorException("Can't get import", (Throwable)e);
        }
        IterableSequence all = iterableSequence;
        RequestFieldQuery fieldQuery = new RequestFieldQuery(request, 0, null, 6, null);
        URI resourceURI = info.getAbsolutePath();
        Sequence sequence = (Sequence)all;
        URI uRI = resourceURI;
        Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"resourceURI");
        Response response = Response.ok((Object)DynamicServerPageKt.asJSONPage((Sequence)sequence, (String)"imports", (URI)uRI, (FieldQuery)((FieldQuery)fieldQuery), (DynamicServerPage.CalculatedField[])new DynamicServerPage.CalculatedField[0])).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"Response.ok(all.asJSONPa\u2026URI, fieldQuery)).build()");
        return response;
    }

    @POST
    @Produces(value={"application/json;charset=UTF-8"})
    @NotNull
    public final ImportJSON create(@Context @NotNull HttpServletRequest request, @QueryParam(value="remoteUrl") @Nullable String remoteUrl, @QueryParam(value="adminConsoleUrl") @Nullable String adminConsoleUrl, @NotNull InputStream requestBody) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)requestBody, (String)"requestBody");
        if (!this.getSecurity().canCreate()) {
            throw (Throwable)new ForbiddenException("Import start is forbidden");
        }
        XdHubMigration migration2 = (XdHubMigration)TransactionKt.legacyTransactional$default((boolean)false, null, (boolean)false, (Function1)((Function1)new Function1<TransientStoreSession, XdHubMigration>(this, remoteUrl, adminConsoleUrl){
            final /* synthetic */ ImportsResource this$0;
            final /* synthetic */ String $remoteUrl;
            final /* synthetic */ String $adminConsoleUrl;

            @NotNull
            public final XdHubMigration invoke(@NotNull TransientStoreSession txn) {
                XdHubMigration xdHubMigration;
                Intrinsics.checkParameterIsNotNull((Object)txn, (String)"txn");
                StoreTransaction storeTransaction = DnqUtils.getCurrentPersistentSession();
                if (storeTransaction == null) {
                    throw new TypeCastException("null cannot be cast to non-null type jetbrains.exodus.entitystore.PersistentStoreTransaction");
                }
                Transaction transaction = ((PersistentStoreTransaction)storeTransaction).getEnvironmentTransaction();
                Intrinsics.checkExpressionValueIsNotNull((Object)transaction, (String)"(DnqUtils.getCurrentPers\u2026  .environmentTransaction");
                long highAddress = transaction.getHighAddress();
                try {
                    XdHubMigration migration2 = (XdHubMigration)TransactionKt.legacyTransactional$default((boolean)false, null, (boolean)true, (Function1)((Function1)new Function1<TransientStoreSession, XdHubMigration>(this){
                        final /* synthetic */ create.migration.1 this$0;

                        @NotNull
                        public final XdHubMigration invoke(@NotNull TransientStoreSession it) {
                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                            return XdHubMigration.Companion.create(this.this$0.$remoteUrl, this.this$0.$adminConsoleUrl);
                        }
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }
                    }), (int)3, null);
                    txn.flush();
                    HubEnvironment.Companion.setHighAddress(ImportsResource.access$getPersistentDataEnvironment$p(this.this$0), highAddress);
                    xdHubMigration = migration2;
                }
                catch (ConstraintsValidationException ex) {
                    DataIntegrityViolationException cause = (DataIntegrityViolationException)CollectionsKt.first((Iterable)ex.getCauses());
                    String string = cause.getMessage();
                    if (string == null) {
                        string = "";
                    }
                    throw (Throwable)new ConflictException(string, null, null, (Throwable)cause);
                }
                catch (MigrationException ex) {
                    String string = ex.getMessage();
                    if (string == null) {
                        string = "";
                    }
                    throw (Throwable)new ConflictException(string, ex.getCode(), null, (Throwable)ex);
                }
                return xdHubMigration;
            }
            {
                this.this$0 = importsResource;
                this.$remoteUrl = string;
                this.$adminConsoleUrl = string2;
                super(1);
            }
        }), (int)7, null);
        try {
            Path path = Files.createTempFile("hub-database", ".tar.gz", new FileAttribute[0]);
            OutputStream os = Files.newOutputStream(path, new OpenOption[0]);
            IOUtils.copy((InputStream)requestBody, (OutputStream)os);
            os.close();
            return (ImportJSON)TransactionKt.legacyTransactional$default((boolean)false, null, (boolean)true, (Function1)((Function1)new Function1<TransientStoreSession, ImportJSON>(migration2, path, request){
                final /* synthetic */ XdHubMigration $migration;
                final /* synthetic */ Path $path;
                final /* synthetic */ HttpServletRequest $request;

                @NotNull
                public final ImportJSON invoke(@NotNull TransientStoreSession it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    HubMigrationSM hubMigrationSM = StateMachineUtils.getStateMachine((XdHubMigration)this.$migration);
                    Path path = this.$path;
                    Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"path");
                    hubMigrationSM.archiveUploaded(path);
                    return (ImportJSON)SerializationExtKt.asJSON((Object)this.$migration, (FieldQuery)((FieldQuery)new RequestFieldQuery(this.$request, 0, null, 6, null)));
                }
                {
                    this.$migration = xdHubMigration;
                    this.$path = path;
                    this.$request = httpServletRequest;
                    super(1);
                }
            }), (int)3, null);
        }
        catch (Exception e) {
            TransactionKt.legacyTransactional$default((boolean)false, null, (boolean)true, (Function1)((Function1)new Function1<TransientStoreSession, Unit>(migration2){
                final /* synthetic */ XdHubMigration $migration;

                public final void invoke(@NotNull TransientStoreSession it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    StateMachineUtils.getStateMachine((XdHubMigration)this.$migration).cancel();
                    this.$migration.delete();
                }
                {
                    this.$migration = xdHubMigration;
                    super(1);
                }
            }), (int)3, null);
            throw (Throwable)new InternalServerErrorException("Can't upload database");
        }
    }

    @javax.ws.rs.Path(value="/{id}")
    @NotNull
    public final ImportSubresource byID(@PathParam(value="id") @NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        return new ImportSubresource((Function0<XdHubMigration>)((Function0)new Function0<XdHubMigration>(id){
            final /* synthetic */ String $id;

            @NotNull
            public final XdHubMigration invoke() {
                XdHubMigration xdHubMigration = XdHubMigration.Companion.resolve(this.$id);
                if (xdHubMigration == null) {
                    throw (Throwable)new NotFoundException("XdHubMigration with id=\"" + this.$id + "\" was not found");
                }
                return xdHubMigration;
            }
            {
                this.$id = string;
                super(0);
            }
        }));
    }

    public ImportsResource() {
        ReadOnlyProperty readOnlyProperty;
        ImportsResource importsResource = this;
        String name$iv = null;
        importsResource.daoContainer$delegate = readOnlyProperty = SpringUtils.bean((String)name$iv, (boolean)false);
        importsResource = this;
        name$iv = null;
        importsResource.jetPass$delegate = readOnlyProperty = SpringUtils.bean((String)name$iv, (boolean)false);
        importsResource = this;
        name$iv = null;
        importsResource.persistentDataEnvironment$delegate = readOnlyProperty = SpringUtils.bean((String)name$iv, (boolean)false);
    }

    @NotNull
    public static final /* synthetic */ JetPassDAOContainer access$getDaoContainer$p(ImportsResource $this) {
        return $this.getDaoContainer();
    }

    @NotNull
    public static final /* synthetic */ Environment access$getPersistentDataEnvironment$p(ImportsResource $this) {
        return $this.getPersistentDataEnvironment();
    }

    @OAuth
    @Transactional
    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0087\u0004\u0018\u00002\u00020\u0001:\u0001\u0015B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\n0\u000bR\u00060\u0000R\u00020\fH\u0007J\u0014\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u0010H\u0007J\u0012\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010\u000f\u001a\u00020\u0010H\u0007J\b\u0010\u0013\u001a\u00020\u0014H\u0007R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Ljetbrains/jetpass/hub2hub/rest/ImportsResource$ImportSubresource;", "", "resolveEntity", "Lkotlin/Function0;", "Ljetbrains/jetpass/hub2hub/dnq/XdHubMigration;", "(Ljetbrains/jetpass/hub2hub/rest/ImportsResource;Lkotlin/jvm/functions/Function0;)V", "getResolveEntity", "()Lkotlin/jvm/functions/Function0;", "delete", "Ljavax/ws/rs/core/Response;", "getConflictsSubresource", "Ljetbrains/jetpass/hub2hub/rest/ImportsResource$ImportSubresource$ImportLinkSubresource;", "Ljetbrains/jetpass/hub2hub/rest/ImportsResource;", "getCounters", "Ljetbrains/jetpass/hub2hub/dto/CountersJSON;", "request", "Ljavax/servlet/http/HttpServletRequest;", "getOne", "Ljetbrains/jetpass/hub2hub/dto/ImportJSON;", "merge", "", "ImportLinkSubresource", "jetbrains.jetpass.hub2hub.rest"})
    public final class ImportSubresource {
        @NotNull
        private final Function0<XdHubMigration> resolveEntity;

        @javax.ws.rs.Path(value="/conflicts")
        @NotNull
        public final ImportLinkSubresource getConflictsSubresource() {
            return new ImportLinkSubresource();
        }

        @GET
        @Produces(value={"application/json;charset=UTF-8"})
        @NotNull
        public final ImportJSON getOne(@Context @NotNull HttpServletRequest request) {
            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
            if (!Security.DefaultImpls.canRead$default((Security)ImportsResource.this.getSecurity(), null, (boolean)false, (int)2, null)) {
                throw (Throwable)new ForbiddenException("Read import status is forbidden");
            }
            return (ImportJSON)SerializationExtKt.asJSON((Object)this.resolveEntity.invoke(), (FieldQuery)((FieldQuery)new RequestFieldQuery(request, 0, null, 6, null)));
        }

        @DELETE
        @Produces(value={"application/json;charset=UTF-8"})
        @NotNull
        public final Response delete() {
            if (!ImportsResource.this.getSecurity().canDelete(null)) {
                throw (Throwable)new ForbiddenException("Delete import is forbidden");
            }
            ResourceUtilKt.daoAction((Function0)((Function0)new Function0<Unit>(this){
                final /* synthetic */ ImportSubresource this$0;

                public final void invoke() {
                    DataAccessExceptionUtilKt.daoTransaction((JetPassDAOContainer)ImportsResource.access$getDaoContainer$p(this.this$0.ImportsResource.this), (boolean)true, (Function1)((Function1)new Function1<TransientStoreSession, Unit>(this){
                        final /* synthetic */ delete.1 this$0;

                        public final void invoke(@NotNull TransientStoreSession it) {
                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                            XdHubMigration migration2 = (XdHubMigration)this.this$0.this$0.getResolveEntity().invoke();
                            StateMachineUtils.getStateMachine((XdHubMigration)migration2).cancel();
                            migration2.delete();
                        }
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }
                    }));
                }
                {
                    this.this$0 = importSubresource;
                    super(0);
                }
            }));
            Response response = Response.ok().build();
            Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"Response.ok().build()");
            return response;
        }

        @GET
        @javax.ws.rs.Path(value="/counters")
        @Produces(value={"application/json;charset=UTF-8"})
        @Nullable
        public final CountersJSON getCounters(@Context @NotNull HttpServletRequest request) {
            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
            if (!Security.DefaultImpls.canRead$default((Security)ImportsResource.this.getSecurity(), null, (boolean)false, (int)2, null)) {
                throw (Throwable)new ForbiddenException("Read import status is forbidden");
            }
            return (CountersJSON)TransactionKt.legacyTransactional$default((boolean)false, null, (boolean)false, (Function1)((Function1)new Function1<TransientStoreSession, CountersJSON>(this, request){
                final /* synthetic */ ImportSubresource this$0;
                final /* synthetic */ HttpServletRequest $request;

                @Nullable
                public final CountersJSON invoke(@NotNull TransientStoreSession it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return ImportSerializers.Companion.counters((XdHubMigration)this.this$0.getResolveEntity().invoke(), (FieldQuery)new RequestFieldQuery(this.$request, 0, null, 6, null));
                }
                {
                    this.this$0 = importSubresource;
                    this.$request = httpServletRequest;
                    super(1);
                }
            }), (int)7, null);
        }

        @POST
        @javax.ws.rs.Path(value="/merge")
        @Produces(value={"application/json;charset=UTF-8"})
        public final void merge() {
            XdHubMigration hubMigration = (XdHubMigration)this.resolveEntity.invoke();
            hubMigration.getLocalJobExecutor().execute((Function0)new Function0<Boolean>(hubMigration){
                final /* synthetic */ XdHubMigration $hubMigration;

                public final boolean invoke() {
                    StateMachineUtils.getStateMachine((XdHubMigration)this.$hubMigration).resolved();
                    return DnqUtils.getCurrentTransientSession().flush();
                }
                {
                    this.$hubMigration = xdHubMigration;
                    super(0);
                }
            });
        }

        @NotNull
        public final Function0<XdHubMigration> getResolveEntity() {
            return this.resolveEntity;
        }

        public ImportSubresource(Function0<XdHubMigration> resolveEntity) {
            Intrinsics.checkParameterIsNotNull(resolveEntity, (String)"resolveEntity");
            this.resolveEntity = resolveEntity;
        }

        @OAuth
        @Transactional
        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\u000eH\u0007J\u001c\u0010\u000f\u001a\u00020\n2\b\b\u0001\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u0010\u001a\u00020\u0011H\u0007J\u001a\u0010\u0012\u001a\u00020\n2\b\b\u0001\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0014\u0010\u0015\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0016"}, d2={"Ljetbrains/jetpass/hub2hub/rest/ImportsResource$ImportSubresource$ImportLinkSubresource;", "", "(Ljetbrains/jetpass/hub2hub/rest/ImportsResource$ImportSubresource;)V", "conflicts", "Lkotlinx/dnq/query/XdQuery;", "Ljetbrains/jetpass/hub2hub/dnq/XdEntityConflict;", "Ljetbrains/jetpass/hub2hub/dnq/XdHubMigration;", "getConflicts", "(Ljetbrains/jetpass/hub2hub/dnq/XdHubMigration;)Lkotlinx/dnq/query/XdQuery;", "getElement", "Ljavax/ws/rs/core/Response;", "conflictId", "", "request", "Ljavax/servlet/http/HttpServletRequest;", "getElements", "info", "Ljavax/ws/rs/core/UriInfo;", "update", "body", "Ljetbrains/jetpass/hub2hub/dto/ResolutionJSON;", "findConflict", "jetbrains.jetpass.hub2hub.rest"})
        public final class ImportLinkSubresource {
            private final XdQuery<XdEntityConflict> getConflicts(@NotNull XdHubMigration $receiver) {
                XdConflictReport xdConflictReport = $receiver.getReport();
                if (xdConflictReport == null || (xdConflictReport = xdConflictReport.getNonDefaultConflicts()) == null) {
                    xdConflictReport = XdQueryKt.emptyQuery((XdEntityType)((XdEntityType)XdEntityConflict.Companion));
                }
                return xdConflictReport;
            }

            /*
             * WARNING - void declaration
             */
            private final XdEntityConflict findConflict(@NotNull XdHubMigration $receiver, String conflictId) {
                void $receiver$iv;
                KProperty1 kProperty1 = (KProperty1)ImportsResource$ImportSubresource$ImportLinkSubresource$findConflict$1.INSTANCE;
                XdQuery<XdEntityConflict> xdQuery = this.getConflicts($receiver);
                NodeBase nodeBase = NodeBaseOperationsKt.eq((String)ReflectionUtilKt.getDBName((KProperty1)$receiver$iv, (KClass)Reflection.getOrCreateKotlinClass(XdEntityConflict.class)), (Comparable)((Comparable)((Object)conflictId)));
                XdEntityConflict xdEntityConflict = (XdEntityConflict)XdQueryKt.firstOrNull(xdQuery, (NodeBase)nodeBase);
                if (xdEntityConflict == null) {
                    throw (Throwable)new NotFoundException("Cannot find conflict with id=\"" + conflictId + '\"');
                }
                return xdEntityConflict;
            }

            @GET
            @Produces(value={"application/json;charset=UTF-8"})
            @NotNull
            public final Response getElements(@Context @NotNull HttpServletRequest request, @Context @NotNull UriInfo info) {
                Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
                ConflictsSequence conflicts = new ConflictsSequence(this.getConflicts((XdHubMigration)ImportSubresource.this.getResolveEntity().invoke()));
                RequestFieldQuery fieldQuery = new RequestFieldQuery(request, ImportsResource.this.getJetPass().getDefaultTop(), null, 4, null);
                URI resourceURI = info.getAbsolutePath();
                Sequence sequence = (Sequence)conflicts;
                URI uRI = resourceURI;
                Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"resourceURI");
                Response response = Response.ok((Object)DynamicServerPageKt.asJSONPage((Sequence)sequence, (String)"conflicts", (URI)uRI, (FieldQuery)((FieldQuery)fieldQuery), (DynamicServerPage.CalculatedField[])new DynamicServerPage.CalculatedField[0])).build();
                Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"Response.ok(conflicts.as\u2026URI, fieldQuery)).build()");
                return response;
            }

            @GET
            @javax.ws.rs.Path(value="/{conflictId}")
            @Produces(value={"application/json;charset=UTF-8"})
            @NotNull
            public final Response getElement(@PathParam(value="conflictId") @NotNull String conflictId, @Context @NotNull HttpServletRequest request) {
                Intrinsics.checkParameterIsNotNull((Object)conflictId, (String)"conflictId");
                Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                Response response = Response.ok((Object)SerializationExtKt.asJSON((Object)this.findConflict((XdHubMigration)ImportSubresource.this.getResolveEntity().invoke(), conflictId), (FieldQuery)((FieldQuery)new RequestFieldQuery(request, 0, null, 6, null)))).build();
                Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"Response.ok(resolveEntit\u2026dQuery(request))).build()");
                return response;
            }

            @POST
            @javax.ws.rs.Path(value="/{conflictId}/update")
            @Produces(value={"application/json;charset=UTF-8"})
            @NotNull
            public final Response update(@PathParam(value="conflictId") @NotNull String conflictId, @NotNull ResolutionJSON body) {
                Intrinsics.checkParameterIsNotNull((Object)conflictId, (String)"conflictId");
                Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
                XdHubMigration hubMigration = (XdHubMigration)ImportSubresource.this.getResolveEntity().invoke();
                XdEntityConflict entityConflict = this.findConflict(hubMigration, conflictId);
                SecurityContext securityContext = OAuthResourceFilter.Companion.getSecurityContext();
                String currentUserId = securityContext != null && (securityContext = securityContext.getAuthorityHolder()) != null ? securityContext.getId() : null;
                hubMigration.getLocalJobExecutor().execute((Function0)new Function0<Unit>(body, entityConflict, currentUserId){
                    final /* synthetic */ ResolutionJSON $body;
                    final /* synthetic */ XdEntityConflict $entityConflict;
                    final /* synthetic */ String $currentUserId;

                    public final void invoke() {
                        XdConflictResolution resolution;
                        ResolutionType type = ResolutionType.Companion.fromString(this.$body.getType());
                        XdConflictResolution xdConflictResolution = this.$entityConflict.getResolution();
                        if (xdConflictResolution == null) {
                            XdConflictResolution xdConflictResolution2;
                            XdConflictResolution $receiver = xdConflictResolution2 = XdConflictResolution.Companion.create(type, false);
                            $receiver.setConflict(this.$entityConflict);
                            xdConflictResolution = resolution = xdConflictResolution2;
                        }
                        if (resolution.getResolutionType() != type) {
                            resolution.setResolutionType(type);
                            resolution.setPropertyOverrides((Iterable)CollectionsKt.emptyList());
                        }
                        if (this.$body.getPropertyOverrides() != null) {
                            Info info = ImportSerializers.Companion.toInfo(this.$body.getPropertyOverrides());
                            if (info == null) {
                                Intrinsics.throwNpe();
                            }
                            resolution.setPropertyOverrides(Info.Companion.toProperties(info));
                        }
                        ResourceUtilKt.daoAction((Function0)((Function0)new Function0<Unit>(this, resolution){
                            final /* synthetic */ update.1 this$0;
                            final /* synthetic */ XdConflictResolution $resolution;

                            public final void invoke() {
                                this.$resolution.validate(this.this$0.$currentUserId);
                            }
                            {
                                this.this$0 = var1_1;
                                this.$resolution = xdConflictResolution;
                                super(0);
                            }
                        }));
                    }
                    {
                        this.$body = resolutionJSON;
                        this.$entityConflict = xdEntityConflict;
                        this.$currentUserId = string;
                        super(0);
                    }
                });
                Response response = Response.accepted().build();
                Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"Response.accepted().build()");
                return response;
            }
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/jetpass/hub2hub/rest/ImportsResource$Companion;", "Lmu/KLogging;", "()V", "jetbrains.jetpass.hub2hub.rest"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

