/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.wiki.processor.runtime;

import java.io.IOException;
import java.util.Stack;
import jetbrains.mps.gtext.runtime.TBaseBuilderContext;
import jetbrains.mps.webr.wiki.processor.runtime.IWikiProcessor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BaseProcessor
implements IWikiProcessor {
    public static final String PROLOG = "<div class=\"wiki text prewrapped\">";
    public static final String EPILOG = "</div>";
    protected static Log log = LogFactory.getLog(BaseProcessor.class);
    protected String text;
    protected boolean wrapWithDiv;
    protected boolean isIE;
    protected TBaseBuilderContext builderContext;
    private Stack<Integer> states = new Stack();

    public void beginState(int state) {
        Integer current = new Integer(this.yystate());
        this.states.push(current);
        this.yybegin(state);
    }

    public int endState() {
        if (this.states.empty()) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Attempt to call endState for an empty stack with text: " + this.yytext()));
            }
            return 0;
        }
        int next = this.states.pop();
        this.yybegin(next);
        return next;
    }

    public String getText() {
        if (this.text == null) {
            this.text = this.yytext();
        }
        return this.text;
    }

    private void setBuilderContext(TBaseBuilderContext builder) {
        this.builderContext = builder;
    }

    @Override
    public String process() throws IOException {
        this.setBuilderContext(new TBaseBuilderContext());
        this.builderContext.initBuffer();
        this.processInternal();
        return this.builderContext.getText();
    }

    @Override
    public String processSafe() {
        try {
            if (this.readerNotExists()) {
                return "";
            }
            this.setBuilderContext(new TBaseBuilderContext());
            this.builderContext.initBuffer();
            this.processInternal();
            return this.builderContext.getText();
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public String process(TBaseBuilderContext builderContext) throws IOException {
        this.setBuilderContext(builderContext);
        this.processInternal();
        return "";
    }

    @Override
    public String processSafe(TBaseBuilderContext builderContext) {
        try {
            this.setBuilderContext(builderContext);
            if (this.readerNotExists()) {
                return "";
            }
            this.processInternal();
            return "";
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    protected void processInternal() throws IOException {
        this.yylex();
    }

    @Override
    public void setWrapWithDiv(boolean wrapWithDiv) {
        this.wrapWithDiv = wrapWithDiv;
    }

    public abstract void yybegin(int var1);

    public abstract String yytext();

    public abstract char yycharat(int var1);

    public abstract void yypushback(int var1);

    public abstract Void yylex() throws IOException;

    public abstract int yystate();

    protected abstract boolean readerNotExists();

    public static String characterToStringSafe(char c) {
        if (c <= '\u001f' && (BaseProcessor.characterInRange(c, '\u0000', '\b') || BaseProcessor.characterInRange(c, '\u000b', '\f') || BaseProcessor.characterInRange(c, '\u000e', '\u001f'))) {
            return "";
        }
        return String.valueOf(c);
    }

    private static boolean characterInRange(char character, char from, char to) {
        return from <= character && character <= to;
    }
}

