/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.wiki.processor.runtime;

import java.util.ArrayList;
import java.util.List;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.webr.wiki.processor.runtime.HtmlAttributeMatcherMarkup;
import jetbrains.mps.webr.wiki.processor.runtime.HtmlAttributeMatcherRemoveMarkup;
import jetbrains.mps.webr.wiki.processor.runtime.IWikiProcessor;
import jetbrains.mps.webr.wiki.processor.runtime.WikiBlockHelp;
import jetbrains.mps.webr.wiki.processor.runtime.WikiProcessor;

public class HtmlAttributeMatcher
implements WikiProcessor {
    private static List<WikiBlockHelp> HELP;
    private static boolean HELP_READY;
    private static HtmlAttributeMatcher INSTANCE;

    private HtmlAttributeMatcher() {
    }

    public String clean(String arg) {
        if (arg == null) {
            return null;
        }
        int s = 0;
        for (int i = 0; i < arg.length(); ++i) {
            s += arg.charAt(i) == '\r' ? 0 : 1;
        }
        char[] ar = new char[s];
        s = 0;
        for (int i = 0; i < arg.length(); ++i) {
            if (arg.charAt(i) == '\r') continue;
            ar[s++] = arg.charAt(i);
        }
        return new String(ar);
    }

    @Override
    public IWikiProcessor createProcessor(String s) {
        HtmlAttributeMatcherMarkup result = HtmlAttributeMatcherMarkup.create(this.clean(s));
        return result;
    }

    @Override
    public IWikiProcessor createRemoveMarkupProcessor(String s) {
        HtmlAttributeMatcherRemoveMarkup result = HtmlAttributeMatcherRemoveMarkup.create(this.clean(s));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<WikiBlockHelp> getHelp() {
        if (!HELP_READY) {
            HtmlAttributeMatcher htmlAttributeMatcher = this;
            synchronized (htmlAttributeMatcher) {
                if (!HELP_READY) {
                    HELP = ListSequence.fromList(new ArrayList());
                    HELP_READY = true;
                }
            }
        }
        return HELP;
    }

    public static HtmlAttributeMatcher getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new HtmlAttributeMatcher();
        }
        return INSTANCE;
    }

    private static String concat(String ... strings) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < strings.length; ++i) {
            sb.append(strings[i]);
            if (i >= strings.length - 1) continue;
            sb.append('\n');
        }
        return sb.toString();
    }
}

