/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.wiki.processor.runtime;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import jetbrains.mps.gtext.runtime.TBaseBuilderContext;
import jetbrains.mps.webr.wiki.processor.runtime.BaseProcessor;
import jetbrains.mps.webr.wiki.processor.runtime.IWikiProcessor;
import jetbrains.mps.webr.wiki.processor.runtime.StringUtils;
import jetbrains.mps.webr.wiki.processor.runtime.TrailingCharStringReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import webr.framework.function.HtmlStringUtil;

public final class RichTextWikiProcessorRemoveMarkup
extends BaseProcessor {
    public static final int YYEOF = -1;
    private static final int ZZ_BUFFERSIZE = 128;
    public static final int YYINITIAL = 0;
    private static final int[] ZZ_LEXSTATE = new int[]{0, 1};
    private static final String ZZ_CMAP_PACKED = "\t\u001c\u0001\u0007\u0001\u0005\u0002\u001d\u0001\u0015\u0012\u001c\u0001\t\u0001\u001b\u0001!\u0001\u0002\u0002\f\u0001\u001e\u0001\u0017\u0002\u001b\u0001\u000b\u0001\b\u0001\f\u0001\u0006\u0001\u001b\u0001\f\n\u0003\u0001\u0012\u0001\f\u0001\u001f\u0001\u0016\u0001 \u0002\f\u0006\u0004\u0014\u0001\u0001\u001b\u0001\n\u0001\u001b\u0001\f\u0001\u001a\u0001\u001b\u0002\u0004\u0001\u000e\u0003\u0004\u0005\u0001\u0001\u0010\u0002\u0001\u0001\u000f\u0002\u0001\u0001\u0011\b\u0001\u0001\r\u0001\u0019\u0001\u0013\u0001\u0018\u0006\u0000\u0001\u0014\u1fa2\u0000\u0002\u0014\udfd6\u0000";
    private static final char[] ZZ_CMAP = RichTextWikiProcessorRemoveMarkup.zzUnpackCMap("\t\u001c\u0001\u0007\u0001\u0005\u0002\u001d\u0001\u0015\u0012\u001c\u0001\t\u0001\u001b\u0001!\u0001\u0002\u0002\f\u0001\u001e\u0001\u0017\u0002\u001b\u0001\u000b\u0001\b\u0001\f\u0001\u0006\u0001\u001b\u0001\f\n\u0003\u0001\u0012\u0001\f\u0001\u001f\u0001\u0016\u0001 \u0002\f\u0006\u0004\u0014\u0001\u0001\u001b\u0001\n\u0001\u001b\u0001\f\u0001\u001a\u0001\u001b\u0002\u0004\u0001\u000e\u0003\u0004\u0005\u0001\u0001\u0010\u0002\u0001\u0001\u000f\u0002\u0001\u0001\u0011\b\u0001\u0001\r\u0001\u0019\u0001\u0013\u0001\u0018\u0006\u0000\u0001\u0014\u1fa2\u0000\u0002\u0014\udfd6\u0000");
    private static final int[] ZZ_ACTION = RichTextWikiProcessorRemoveMarkup.zzUnpackAction();
    private static final String ZZ_ACTION_PACKED_0 = "\u0002\u0000\u0001\u0001\u0001\u0002\u0001\u0001\u0001\u0003\u0003\u0001\u0001\u0004\u0001\u0005\u0001\u0001\u0001\u0006\u0001\u0007\u0001\b\u0001\t\u0001\n\u0003\u0001\u0001\u000b\u0001\f\u0002\u000b\u0002\f\u0003\u0000\u0001\r\t\u0000\u0001\u000e\u0010\u0000\u0001\u000f\b\u0000\u0001\u0010\u0001\u0000\u0002\u0011\u0002\u0012\u0001\u000f\u0004\u0000\u0001\u0013\u0001\u0000\u0001\u0014\u0001\u0000\u0001\u0010\u0002\u0000\u0001\u0010\u0001\u0015\u0005\u0000\u0001\u0016\u0001\u0000\u0001\u0017\u0001\u0014\u0002\u0000\u0002\u0010\u0002\u0000\u0001\u0018\u0001\u0015\u0004\u0000\u0001\u0016\u0005\u0000\u0001\u0018\u0003\u0000\u0001\u0018\u0007\u0000\u0001\u0016\u0003\u0000\u0001\u0019\u0003\u0000\u0001\u0018\u0002\u0000\u0001\u0018\u0001\u0000\u0001\u0019\u0005\u0000\u0002\u0018\u0005\u0000\u0001\u001a\u0003\u0000\u0001\u0018\u0001\u0000\u0001\u001b\u0004\u0000\u0001\u001b\u0003\u0000\u0001\u001b\u0002\u0000\u0001\u001b\u0002\u0000\u0001\u001b\u0001\u0000\u0001\u001c";
    private static final int[] ZZ_ROWMAP = RichTextWikiProcessorRemoveMarkup.zzUnpackRowMap();
    private static final String ZZ_ROWMAP_PACKED_0 = "\u0000\u0000\u0000\"\u0000D\u0000f\u0000\u0088\u0000\u00aa\u0000\u00aa\u0000\u00cc\u0000\u00ee\u0000\u00aa\u0000\u0110\u0000\u0132\u0000D\u0000D\u0000D\u0000D\u0000D\u0000\u0154\u0000\u0176\u0000\u0198\u0000D\u0000\u01ba\u0000\u0154\u0000\u0176\u0000D\u0000\u01dc\u0000\u01fe\u0000\u0154\u0000\u0176\u0000D\u0000\u0220\u0000\u0242\u0000\u0264\u0000\u0286\u0000\u02a8\u0000\u02ca\u0000\u02ec\u0000\u030e\u0000\u0330\u0000D\u0000\u0352\u0000\u0374\u0000\u0396\u0000\u03b8\u0000\u03da\u0000\u03fc\u0000\u041e\u0000\u0440\u0000\u0462\u0000\u0484\u0000\u04a6\u0000\u04c8\u0000\u04ea\u0000\u050c\u0000\u052e\u0000\u0550\u0000\u0550\u0000\u0572\u0000\u0594\u0000\u05b6\u0000\u05d8\u0000\u05fa\u0000\u061c\u0000\u063e\u0000\u0660\u0000\u0682\u0000\u06a4\u0000D\u0000\u06c6\u0000D\u0000\u06e8\u0000D\u0000\u070a\u0000\u072c\u0000\u074e\u0000\u0770\u0000D\u0000\u0792\u0000\u07b4\u0000\u07d6\u0000\u07f8\u0000\u081a\u0000\u083c\u0000\u085e\u0000\u0880\u0000\u08a2\u0000\u08c4\u0000\u08e6\u0000\u0908\u0000\u092a\u0000\u092a\u0000\u094c\u0000D\u0000D\u0000\u096e\u0000\u0990\u0000D\u0000\u09b2\u0000\u09d4\u0000\u09f6\u0000\u0a18\u0000D\u0000\u0a3a\u0000\u0a5c\u0000\u0a7e\u0000\u0aa0\u0000D\u0000\u0ac2\u0000\u0ae4\u0000\u0b06\u0000\u0b28\u0000\u0b4a\u0000\u0b6c\u0000\u09b2\u0000\u0b8e\u0000\u0bb0\u0000\u0bd2\u0000\u0bf4\u0000\u0c16\u0000\u0c38\u0000\u0c5a\u0000\u0c7c\u0000\u0c9e\u0000\u0cc0\u0000\u0cc0\u0000\u0ce2\u0000\u0d04\u0000\u0d26\u0000\u0d26\u0000\u0d48\u0000\u0d6a\u0000\u0d8c\u0000\u0dae\u0000\u0dd0\u0000\u0df2\u0000\u0e14\u0000\u0e36\u0000D\u0000\u0e58\u0000\u0e7a\u0000\u0e9c\u0000\u0ebe\u0000\u0ee0\u0000D\u0000\u0f02\u0000\u0f24\u0000\u0f46\u0000\u0f68\u0000\u0f8a\u0000\u0fac\u0000D\u0000\u0fce\u0000\u0ff0\u0000\u1012\u0000\u0f46\u0000\u0e14\u0000\u1034\u0000\u1056\u0000\u1078\u0000\u109a\u0000\u10bc\u0000\u10de\u0000\u1100\u0000\u1122\u0000\u1144\u0000\u1166\u0000\u1188\u0000\u11aa\u0000\u11cc\u0000\u11ee\u0000\u1210\u0000D\u0000\u1232\u0000D";
    private static final int[] ZZ_TRANS = RichTextWikiProcessorRemoveMarkup.zzUnpackTrans();
    private static final String ZZ_TRANS_PACKED_0 = "\u0005\u0003\u0001\u0004\u0001\u0005\u0001\u0006\u0001\u0003\u0001\u0007\u0001\b\u0002\u0003\u0001\t\u0007\u0003\u0001\n\u0001\u0003\u0001\u000b\u0001\f\u0003\u0003\u0002\r\u0001\u000e\u0001\u000f\u0001\u0010\u0001\u0011\u0005\u0003\u0001\u0004\u0001\u0005\u0001\u0006\u0001\u0012\u0001\u0007\u0001\b\u0001\u0013\u0001\u0003\u0001\t\u0007\u0003\u0001\n\u0001\u0014\u0001\u000b\u0001\f\u0003\u0003\u0002\r\u0001\u000e\u0001\u000f\u0001\u0010\u0001\u0011\"\u0000\u0005\u0015\u0001\u0016\u0002\u0015\u0001\u0017\u0002\u0015\u0001\u0018\b\u0015\u0001\u0019\u0001\u001a\u0007\u0015\u0001\u0019\u0004\u0015\u0006\u0000\u0001\u001b#\u0000\u0001\u001c\u0002\u0000\u0001\u001d\u0018\u0000\u0001\u001e\u0003\u0000\u0001\u001e\u0001\u0000\u0001\u001e\u0002\u0000\u0001\u001e\u0001\u0000\u0001\u001e\u0005\u0000\u0001\u001e\u0006\u0000\u0002\u001e\u0014\u0000\u0001\u001f*\u0000\u0001 \"\u0000\u0001!\t\u0000\u0005\"\u0001\u0000\u0001\"\u0003\u0000\u0001#\n\"\u0001\u0000\f\"\u0005$\u0001\u0000\u0001$\u0001\u0000\u0001$\u0001\u0000\u0001%\u0001\u0000\t$\u0001\u0000\f$\u0016&\u0001'\u000b&\u0005\u0015\u0001\u0016\u000e\u0015\u0001\u0019\u0001\u001a\u0007\u0015\u0001\u0019\u0004\u0015\u0005\u0000\u0001(\u001c\u0000\u0005)\u0001\u0000\u0001*\u0001\u0000\u0001)\u0001\u0000\u000b)\u0001\u0000\f)\u000f\u0000\u0001+\u0012\u0000\u0017,\u0001-\n,\u0019!\u0001.\b!\u0005\"\u0001\u0000\u0001\"\u0001\u0000\u0001/\u00010\u00011\n\"\u0001\u0000\u0011\"\u0001\u0000\u0001\"\u0001\u0000\u00012\u00010\u00011\n\"\u0001\u0000\f\"\u0005$\u0001\u0000\u0001$\u0001\u0000\u0001$\u00013\u00014\u00015\t$\u0001\u0000\u0011$\u0001\u0000\u0001$\u0001\u0000\u0001$\u00013\u00014\u00016\t$\u0001\u0000\f$\u0016&\u00017\u000b&\u00058\u00019\u000f8\u00019\u0001:\u000b8\u0005;\u0001\u0000\u0001<\u0001=\u0001;\u0001=\u000b;\u0001\u0000\f;\u0006\u0000\u0001>+\u0000\u0001?\u0011\u0000\u0017,\u0001@\n,\u0017A\u0001B\nA\u0018.\u0001C\t.\u0002\u0000\u0001D\u0002\u0000\u0001E\u0001D\u0001E\u0001D\u0001E\u0001\u0000\u0003D\u0004\u0000\u0002D\u0001\u0000\u0001E\u0004D\u0001\u0000\u0001D\u0002\u0000\u0001D\u0002\u0000\u0001D\u0005\"\u0001\u0000\u0001\"\u0002\u0000\u00010\u00011\n\"\u0001\u0000\u0011\"\u0001\u0000\u0001\"\u0001\u0000\u0001\"\u00010\u00011\n\"\u0001\u0000\f\"\b\u0000\u0001/\u0019\u0000\u0005$\u0001\u0000\u0001$\u0001\u0000\u0001$\u00013\u00014\u0001\u0000\t$\u0001\u0000\u0011$\u0001\u0000\u0001$\u0001\u0000\u0001$\u00013\u00014\n$\u0001\u0000\f$\u0002\u0000\u0001F\u0002\u0000\u0001G\u0001F\u0001G\u0001F\u0001G\u0001\u0000\u0003F\u0004\u0000\u0002F\u0001\u0000\u0001G\u0004F\u0001\u0000\u0001F\u0002\u0000\u0001F\u0002\u0000\u0001F\u000b\u0000\u00015\u001b\u0000\u0001H\u000f\u0000\u0001H\f\u0000\u00168\u0001I\u000b8\u0016J\u0001K\u000bJ\u0005;\u0001\u0000\u0001L\u0001=\u0001;\u0001=\u000b;\u0001\u0000\u0011;\u0001=\u0001M\u0001=\u0001;\u0001=\u000b;\u0001=\u0011;\u0001\u0000\u0001N\u0001=\u0001;\u0001=\u000b;\u0001\u0000\f;\u0006\u0000\u0001O*\u0000\u0001P\u0012\u0000\u0017,\u0001Q\n,\u0017A\u0001R\nA\u0017S\u0001T\nS\u0018.\u0001U\t.\b\u0000\u0001V$\u0000\u0001W\u0016\u0000\u00168\u0001X\u000b8\u0016J\u0001Y\u000bJ\u0005Z\u0001[\u000fZ\u0001[\u0001\\\u000bZ\u0005;\u0001=\u0001]\u0001=\u0001;\u0001=\u000b;\u0001=\u0011;\u0001=\u0001\u0000\u0001=\u0001;\u0001=\u000b;\u0001=\f;\u0005\u0000\u0001^\u0001O\u0002\u0000\u0001_\u000b\u0000\u0001^\u001d\u0000\u0001`'\u0000\u0001a\n\u0000\u0017A\u0001b\nA\u0017S\u0001c\nS\u0017d\u0001e\nd\u0018\u0000\u0001f\t\u0000\u0005g\u0001\u0000\u0001g\u0003\u0000\u0001h\ng\u0001\u0000\fg\u0005i\u0001\u0000\u0001i\u0001\u0000\u0001i\u0001\u0000\u0001j\u0001\u0000\ti\u0001\u0000\fi\u0005\u0000\u0001k\u000f\u0000\u0001k\u0001l\u000b\u0000\u0016J\u0001m\u000bJ\u0016Z\u0001n\u0010Z\u0001[\u000fZ\u0001[\u0001o\u000bZ\u0005\u0000\u0001^\u0003\u0000\u0001_\u000b\u0000\u0001^\u001e\u0000\u0001p\u000f\u0000\u0017S\u0001q!S\u0001r\nS\u0017d\u0001s\nd\u0017t\u0001u\nt\u0005g\u0001\u0000\u0001g\u0001\u0000\u0001D\u0001v\u0001w\ng\u0001\u0000\u0011g\u0001\u0000\u0001g\u0001\u0000\u0001x\u0001v\u0001w\ng\u0001\u0000\fg\u0005i\u0001\u0000\u0001i\u0001\u0000\u0001i\u0001y\u0001z\u0001F\ti\u0001\u0000\u0011i\u0001\u0000\u0001i\u0001\u0000\u0001i\u0001y\u0001z\u0001{\ti\u0001\u0000\fi\u0005\u0000\u0001k\u000f\u0000\u0001k\f\u0000\u0005|\u0001}\u000f|\u0001}\u0001~\u000b|\u0016Z\u0001\u007f\u000bZ\u0005\u0080\u0001\u0081\u000f\u0080\u0001\u0081\u0001\u0082\u000b\u0080\u0001\u0000\u0001\u0083\u0001\u0084\u0001\u0000\u0001\u0083\t\u0000\u0004\u0083'\u0000\u0001\u0085\n\u0000\u0017d\u0001\u0086\nd\u0017t\u0001\u0087!t\u0001\u0088\nt\u0005g\u0001\u0000\u0001g\u0002\u0000\u0001v\u0001w\ng\u0001\u0000\u0011g\u0001\u0000\u0001g\u0001\u0000\u0001g\u0001v\u0001w\ng\u0001\u0000\fg\b\u0000\u0001D\u0019\u0000\u0005i\u0001\u0000\u0001i\u0001\u0000\u0001i\u0001y\u0001z\u0001\u0000\ti\u0001\u0000\u0011i\u0001\u0000\u0001i\u0001\u0000\u0001i\u0001y\u0001z\ni\u0001\u0000\fi\u000b\u0000\u0001F\u0016\u0000\u0016|\u0001\u0089\u000b|\u0005\u0000\u0001\u008a\u000f\u0000\u0001\u008a\u0001\u008b\u000b\u0000\u0016Z\u0001\u0082\u000bZ\u0016\u0080\u0001\u008c\u0010\u0080\u0001\u0081\u000f\u0080\u0001\u0081\u0001\u008d\u000b\u0080\u0001\u0000\u0001\u0083\u0002\u0000\u0001\u0083\t\u0000\u0004\u0083\u0001\u0000\u0001\u008e\u0011\u0000\u0002\u008f\t\u0000\u0001\u008f*\u0000\u0001\u0090\n\u0000\u0017d\u0001\u0091\nd\u0017t\u0001\u0092!t\u0001\u0093\nt\u0016|\u0001\u0094\u000b|\u0005\u0000\u0001\u008a\u000f\u0000\u0001\u008a\u0001\u0095\u000b\u0000\u0016\u0080\u0001\u0096\u000b\u0080\u0005\u0000\u0001\u0097\u000f\u0000\u0001\u0097\u0001\u0098\u000b\u0000\r\u008e\u0001\u0099\u0014\u008e\u0003\u0000\u0002\u009a\t\u0000\u0001\u009a\u0013\u0000\u0017t\u0001\u009b!t\u0001\u009c!t\u0001\u009d\nt\u0016|\u0001~\u000b|\u0005\u0000\u0001\u008a\u000f\u0000\u0001\u008a\f\u0000\u0016\u0080\u0001\u009e\u000b\u0080\u0005\u0000\u0001\u0097\u000f\u0000\u0001\u0097\u0001\u009f\u000b\u0000\r\u008e\u0001\u0099\u0001\u00a0\u0013\u008e\u0003\u0000\u0002\u00a1\t\u0000\u0001\u00a1*\u0000\u0001\u00a2\n\u0000\u0016\u0080\u0001\u008d\u000b\u0080\u0005\u0000\u0001\u0097\u000f\u0000\u0001\u0097\u0001\u00a3\u000b\u0000\r\u008e\u0001\u0099\u0001\u008e\u0001\u00a4\u0012\u008e\u0003\u0000\u0002\u00a5\t\u0000\u0001\u00a5*\u0000\u0001\u00a6\u000f\u0000\u0001\u0097\u000f\u0000\u0001\u0097\f\u0000\r\u008e\u0001\u0099\u0002\u008e\u0001\u00a7\u0011\u008e\u0003\u0000\u0002\u00a8\t\u0000\u0001\u00a8*\u0000\u0001\u00a9\n\u0000\r\u008e\u0001\u0099\u0001\u008e\u0001\u00aa\u0012\u008e\u0003\u0000\u0002\u00ab\t\u0000\u0001\u00ab*\u0000\u0001\u00ac\n\u0000\r\u008e\u0001\u0099\u0003\u008e\u0001\u00ad\u0010\u008e\u0013\u0000\u0001\u008e\u000e\u0000\r\u008e\u0001\u0099\u0005\u008e\u0001\u00ae\u000e\u008e";
    private static final int ZZ_UNKNOWN_ERROR = 0;
    private static final int ZZ_NO_MATCH = 1;
    private static final int ZZ_PUSHBACK_2BIG = 2;
    private static final String[] ZZ_ERROR_MSG = new String[]{"Unkown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
    private static final int[] ZZ_ATTRIBUTE = RichTextWikiProcessorRemoveMarkup.zzUnpackAttribute();
    private static final String ZZ_ATTRIBUTE_PACKED_0 = "\u0002\u0000\u0001\t\t\u0001\u0005\t\u0003\u0001\u0001\t\u0003\u0001\u0001\t\u0001\u0001\u0003\u0000\u0001\t\t\u0000\u0001\t\u0010\u0000\u0001\u0001\b\u0000\u0001\u0001\u0001\u0000\u0001\t\u0001\u0001\u0001\t\u0001\u0001\u0001\t\u0004\u0000\u0001\t\u0001\u0000\u0001\u0001\u0001\u0000\u0001\u0001\u0002\u0000\u0002\u0001\u0005\u0000\u0001\u0001\u0001\u0000\u0002\t\u0002\u0000\u0001\t\u0001\u0001\u0002\u0000\u0001\u0001\u0001\t\u0004\u0000\u0001\t\u0005\u0000\u0001\u0001\u0003\u0000\u0001\u0001\u0007\u0000\u0001\u0001\u0003\u0000\u0001\u0001\u0003\u0000\u0001\u0001\u0002\u0000\u0001\u0001\u0001\u0000\u0001\t\u0005\u0000\u0001\t\u0001\u0001\u0005\u0000\u0001\t\u0003\u0000\u0001\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0001\u0003\u0000\u0001\u0001\u0002\u0000\u0001\u0001\u0002\u0000\u0001\t\u0001\u0000\u0001\t";
    private Reader zzReader;
    private int zzState;
    private int zzLexicalState = 0;
    private char[] zzBuffer = new char[128];
    private int zzMarkedPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private int yyline;
    private int yychar;
    private int yycolumn;
    private boolean zzAtBOL = true;
    private boolean zzAtEOF;
    private boolean zzEOFDone;
    private boolean[] zzFin = new boolean[129];
    private Log log = LogFactory.getLog(RichTextWikiProcessorRemoveMarkup.class);
    private int TextColorercolorSuffixKeyLength = "{color}".length();
    private int TextColorercolorPrefixKeyLength = "{color:".length();
    private int NewLinesSimplenewLineCount;
    private boolean liveModePreview = false;

    private static int[] zzUnpackAction() {
        int[] result = new int[174];
        int offset = 0;
        offset = RichTextWikiProcessorRemoveMarkup.zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAction(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackRowMap() {
        int[] result = new int[174];
        int offset = 0;
        offset = RichTextWikiProcessorRemoveMarkup.zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackRowMap(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int high = packed.charAt(i++) << 16;
            result[j++] = high | packed.charAt(i++);
        }
        return j;
    }

    private static int[] zzUnpackTrans() {
        int[] result = new int[4692];
        int offset = 0;
        offset = RichTextWikiProcessorRemoveMarkup.zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackTrans(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            int value = packed.charAt(i++);
            do {
                result[j++] = --value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackAttribute() {
        int[] result = new int[174];
        int offset = 0;
        offset = RichTextWikiProcessorRemoveMarkup.zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAttribute(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    @Override
    public IWikiProcessor clone(String input) {
        RichTextWikiProcessorRemoveMarkup cloned = RichTextWikiProcessorRemoveMarkup.create(input);
        return cloned;
    }

    @Override
    protected boolean readerNotExists() {
        return this.zzReader == null;
    }

    private String yytext(int prefixLength, int suffixLength) {
        return new String(this.zzBuffer, this.zzStartRead + prefixLength, this.zzMarkedPos - this.zzStartRead - suffixLength - prefixLength);
    }

    @Override
    public RichTextWikiProcessorRemoveMarkup setLivePreviewMode(boolean value) {
        return this;
    }

    public final void appendBlank(char a) {
        switch (a) {
            case '\n': {
                TBaseBuilderContext builderContext = this.builderContext;
                builderContext.append("<br/>");
                break;
            }
            case '\t': {
                TBaseBuilderContext builderContext = this.builderContext;
                builderContext.append("\t");
                break;
            }
            case ' ': {
                TBaseBuilderContext builderContext = this.builderContext;
                builderContext.append(" ");
                break;
            }
            default: {
                TBaseBuilderContext builderContext = this.builderContext;
                builderContext.append("" + a);
            }
        }
    }

    public final void appendBlank(String s) {
        for (int i = 0; i < s.length(); ++i) {
            this.appendBlank(s.charAt(i));
        }
    }

    public void appendTitledText() {
        int contentEnds = this.getText().lastIndexOf(124);
        String title = StringUtils.substring(this.getText(), contentEnds + 1, this.getText().length() - 2).trim();
        String content = StringUtils.substring(this.getText(), 2, contentEnds);
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append("<span title=\"");
        builderContext.append(title.trim());
        builderContext.append("\">");
        builderContext = this.builderContext;
        this.clone(content).processSafe(builderContext);
        builderContext = this.builderContext;
        builderContext.append("</span>");
    }

    public void removeFramingMarkup(String symbol, String tag, boolean addHtml) {
        String[] strings;
        int indexOfSymbol = this.getText().indexOf(symbol);
        int indexOfLastSymbol = this.getText().lastIndexOf(symbol);
        this.appendBlank(StringUtils.substring(this.getText(), 0, indexOfSymbol));
        int delemiterIdx = indexOfSymbol + 1;
        for (String str : strings = StringUtils.substring(this.getText(), indexOfSymbol + 1, indexOfLastSymbol).split('\\' + symbol + "[ \t\r\n]" + '\\' + symbol)) {
            TBaseBuilderContext builderContext;
            if (addHtml) {
                builderContext = this.builderContext;
                builderContext.append("<");
                builderContext = this.builderContext;
                builderContext.append(tag);
                builderContext = this.builderContext;
                builderContext.append(">");
            }
            builderContext = this.builderContext;
            this.clone(str).processSafe(builderContext);
            if (addHtml) {
                builderContext = this.builderContext;
                builderContext.append("</");
                builderContext = this.builderContext;
                builderContext.append(tag);
                builderContext = this.builderContext;
                builderContext.append(">");
            }
            delemiterIdx += str.length() + symbol.length();
            if (str == strings[strings.length - 1]) continue;
            this.appendBlank(this.getText().charAt(delemiterIdx));
            delemiterIdx += symbol.length() + 1;
        }
        this.appendBlank(this.getText().charAt(this.getText().length() - 1) == '\r' ? StringUtils.substring(this.getText(), indexOfLastSymbol + 1, this.getText().length() - 2) : StringUtils.substring(this.getText(), indexOfLastSymbol + 1));
    }

    public static RichTextWikiProcessorRemoveMarkup create(String s) {
        if (s == null) {
            Reader reader = null;
            return new RichTextWikiProcessorRemoveMarkup(reader);
        }
        return new RichTextWikiProcessorRemoveMarkup(new TrailingCharStringReader(s, '\n'));
    }

    public RichTextWikiProcessorRemoveMarkup(Reader in) {
        this.zzReader = in;
    }

    public RichTextWikiProcessorRemoveMarkup(InputStream in) {
        this(new InputStreamReader(in));
    }

    private static char[] zzUnpackCMap(String packed) {
        char[] map = new char[65536];
        int i = 0;
        int j = 0;
        while (i < 108) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                map[j++] = value;
            } while (--count > 0);
        }
        return map;
    }

    private boolean zzRefill() throws IOException {
        int numRead;
        if (this.zzStartRead > 0) {
            System.arraycopy(this.zzBuffer, this.zzStartRead, this.zzBuffer, 0, this.zzEndRead - this.zzStartRead);
            System.arraycopy(this.zzFin, this.zzStartRead, this.zzFin, 0, this.zzEndRead + 1 - this.zzStartRead);
            this.zzEndRead -= this.zzStartRead;
            this.zzCurrentPos -= this.zzStartRead;
            this.zzMarkedPos -= this.zzStartRead;
            this.zzStartRead = 0;
        }
        if (this.zzCurrentPos >= this.zzBuffer.length) {
            char[] newBuffer = new char[this.zzCurrentPos * 2];
            boolean[] newFin = new boolean[newBuffer.length + 1];
            System.arraycopy(this.zzBuffer, 0, newBuffer, 0, this.zzBuffer.length);
            System.arraycopy(this.zzFin, 0, newFin, 0, this.zzFin.length);
            this.zzBuffer = newBuffer;
            this.zzFin = newFin;
        }
        if ((numRead = this.zzReader.read(this.zzBuffer, this.zzEndRead, this.zzBuffer.length - this.zzEndRead)) > 0) {
            for (int i = this.zzEndRead + 1; i < numRead + this.zzEndRead + 1; ++i) {
                this.zzFin[i] = false;
            }
            this.zzEndRead += numRead;
            return false;
        }
        if (numRead == 0) {
            int c = this.zzReader.read();
            if (c == -1) {
                return true;
            }
            this.zzBuffer[this.zzEndRead++] = (char)c;
            this.zzFin[this.zzEndRead] = false;
            return false;
        }
        return true;
    }

    public final void yyclose() throws IOException {
        this.zzAtEOF = true;
        this.zzEndRead = this.zzStartRead;
        if (this.zzReader != null) {
            this.zzReader.close();
        }
    }

    public final void yyreset(Reader reader) {
        this.zzReader = reader;
        this.zzAtBOL = true;
        this.zzAtEOF = false;
        this.zzEOFDone = false;
        this.zzStartRead = 0;
        this.zzEndRead = 0;
        this.zzMarkedPos = 0;
        this.zzCurrentPos = 0;
        this.yycolumn = 0;
        this.yychar = 0;
        this.yyline = 0;
        this.zzLexicalState = 0;
    }

    @Override
    public final int yystate() {
        return this.zzLexicalState;
    }

    @Override
    public final void yybegin(int newState) {
        this.zzLexicalState = newState;
    }

    @Override
    public final String yytext() {
        return new String(this.zzBuffer, this.zzStartRead, this.zzMarkedPos - this.zzStartRead);
    }

    @Override
    public final char yycharat(int pos) {
        return this.zzBuffer[this.zzStartRead + pos];
    }

    public final int yylength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    private void zzScanError(int errorCode) {
        String message;
        try {
            message = ZZ_ERROR_MSG[errorCode];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            message = ZZ_ERROR_MSG[0];
        }
        throw new Error(message);
    }

    @Override
    public void yypushback(int number) {
        if (number > this.yylength()) {
            this.zzScanError(2);
        }
        this.zzMarkedPos -= number;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void yylex() throws IOException {
        int zzEndReadL = this.zzEndRead;
        char[] zzBufferL = this.zzBuffer;
        char[] zzCMapL = ZZ_CMAP;
        int[] zzTransL = ZZ_TRANS;
        int[] zzRowMapL = ZZ_ROWMAP;
        int[] zzAttrL = ZZ_ATTRIBUTE;
        block95: while (true) {
            int zzInput;
            boolean eof;
            int zzMarkedPosL;
            if ((zzMarkedPosL = this.zzMarkedPos) > this.zzStartRead) {
                switch (zzBufferL[zzMarkedPosL - 1]) {
                    case '\n': 
                    case '\u000b': 
                    case '\f': 
                    case '\u0085': 
                    case '\u2028': 
                    case '\u2029': {
                        this.zzAtBOL = true;
                        break;
                    }
                    case '\r': {
                        if (zzMarkedPosL < zzEndReadL) {
                            this.zzAtBOL = zzBufferL[zzMarkedPosL] != '\n';
                            break;
                        }
                        if (this.zzAtEOF) {
                            this.zzAtBOL = false;
                            break;
                        }
                        eof = this.zzRefill();
                        zzMarkedPosL = this.zzMarkedPos;
                        zzEndReadL = this.zzEndRead;
                        zzBufferL = this.zzBuffer;
                        if (eof) {
                            this.zzAtBOL = false;
                            break;
                        }
                        this.zzAtBOL = zzBufferL[zzMarkedPosL] != '\n';
                        break;
                    }
                    default: {
                        this.zzAtBOL = false;
                    }
                }
            }
            int zzAction = -1;
            this.zzCurrentPos = this.zzStartRead = zzMarkedPosL;
            int zzCurrentPosL = this.zzStartRead;
            this.zzState = this.zzAtBOL ? ZZ_LEXSTATE[this.zzLexicalState + 1] : ZZ_LEXSTATE[this.zzLexicalState];
            while (true) {
                if (zzCurrentPosL < zzEndReadL) {
                    zzInput = zzBufferL[zzCurrentPosL++];
                } else {
                    if (this.zzAtEOF) {
                        zzInput = -1;
                        break;
                    }
                    this.zzCurrentPos = zzCurrentPosL;
                    this.zzMarkedPos = zzMarkedPosL;
                    eof = this.zzRefill();
                    zzCurrentPosL = this.zzCurrentPos;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    zzEndReadL = this.zzEndRead;
                    if (eof) {
                        zzInput = -1;
                        break;
                    }
                    zzInput = zzBufferL[zzCurrentPosL++];
                }
                int zzNext = zzTransL[zzRowMapL[this.zzState] + zzCMapL[zzInput]];
                if (zzNext == -1) break;
                this.zzState = zzNext;
                int zzAttributes = zzAttrL[this.zzState];
                if ((zzAttributes & 1) != 1) continue;
                zzAction = this.zzState;
                zzMarkedPosL = zzCurrentPosL;
                if ((zzAttributes & 8) == 8) break;
            }
            this.zzMarkedPos = zzMarkedPosL;
            switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
                case 27: {
                    TBaseBuilderContext builderContext = this.builderContext;
                    builderContext.append(HtmlStringUtil.html((Object)this.yytext(5, 5)));
                }
                case 29: {
                    continue block95;
                }
                case 9: {
                    TBaseBuilderContext builderContext = this.builderContext;
                    builderContext.append(">");
                }
                case 30: {
                    continue block95;
                }
                case 23: {
                    try {
                        TBaseBuilderContext builderContext = this.builderContext;
                        this.clone(this.yytext(2, 2)).processSafe(builderContext);
                    }
                    finally {
                        this.text = null;
                    }
                }
                case 31: {
                    continue block95;
                }
                case 18: {
                    try {
                        this.removeFramingMarkup("*", "strong", false);
                    }
                    finally {
                        this.text = null;
                    }
                }
                case 32: {
                    continue block95;
                }
                case 17: {
                    try {
                        this.removeFramingMarkup("+", "u", false);
                    }
                    finally {
                        this.text = null;
                    }
                }
                case 33: {
                    continue block95;
                }
                case 16: {
                    TBaseBuilderContext builderContext = this.builderContext;
                    builderContext.append(HtmlStringUtil.html((Object)this.yytext(2, 2)));
                }
                case 34: {
                    continue block95;
                }
                case 12: {
                    this.yypushback(1);
                    try {
                        this.NewLinesSimplenewLineCount += this.getText().length();
                    }
                    finally {
                        this.text = null;
                    }
                }
                case 35: {
                    continue block95;
                }
                case 14: {
                    this.yypushback(2);
                    try {
                        this.NewLinesSimplenewLineCount += this.getText().length();
                    }
                    finally {
                        this.text = null;
                    }
                }
                case 36: {
                    continue block95;
                }
                case 26: {
                    TBaseBuilderContext builderContext = this.builderContext;
                    builderContext.append(HtmlStringUtil.html((Object)this.yytext(4, 5)));
                    this.builderContext.append(" ");
                }
                case 37: {
                    continue block95;
                }
                case 28: {
                    try {
                        int beg = this.getText().indexOf(125);
                        TBaseBuilderContext builderContext = this.builderContext;
                        this.clone(this.yytext(beg + 1, this.TextColorercolorSuffixKeyLength)).processSafe(builderContext);
                    }
                    finally {
                        this.text = null;
                    }
                }
                case 38: {
                    continue block95;
                }
                case 24: {
                    TBaseBuilderContext builderContext = this.builderContext;
                    builderContext.append(HtmlStringUtil.html((Object)this.yytext(3, 3)));
                }
                case 39: {
                    continue block95;
                }
                case 5: {
                    TBaseBuilderContext builderContext = this.builderContext;
                    builderContext.append("'");
                }
                case 40: {
                    continue block95;
                }
                case 25: {
                    TBaseBuilderContext builderContext = this.builderContext;
                    builderContext.append(HtmlStringUtil.html((Object)this.yytext(3, 4)));
                    this.builderContext.append(" ");
                }
                case 41: {
                    continue block95;
                }
                case 20: {
                    try {
                        TBaseBuilderContext builderContext = this.builderContext;
                        builderContext.append(HtmlStringUtil.html((Object)this.getText()));
                    }
                    finally {
                        this.text = null;
                    }
                }
                case 42: {
                    continue block95;
                }
                case 4: {
                    TBaseBuilderContext builderContext = this.builderContext;
                    builderContext.append("\r");
                }
                case 43: {
                    continue block95;
                }
                case 7: {
                    TBaseBuilderContext builderContext = this.builderContext;
                    builderContext.append("&");
                }
                case 44: {
                    continue block95;
                }
                case 2: {
                    this.text = null;
                }
                case 45: {
                    continue block95;
                }
                case 10: {
                    TBaseBuilderContext builderContext = this.builderContext;
                    builderContext.append("\"");
                }
                case 46: {
                    continue block95;
                }
                case 22: {
                    TBaseBuilderContext builderContext = this.builderContext;
                    builderContext.append(HtmlStringUtil.html((Object)this.yytext(2, 3)));
                    this.builderContext.append(" ");
                }
                case 47: {
                    continue block95;
                }
                case 19: {
                    try {
                        TBaseBuilderContext builderContext = this.builderContext;
                        builderContext.append("" + this.getText().charAt(2));
                    }
                    finally {
                        this.text = null;
                    }
                }
                case 48: {
                    continue block95;
                }
                case 15: {
                    TBaseBuilderContext builderContext = this.builderContext;
                    builderContext.append(HtmlStringUtil.html((Object)this.yytext(1, 2)));
                    this.builderContext.append(" ");
                }
                case 49: {
                    continue block95;
                }
                case 8: {
                    TBaseBuilderContext builderContext = this.builderContext;
                    builderContext.append("<");
                }
                case 50: {
                    continue block95;
                }
                case 3: {
                    TBaseBuilderContext builderContext = this.builderContext;
                    builderContext.append("\t");
                }
                case 51: {
                    continue block95;
                }
                case 11: {
                    this.yypushback(1);
                    try {
                        this.NewLinesSimplenewLineCount += this.getText().length();
                        for (int i = 0; i < this.NewLinesSimplenewLineCount; ++i) {
                            TBaseBuilderContext builderContext = this.builderContext;
                            builderContext.append("\n");
                        }
                        this.NewLinesSimplenewLineCount = 0;
                    }
                    finally {
                        this.text = null;
                    }
                }
                case 52: {
                    continue block95;
                }
                case 1: {
                    this.builderContext.append(BaseProcessor.characterToStringSafe(this.yycharat(0)));
                }
                case 53: {
                    continue block95;
                }
                case 6: {
                    this.text = null;
                }
                case 54: {
                    continue block95;
                }
                case 21: {
                    try {
                        TBaseBuilderContext builderContext = this.builderContext;
                        this.clone(StringUtils.substring(this.getText(), 2, this.getText().lastIndexOf("|"))).processSafe(builderContext);
                    }
                    finally {
                        this.text = null;
                    }
                }
                case 55: {
                    continue block95;
                }
                case 13: {
                    try {
                        TBaseBuilderContext builderContext = this.builderContext;
                        builderContext.append(this.yytext(1, 0));
                    }
                    finally {
                        this.text = null;
                    }
                }
                case 56: {
                    continue block95;
                }
            }
            if (zzInput == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                return null;
            }
            this.zzScanError(1);
        }
    }
}

