/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.wiki.processor.runtime;

import java.util.ArrayList;
import java.util.List;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.mps.webr.wiki.processor.runtime.IWikiProcessor;
import jetbrains.mps.webr.wiki.processor.runtime.TextColorerProcessorMarkup;
import jetbrains.mps.webr.wiki.processor.runtime.TextColorerProcessorRemoveMarkup;
import jetbrains.mps.webr.wiki.processor.runtime.WikiBlockHelp;
import jetbrains.mps.webr.wiki.processor.runtime.WikiProcessor;
import jetbrains.springframework.configuration.runtime.ServiceLocator;

public class TextColorerProcessor
implements WikiProcessor {
    private static List<WikiBlockHelp> HELP;
    private static boolean HELP_READY;
    private static TextColorerProcessor INSTANCE;

    private TextColorerProcessor() {
    }

    public String clean(String arg) {
        if (arg == null) {
            return null;
        }
        int s = 0;
        for (int i = 0; i < arg.length(); ++i) {
            s += arg.charAt(i) == '\r' ? 0 : 1;
        }
        char[] ar = new char[s];
        s = 0;
        for (int i = 0; i < arg.length(); ++i) {
            if (arg.charAt(i) == '\r') continue;
            ar[s++] = arg.charAt(i);
        }
        return new String(ar);
    }

    @Override
    public IWikiProcessor createProcessor(String s) {
        TextColorerProcessorMarkup result = TextColorerProcessorMarkup.create(this.clean(s));
        return result;
    }

    @Override
    public IWikiProcessor createRemoveMarkupProcessor(String s) {
        TextColorerProcessorRemoveMarkup result = TextColorerProcessorRemoveMarkup.create(this.clean(s));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<WikiBlockHelp> getHelp() {
        if (!HELP_READY) {
            TextColorerProcessor textColorerProcessor = this;
            synchronized (textColorerProcessor) {
                if (!HELP_READY) {
                    HELP = ListSequence.fromList(new ArrayList());
                    ListSequence.fromList(HELP).addElement((Object)new WikiBlockHelp((_FunctionTypes._return_P0_E0<? extends String>)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("TextColorer.You_can_color_your_text_use_keyword_or_#RRGGBB", new Object[0]);
                        }
                    }, (_FunctionTypes._return_P0_E0<? extends String>)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return TextColorerProcessor.concat(new String[]{"{color:green}" + ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("TextColorer.green", new Object[0]) + "{color} " + ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("TextColorer.and", new Object[0]) + " {color:#E6E6FA}" + ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("TextColorer.another_color", new Object[0]) + "{color}"});
                        }
                    }, true));
                    ListSequence.fromList(HELP).addElement((Object)new WikiBlockHelp((_FunctionTypes._return_P0_E0<? extends String>)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("Links.External_link_with_alias", new Object[0]);
                        }
                    }, (_FunctionTypes._return_P0_E0<? extends String>)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return TextColorerProcessor.concat(new String[]{"[http://jetbrains.com JetBrains, Inc.]"});
                        }
                    }, true));
                    ListSequence.fromList(HELP).addElement((Object)new WikiBlockHelp((_FunctionTypes._return_P0_E0<? extends String>)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("Links.External_link_with_alias_", new Object[0]);
                        }
                    }, (_FunctionTypes._return_P0_E0<? extends String>)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return TextColorerProcessor.concat(new String[]{"[JetBrains, Inc.|http://jetbrains.com]"});
                        }
                    }, true));
                    ListSequence.fromList(HELP).addElement((Object)new WikiBlockHelp((_FunctionTypes._return_P0_E0<? extends String>)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("Links.External_link", new Object[0]);
                        }
                    }, (_FunctionTypes._return_P0_E0<? extends String>)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return TextColorerProcessor.concat(new String[]{"http://jetbrains.com", "[http://jetbrains.com]", "<http://jetbrains.com>"});
                        }
                    }, true));
                    ListSequence.fromList(HELP).addElement((Object)new WikiBlockHelp((_FunctionTypes._return_P0_E0<? extends String>)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("Links.Email_address", new Object[0]);
                        }
                    }, (_FunctionTypes._return_P0_E0<? extends String>)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return TextColorerProcessor.concat(new String[]{"<no_reply@jetbrains.com>"});
                        }
                    }, true));
                    HELP_READY = true;
                }
            }
        }
        return HELP;
    }

    public static TextColorerProcessor getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new TextColorerProcessor();
        }
        return INSTANCE;
    }

    private static String concat(String ... strings) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < strings.length; ++i) {
            sb.append(strings[i]);
            if (i >= strings.length - 1) continue;
            sb.append('\n');
        }
        return sb.toString();
    }
}

