/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.wiki.processor.runtime;

import java.util.ArrayList;
import java.util.List;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.mps.webr.wiki.processor.runtime.IWikiProcessor;
import jetbrains.mps.webr.wiki.processor.runtime.WebrWikiMarkup;
import jetbrains.mps.webr.wiki.processor.runtime.WebrWikiRemoveMarkup;
import jetbrains.mps.webr.wiki.processor.runtime.WikiBlockHelp;
import jetbrains.mps.webr.wiki.processor.runtime.WikiProcessor;
import jetbrains.mps.webr.wiki.processor.runtime.WikiUtil;
import jetbrains.springframework.configuration.runtime.ServiceLocator;

public class WebrWiki
implements WikiProcessor {
    private static List<WikiBlockHelp> HELP;
    private static boolean HELP_READY;
    private static WebrWiki INSTANCE;

    private WebrWiki() {
    }

    public String clean(String arg) {
        if (arg == null) {
            return null;
        }
        int s = 0;
        for (int i = 0; i < arg.length(); ++i) {
            s += arg.charAt(i) == '\r' ? 0 : 1;
        }
        char[] ar = new char[s];
        s = 0;
        for (int i = 0; i < arg.length(); ++i) {
            if (arg.charAt(i) == '\r') continue;
            ar[s++] = arg.charAt(i);
        }
        return new String(ar);
    }

    @Override
    public IWikiProcessor createProcessor(String s) {
        WebrWikiMarkup result = WebrWikiMarkup.create(this.clean(s));
        result.setWrapWithDiv(true);
        return result;
    }

    @Override
    public IWikiProcessor createRemoveMarkupProcessor(String s) {
        WebrWikiRemoveMarkup result = WebrWikiRemoveMarkup.create(this.clean(s));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<WikiBlockHelp> getHelp() {
        if (!HELP_READY) {
            WebrWiki webrWiki = this;
            synchronized (webrWiki) {
                if (!HELP_READY) {
                    HELP = ListSequence.fromList(new ArrayList());
                    ListSequence.fromList(HELP).addElement((Object)new WikiBlockHelp((_FunctionTypes._return_P0_E0<? extends String>)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("HtmlText.Subset_of_HTML", new Object[0]);
                        }
                    }, (_FunctionTypes._return_P0_E0<? extends String>)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return WebrWiki.concat(new String[]{WikiUtil.getSampleHtml()});
                        }
                    }, true));
                    ListSequence.fromList(HELP).addElement((Object)new WikiBlockHelp((_FunctionTypes._return_P0_E0<? extends String>)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("Quoting.Reply_quotation", new Object[0]);
                        }
                    }, (_FunctionTypes._return_P0_E0<? extends String>)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return WebrWiki.concat(new String[]{((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("Quoting.{0}Text_to{1}reply_on{2}", new Object[]{">", "\n>", "\n"}) + ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("Quoting.Your_reply", new Object[0]) + ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("Quoting.{0}More_text_to_quote{1}", new Object[]{"\n\n{quote}", "{quote}"})});
                        }
                    }, true));
                    ListSequence.fromList(HELP).addElement((Object)new WikiBlockHelp((_FunctionTypes._return_P0_E0<? extends String>)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("Quoting.Monospace_text", new Object[0]);
                        }
                    }, (_FunctionTypes._return_P0_E0<? extends String>)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return WebrWiki.concat(new String[]{"{monospace}" + ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("Quoting.test", new Object[0]) + "{monospace}"});
                        }
                    }, true));
                    ListSequence.fromList(HELP).addElement((Object)new WikiBlockHelp((_FunctionTypes._return_P0_E0<? extends String>)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("Quoting.Monospace_text2", new Object[0]);
                        }
                    }, (_FunctionTypes._return_P0_E0<? extends String>)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return WebrWiki.concat(new String[]{"{{" + ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("Quoting.text", new Object[0]) + "}}"});
                        }
                    }, true));
                    ListSequence.fromList(HELP).addElement((Object)new WikiBlockHelp((_FunctionTypes._return_P0_E0<? extends String>)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("Quoting.Text_without_wiki_formatting", new Object[0]);
                        }
                    }, (_FunctionTypes._return_P0_E0<? extends String>)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return WebrWiki.concat(new String[]{"{noformat}*" + ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("Quoting.link", new Object[0]) + "* [http://www.ya.ru]{noformat}"});
                        }
                    }, true));
                    ListSequence.fromList(HELP).addElement((Object)new WikiBlockHelp((_FunctionTypes._return_P0_E0<? extends String>)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("Quoting.Collapsible_block", new Object[0]);
                        }
                    }, (_FunctionTypes._return_P0_E0<? extends String>)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return WebrWiki.concat(new String[]{"{cut " + ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("Quoting.Head_of_block", new Object[0]) + "} " + ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("Quoting.Internal_block", new Object[0]) + "{cut}"});
                        }
                    }, true));
                    ListSequence.fromList(HELP).addElement((Object)new WikiBlockHelp((_FunctionTypes._return_P0_E0<? extends String>)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("TextColorer.You_can_color_your_text_use_keyword_or_#RRGGBB", new Object[0]);
                        }
                    }, (_FunctionTypes._return_P0_E0<? extends String>)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return WebrWiki.concat(new String[]{"{color:green}" + ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("TextColorer.green", new Object[0]) + "{color} " + ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("TextColorer.and", new Object[0]) + " {color:#E6E6FA}" + ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("TextColorer.another_color", new Object[0]) + "{color}"});
                        }
                    }, true));
                    ListSequence.fromList(HELP).addElement((Object)new WikiBlockHelp((_FunctionTypes._return_P0_E0<? extends String>)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("UniversalStacktraceCaller.Exception", new Object[0]);
                        }
                    }, (_FunctionTypes._return_P0_E0<? extends String>)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return WebrWiki.concat(new String[]{WikiUtil.getSampleStackTrace()});
                        }
                    }, true));
                    ListSequence.fromList(HELP).addElement((Object)new WikiBlockHelp((_FunctionTypes._return_P0_E0<? extends String>)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("HighlightCaller.Code_markup_with_parameters", new Object[0]);
                        }
                    }, (_FunctionTypes._return_P0_E0<? extends String>)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return WebrWiki.concat(new String[]{"{code:lang=scala|title=Code}object HelloWorld {\n  def main(args: Array[String]) {\n    println(\"Hello, world!\")\n  }\n}{code}"});
                        }
                    }, true));
                    ListSequence.fromList(HELP).addElement((Object)new WikiBlockHelp((_FunctionTypes._return_P0_E0<? extends String>)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return WikiUtil.getCodeHelpText();
                        }
                    }, (_FunctionTypes._return_P0_E0<? extends String>)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return WebrWiki.concat(new String[]{"{code lang=hs}\n-- Point-free style\nfib :: Integer -> Integer\nfib = (fibs !!)\n       where fibs = 0 : scanl (+) 1 fibs\n \n-- Explicit\nfib :: Integer -> Integer\nfib n = fibs !! n\n        where fibs = 0 : scanl (+) 1 fibs\n{code}\n\n```css\n.wikicode {\n  background-color: #f9f9f9;\n  border: 1px dashed  #2f6fab;\n  color: black;\n  line-height: 140%;\n  padding: 5px 10px;\n  overflow-x: auto;\n}\n```\n\n```\ninput.translate(string.maketrans(\"ATGC\", \"TACG\"))[::-1]\n```"});
                        }
                    }, false));
                    ListSequence.fromList(HELP).addElement((Object)new WikiBlockHelp((_FunctionTypes._return_P0_E0<? extends String>)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("HighlightCaller.Inline-code_highlighter", new Object[0]);
                        }
                    }, (_FunctionTypes._return_P0_E0<? extends String>)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return WebrWiki.concat(new String[]{"`char[] buffer = new char[256];`\n``char[] buffer = new char[256];``"});
                        }
                    }, true));
                    ListSequence.fromList(HELP).addElement((Object)new WikiBlockHelp((_FunctionTypes._return_P0_E0<? extends String>)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("Table.Tables", new Object[0]);
                        }
                    }, (_FunctionTypes._return_P0_E0<? extends String>)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return WebrWiki.concat(new String[]{"||a||b||\n|a|b|"});
                        }
                    }, true));
                    ListSequence.fromList(HELP).addElement((Object)new WikiBlockHelp((_FunctionTypes._return_P0_E0<? extends String>)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("RichText.Level_4_header", new Object[]{4});
                        }
                    }, (_FunctionTypes._return_P0_E0<? extends String>)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return WebrWiki.concat(new String[]{"====" + ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("RichText.Level_4_header_sample", new Object[]{4}) + "====\r\n"});
                        }
                    }, true));
                    ListSequence.fromList(HELP).addElement((Object)new WikiBlockHelp((_FunctionTypes._return_P0_E0<? extends String>)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("RichText.Level_3_header", new Object[]{3});
                        }
                    }, (_FunctionTypes._return_P0_E0<? extends String>)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return WebrWiki.concat(new String[]{"===" + ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("RichText.Level_3_header_sample", new Object[]{3}) + "===\r\n"});
                        }
                    }, true));
                    ListSequence.fromList(HELP).addElement((Object)new WikiBlockHelp((_FunctionTypes._return_P0_E0<? extends String>)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("RichText.Level_2_header", new Object[]{2});
                        }
                    }, (_FunctionTypes._return_P0_E0<? extends String>)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return WebrWiki.concat(new String[]{"==" + ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("RichText.Level_2_header_sample", new Object[]{2}) + "==\r\n"});
                        }
                    }, true));
                    ListSequence.fromList(HELP).addElement((Object)new WikiBlockHelp((_FunctionTypes._return_P0_E0<? extends String>)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("RichText.Level_1_header", new Object[]{1});
                        }
                    }, (_FunctionTypes._return_P0_E0<? extends String>)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return WebrWiki.concat(new String[]{"=" + ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("RichText.Level_1_header_sample", new Object[]{1}) + "=\r\n"});
                        }
                    }, true));
                    ListSequence.fromList(HELP).addElement((Object)new WikiBlockHelp((_FunctionTypes._return_P0_E0<? extends String>)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("RichText.Bold_italic", new Object[0]);
                        }
                    }, (_FunctionTypes._return_P0_E0<? extends String>)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return WebrWiki.concat(new String[]{"'''''" + ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("RichText.Bold_italic_sample", new Object[0]) + "'''''"});
                        }
                    }, true));
                    ListSequence.fromList(HELP).addElement((Object)new WikiBlockHelp((_FunctionTypes._return_P0_E0<? extends String>)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("RichText.Bold", new Object[0]);
                        }
                    }, (_FunctionTypes._return_P0_E0<? extends String>)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return WebrWiki.concat(new String[]{"'''" + ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("RichText.Bold_sample", new Object[0]) + "'''"});
                        }
                    }, true));
                    ListSequence.fromList(HELP).addElement((Object)new WikiBlockHelp((_FunctionTypes._return_P0_E0<? extends String>)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("RichText.Italic", new Object[0]);
                        }
                    }, (_FunctionTypes._return_P0_E0<? extends String>)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return WebrWiki.concat(new String[]{"''" + ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("RichText.Italic_sample", new Object[0]) + "''"});
                        }
                    }, true));
                    ListSequence.fromList(HELP).addElement((Object)new WikiBlockHelp((_FunctionTypes._return_P0_E0<? extends String>)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("RichText.Strike", new Object[0]);
                        }
                    }, (_FunctionTypes._return_P0_E0<? extends String>)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return WebrWiki.concat(new String[]{"--" + ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("RichText.deleted", new Object[0]) + "--"});
                        }
                    }, true));
                    ListSequence.fromList(HELP).addElement((Object)new WikiBlockHelp((_FunctionTypes._return_P0_E0<? extends String>)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("RichText.Line_break", new Object[0]);
                        }
                    }, (_FunctionTypes._return_P0_E0<? extends String>)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return WebrWiki.concat(new String[]{((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("RichText.first_line", new Object[0]), "-----", ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("RichText.second_line", new Object[0])});
                        }
                    }, true));
                    ListSequence.fromList(HELP).addElement((Object)new WikiBlockHelp((_FunctionTypes._return_P0_E0<? extends String>)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("RichText.Adds_text_on_mouseover", new Object[0]);
                        }
                    }, (_FunctionTypes._return_P0_E0<? extends String>)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return WebrWiki.concat(new String[]{"~~" + ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("RichText.Text", new Object[0]) + "|" + ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("RichText.Text_on_mouseover", new Object[0]) + "~~"});
                        }
                    }, true));
                    ListSequence.fromList(HELP).addElement((Object)new WikiBlockHelp((_FunctionTypes._return_P0_E0<? extends String>)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("RichText.Underline", new Object[0]);
                        }
                    }, (_FunctionTypes._return_P0_E0<? extends String>)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return WebrWiki.concat(new String[]{"+" + ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("RichText.Underline_sample", new Object[0]) + "+"});
                        }
                    }, true));
                    ListSequence.fromList(HELP).addElement((Object)new WikiBlockHelp((_FunctionTypes._return_P0_E0<? extends String>)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("RichText.Bold_a", new Object[0]);
                        }
                    }, (_FunctionTypes._return_P0_E0<? extends String>)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return WebrWiki.concat(new String[]{"*" + ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("RichText.Bold_a_sample", new Object[0]) + "*"});
                        }
                    }, true));
                    ListSequence.fromList(HELP).addElement((Object)new WikiBlockHelp((_FunctionTypes._return_P0_E0<? extends String>)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("Lists.Lists", new Object[0]);
                        }
                    }, (_FunctionTypes._return_P0_E0<? extends String>)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return WebrWiki.concat(new String[]{"* " + ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("Lists.first", new Object[0]), "* " + ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("Lists.second", new Object[0]), "* " + ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("Lists.third", new Object[0]), "# " + ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("Lists.first1", new Object[0]), "# " + ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("Lists.second1", new Object[0]), "# " + ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("Lists.third1", new Object[0]), "* " + ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("Lists.first2", new Object[0]), "*# " + ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("Lists.second2", new Object[0]), "*#- " + ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("Lists.second3", new Object[0]) + " I", "*#- " + ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("Lists.second4", new Object[0]) + " II", "*# " + ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("Lists.third2", new Object[0])});
                        }
                    }, true));
                    ListSequence.fromList(HELP).addElement((Object)new WikiBlockHelp((_FunctionTypes._return_P0_E0<? extends String>)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("Links.External_link_with_alias", new Object[0]);
                        }
                    }, (_FunctionTypes._return_P0_E0<? extends String>)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return WebrWiki.concat(new String[]{"[http://jetbrains.com JetBrains, Inc.]"});
                        }
                    }, true));
                    ListSequence.fromList(HELP).addElement((Object)new WikiBlockHelp((_FunctionTypes._return_P0_E0<? extends String>)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("Links.External_link_with_alias_", new Object[0]);
                        }
                    }, (_FunctionTypes._return_P0_E0<? extends String>)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return WebrWiki.concat(new String[]{"[JetBrains, Inc.|http://jetbrains.com]"});
                        }
                    }, true));
                    ListSequence.fromList(HELP).addElement((Object)new WikiBlockHelp((_FunctionTypes._return_P0_E0<? extends String>)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("Links.External_link", new Object[0]);
                        }
                    }, (_FunctionTypes._return_P0_E0<? extends String>)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return WebrWiki.concat(new String[]{"http://jetbrains.com", "[http://jetbrains.com]", "<http://jetbrains.com>"});
                        }
                    }, true));
                    ListSequence.fromList(HELP).addElement((Object)new WikiBlockHelp((_FunctionTypes._return_P0_E0<? extends String>)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("Links.Email_address", new Object[0]);
                        }
                    }, (_FunctionTypes._return_P0_E0<? extends String>)new _FunctionTypes._return_P0_E0<String>(){

                        public String invoke() {
                            return WebrWiki.concat(new String[]{"<no_reply@jetbrains.com>"});
                        }
                    }, true));
                    HELP_READY = true;
                }
            }
        }
        return HELP;
    }

    public static WebrWiki getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new WebrWiki();
        }
        return INSTANCE;
    }

    private static String concat(String ... strings) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < strings.length; ++i) {
            sb.append(strings[i]);
            if (i >= strings.length - 1) continue;
            sb.append('\n');
        }
        return sb.toString();
    }
}

