/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.wiki.processor.runtime.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import jetbrains.mps.webr.wiki.processor.runtime.HtmlAttributeMatcher;
import jetbrains.mps.webr.wiki.processor.runtime.HtmlAttributeMatcherMarkup;
import jetbrains.mps.webr.wiki.processor.runtime.utils.AttributeCreator;
import jetbrains.mps.webr.wiki.processor.runtime.utils.HtmlAttribute;
import jetbrains.mps.webr.wiki.processor.runtime.utils.StyleAttributeCreator;
import jetbrains.mps.webr.wiki.processor.runtime.utils.TagTitle;
import jetbrains.mps.webr.wiki.processor.runtime.utils.TypeAttributeCreator;

public class AttributeManufacture {
    public static final String CLASS = "class";
    private static final AttributeCreator[] DEFAULT_CREATORS = new AttributeCreator[]{new StyleAttributeCreator(), new TypeAttributeCreator()};
    private final Map<String, AttributeCreator> attributeProcessors = MapSequence.fromMap(new HashMap());
    private String baseUrl = "";

    public AttributeManufacture() {
        this.addAttributeCreators(DEFAULT_CREATORS);
    }

    public AttributeManufacture(AttributeCreator ... creators) {
        this();
        this.addAttributeCreators(creators);
    }

    public AttributeManufacture(String baseUrl, AttributeCreator ... creators) {
        this();
        this.baseUrl = baseUrl;
        this.addAttributeCreators(creators);
    }

    private void addAttributeCreators(AttributeCreator ... creators) {
        for (int i = 0; i < creators.length; ++i) {
            MapSequence.fromMap(this.attributeProcessors).put((Object)creators[i].acceptableAttributeKey(), (Object)creators[i]);
        }
    }

    private ArrayList<HtmlAttribute> parse(String attributes, ArrayList<HtmlAttribute> result, TagTitle tag) {
        String out = ((HtmlAttributeMatcherMarkup)HtmlAttributeMatcher.getInstance().createProcessor(attributes)).setHtmlAttributeMatcher_attributeProcessors(this.attributeProcessors).setHtmlAttributeMatcher_prevResultSize(result.size()).setHtmlAttributeMatcher_result(result).setHtmlAttributeMatcher_tag(tag).setHtmlAttributeMatcher_baseUrl(this.baseUrl).processSafe();
        return result;
    }

    public ArrayList<HtmlAttribute> getAttributes(String attributes, TagTitle tag, String additionalStyleClass) {
        ArrayList<HtmlAttribute> result = this.getAttributes(tag, additionalStyleClass);
        return this.parse(attributes, result, tag);
    }

    public ArrayList<HtmlAttribute> getAttributes(TagTitle tag, String additionalStyleClass) {
        ArrayList<HtmlAttribute> result = new ArrayList<HtmlAttribute>();
        if (tag.classRequired()) {
            String classValue = AttributeManufacture.getStyleClasses(tag, additionalStyleClass);
            result.add(new HtmlAttribute(CLASS, classValue));
        }
        return result;
    }

    private static String getStyleClasses(TagTitle tag, String additionalStyleClass) {
        if (additionalStyleClass == null || additionalStyleClass.length() == 0) {
            return tag.getClassName();
        }
        StringBuilder sb = new StringBuilder(tag.getClassName());
        sb.append('-');
        sb.append(additionalStyleClass);
        return sb.toString();
    }
}

