/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.wiki.processor.runtime.utils;

import jetbrains.mps.webr.wiki.processor.runtime.utils.HtmlTag;
import jetbrains.mps.webr.wiki.processor.runtime.utils.StringUtils;
import jetbrains.mps.webr.wiki.processor.runtime.utils.TagTitle;

public class ClosingHtmlTag
extends HtmlTag {
    public ClosingHtmlTag(String text) {
        super(text);
        this.init();
    }

    @Override
    public boolean isOpeningTag() {
        return false;
    }

    @Override
    protected void parse(String parsingString) {
        int idx = parsingString.indexOf(">");
        String title = StringUtils.substring(parsingString, 2, idx);
        this.tagTitle = TagTitle.parse(StringUtils.stripEnd(title, " \n\r\t"));
    }

    @Override
    protected String stringPresentation() {
        StringBuilder builder = new StringBuilder("</");
        builder.append(this.getTagTitle().toString());
        builder.append(">");
        return builder.toString();
    }
}

