/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.wiki.processor.runtime.utils;

import java.util.regex.Pattern;
import webr.framework.function.HtmlStringUtil;

public class HtmlAttribute {
    private static String JAVASCRIPT_PREFIX = "javascript";
    private static String VBSCRIPT_PREFIX = "vbscript";
    private static String DATA_PREFIX = "data";
    private static String EXPRESSION_PREFIX = "expression";
    private static Pattern DANGEROUS_SYMBOLS_PATTERN = Pattern.compile("([&][#][x]?[0-9]{1,3})|[\t]");
    private static int CHECKED_PREFIX_LENGTH = JAVASCRIPT_PREFIX.length() + "&#116;".length();
    private String myKey;
    private String myValue;

    public HtmlAttribute(String key, String value) {
        this.set(key, value == null ? null : value.trim());
    }

    private void set(String key, String value) {
        String valuePrefix = value.substring(0, Math.min(value.length(), CHECKED_PREFIX_LENGTH)).toLowerCase();
        if (valuePrefix.startsWith(JAVASCRIPT_PREFIX) || valuePrefix.startsWith(VBSCRIPT_PREFIX) || valuePrefix.startsWith(DATA_PREFIX) || valuePrefix.startsWith(EXPRESSION_PREFIX)) {
            return;
        }
        if (DANGEROUS_SYMBOLS_PATTERN.matcher(valuePrefix).find()) {
            return;
        }
        this.setKey(key);
        this.setValue(HtmlStringUtil.doubleToSingleQuotes((String)value));
    }

    public String getKey() {
        return this.myKey;
    }

    private void setKey(String value) {
        this.myKey = value;
    }

    public String getValue() {
        return this.myValue;
    }

    public void setValue(String value) {
        this.myValue = value;
    }
}

