/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.wiki.processor.runtime.utils;

import jetbrains.mps.webr.wiki.processor.runtime.utils.TagTitle;
import jetbrains.mps.webr.wiki.processor.runtime.utils.TagType;

public abstract class HtmlTag {
    protected TagTitle tagTitle;
    private final String text;
    private String emptyPrefix;
    private String emptySuffix;

    public HtmlTag(String text) {
        this.text = text;
    }

    protected void init() {
        this.parse(this.text == null ? null : this.text.trim());
        if (this.tagTitle != null && this.tagTitle.isInline()) {
            int idx = this.text.indexOf("<");
            this.emptyPrefix = idx > 0 ? this.filteredSubstring(0, idx) : "";
            idx = this.text.lastIndexOf(">");
            this.emptySuffix = idx > 0 && idx < this.text.length() - 1 ? this.filteredSubstring(idx + 1, this.text.length()) : "";
        } else {
            this.emptyPrefix = "";
            this.emptySuffix = "";
        }
    }

    public boolean isValidTag() {
        return this.tagTitle != null && this.tagTitle.getType() == TagType.VALID;
    }

    public String getText() {
        return this.text;
    }

    public boolean isIgnoredTag() {
        return this.tagTitle != null && this.tagTitle.getType() == TagType.IGNORED;
    }

    public boolean isIgnoredTagWithIgnoredBody() {
        return this.tagTitle != null && this.tagTitle.getType() == TagType.IGNORED_TAG_WITH_IGNORED_BODY;
    }

    public TagTitle getTagTitle() {
        return this.tagTitle;
    }

    public abstract boolean isOpeningTag();

    protected abstract void parse(String var1);

    protected abstract String stringPresentation();

    public final String toString() {
        if (!this.tagTitle.isInline()) {
            return this.stringPresentation();
        }
        StringBuilder builder = new StringBuilder();
        if (this.emptyPrefix.length() > 0) {
            builder.append(this.emptyPrefix);
        }
        builder.append(this.stringPresentation());
        if (this.emptySuffix.length() > 0) {
            builder.append(this.emptySuffix);
        }
        return builder.toString();
    }

    private String filteredSubstring(int begin, int end) {
        return this.text.substring(begin, end).replaceAll("\r", "");
    }
}

