/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.wiki.processor.runtime.utils;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jetbrains.mps.internal.collections.runtime.SetSequence;
import jetbrains.mps.webr.wiki.processor.runtime.utils.AttributeCreator;
import jetbrains.mps.webr.wiki.processor.runtime.utils.HtmlAttribute;
import jetbrains.mps.webr.wiki.processor.runtime.utils.TagTitle;

public class StyleAttributeCreator
implements AttributeCreator {
    private static final Pattern CSS_EXPRESSION = Pattern.compile("[a-zA-Z][a-zA-Z0-9-_]*[ \r\n\t]*[:][ \r\n\t]*[^;]+([;]|([;]?$))");
    private static final Set<String> ALLOWED_PROPERTIES = SetSequence.fromSetAndArray(new HashSet(), (Object[])new String[]{"outline-width", "outline", "margin-top", "margin-bottom", "margin-right", "margin-left", "margin", "padding-top", "padding-bottom", "padding-right", "padding-left", "padding", "border-width", "border-top-width", "border-right-width", "border-bottom-width", "border-left-width", "border-top-color", "border-left-color", "border-right-color", "border-bottom-color", "border-color", "border-style", "border-top", "border-bottom", "border-right", "border-left", "border", "display", "float", "clear", "width", "min-width", "max-width", "height", "max-height", "min-height", "line-height", "vertical-align", "overflow", "overflow-x", "overflow-y", "visibility", "list-style-type", "list-style-image", "list-style-position", "list-style", "color", "background-color", "background-image", "background-repeat", "background-position", "background", "font-family", "font-style", "font-variant", "font-weight", "absolute-size", "relative-size", "font-size", "font", "text-indent", "text-align", "text-decoration", "letter-spacing", "word-spacing", "text-transform", "white-space", "table-layout", "border-collapse", "border-spacing", "empty-cells"});
    private static final String JAVASCRIPT = "javascript";
    private static final String EXPRESSION = "expression";
    private static final String ACCEPTABLE_ATTRIBUTE_KEY = "style";

    @Override
    public HtmlAttribute create(String attributeValue, TagTitle tag) {
        Matcher matcher = CSS_EXPRESSION.matcher(attributeValue);
        StringBuilder result = new StringBuilder();
        while (matcher.find()) {
            String value;
            String expression = matcher.group();
            int separatorIdx = expression.indexOf(":");
            String key = StyleAttributeCreator.trim_585scw_a0a0c0d0a(expression.substring(0, separatorIdx)).toLowerCase();
            if (!SetSequence.fromSet(ALLOWED_PROPERTIES).contains((Object)key)) continue;
            int length = expression.length();
            if (expression.charAt(expression.length() - 1) == ';') {
                --length;
            }
            if ((value = StyleAttributeCreator.trim_585scw_a0a2a3a3a0(expression.substring(separatorIdx + 1, length))) == null || value.length() <= 0 || (value = value.toLowerCase()).contains(JAVASCRIPT) || value.contains(EXPRESSION)) continue;
            result.append(key);
            result.append(":");
            result.append(value);
            result.append(";");
        }
        return new HtmlAttribute(ACCEPTABLE_ATTRIBUTE_KEY, result.toString());
    }

    @Override
    public String acceptableAttributeKey() {
        return ACCEPTABLE_ATTRIBUTE_KEY;
    }

    public static String trim_585scw_a0a0c0d0a(String str) {
        return str == null ? null : str.trim();
    }

    public static String trim_585scw_a0a2a3a3a0(String str) {
        return str == null ? null : str.trim();
    }
}

