/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.wiki.processor.runtime.utils;

import java.util.LinkedList;
import java.util.ListIterator;
import jetbrains.mps.gtext.runtime.TBaseBuilderContext;
import jetbrains.mps.webr.wiki.processor.runtime.IWikiProcessor;
import jetbrains.mps.webr.wiki.processor.runtime.utils.ClosingHtmlTag;
import jetbrains.mps.webr.wiki.processor.runtime.utils.HtmlTag;
import jetbrains.mps.webr.wiki.processor.runtime.utils.OpeningHtmlTag;
import jetbrains.mps.webr.wiki.processor.runtime.utils.StringUtils;
import jetbrains.mps.webr.wiki.processor.runtime.utils.TagTitle;
import webr.framework.textBuilder.TBuilderContext;

public class TagStack {
    private LinkedList<TagContextPair> tags = new LinkedList();
    private LinkedList<UnclosedTagPositionPair> unclosedTags = new LinkedList();

    public TBaseBuilderContext openTag(OpeningHtmlTag tag, TBaseBuilderContext context) {
        if (tag.getTagTitle().canBeUnclosed() && tag.isValidTag()) {
            this.unclosedTags.addLast(new UnclosedTagPositionPair(tag.getTagTitle(), this.tags.size()));
            return context;
        }
        this.tags.addLast(new TagContextPair(tag, context));
        TBuilderContext newContext = new TBuilderContext();
        newContext.initBuffer();
        return newContext;
    }

    public TBaseBuilderContext closeTag(ClosingHtmlTag tag, TBaseBuilderContext context, IWikiProcessor processor) {
        if (tag.getTagTitle().canBeUnclosed() && tag.isValidTag()) {
            UnclosedTagPositionPair pair;
            ListIterator<UnclosedTagPositionPair> it = this.unclosedTags.listIterator(this.unclosedTags.size());
            boolean hasValidOpeningTag = false;
            while (it.hasPrevious()) {
                pair = it.previous();
                if (pair.getTagTitle() != tag.tagTitle || pair.getPosition() != this.tags.size()) continue;
                hasValidOpeningTag = true;
                break;
            }
            if (hasValidOpeningTag) {
                it = this.unclosedTags.listIterator(this.unclosedTags.size());
                while (it.hasPrevious()) {
                    pair = it.previous();
                    if (pair.getTagTitle() == tag.tagTitle && pair.getPosition() == this.tags.size()) {
                        context.append(tag.toString());
                        it.remove();
                        break;
                    }
                    it.remove();
                }
            }
            return context;
        }
        ListIterator<TagContextPair> it = this.tags.listIterator(this.tags.size());
        boolean hasValidOpenTag = false;
        TagContextPair p = null;
        int idx = this.tags.size();
        while (it.hasPrevious()) {
            --idx;
            p = it.previous();
            if (p.tag.getTagTitle() == tag.getTagTitle()) {
                hasValidOpenTag = true;
                break;
            }
            if (p.tag.getTagTitle().canBeUnclosed()) continue;
        }
        if (!hasValidOpenTag) {
            return context;
        }
        if (tag.isIgnoredTagWithIgnoredBody()) {
            while (this.tags.removeLast().getTag().getTagTitle() != p.tag.getTagTitle()) {
            }
            return p.context;
        }
        TBaseBuilderContext c = p == null ? context : p.context;
        TBaseBuilderContext result = this.closeTagsWhile(idx, c, processor);
        if (!tag.isIgnoredTagWithIgnoredBody()) {
            result.append(context.getText());
            if (!tag.isIgnoredTag()) {
                this.appendTag((HtmlTag)tag, result);
            }
        }
        return result;
    }

    public TBaseBuilderContext closeTag(ClosingHtmlTag tag, TBaseBuilderContext context, IWikiProcessor processor, boolean noMarkup) {
        if (noMarkup) {
            TagContextPair pair;
            ListIterator<TagContextPair> it = this.tags.listIterator(this.tags.size());
            boolean hasValidOpeningTag = false;
            while (it.hasPrevious()) {
                pair = it.previous();
                if (pair.getTag().getTagTitle() != tag.tagTitle) continue;
                hasValidOpeningTag = true;
                break;
            }
            if (hasValidOpeningTag) {
                it = this.tags.listIterator(this.tags.size());
                while (it.hasPrevious()) {
                    pair = it.previous();
                    it.remove();
                    if (pair.getTag().getTagTitle() != tag.tagTitle) continue;
                    return pair.getContext();
                }
            }
            return context;
        }
        return this.closeTag(tag, context, processor);
    }

    public TBaseBuilderContext closeTagsWhile(int stopIdx, TBaseBuilderContext context, IWikiProcessor processor) {
        return this.closeTagsWhile(stopIdx, context, null, processor);
    }

    private TBaseBuilderContext closeTagsWhile(int stopIdx, TBaseBuilderContext context, TBaseBuilderContext currentContext, IWikiProcessor processor) {
        StringBuilder builder = new StringBuilder();
        int start = stopIdx >= 0 ? stopIdx : 0;
        ListIterator<TagContextPair> it = this.tags.listIterator(start);
        int idx = start;
        while (it.hasNext()) {
            TagContextPair pair = (TagContextPair)it.next();
            if (idx != start) {
                builder.append(pair.getContext().getText());
            }
            if ((idx == stopIdx || pair.getTag().getTagTitle().canBeUnclosed()) && pair.getTag().isValidTag()) {
                builder.append(pair.getTag().toString());
            }
            it.remove();
            ++idx;
        }
        if (stopIdx >= 0) {
            context.append(builder.toString());
        } else {
            if (currentContext != null) {
                builder.append(currentContext.getText());
            }
            String t = builder.toString();
            processor.clone(t).processSafe(context);
        }
        return context;
    }

    public TBaseBuilderContext closeAllTags(TBaseBuilderContext context, IWikiProcessor processor, boolean noMarkup) {
        if (noMarkup) {
            this.unclosedTags.clear();
            if (this.tags.isEmpty()) {
                return context;
            }
            TBaseBuilderContext result = this.tags.getFirst().getContext();
            ListIterator<TagContextPair> it = this.tags.listIterator(1);
            while (it.hasNext()) {
                result.append(it.next().getContext().getText());
            }
            result.append(StringUtils.stripEnd(context.getText(), " \n\r\t"));
            return result;
        }
        return this.closeAllTags(context, processor);
    }

    public TBaseBuilderContext closeAllTags(TBaseBuilderContext context, IWikiProcessor processor) {
        this.unclosedTags.clear();
        if (this.tags.isEmpty()) {
            return context;
        }
        TBaseBuilderContext result = this.closeTagsWhile(-1, this.tags.getFirst().getContext(), context, processor);
        return result;
    }

    public boolean isEmpty() {
        return this.tags.isEmpty();
    }

    public int size() {
        return this.tags.size();
    }

    private void appendTag(HtmlTag tag, TBaseBuilderContext context) {
        String tagStr = tag.toString();
        if (this.isEmpty() && !tag.isOpeningTag() && tag.getTagTitle().isInline()) {
            tagStr = StringUtils.stripEnd(tagStr, " \n\r\t");
        }
        if (!tag.isIgnoredTag()) {
            context.append(tagStr);
        }
    }

    private void appendTag(HtmlTag tag, StringBuilder context) {
        String tagStr = tag.toString();
        if (this.isEmpty() && !tag.isOpeningTag() && tag.getTagTitle().isInline()) {
            tagStr = StringUtils.stripEnd(tagStr, " \n\r\t");
        }
        if (!tag.isIgnoredTag()) {
            context.append(tagStr);
        }
    }

    private class UnclosedTagPositionPair {
        private TagTitle myTagTitle;
        private int myPosition;

        public UnclosedTagPositionPair(TagTitle title, int position) {
            this.setTagTitle(title);
            this.setPosition(position);
        }

        public TagTitle getTagTitle() {
            return this.myTagTitle;
        }

        public void setTagTitle(TagTitle value) {
            this.myTagTitle = value;
        }

        public int getPosition() {
            return this.myPosition;
        }

        public void setPosition(int value) {
            this.myPosition = value;
        }
    }

    public class TagContextPair {
        private final HtmlTag tag;
        private final TBaseBuilderContext context;

        public TagContextPair(HtmlTag tag, TBaseBuilderContext context) {
            this.tag = tag;
            this.context = context;
        }

        public HtmlTag getTag() {
            return this.tag;
        }

        public TBaseBuilderContext getContext() {
            return this.context;
        }
    }
}

