/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.wiki.processor.runtime.utils;

import jetbrains.mps.webr.wiki.processor.runtime.utils.TagType;

public enum TagTitle {
    a(TagType.VALID, true, false),
    abbr(TagType.VALID, true, false),
    acronym(TagType.VALID, true, false),
    address(TagType.VALID, false, false),
    area(TagType.VALID, false, true),
    b(TagType.VALID, true, false),
    bdo(TagType.VALID, true, false),
    big(TagType.VALID, true, false),
    blockquote(TagType.VALID, false, false, "wiki quote"),
    br(TagType.VALID, true, true),
    wbr(TagType.VALID, true, true),
    button(TagType.VALID, true, true, "wiki-parsed-html"),
    caption(TagType.VALID, false, false, "wiki-parsed-html"),
    center(TagType.VALID, true, false),
    cite(TagType.VALID, true, false),
    code(TagType.VALID, true, false, "inline-code"),
    col(TagType.VALID, false, true),
    colgroup(TagType.VALID, false, false),
    dd(TagType.VALID, false, false),
    del(TagType.VALID, true, false),
    dfn(TagType.VALID, true, false),
    dir(TagType.VALID, false, false),
    div(TagType.VALID, false, false, "wiki-parsed-html"),
    dl(TagType.VALID, false, false),
    em(TagType.VALID, true, false),
    font(TagType.VALID, true, true),
    fieldset(TagType.REPLACED_BY_DIV, false, false),
    frame(TagType.REPLACED_BY_DIV, false, true),
    frameset(TagType.REPLACED_BY_DIV, false, false),
    h1(TagType.VALID, false, false),
    h2(TagType.VALID, false, false),
    h3(TagType.VALID, false, false),
    h4(TagType.VALID, false, false),
    h5(TagType.VALID, false, false),
    h6(TagType.VALID, false, false),
    hr(TagType.VALID, false, true),
    i(TagType.VALID, true, false),
    iframe(TagType.REPLACED_BY_DIV, false, false),
    img(TagType.VALID, false, true, "wiki picture"),
    input(TagType.VALID, false, true, "wiki-parsed-html"),
    ins(TagType.VALID, true, false),
    kbd(TagType.VALID, true, false),
    label(TagType.VALID, false, false, "wiki-parsed-html"),
    legend(TagType.VALID, false, false, "wiki-parsed-html"),
    li(TagType.VALID, false, false, "wiki-parsed-html"),
    map(TagType.VALID, false, false, "wiki-parsed-html"),
    menu(TagType.VALID, false, false, "wiki-parsed-html"),
    noframes(TagType.IGNORED, false, false),
    ol(TagType.VALID, false, false, "wiki-list0"),
    optgroup(TagType.VALID, false, false, "wiki-parsed-html"),
    option(TagType.VALID, false, false, "wiki-parsed-html"),
    p(TagType.VALID, false, false, "wiki-parsed-html"),
    q(TagType.VALID, true, false),
    pre(TagType.VALID, false, false, "wikicode"),
    s(TagType.VALID, true, false),
    samp(TagType.VALID, true, false),
    select(TagType.VALID, false, false, "wiki-parsed-html"),
    small(TagType.VALID, true, false),
    span(TagType.VALID, true, false, "wiki-parsed-html"),
    strike(TagType.VALID, true, false),
    strong(TagType.VALID, true, false),
    sub(TagType.VALID, true, false),
    sup(TagType.VALID, true, false),
    table(TagType.VALID, false, false, "wiki-tbl"),
    tbody(TagType.VALID, false, false),
    thead(TagType.VALID, false, false),
    td(TagType.VALID, false, false, "wiki-tbl-td"),
    textarea(TagType.VALID, false, false, "wiki-parsed-html"),
    tfoot(TagType.VALID, false, false),
    th(TagType.VALID, false, false, "wiki-tbl-th"),
    thread(TagType.VALID, false, false),
    tr(TagType.VALID, false, false),
    tt(TagType.VALID, false, false),
    u(TagType.VALID, true, false),
    ul(TagType.VALID, false, false, "wiki-list0"),
    var(TagType.VALID, true, false),
    form(TagType.REPLACED_BY_DIV, false, false, "wiki-parsed-html"),
    body(TagType.IGNORED, false, false),
    html(TagType.IGNORED, false, false),
    noscript(TagType.IGNORED, false, false),
    script(TagType.IGNORED_TAG_WITH_IGNORED_BODY, false, false),
    style(TagType.IGNORED_TAG_WITH_IGNORED_BODY, false, false),
    applet(TagType.IGNORED_TAG_WITH_IGNORED_BODY, false, true),
    base(TagType.IGNORED_TAG_WITH_IGNORED_BODY, false, true),
    link(TagType.IGNORED_TAG_WITH_IGNORED_BODY, false, true),
    object(TagType.IGNORED_TAG_WITH_IGNORED_BODY, false, true),
    param(TagType.IGNORED_TAG_WITH_IGNORED_BODY, false, true),
    head(TagType.IGNORED_TAG_WITH_IGNORED_BODY, false, false),
    meta(TagType.IGNORED_TAG_WITH_IGNORED_BODY, false, true),
    title(TagType.IGNORED_TAG_WITH_IGNORED_BODY, false, false),
    basefont(TagType.IGNORED_TAG_WITH_IGNORED_BODY, false, true);

    private final TagType type;
    private final boolean isInline;
    private final boolean canBeUnclosed;
    private final String className;

    private TagTitle(TagType type, boolean isInline, boolean canBeUnclosed) {
        this(type, isInline, canBeUnclosed, "");
    }

    private TagTitle(TagType type, boolean isInline, boolean canBeUnclosed, String className) {
        this.type = type;
        this.isInline = isInline;
        this.canBeUnclosed = canBeUnclosed;
        this.className = className;
    }

    public TagType getType() {
        return this.type;
    }

    public boolean isInline() {
        return this.isInline;
    }

    public boolean canBeUnclosed() {
        return this.canBeUnclosed;
    }

    public boolean classRequired() {
        return this.className != null && this.className.length() > 0;
    }

    public String getClassName() {
        return this.className;
    }

    public static TagTitle parse(String title) {
        if (title == null || title.length() == 0) {
            return null;
        }
        TagTitle t = null;
        int endOfTagPrefix = title.indexOf(58);
        if (endOfTagPrefix > -1 && endOfTagPrefix < title.length() - 1) {
            title = title.substring(endOfTagPrefix + 1);
        }
        try {
            t = TagTitle.valueOf(title.toLowerCase());
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
        if (t.getType() == TagType.REPLACED_BY_DIV) {
            t = div;
        }
        return t;
    }
}

