/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.service.util.cmd;

import com.jetbrains.service.util.cmd.InterruptableInputStream;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogStreamThread
extends Thread {
    private final InputStream myInput;
    private final boolean myLogToConsoleFlag;
    private final String myLogToConsolePrefix;
    private final boolean myAddToBufferFlag;
    private final AtomicBoolean myFailed = new AtomicBoolean(false);
    private final AtomicBoolean myInterruptFlag = new AtomicBoolean(false);
    private volatile StringBuilder myOutputString = new StringBuilder();
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());

    public LogStreamThread(@NotNull InputStream input, String logPrefix) {
        this(input, logPrefix != null, logPrefix != null ? logPrefix : "", true);
    }

    public LogStreamThread(@NotNull InputStream input, boolean logToConsole, @NotNull String logPrefix, boolean addToBuffer) {
        this.myInput = input;
        this.myLogToConsoleFlag = logToConsole;
        this.myLogToConsolePrefix = logPrefix;
        this.myAddToBufferFlag = addToBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            String line;
            InterruptableInputStream in = new InterruptableInputStream(this.myInput, this.myInterruptFlag);
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, Charset.forName("UTF-8")));
            while ((line = br.readLine()) != null) {
                if (this.myLogToConsoleFlag) {
                    System.out.println(this.myLogToConsolePrefix + line);
                }
                if (!this.myAddToBufferFlag) continue;
                if (this.myOutputString.length() != 0) {
                    this.myOutputString.append(System.lineSeparator());
                }
                this.myOutputString.append(line);
            }
        }
        catch (InterruptedIOException line) {
        }
        catch (Throwable e) {
            this.LOG.error("Error in reading stream", e);
            this.myFailed.set(true);
        }
        finally {
            this.closeNoThrow();
        }
    }

    public void setInterruptFlag() {
        this.myInterruptFlag.set(true);
    }

    private void closeNoThrow() {
        try {
            this.myInput.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @NotNull
    public String getOutputString() {
        return this.myOutputString.toString();
    }

    public boolean isFailed() {
        return this.myFailed.get();
    }

    public boolean isInterruptFlagSet() {
        return this.myInterruptFlag.get();
    }
}

