/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.service.util.contract.service;

import com.jetbrains.service.util.BundleProperty;
import com.jetbrains.service.util.ConfiguratorUtils;
import com.jetbrains.service.util.PropertiesUtil;
import com.jetbrains.service.util.ServiceProperties;
import com.jetbrains.service.util.StatusException;
import com.jetbrains.service.util.SystemUtil;
import com.jetbrains.service.util.contract.service.ConfigurableService;
import com.jetbrains.service.util.contract.service.context.CommonContextProvider;
import com.jetbrains.service.util.contract.service.context.ConfiguringContextProvider;
import com.jetbrains.service.util.logging.log4j.LoggingUtil;
import com.jetbrains.service.util.properties.impl.PropertiesBasedConfigurationHelper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurableServiceBase
implements ConfigurableService {
    public static final String CONVENIENT_SERVICE_CONFIG_PROPERTIES = "service-config.properties";
    public static final String CONVENIENT_BUNDLE_IN_PROCESS_SERVICE_CONFIG_PATH_PROPERTY = "bundle-in-process-service-config-path";
    public static final String SERVICE_CONFIG_PROPERTIES = "service-config.properties";

    @Override
    public void configure(@NotNull ConfiguringContextProvider contextProvider) {
        if (!LoggingUtil.isConfigured()) {
            LoggingUtil.setupConsoleLogging(contextProvider.isDebugEnabled());
        }
        Properties commandLineProperties = this.getCommandLineProperties(contextProvider);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.getDefaultProperties(contextProvider));
        Properties existingProperties = this.getAllProperties(contextProvider);
        this.removeOneTimeProperties(existingProperties, commandLineProperties);
        properties.putAll((Map<?, ?>)existingProperties);
        properties.putAll((Map<?, ?>)commandLineProperties);
        this.configure(properties, contextProvider);
    }

    private void removeOneTimeProperties(@NotNull Properties allProperties, @NotNull Properties cliProperties) {
        Collection<String> allServices = PropertiesBasedConfigurationHelper.getHelper().getServices(allProperties);
        for (String property : this.getOneTimeProperties(cliProperties)) {
            allProperties.remove(property);
            if (property.startsWith("bundle.")) continue;
            for (String serviceId : allServices) {
                allProperties.remove(PropertiesBasedConfigurationHelper.getHelper().getPrefixedPropertyName(serviceId, property));
            }
        }
    }

    protected List<String> getOneTimeProperties(@NotNull Properties cliProperties) {
        ArrayList<String> oneTimeProperties = new ArrayList<String>();
        oneTimeProperties.add("bundledin");
        if (cliProperties.containsKey(BundleProperty.INSTALLATION_UUID.getPrefixedName())) {
            oneTimeProperties.addAll(Arrays.asList("license-key", "license-user-name", "hub-url", BundleProperty.HUB_URL.getPrefixedName(), BundleProperty.LOCALE.getPrefixedName(), BundleProperty.ROOT_PASSWORD.getPrefixedName()));
        }
        return oneTimeProperties;
    }

    @NotNull
    private Properties getCommandLineProperties(ConfiguringContextProvider serviceConfigurationProvider) {
        return PropertiesUtil.convertToProperties(serviceConfigurationProvider.getNewProperties());
    }

    protected void configure(@NotNull Properties properties, @NotNull CommonContextProvider contextProvider) {
        this.setTempDir(properties);
        ConfiguratorUtils.savePropertiesFile(this.getConfigPath(contextProvider), properties);
        this.createConvenientConfigFileIfNeeded(properties, contextProvider);
    }

    protected Logger getLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }

    @NotNull
    protected final File getServiceHome(@NotNull CommonContextProvider contextProvider) {
        return contextProvider.getServiceHome();
    }

    @NotNull
    protected final File getConfFolder(@NotNull CommonContextProvider contextProvider) {
        return contextProvider.getAppConfFolder();
    }

    @NotNull
    public String getServicePresentableName(@NotNull Properties serviceProperties) {
        return this.getMandatoryProperty("presentation-service-name", serviceProperties);
    }

    @NotNull
    protected String getServiceCookieName() {
        return "JSESSIONID";
    }

    @NotNull
    protected File getConfigPath(@NotNull CommonContextProvider contextProvider) {
        return this.getConvenientConfigFile(contextProvider);
    }

    @NotNull
    protected final File getConvenientConfigFile(@NotNull CommonContextProvider contextProvider) {
        return new File(this.getConfFolder(contextProvider), "service-config.properties");
    }

    @NotNull
    public final String getMandatoryProperty(@NotNull String propertyName, @NotNull Properties properties) {
        String value = properties.getProperty(propertyName);
        if (value == null) {
            throw new StatusException(String.format("Mandatory config property '%s' is not found in config file", propertyName));
        }
        return value;
    }

    @NotNull
    public Properties getAllProperties(@NotNull CommonContextProvider contextProvider) {
        Properties ps = new Properties();
        ps.putAll((Map<?, ?>)this.getDefaultProperties(contextProvider));
        File configPath = this.getConfigPath(contextProvider);
        if (configPath.exists()) {
            ps.putAll((Map<?, ?>)ConfiguratorUtils.loadPropertiesFile(configPath));
        } else if (LoggingUtil.isConfigured()) {
            this.getLogger().debug(String.format("Properties file %s is not found", configPath));
        }
        return ps;
    }

    @NotNull
    protected Properties getDefaultProperties(@NotNull CommonContextProvider contextProvider) {
        Properties ps = new Properties();
        ps.setProperty("org.eclipse.jetty.servlet.SessionCookie", this.getServiceCookieName());
        ps.setProperty("org.eclipse.jetty.servlet.SessionIdPathParameterName", this.getServiceCookieName().toLowerCase());
        return ps;
    }

    public final void setTempDir(@NotNull Properties properties) {
        try {
            SystemUtil.setTempDir(Paths.get(PropertiesBasedConfigurationHelper.getHelper().getMandatoryServiceProperty(properties, ServiceProperties.TEMP_DIR_PROPERTY), new String[0]));
        }
        catch (IOException e) {
            this.getLogger().warn(String.format("Cannot set temp dir for service %s", this.getServicePresentableName(properties)), (Throwable)e);
        }
    }

    private void createConvenientConfigFileIfNeeded(@NotNull Properties properties, @NotNull CommonContextProvider contextProvider) {
        File convenientConfigPathForBundleInProcessService;
        File configPath;
        if (properties.containsKey("bundledin") && !(configPath = this.getConfigPath(contextProvider)).equals(convenientConfigPathForBundleInProcessService = this.getConvenientConfigFile(contextProvider))) {
            Properties inProcessProperties = new Properties();
            inProcessProperties.setProperty(CONVENIENT_BUNDLE_IN_PROCESS_SERVICE_CONFIG_PATH_PROPERTY, configPath.getAbsolutePath());
            ConfiguratorUtils.savePropertiesFile(convenientConfigPathForBundleInProcessService, inProcessProperties);
        }
        this.removeLegacyConvenientConfigFile(contextProvider);
    }

    private void removeLegacyConvenientConfigFile(@NotNull CommonContextProvider contextProvider) {
        File legacyConvenientConfigFile = new File(this.getServiceHome(contextProvider), "service-config.properties");
        try {
            Files.deleteIfExists(legacyConvenientConfigFile.toPath());
        }
        catch (Exception e) {
            this.getLogger().debug(String.format("Can not remove legacy config file: [%s]", legacyConvenientConfigFile.getPath()), (Throwable)e);
        }
    }
}

