/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.client.resource;

import com.intellij.hub.auth.InvalidTokenException;
import com.intellij.hub.auth.TokenVerification;
import com.intellij.hub.auth.basic.BasicAuthToken;
import com.intellij.hub.auth.oauth2.consumer.TokenHolder;
import com.intellij.hub.auth.oauth2.token.AccessToken;
import com.intellij.hub.auth.oauth2.token.GuestToken;
import com.intellij.hub.auth.oauth2.token.PermanentToken;
import java.util.Collection;
import java.util.List;
import jetbrains.jetpass.api.authority.auth.TokenInfo;
import jetbrains.jetpass.client.accounts.BaseAccountsClient;
import jetbrains.jetpass.client.accounts.Partial;
import jetbrains.jetpass.client.resource.DSAPublicKeySource;
import jetbrains.jetpass.client.resource.PermanentTokenCache;
import jetbrains.jetpass.rest.dto.UserJSON;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\bJ\u000e\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\bJ\u000e\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\bJ\u0010\u0010\u001b\u001a\u00020\u001c2\b\u0010\u0016\u001a\u0004\u0018\u00010\bJ\u0012\u0010\u001d\u001a\u0004\u0018\u00010\b2\b\u0010\u0016\u001a\u0004\u0018\u00010\bJ\u0010\u0010\u001e\u001a\u00020\b2\b\u0010\u0016\u001a\u0004\u0018\u00010\bJ\u000e\u0010\u001f\u001a\u00020\u00152\u0006\u0010 \u001a\u00020\u0015J\u000e\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u001cR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u001b\u0010\r\u001a\u00020\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\f\u001a\u0004\b\u000e\u0010\nR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006!"}, d2={"Ljetbrains/jetpass/client/resource/RequestValidator;", "", "client", "Ljetbrains/jetpass/client/accounts/BaseAccountsClient;", "permanentTokenCache", "Ljetbrains/jetpass/client/resource/PermanentTokenCache;", "(Ljetbrains/jetpass/client/accounts/BaseAccountsClient;Ljetbrains/jetpass/client/resource/PermanentTokenCache;)V", "clientServiceId", "", "getClientServiceId", "()Ljava/lang/String;", "clientServiceId$delegate", "Lkotlin/Lazy;", "guestId", "getGuestId", "guestId$delegate", "keySource", "Ljetbrains/jetpass/client/resource/DSAPublicKeySource;", "getPermanentTokenCache", "()Ljetbrains/jetpass/client/resource/PermanentTokenCache;", "getAccessToken", "Lcom/intellij/hub/auth/oauth2/token/AccessToken;", "header", "getAccessTokenFromBasic", "basicAuthorizationHeader", "getAccessTokenFromBearer", "bearerAuthorizationHeader", "getTokenInfo", "Ljetbrains/jetpass/api/authority/auth/TokenInfo;", "getUserId", "getUserIdOrGuestId", "verify", "token", "jetbrains.jetpass.client.accounts"})
public final class RequestValidator {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @NotNull
    private final Lazy guestId$delegate;
    @NotNull
    private final Lazy clientServiceId$delegate;
    private final DSAPublicKeySource keySource;
    private final BaseAccountsClient client;
    @NotNull
    private final PermanentTokenCache permanentTokenCache;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(RequestValidator.class), "guestId", "getGuestId()Ljava/lang/String;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(RequestValidator.class), "clientServiceId", "getClientServiceId()Ljava/lang/String;"))};
    }

    @NotNull
    public final String getGuestId() {
        Lazy lazy = this.guestId$delegate;
        RequestValidator requestValidator = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (String)lazy.getValue();
    }

    @NotNull
    public final String getClientServiceId() {
        Lazy lazy = this.clientServiceId$delegate;
        RequestValidator requestValidator = this;
        KProperty kProperty = $$delegatedProperties[1];
        return (String)lazy.getValue();
    }

    @Nullable
    public final String getUserId(@Nullable String header2) throws InvalidTokenException {
        String string;
        String string2;
        String it;
        CharSequence charSequence;
        String string3 = header2;
        if (string3 != null && (string3 = !((charSequence = (CharSequence)(it = (string2 = string3))).length() == 0) ? string2 : null) != null) {
            it = string2 = string3;
            string = this.getTokenInfo(header2).getUser();
        } else {
            string = null;
        }
        return string;
    }

    @NotNull
    public final String getUserIdOrGuestId(@Nullable String header2) throws InvalidTokenException {
        String string;
        CharSequence charSequence;
        if (header2 == null || (charSequence = (CharSequence)header2).length() == 0) {
            string = this.getGuestId();
        } else {
            String string2 = this.getTokenInfo(header2).getUser();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"getTokenInfo(header).user");
        }
        return string;
    }

    @NotNull
    public final AccessToken getAccessToken(@Nullable String header2) throws InvalidTokenException {
        AccessToken accessToken;
        if (header2 != null && AccessToken.Companion.isBearer(header2)) {
            accessToken = this.getAccessTokenFromBearer(header2);
        } else if (header2 != null && BasicAuthToken.Companion.isBasic(header2)) {
            accessToken = this.getAccessTokenFromBasic(header2);
        } else {
            throw (Throwable)InvalidTokenException.Companion.invalidAuthHeaderType();
        }
        AccessToken token = accessToken;
        return this.verify(token);
    }

    @NotNull
    public final TokenInfo getTokenInfo(@Nullable String header2) throws InvalidTokenException {
        TokenInfo tokenInfo;
        if (header2 != null && PermanentToken.Companion.isPermanentTokenHeader(header2)) {
            PermanentToken permanentToken = PermanentToken.Companion.decodeHeader(header2);
            TokenInfo t = this.permanentTokenCache.getTokenInfo(permanentToken);
            tokenInfo = this.verify(t);
        } else if (header2 != null && GuestToken.isGuestTokenHeader((String)header2)) {
            String clientServiceId2 = this.getClientServiceId();
            tokenInfo = new TokenInfo(this, clientServiceId2){
                final /* synthetic */ RequestValidator this$0;
                final /* synthetic */ String $clientServiceId;

                @Nullable
                public String getId() {
                    return null;
                }

                @NotNull
                public String getClient() {
                    return this.$clientServiceId;
                }

                @NotNull
                public String getUser() {
                    return this.this$0.getGuestId();
                }

                @NotNull
                public List<String> getScope() {
                    return CollectionsKt.listOf((Object)this.$clientServiceId);
                }
                {
                    this.this$0 = $outer;
                    this.$clientServiceId = $captured_local_variable$1;
                }
            };
        } else {
            AccessToken accessToken = this.getAccessToken(header2);
            tokenInfo = new TokenInfo(accessToken){
                final /* synthetic */ AccessToken $accessToken;

                @Nullable
                public String getId() {
                    return null;
                }

                @NotNull
                public String getClient() {
                    return this.$accessToken.getData().getClient();
                }

                @Nullable
                public String getUser() {
                    return this.$accessToken.getData().getUser();
                }

                @NotNull
                public List<String> getScope() {
                    return ArraysKt.toList((Object[])this.$accessToken.getData().getScope());
                }
                {
                    this.$accessToken = $captured_local_variable$0;
                }
            };
        }
        return tokenInfo;
    }

    @NotNull
    public final AccessToken getAccessTokenFromBasic(@NotNull String basicAuthorizationHeader) throws InvalidTokenException {
        Intrinsics.checkParameterIsNotNull((Object)basicAuthorizationHeader, (String)"basicAuthorizationHeader");
        BasicAuthToken basic = BasicAuthToken.Companion.decodeHeader(basicAuthorizationHeader);
        TokenHolder<?> tokenHolder = this.client.getTokenHolder();
        if (tokenHolder == null) {
            Intrinsics.throwNpe();
        }
        return tokenHolder.getToken(basic).getAccessToken();
    }

    @NotNull
    public final AccessToken getAccessTokenFromBearer(@NotNull String bearerAuthorizationHeader) throws InvalidTokenException {
        Intrinsics.checkParameterIsNotNull((Object)bearerAuthorizationHeader, (String)"bearerAuthorizationHeader");
        return AccessToken.Companion.decodeHeader(bearerAuthorizationHeader);
    }

    @NotNull
    public final AccessToken verify(@NotNull AccessToken token) throws InvalidTokenException {
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        String clientServiceId2 = this.getClientServiceId();
        TokenVerification.verifyScope((AccessToken)token, (String)clientServiceId2);
        TokenVerification.verifyExpiration((AccessToken)token);
        TokenVerification.verifySignature((AccessToken)token, (com.intellij.hub.auth.oauth2.provider.source.DSAPublicKeySource)((com.intellij.hub.auth.oauth2.provider.source.DSAPublicKeySource)this.keySource));
        return token;
    }

    @NotNull
    public final TokenInfo verify(@NotNull TokenInfo token) throws InvalidTokenException {
        Collection $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        String clientServiceId2 = this.getClientServiceId();
        Iterable iterable = token.getScope();
        Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"token.scope");
        Collection collection = $receiver$iv = (Collection)CollectionsKt.toList((Iterable)iterable);
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = collection;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        TokenVerification.verifyScope((String[])stringArray, (String)clientServiceId2);
        return token;
    }

    @NotNull
    public final PermanentTokenCache getPermanentTokenCache() {
        return this.permanentTokenCache;
    }

    public RequestValidator(@NotNull BaseAccountsClient client, @NotNull PermanentTokenCache permanentTokenCache) {
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Intrinsics.checkParameterIsNotNull((Object)permanentTokenCache, (String)"permanentTokenCache");
        this.client = client;
        this.permanentTokenCache = permanentTokenCache;
        this.guestId$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ RequestValidator this$0;

            @NotNull
            public final String invoke() {
                UserJSON userJSON = RequestValidator.access$getClient$p(this.this$0).getGuest(Partial.user(Partial.User.ID));
                if (userJSON == null) {
                    Intrinsics.throwNpe();
                }
                String string = userJSON.getId();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                return string;
            }
            {
                this.this$0 = requestValidator;
                super(0);
            }
        }));
        this.clientServiceId$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ RequestValidator this$0;

            @NotNull
            public final String invoke() {
                String string = RequestValidator.access$getClient$p(this.this$0).getClientServiceId();
                if (string == null) {
                    throw (Throwable)new IllegalStateException("Unable to verify empty serviceId");
                }
                return string;
            }
            {
                this.this$0 = requestValidator;
                super(0);
            }
        }));
        this.keySource = new DSAPublicKeySource(this.client.getHubClient());
    }

    @NotNull
    public static final /* synthetic */ BaseAccountsClient access$getClient$p(RequestValidator $this) {
        return $this.client;
    }
}

