/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.importing.rest;

import java.util.List;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import jetbrains.jetpass.importing.dto.json.ImportReportJSON;
import jetbrains.jetpass.importing.dto.json.UserBundleJSON;
import jetbrains.jetpass.importing.dto.json.UserGroupBundleJSON;
import jetbrains.jetpass.importing.rest.UserGroupImporter;
import jetbrains.jetpass.importing.rest.UserImporter;
import jetbrains.jetpass.oauth2.rest.security.OAuth;
import jetbrains.jetpass.oauth2.rest.security.OAuthResourceFilter;
import jetbrains.jetpass.oauth2.rest.security.SecurityContext;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Path(value="/import")
@Produces(value={"application/json;charset=UTF-8"})
@OAuth
@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\bH\u0007\u00a8\u0006\t"}, d2={"Ljetbrains/jetpass/importing/rest/ImportResource;", "", "()V", "uploadGroups", "Ljetbrains/jetpass/importing/dto/json/ImportReportJSON;", "bundle", "Ljetbrains/jetpass/importing/dto/json/UserGroupBundleJSON;", "uploadUsers", "Ljetbrains/jetpass/importing/dto/json/UserBundleJSON;", "jetbrains.jetpass.importing"})
public final class ImportResource {
    @POST
    @Path(value="/users")
    @NotNull
    public final ImportReportJSON uploadUsers(@NotNull UserBundleJSON bundle) {
        Intrinsics.checkParameterIsNotNull((Object)bundle, (String)"bundle");
        SecurityContext securityContext = OAuthResourceFilter.Companion.getSecurityContext();
        if (securityContext == null) {
            Intrinsics.throwNpe();
        }
        UserImporter importer = new UserImporter(securityContext);
        List list = bundle.getUsers();
        return importer.importAll(list != null ? (Iterable)list : (Iterable)CollectionsKt.emptyList());
    }

    @POST
    @Path(value="/groups")
    @NotNull
    public final ImportReportJSON uploadGroups(@NotNull UserGroupBundleJSON bundle) {
        Intrinsics.checkParameterIsNotNull((Object)bundle, (String)"bundle");
        SecurityContext securityContext = OAuthResourceFilter.Companion.getSecurityContext();
        if (securityContext == null) {
            Intrinsics.throwNpe();
        }
        UserGroupImporter importer = new UserGroupImporter(securityContext);
        List list = bundle.getGroups();
        return importer.importAll(list != null ? (Iterable)list : (Iterable)CollectionsKt.emptyList());
    }
}

