/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.integration.upsource.service;

import jetbrains.youtrack.integration.persistence.XdVcsChange;
import jetbrains.youtrack.integration.persistence.XdVcsServer;
import jetbrains.youtrack.integration.service.VcsService;
import jetbrains.youtrack.integration.vcs.CommonChangeDTO;
import jetbrains.youtrack.upsource.dto.UpsourceChangeDTO;
import jetbrains.youtrack.upsource.persistence.XdUpsourceChangesProcessor;
import jetbrains.youtrack.upsource.persistence.XdUpsourceServer;
import jetbrains.youtrack.upsource.rest.UpsourceChange;
import jetbrains.youtrack.upsource.rest.UpsourceRest;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

@Service(value="upsourceService")
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0005H\u0016J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Ljetbrains/youtrack/integration/upsource/service/UpsourceService;", "Ljetbrains/youtrack/integration/service/VcsService;", "Ljetbrains/youtrack/upsource/persistence/XdUpsourceChangesProcessor;", "()V", "integrationType", "", "getIntegrationType", "()Ljava/lang/String;", "getCommit", "Ljetbrains/youtrack/integration/vcs/CommonChangeDTO;", "changesProcessor", "hash", "getLogPrefix", "toDto", "Ljetbrains/youtrack/upsource/dto/UpsourceChangeDTO;", "vcsChange", "Ljetbrains/youtrack/integration/persistence/XdVcsChange;", "youtrack-upsource-integration"})
public final class UpsourceService
extends VcsService<XdUpsourceChangesProcessor> {
    @NotNull
    private final String integrationType = "Upsource";

    @NotNull
    public String getIntegrationType() {
        return this.integrationType;
    }

    @Nullable
    public CommonChangeDTO getCommit(@NotNull XdUpsourceChangesProcessor changesProcessor, @NotNull String hash) {
        CommonChangeDTO commonChangeDTO;
        UpsourceChange commit;
        Intrinsics.checkParameterIsNotNull((Object)((Object)changesProcessor), (String)"changesProcessor");
        Intrinsics.checkParameterIsNotNull((Object)hash, (String)"hash");
        XdVcsServer xdVcsServer = changesProcessor.getServer();
        if (xdVcsServer == null) {
            throw new TypeCastException("null cannot be cast to non-null type jetbrains.youtrack.upsource.persistence.XdUpsourceServer");
        }
        XdUpsourceServer uServer = (XdUpsourceServer)xdVcsServer;
        UpsourceRest rest = uServer.getRest();
        UpsourceChange upsourceChange = commit = rest.getCommit(changesProcessor.getUpsourceHubResourceKey(), hash);
        if (upsourceChange != null) {
            UpsourceChange upsourceChange2;
            UpsourceChange it = upsourceChange2 = upsourceChange;
            boolean bl = false;
            commonChangeDTO = uServer.toDto(changesProcessor, it);
        } else {
            commonChangeDTO = null;
        }
        return commonChangeDTO;
    }

    @NotNull
    public String getLogPrefix(@NotNull XdUpsourceChangesProcessor changesProcessor) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)changesProcessor), (String)"changesProcessor");
        return "Upsource Integration [" + changesProcessor.getProject().getShortName() + "<-" + changesProcessor.getUpsourceProjectName() + '(' + changesProcessor.getUpsourceHubResourceKey() + ")]: ";
    }

    @NotNull
    public UpsourceChangeDTO toDto(@NotNull XdVcsChange vcsChange) {
        UpsourceChangeDTO upsourceChangeDTO;
        Intrinsics.checkParameterIsNotNull((Object)vcsChange, (String)"vcsChange");
        UpsourceChangeDTO $receiver = upsourceChangeDTO = new UpsourceChangeDTO();
        boolean bl = false;
        this.tweakChangeDto(vcsChange, $receiver);
        return upsourceChangeDTO;
    }
}

