/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.dao.util;

import java.util.Iterator;
import jetbrains.jetpass.dao.util.AbstractPersistent23Tree;
import jetbrains.jetpass.dao.util.Pair;

public class Persistent23Tree<K extends Comparable<K>> {
    private AbstractPersistent23Tree.RootNode<K> root;

    public Persistent23Tree() {
        this(null);
    }

    Persistent23Tree(AbstractPersistent23Tree.RootNode<K> root) {
        this.root = root;
    }

    public ImmutableTree<K> getCurrent() {
        return new ImmutableTree<K>(this.root);
    }

    public int size() {
        AbstractPersistent23Tree.RootNode<K> currentRoot = this.root;
        return currentRoot == null ? 0 : currentRoot.getSize();
    }

    public Persistent23Tree<K> getClone() {
        return new Persistent23Tree<K>(this.root);
    }

    public MutableTree<K> beginWrite() {
        return new MutableTree(this);
    }

    boolean endWrite(MutableTree<K> tree) {
        if (this.root != tree.getStartingRoot()) {
            return false;
        }
        this.root = tree.getRoot();
        return true;
    }

    AbstractPersistent23Tree.RootNode<K> getRoot() {
        return this.root;
    }

    public static class MutableTree<K extends Comparable<K>>
    extends AbstractPersistent23Tree<K> {
        private final Persistent23Tree<K> baseTree;
        private AbstractPersistent23Tree.RootNode<K> startingRoot;
        private AbstractPersistent23Tree.RootNode<K> root;

        MutableTree(Persistent23Tree<K> tree) {
            this.startingRoot = tree.getRoot();
            this.root = this.startingRoot;
            this.baseTree = tree;
        }

        public void add(K key) {
            if (this.root == null) {
                this.root = new AbstractPersistent23Tree.RootBinaryNode<K>(key, 1);
            } else {
                AbstractPersistent23Tree.SplitResult<K> splitResult = this.root.insert(key);
                int size = splitResult.sizeChanged ? this.root.getSize() + 1 : this.root.getSize();
                this.root = splitResult.getSecondNode() == null ? splitResult.getFirstNode().asRoot(size) : new AbstractPersistent23Tree.RootInternalBinaryNode<K>(splitResult.getFirstNode(), splitResult.getKey(), splitResult.getSecondNode(), size);
            }
        }

        public boolean exclude(K key) {
            if (this.root == null) {
                return false;
            }
            Pair<AbstractPersistent23Tree.Node<K>, K> removeResult = this.root.remove(key, true);
            if (removeResult == null) {
                return false;
            }
            AbstractPersistent23Tree.Node<K> result = removeResult.getFirst();
            if (result instanceof AbstractPersistent23Tree.RemovedNode) {
                result = result.getFirstChild();
            }
            this.root = result == null ? null : result.asRoot(this.root.getSize() - 1);
            return true;
        }

        public void addAll(Iterable<K> keys, int size) {
            this.addAll(keys.iterator(), size);
        }

        public void addAll(Iterator<K> keys, int size) {
            if (!this.isEmpty()) {
                throw new UnsupportedOperationException();
            }
            this.root = this.makeRootNode(keys, size, 1);
        }

        public boolean endWrite() {
            if (this.baseTree.endWrite(this)) {
                this.startingRoot = this.root;
                return true;
            }
            return false;
        }

        private AbstractPersistent23Tree.Node<K> makeNode(Iterator<K> iterator, int size, int toDepth) {
            if (size <= 0) {
                return null;
            }
            int left = size;
            AbstractPersistent23Tree.Node<Comparable> node = null;
            int depth = 1;
            int minSize = 0;
            int maxSize = 0;
            while (left > 0) {
                int minUp;
                int up;
                int third;
                int second;
                if (depth >= toDepth) {
                    if (left <= maxSize + 1) {
                        return MutableTree.createNode(node, (Comparable)iterator.next(), this.makeNode(iterator, left - 1, depth - 1));
                    }
                    if (left <= 2 * maxSize + 2) {
                        int third2 = Math.max(left - 2 - maxSize, minSize);
                        return MutableTree.createNode(node, (Comparable)iterator.next(), this.makeNode(iterator, left - 2 - third2, depth - 1), (Comparable)iterator.next(), this.makeNode(iterator, third2, depth - 1));
                    }
                }
                if ((second = left - 3 - (third = Math.max(left - (up = Math.max(left - 3 - 2 * maxSize, minUp = (1 << Math.max(toDepth, depth + 1)) - (1 << depth) - 1)) - 3 - maxSize, minSize)) - up) >= minSize) {
                    node = MutableTree.createNode(node, (Comparable)iterator.next(), this.makeNode(iterator, second, depth - 1), (Comparable)iterator.next(), this.makeNode(iterator, third, depth - 1));
                    left -= second + third + 2;
                } else {
                    up = Math.max(left - 2 - maxSize, minUp);
                    second = left - 2 - up;
                    node = MutableTree.createNode(node, (Comparable)iterator.next(), this.makeNode(iterator, second, depth - 1));
                    left -= second + 1;
                }
                maxSize = maxSize * 3 + 2;
                minSize = minSize * 2 + 1;
                ++depth;
            }
            return node;
        }

        private AbstractPersistent23Tree.RootNode<K> makeRootNode(Iterator<K> iterator, int size, int toDepth) {
            if (size <= 0) {
                return null;
            }
            int left = size;
            AbstractPersistent23Tree.Node<Comparable> node = null;
            int depth = 1;
            int minSize = 0;
            int maxSize = 0;
            while (true) {
                int minUp;
                int up;
                int third;
                int second;
                if (depth >= toDepth) {
                    if (left <= maxSize + 1) {
                        return MutableTree.createRootNode(node, (Comparable)iterator.next(), this.makeNode(iterator, left - 1, depth - 1), size);
                    }
                    if (left <= 2 * maxSize + 2) {
                        int third2 = Math.max(left - 2 - maxSize, minSize);
                        return MutableTree.createRootNode(node, (Comparable)iterator.next(), this.makeNode(iterator, left - 2 - third2, depth - 1), (Comparable)iterator.next(), this.makeNode(iterator, third2, depth - 1), size);
                    }
                }
                if ((second = left - 3 - (third = Math.max(left - (up = Math.max(left - 3 - 2 * maxSize, minUp = (1 << Math.max(toDepth, depth + 1)) - (1 << depth) - 1)) - 3 - maxSize, minSize)) - up) >= minSize) {
                    if ((left -= second + third + 2) <= 0) {
                        return MutableTree.createRootNode(node, (Comparable)iterator.next(), this.makeNode(iterator, second, depth - 1), (Comparable)iterator.next(), this.makeNode(iterator, third, depth - 1), size);
                    }
                    node = MutableTree.createNode(node, (Comparable)iterator.next(), this.makeNode(iterator, second, depth - 1), (Comparable)iterator.next(), this.makeNode(iterator, third, depth - 1));
                } else {
                    if ((left -= (second = left - 2 - (up = Math.max(left - 2 - maxSize, minUp))) + 1) <= 0) {
                        return MutableTree.createRootNode(node, (Comparable)iterator.next(), this.makeNode(iterator, second, depth - 1), size);
                    }
                    node = MutableTree.createNode(node, (Comparable)iterator.next(), this.makeNode(iterator, second, depth - 1));
                }
                maxSize = maxSize * 3 + 2;
                minSize = minSize * 2 + 1;
                ++depth;
            }
        }

        @Override
        AbstractPersistent23Tree.RootNode<K> getRoot() {
            return this.root;
        }

        void setRoot(AbstractPersistent23Tree.RootNode<K> node) {
            this.root = node;
        }

        AbstractPersistent23Tree.Node<K> getStartingRoot() {
            return this.startingRoot;
        }

        void checkTip() {
            if (this.root != null) {
                MutableTree.checkNode(this.root);
            }
        }
    }

    public static class ImmutableTree<K extends Comparable<K>>
    extends AbstractPersistent23Tree<K> {
        private final AbstractPersistent23Tree.RootNode<K> root;

        ImmutableTree(AbstractPersistent23Tree.RootNode<K> root) {
            this.root = root;
        }

        @Override
        AbstractPersistent23Tree.RootNode<K> getRoot() {
            return this.root;
        }
    }
}

