/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.dao.access.view;

import java.util.List;
import jetbrains.jetpass.api.IdItem;
import jetbrains.jetpass.api.Service;
import jetbrains.jetpass.api.authority.AuthorityHolder;
import jetbrains.jetpass.api.authority.User;
import jetbrains.jetpass.api.authority.UserGroup;
import jetbrains.jetpass.api.security.Permission;
import jetbrains.jetpass.api.security.Project;
import jetbrains.jetpass.api.security.ProjectRole;
import jetbrains.jetpass.api.security.Role;
import jetbrains.jetpass.dao.access.view.AccessGrantOption;
import jetbrains.jetpass.dao.access.view.AddGroupOption;
import jetbrains.jetpass.dao.access.view.AddNewGroupOption;
import jetbrains.jetpass.dao.access.view.GrantRoleOption;
import jetbrains.jetpass.dao.api.permissionCache.PermissionCache;
import jetbrains.jetpass.dao.api.permissionCache.PermissionQuery;
import jetbrains.jetpass.dao.dnq.api.JetPassDAOContainer;
import jetbrains.jetpass.dao.dnq.api.JetPassReadOnlyDAO;
import jetbrains.jetpass.dao.dnq.api.JetPassReadonlyDAOUtilKt;
import jetbrains.jetpass.dao.dnq.api.authority.JetPassUserGroupDAO;
import jetbrains.jetpass.userManagement.persistence.dnq.XdBaseUserGroup;
import jetbrains.jetpass.userManagement.persistence.dnq.XdProject;
import jetbrains.jetpass.userManagement.persistence.dnq.XdUUIDObject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001'B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001bJ\u001e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u001e\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001bJ\u001e\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u001e\u0010\u001f\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001bJ\u001e\u0010\u001f\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00130#2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\"\u0010$\u001a\b\u0012\u0004\u0012\u00020\f0#*\u00020%2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\"\u0010$\u001a\b\u0012\u0004\u0012\u00020\f0#*\u00020%2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\"\u0010&\u001a\b\u0012\u0004\u0012\u00020\f0#*\u00020!2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\"\u0010&\u001a\b\u0012\u0004\u0012\u00020\f0#*\u00020!2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006("}, d2={"Ljetbrains/jetpass/dao/access/view/AccessGranter;", "", "daoContainer", "Ljetbrains/jetpass/dao/dnq/api/JetPassDAOContainer;", "permissionCache", "Ljetbrains/jetpass/dao/api/permissionCache/PermissionCache;", "(Ljetbrains/jetpass/dao/dnq/api/JetPassDAOContainer;Ljetbrains/jetpass/dao/api/permissionCache/PermissionCache;)V", "getDaoContainer", "()Ljetbrains/jetpass/dao/dnq/api/JetPassDAOContainer;", "getPermissionCache", "()Ljetbrains/jetpass/dao/api/permissionCache/PermissionCache;", "createAddGroupOption", "Ljetbrains/jetpass/dao/access/view/AccessGrantOption;", "userGroup", "Ljetbrains/jetpass/api/authority/UserGroup;", "createGrantRoleOption", "project", "Ljetbrains/jetpass/api/security/Project;", "role", "Ljetbrains/jetpass/api/security/Role;", "createNewGroupOption", "createUniqueGroupName", "", "forGroup", "Ljetbrains/jetpass/dao/access/view/AccessGranter$OptionList;", "group", "permission", "Ljetbrains/jetpass/api/security/Permission;", "forService", "service", "Ljetbrains/jetpass/api/Service;", "forUser", "user", "Ljetbrains/jetpass/api/authority/User;", "rolesContainingPermission", "Lkotlin/sequences/Sequence;", "getGrantRoleOptions", "Ljetbrains/jetpass/api/authority/AuthorityHolder;", "getGroupOptions", "OptionList", "jetbrains.jetpass.dao.access.view"})
public final class AccessGranter {
    @NotNull
    private final JetPassDAOContainer daoContainer;
    @NotNull
    private final PermissionCache permissionCache;

    @NotNull
    public final OptionList forUser(@NotNull User user, @NotNull Project project, @NotNull Role role) {
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)role, (String)"role");
        Sequence options = SequencesKt.plus(this.getGroupOptions(user, project, role), this.getGrantRoleOptions((AuthorityHolder)user, project, role));
        String string = user.getId();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"user.id");
        PermissionQuery permissionQuery = this.permissionCache.user(string).toProject(project.getId());
        String string2 = role.getId();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"role.id");
        PermissionQuery permissionQuery2 = permissionQuery.withRole(string2);
        return new OptionList(permissionQuery2.canAccess(), SequencesKt.toList((Sequence)options));
    }

    @NotNull
    public final OptionList forUser(@NotNull User user, @NotNull Project project, @NotNull Permission permission) {
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)permission, (String)"permission");
        Sequence options = SequencesKt.plus(this.getGroupOptions(user, project, permission), this.getGrantRoleOptions((AuthorityHolder)user, project, permission));
        String string = user.getId();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"user.id");
        PermissionQuery permissionQuery = this.permissionCache.user(string).toProject(project.getId());
        String string2 = permission.getId();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"permission.id");
        PermissionQuery permissionQuery2 = permissionQuery.withPermission(string2);
        return new OptionList(permissionQuery2.canAccess(), SequencesKt.toList((Sequence)options));
    }

    @NotNull
    public final OptionList forGroup(@NotNull UserGroup group, @NotNull Project project, @NotNull Role role) {
        Intrinsics.checkParameterIsNotNull((Object)group, (String)"group");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)role, (String)"role");
        Sequence<AccessGrantOption> options = this.getGrantRoleOptions((AuthorityHolder)group, project, role);
        String string = group.getId();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"group.id");
        PermissionQuery permissionQuery = this.permissionCache.group(string).toProject(project.getId());
        String string2 = role.getId();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"role.id");
        PermissionQuery permissionQuery2 = permissionQuery.withRole(string2);
        return new OptionList(permissionQuery2.canAccess(), SequencesKt.toList(options));
    }

    @NotNull
    public final OptionList forGroup(@NotNull UserGroup group, @NotNull Project project, @NotNull Permission permission) {
        Intrinsics.checkParameterIsNotNull((Object)group, (String)"group");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)permission, (String)"permission");
        Sequence<AccessGrantOption> options = this.getGrantRoleOptions((AuthorityHolder)group, project, permission);
        String string = group.getId();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"group.id");
        PermissionQuery permissionQuery = this.permissionCache.group(string).toProject(project.getId());
        String string2 = permission.getId();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"permission.id");
        PermissionQuery permissionQuery2 = permissionQuery.withPermission(string2);
        return new OptionList(permissionQuery2.canAccess(), SequencesKt.toList(options));
    }

    @NotNull
    public final OptionList forService(@NotNull Service service, @NotNull Project project, @NotNull Role role) {
        Intrinsics.checkParameterIsNotNull((Object)service, (String)"service");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)role, (String)"role");
        Sequence<AccessGrantOption> options = this.getGrantRoleOptions((AuthorityHolder)service, project, role);
        String string = service.getId();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"service.id");
        PermissionQuery permissionQuery = this.permissionCache.service(string).toProject(project.getId());
        String string2 = role.getId();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"role.id");
        PermissionQuery permissionQuery2 = permissionQuery.withRole(string2);
        return new OptionList(permissionQuery2.canAccess(), SequencesKt.toList(options));
    }

    @NotNull
    public final OptionList forService(@NotNull Service service, @NotNull Project project, @NotNull Permission permission) {
        Intrinsics.checkParameterIsNotNull((Object)service, (String)"service");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)permission, (String)"permission");
        Sequence<AccessGrantOption> options = this.getGrantRoleOptions((AuthorityHolder)service, project, permission);
        String string = service.getId();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"service.id");
        PermissionQuery permissionQuery = this.permissionCache.service(string).toProject(project.getId());
        String string2 = permission.getId();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"permission.id");
        PermissionQuery permissionQuery2 = permissionQuery.withPermission(string2);
        return new OptionList(permissionQuery2.canAccess(), SequencesKt.toList(options));
    }

    private final Sequence<AccessGrantOption> getGroupOptions(@NotNull User $receiver, Project project, Permission permission) {
        String groupsWithAccessQuery = "access(project: {" + project.getId() + "}, with: {" + permission.getId() + "}) and not user: {" + $receiver.getId() + '}';
        Sequence result2 = CollectionsKt.asSequence((Iterable)SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)this.daoContainer.getUserGroupDAO().getAllItems().query(groupsWithAccessQuery))), (Function1)((Function1)new Function1<UserGroup, AccessGrantOption>(this){
            final /* synthetic */ AccessGranter this$0;

            @Nullable
            public final AccessGrantOption invoke(@NotNull UserGroup it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return AccessGranter.access$createAddGroupOption(this.this$0, it);
            }
            {
                this.this$0 = accessGranter;
                super(1);
            }
        }))));
        return SequencesKt.none((Sequence)result2) ? SequencesKt.mapNotNull(this.rolesContainingPermission(permission), (Function1)((Function1)new Function1<Role, AccessGrantOption>(this, project){
            final /* synthetic */ AccessGranter this$0;
            final /* synthetic */ Project $project;

            @Nullable
            public final AccessGrantOption invoke(@NotNull Role it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return AccessGranter.access$createNewGroupOption(this.this$0, this.$project, it);
            }
            {
                this.this$0 = accessGranter;
                this.$project = project;
                super(1);
            }
        })) : result2;
    }

    private final Sequence<AccessGrantOption> getGroupOptions(@NotNull User $receiver, Project project, Role role) {
        String groupsWithAccessQuery = "access(project: {" + project.getId() + "}, with: {" + role.getId() + "}) and not user: {" + $receiver.getId() + '}';
        Sequence result2 = CollectionsKt.asSequence((Iterable)SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)this.daoContainer.getUserGroupDAO().getAllItems().query(groupsWithAccessQuery))), (Function1)((Function1)new Function1<UserGroup, AccessGrantOption>(this){
            final /* synthetic */ AccessGranter this$0;

            @Nullable
            public final AccessGrantOption invoke(@NotNull UserGroup it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return AccessGranter.access$createAddGroupOption(this.this$0, it);
            }
            {
                this.this$0 = accessGranter;
                super(1);
            }
        }))));
        return SequencesKt.none((Sequence)result2) ? SequencesKt.filterNotNull((Sequence)SequencesKt.sequenceOf((Object[])new AccessGrantOption[]{this.createNewGroupOption(project, role)})) : result2;
    }

    private final AccessGrantOption createNewGroupOption(Project project, Role role) {
        XdProject xdProject = (XdProject)JetPassReadonlyDAOUtilKt.resolveOrNull((IdItem)((IdItem)project), (JetPassReadOnlyDAO)((JetPassReadOnlyDAO)this.daoContainer.getJetPassProjectDAO()));
        return this.daoContainer.getJetPassUserGroupDAO().getSecurity().canCreate(xdProject) && this.daoContainer.getJetPassProjectRoleDAO().getSecurity().canCreate(xdProject) ? (AccessGrantOption)new AddNewGroupOption(this.createUniqueGroupName(project, role), project, role) : null;
    }

    private final String createUniqueGroupName(Project project, Role role) {
        String groupNameBase;
        String groupName = groupNameBase = project.getName() + ' ' + role.getName() + 's';
        int attempt = 1;
        while (this.daoContainer.getUserGroupDAO().getFirstByName(groupName) != null) {
            groupName = groupNameBase + ' ' + attempt;
            ++attempt;
        }
        return groupName;
    }

    private final AccessGrantOption createAddGroupOption(UserGroup userGroup) {
        JetPassUserGroupDAO groupDAO = this.daoContainer.getJetPassUserGroupDAO();
        XdBaseUserGroup xdGroup = (XdBaseUserGroup)groupDAO.resolveOrNull((IdItem)userGroup);
        return xdGroup != null && groupDAO.getSecurity().canUpdate((XdUUIDObject)xdGroup) ? (AccessGrantOption)new AddGroupOption(userGroup) : null;
    }

    private final Sequence<AccessGrantOption> getGrantRoleOptions(@NotNull AuthorityHolder $receiver, Project project, Permission permission) {
        return SequencesKt.flatMap(this.rolesContainingPermission(permission), (Function1)((Function1)new Function1<Role, Sequence<? extends AccessGrantOption>>(this, $receiver, project){
            final /* synthetic */ AccessGranter this$0;
            final /* synthetic */ AuthorityHolder receiver$0;
            final /* synthetic */ Project $project;

            @NotNull
            public final Sequence<AccessGrantOption> invoke(@NotNull Role role) {
                Intrinsics.checkParameterIsNotNull((Object)role, (String)"role");
                return AccessGranter.access$getGrantRoleOptions(this.this$0, this.receiver$0, this.$project, role);
            }
            {
                this.this$0 = accessGranter;
                this.receiver$0 = authorityHolder;
                this.$project = project;
                super(1);
            }
        }));
    }

    /*
     * Unable to fully structure code
     */
    private final Sequence<AccessGrantOption> getGrantRoleOptions(@NotNull AuthorityHolder $receiver, Project project, Role role) {
        block3: {
            v0 = $receiver.getProjectRoles();
            Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"projectRoles");
            $receiver$iv = CollectionsKt.asSequence((Iterable)v0);
            for (E element$iv : $receiver$iv) {
                v1 = it = (ProjectRole)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
                v2 = v1.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"it.project");
                if (!Intrinsics.areEqual((Object)v2.getId(), (Object)project.getId())) ** GOTO lbl-1000
                v3 = it.getRole();
                Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"it.role");
                if (Intrinsics.areEqual((Object)v3.getId(), (Object)role.getId())) {
                    v4 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v4 = false;
                }
                if (!v4) continue;
                v5 = false;
                break block3;
            }
            v5 = true;
        }
        return v5 != false ? SequencesKt.filterNotNull((Sequence)SequencesKt.sequenceOf((Object[])new AccessGrantOption[]{this.createGrantRoleOption(project, role)})) : SequencesKt.emptySequence();
    }

    private final AccessGrantOption createGrantRoleOption(Project project, Role role) {
        XdProject xdProject = (XdProject)JetPassReadonlyDAOUtilKt.resolveOrNull((IdItem)((IdItem)project), (JetPassReadOnlyDAO)((JetPassReadOnlyDAO)this.daoContainer.getJetPassProjectDAO()));
        return this.daoContainer.getJetPassProjectRoleDAO().getSecurity().canCreate(xdProject) ? (AccessGrantOption)new GrantRoleOption(project, role) : null;
    }

    private final Sequence<Role> rolesContainingPermission(Permission permission) {
        return CollectionsKt.asSequence((Iterable)((Iterable)this.daoContainer.getRoleDAO().getAllItems().query("permission: {" + permission.getId() + '}')));
    }

    @NotNull
    public final JetPassDAOContainer getDaoContainer() {
        return this.daoContainer;
    }

    @NotNull
    public final PermissionCache getPermissionCache() {
        return this.permissionCache;
    }

    public AccessGranter(@NotNull JetPassDAOContainer daoContainer, @NotNull PermissionCache permissionCache) {
        Intrinsics.checkParameterIsNotNull((Object)daoContainer, (String)"daoContainer");
        Intrinsics.checkParameterIsNotNull((Object)permissionCache, (String)"permissionCache");
        this.daoContainer = daoContainer;
        this.permissionCache = permissionCache;
    }

    @Nullable
    public static final /* synthetic */ AccessGrantOption access$createAddGroupOption(AccessGranter $this, @NotNull UserGroup userGroup) {
        return $this.createAddGroupOption(userGroup);
    }

    @Nullable
    public static final /* synthetic */ AccessGrantOption access$createNewGroupOption(AccessGranter $this, @NotNull Project project, @NotNull Role role) {
        return $this.createNewGroupOption(project, role);
    }

    @NotNull
    public static final /* synthetic */ Sequence access$getGrantRoleOptions(AccessGranter $this, @NotNull AuthorityHolder $receiver, @NotNull Project project, @NotNull Role role) {
        return $this.getGrantRoleOptions($receiver, project, role);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Ljetbrains/jetpass/dao/access/view/AccessGranter$OptionList;", "", "hasAccessAlready", "", "options", "", "Ljetbrains/jetpass/dao/access/view/AccessGrantOption;", "(ZLjava/util/List;)V", "getHasAccessAlready", "()Z", "getOptions", "()Ljava/util/List;", "jetbrains.jetpass.dao.access.view"})
    public static final class OptionList {
        private final boolean hasAccessAlready;
        @NotNull
        private final List<AccessGrantOption> options;

        public final boolean getHasAccessAlready() {
            return this.hasAccessAlready;
        }

        @NotNull
        public final List<AccessGrantOption> getOptions() {
            return this.options;
        }

        public OptionList(boolean hasAccessAlready, @NotNull List<? extends AccessGrantOption> options) {
            Intrinsics.checkParameterIsNotNull(options, (String)"options");
            this.hasAccessAlready = hasAccessAlready;
            this.options = options;
        }
    }
}

