/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.ssh;

import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.RSAPublicKeySpec;
import jetbrains.jetpass.ssh.PublicKeyParseException;
import jetbrains.jetpass.ssh.SSH2DataBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0006\u0010\u000e\u001a\u00020\u0003J\u0006\u0010\u000f\u001a\u00020\u0003J\u0006\u0010\u0010\u001a\u00020\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0011"}, d2={"Ljetbrains/jetpass/ssh/PublicKeyData;", "", "base64", "", "comment", "(Ljava/lang/String;Ljava/lang/String;)V", "getBase64", "()Ljava/lang/String;", "getComment", "decodeDSAPublicKey", "Ljava/security/PublicKey;", "buffer", "Ljetbrains/jetpass/ssh/SSH2DataBuffer;", "decodeRSAPublicKey", "getFingerPrint", "getOpenSSH", "getPublicKey", "jetbrains.jetpass.ssh"})
public final class PublicKeyData {
    @NotNull
    private final String base64;
    @NotNull
    private final String comment;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final PublicKey getPublicKey() throws PublicKeyParseException {
        PublicKey publicKey;
        String type;
        byte[] byArray = Base64.decodeBase64((String)this.base64);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"Base64.decodeBase64(base64)");
        SSH2DataBuffer buffer = new SSH2DataBuffer(byArray);
        String string = type = buffer.readString();
        switch (string.hashCode()) {
            case -1921406725: {
                if (!string.equals("ssh-rsa")) throw (Throwable)new PublicKeyParseException(PublicKeyParseException.ErrorCode.UNKNOWN_PUBLIC_KEY_CERTIFICATE_FORMAT, null, 2, null);
                break;
            }
            case -1921420161: {
                if (!string.equals("ssh-dss")) throw (Throwable)new PublicKeyParseException(PublicKeyParseException.ErrorCode.UNKNOWN_PUBLIC_KEY_CERTIFICATE_FORMAT, null, 2, null);
                publicKey = this.decodeDSAPublicKey(buffer);
                return publicKey;
            }
        }
        publicKey = this.decodeRSAPublicKey(buffer);
        return publicKey;
        throw (Throwable)new PublicKeyParseException(PublicKeyParseException.ErrorCode.UNKNOWN_PUBLIC_KEY_CERTIFICATE_FORMAT, null, 2, null);
    }

    @NotNull
    public final String getOpenSSH() {
        byte[] byArray = Base64.decodeBase64((String)this.base64);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"Base64.decodeBase64(base64)");
        SSH2DataBuffer buffer = new SSH2DataBuffer(byArray);
        String type = buffer.readString();
        return type + ' ' + this.base64 + ' ' + this.comment;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getFingerPrint() throws PublicKeyParseException {
        StringBuilder builder = new StringBuilder();
        char[] hexChars = Hex.encodeHex((byte[])DigestUtils.md5((byte[])Base64.decodeBase64((String)this.base64)));
        int n = 0;
        Intrinsics.checkExpressionValueIsNotNull((Object)hexChars, (String)"hexChars");
        int n2 = hexChars.length;
        while (n < n2) {
            void index;
            if (index > 0 && index % 2 == false) {
                builder.append(':');
            }
            builder.append(hexChars[index]);
            ++index;
        }
        String string = builder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"builder.toString()");
        return string;
    }

    private final PublicKey decodeRSAPublicKey(SSH2DataBuffer buffer) throws PublicKeyParseException {
        PublicKey publicKey;
        BigInteger e = buffer.readMPint();
        BigInteger n = buffer.readMPint();
        try {
            KeyFactory rsaKeyFact = KeyFactory.getInstance("RSA");
            RSAPublicKeySpec rsaPubSpec = new RSAPublicKeySpec(n, e);
            PublicKey publicKey2 = rsaKeyFact.generatePublic(rsaPubSpec);
            Intrinsics.checkExpressionValueIsNotNull((Object)publicKey2, (String)"rsaKeyFact.generatePublic(rsaPubSpec)");
            publicKey = publicKey2;
        }
        catch (Exception ex) {
            throw (Throwable)new PublicKeyParseException(PublicKeyParseException.ErrorCode.SSH2RSA_ERROR_DECODING_PUBLIC_KEY_BLOB, (Throwable)ex);
        }
        return publicKey;
    }

    private final PublicKey decodeDSAPublicKey(SSH2DataBuffer buffer) throws PublicKeyParseException {
        PublicKey publicKey;
        BigInteger p = buffer.readMPint();
        BigInteger q = buffer.readMPint();
        BigInteger g = buffer.readMPint();
        BigInteger y = buffer.readMPint();
        try {
            KeyFactory dsaKeyFact = KeyFactory.getInstance("DSA");
            DSAPublicKeySpec dsaPubSpec = new DSAPublicKeySpec(y, p, q, g);
            PublicKey publicKey2 = dsaKeyFact.generatePublic(dsaPubSpec);
            Intrinsics.checkExpressionValueIsNotNull((Object)publicKey2, (String)"dsaKeyFact.generatePublic(dsaPubSpec)");
            publicKey = publicKey2;
        }
        catch (Exception e) {
            throw (Throwable)new PublicKeyParseException(PublicKeyParseException.ErrorCode.SSH2DSA_ERROR_DECODING_PUBLIC_KEY_BLOB, (Throwable)e);
        }
        return publicKey;
    }

    @NotNull
    public final String getBase64() {
        return this.base64;
    }

    @NotNull
    public final String getComment() {
        return this.comment;
    }

    public PublicKeyData(@NotNull String base64, @NotNull String comment) {
        Intrinsics.checkParameterIsNotNull((Object)base64, (String)"base64");
        Intrinsics.checkParameterIsNotNull((Object)comment, (String)"comment");
        this.base64 = base64;
        this.comment = comment;
    }

    public /* synthetic */ PublicKeyData(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = "";
        }
        this(string, string2);
    }
}

