/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.ssh;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import jetbrains.jetpass.ssh.PublicKeyData;
import jetbrains.jetpass.ssh.PublicKeyParseException;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\f\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004H\u0002J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004H\u0002J\u0014\u0010\r\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Ljetbrains/jetpass/ssh/PublicKeyUtil;", "", "()V", "BEGIN_PUB_KEY", "", "COMMENT_HEADER_NAME", "END_PUB_KEY", "NEW_LINE_SEPARATOR", "load", "Ljetbrains/jetpass/ssh/PublicKeyData;", "key", "loadOpenSSHBase64Key", "loadSecSHBase64KeyData", "unwrap", "char", "", "jetbrains.jetpass.ssh"})
public final class PublicKeyUtil {
    private static final String BEGIN_PUB_KEY = "---- BEGIN SSH2 PUBLIC KEY ----";
    private static final String END_PUB_KEY = "---- END SSH2 PUBLIC KEY ----";
    private static final String COMMENT_HEADER_NAME = "Comment";
    private static final String NEW_LINE_SEPARATOR = "\\";
    public static final PublicKeyUtil INSTANCE;

    @NotNull
    public final PublicKeyData load(@NotNull String key) throws PublicKeyParseException {
        PublicKeyData publicKeyData;
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        String string = key;
        if (StringsKt.startsWith$default((String)((Object)StringsKt.trimStart((CharSequence)string)).toString(), (String)"ssh-", (boolean)false, (int)2, null)) {
            publicKeyData = this.loadOpenSSHBase64Key(key);
        } else {
            string = key;
            if (StringsKt.startsWith$default((String)((Object)StringsKt.trimStart((CharSequence)string)).toString(), (String)"----", (boolean)false, (int)2, null)) {
                publicKeyData = this.loadSecSHBase64KeyData(key);
            } else {
                string = key;
                if (StringsKt.startsWith$default((String)((Object)StringsKt.trimStart((CharSequence)string)).toString(), (String)"AAAA", (boolean)false, (int)2, null)) {
                    publicKeyData = new PublicKeyData(key, null, 2, null);
                } else {
                    throw (Throwable)new PublicKeyParseException(PublicKeyParseException.ErrorCode.UNKNOWN_PUBLIC_KEY_FILE_FORMAT, null, 2, null);
                }
            }
        }
        return publicKeyData;
    }

    private final PublicKeyData loadOpenSSHBase64Key(String key) throws PublicKeyParseException {
        PublicKeyData publicKeyData;
        try {
            PublicKeyData publicKeyData2;
            StringTokenizer st = new StringTokenizer(key);
            st.nextToken();
            String string = st.nextToken();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"st.nextToken()");
            Enumeration enumeration = st;
            String string2 = string;
            PublicKeyData publicKeyData3 = publicKeyData2;
            PublicKeyData publicKeyData4 = publicKeyData2;
            Sequence sequence = SequencesKt.asSequence((Iterator)CollectionsKt.iterator((Enumeration)enumeration));
            publicKeyData3(string2, SequencesKt.joinToString$default((Sequence)sequence, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
            publicKeyData = publicKeyData4;
        }
        catch (NoSuchElementException e) {
            throw (Throwable)new PublicKeyParseException(PublicKeyParseException.ErrorCode.CORRUPT_OPENSSH_PUBLIC_KEY_STRING, null, 2, null);
        }
        return publicKeyData;
    }

    private final PublicKeyData loadSecSHBase64KeyData(String key) throws PublicKeyParseException {
        StringBuilder base64Data = new StringBuilder();
        StringBuilder comment = new StringBuilder();
        boolean startKey = false;
        boolean startKeyBody = false;
        boolean endKey = false;
        boolean readHeader = false;
        boolean readMultilineComment = false;
        Iterator iterator = StringsKt.split$default((CharSequence)key, (char[])new char[]{'\n'}, (boolean)false, (int)0, (int)6, null).iterator();
        while (iterator.hasNext()) {
            String string;
            StringBuilder stringBuilder;
            String line;
            String string2;
            String string3 = string2 = (line = (String)iterator.next());
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String trimLine = ((Object)StringsKt.trim((CharSequence)string3)).toString();
            if (!startKey && Intrinsics.areEqual((Object)trimLine, (Object)BEGIN_PUB_KEY)) {
                startKey = true;
                continue;
            }
            if (!startKey) continue;
            if (Intrinsics.areEqual((Object)trimLine, (Object)END_PUB_KEY)) {
                endKey = true;
                break;
            }
            if (readHeader) {
                int newLine = StringsKt.indexOf$default((CharSequence)trimLine, (String)NEW_LINE_SEPARATOR, (int)0, (boolean)false, (int)6, null);
                if (newLine < 0) {
                    readHeader = false;
                    if (!readMultilineComment) continue;
                    comment.append(line);
                    readMultilineComment = false;
                    continue;
                }
                if (!readMultilineComment) continue;
                String string4 = line;
                int n = 0;
                int n2 = newLine + 1;
                stringBuilder = comment;
                String string5 = string4;
                if (string5 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string5.substring(n, n2), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                stringBuilder.append(string);
                continue;
            }
            int header = StringsKt.indexOf$default((CharSequence)trimLine, (char)':', (int)0, (boolean)false, (int)6, null);
            if (header > 0) {
                int stringEnd;
                String string6 = trimLine;
                int n = 0;
                String string7 = string6;
                if (string7 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string8 = string7.substring(n, header);
                Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                boolean isCommentHeader = Intrinsics.areEqual((Object)string8, (Object)COMMENT_HEADER_NAME);
                if (startKeyBody) {
                    throw (Throwable)new PublicKeyParseException(PublicKeyParseException.ErrorCode.CORRUPT_SECSSH_PUBLIC_KEY_STRING, null, 2, null);
                }
                if (StringsKt.endsWith$default((String)trimLine, (String)NEW_LINE_SEPARATOR, (boolean)false, (int)2, null)) {
                    readHeader = true;
                    if (isCommentHeader) {
                        readMultilineComment = true;
                    }
                }
                int n3 = stringEnd = readMultilineComment ? StringsKt.indexOf$default((CharSequence)trimLine, (String)NEW_LINE_SEPARATOR, (int)0, (boolean)false, (int)6, null) : trimLine.length();
                if (!isCommentHeader) continue;
                String string9 = trimLine;
                int n4 = header + 2;
                stringBuilder = comment;
                String string10 = string9;
                if (string10 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string10.substring(n4, stringEnd), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                stringBuilder.append(string);
                continue;
            }
            startKeyBody = true;
            base64Data.append(trimLine);
        }
        if (!endKey) {
            throw (Throwable)new PublicKeyParseException(PublicKeyParseException.ErrorCode.CORRUPT_SECSSH_PUBLIC_KEY_STRING, null, 2, null);
        }
        String string = base64Data.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"base64Data.toString()");
        String string11 = comment.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string11, (String)"comment.toString()");
        return new PublicKeyData(string, this.unwrap(string11, '\"'));
    }

    private final String unwrap(@NotNull String $receiver, char c) {
        String string;
        if ($receiver.length() == 0) {
            return $receiver;
        }
        if ($receiver.charAt(0) == c && $receiver.charAt($receiver.length() - 1) == c) {
            int n = 1;
            string = StringsKt.substring((String)$receiver, (IntRange)new IntRange(n, $receiver.length() - 2));
        } else {
            string = $receiver;
        }
        return string;
    }

    private PublicKeyUtil() {
    }

    static {
        PublicKeyUtil publicKeyUtil;
        INSTANCE = publicKeyUtil = new PublicKeyUtil();
        BEGIN_PUB_KEY = BEGIN_PUB_KEY;
        END_PUB_KEY = END_PUB_KEY;
        COMMENT_HEADER_NAME = COMMENT_HEADER_NAME;
        NEW_LINE_SEPARATOR = NEW_LINE_SEPARATOR;
    }
}

