/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.ssh;

import java.math.BigInteger;
import jetbrains.jetpass.ssh.PublicKeyParseException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\u0003H\u0002J\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010\f\u001a\u00020\u0006H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Ljetbrains/jetpass/ssh/SSH2DataBuffer;", "", "data", "", "([B)V", "pos", "", "readByteArray", "readMPint", "Ljava/math/BigInteger;", "readString", "", "readUInt32", "jetbrains.jetpass.ssh"})
public final class SSH2DataBuffer {
    private int pos;
    private final byte[] data;

    @NotNull
    public final BigInteger readMPint() throws PublicKeyParseException {
        BigInteger bigInteger;
        byte[] raw = this.readByteArray();
        byte[] byArray = raw;
        byte[] byArray2 = byArray;
        if (!(byArray2.length == 0)) {
            bigInteger = new BigInteger(raw);
        } else {
            BigInteger bigInteger2 = BigInteger.valueOf(0L);
            bigInteger = bigInteger2;
            Intrinsics.checkExpressionValueIsNotNull((Object)bigInteger2, (String)"BigInteger.valueOf(0)");
        }
        return bigInteger;
    }

    @NotNull
    public final String readString() throws PublicKeyParseException {
        byte[] byArray = this.readByteArray();
        return new String(byArray, Charsets.UTF_8);
    }

    private final byte[] readByteArray() throws PublicKeyParseException {
        int len = this.readUInt32();
        if (len < 0 || len > this.data.length - this.pos) {
            throw (Throwable)new PublicKeyParseException(PublicKeyParseException.ErrorCode.CORRUPT_BYTE_ARRAY_ON_READ, null, 2, null);
        }
        byte[] str = new byte[len];
        System.arraycopy(this.data, this.pos, str, 0, len);
        this.pos += len;
        return str;
    }

    private final int readUInt32() {
        int n = this.pos;
        this.pos = n + 1;
        int byte1 = this.data[n] & 0xFF;
        int n2 = this.pos;
        this.pos = n2 + 1;
        int byte2 = this.data[n2] & 0xFF;
        int n3 = this.pos;
        this.pos = n3 + 1;
        int byte3 = this.data[n3] & 0xFF;
        int n4 = this.pos;
        this.pos = n4 + 1;
        int byte4 = this.data[n4] & 0xFF;
        return (byte1 << 24) + (byte2 << 16) + (byte3 << 8) + (byte4 << 0);
    }

    public SSH2DataBuffer(@NotNull byte[] data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        this.data = data;
    }
}

