/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.ring.servlet.util;

import java.io.IOException;
import java.net.URL;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import jetbrains.ring.servlet.LookupResult;
import jetbrains.ring.servlet.util.InvalidationPolicy;
import jetbrains.ring.servlet.util.ServletUtil;

public class IndexFileHolder {
    private final URL url;
    private final String replacePattern;
    private final String contextTag;
    private final String cacheControl;
    private final ConcurrentHashMap<String, LookupResult.IndexResource> path2index = new ConcurrentHashMap(1);
    private final InvalidationPolicy invalidationPolicy;

    public IndexFileHolder(URL url, String replacePattern, String contextTag, String cacheControl) {
        this(url, replacePattern, contextTag, cacheControl, new InvalidationPolicy.NeverInvalidationPolicy());
    }

    public IndexFileHolder(URL url, String replacePattern, String contextTag, String cacheControl, InvalidationPolicy policy) {
        this.url = url;
        this.replacePattern = replacePattern;
        this.contextTag = contextTag;
        this.cacheControl = cacheControl;
        this.invalidationPolicy = policy;
    }

    public LookupResult.IndexResource getIndexResource(HttpServletRequest request) throws IOException {
        return this.getIndexResource(ServletUtil.getServletPath(request));
    }

    protected LookupResult.IndexResource getIndexResource(String path) throws IOException {
        long lastModified = this.getLastModified();
        LookupResult.IndexResource resource = this.path2index.get(path);
        if (resource == null) {
            LookupResult.IndexResource res = new LookupResult.IndexResource(this.url, lastModified, this.replacePattern, this.contextTag, path);
            res.setCacheControl(this.cacheControl);
            resource = this.path2index.putIfAbsent(path, res);
            if (resource == null) {
                resource = res;
            }
        }
        return resource;
    }

    protected long getLastModified() {
        long lastModified = this.invalidationPolicy.lastModified();
        if (this.invalidationPolicy.isModified()) {
            this.path2index.clear();
            lastModified = this.invalidationPolicy.lastModified();
        }
        return lastModified;
    }
}

