/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.integration.vcs.rest;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Set;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import jetbrains.charisma.persistent.BeansKt;
import jetbrains.youtrack.core.ssl.XdStorageEntry;
import jetbrains.youtrack.integration.github.persistence.CredentialsDto;
import jetbrains.youtrack.integration.persistence.XdVcsChangeProcessor;
import jetbrains.youtrack.integration.vcs.CommonChangeDTO;
import jetbrains.youtrack.integration.vcs.rest.JerseyClientExceptionWrapper;
import jetbrains.youtrack.integration.vcs.rest.VcsRestClient;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import mu.KLogging;
import org.apache.commons.io.IOUtils;
import org.glassfish.jersey.message.internal.MessageBodyProviderNotFoundException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 B*\n\b\u0000\u0010\u0001 \u0000*\u00020\u00022\u00020\u0003:\u0001BB\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u001d\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00028\u00002\u0006\u0010\u0011\u001a\u00020\u0005H&\u00a2\u0006\u0002\u0010\u0012J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u001d\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00028\u00002\u0006\u0010\u0019\u001a\u00020\u001aH&\u00a2\u0006\u0002\u0010\u001bJ'\u0010\u001c\u001a\u0002H\u001d\"\u0004\b\u0001\u0010\u001d2\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u001f\u00a2\u0006\u0002\u0010 J'\u0010\u001c\u001a\u0002H\u001d\"\u0004\b\u0001\u0010\u001d2\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H\u001d0\"\u00a2\u0006\u0002\u0010#J\u001e\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00050%2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020\u0005H&J\u001f\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010\u0010\u001a\u00028\u00002\u0006\u0010)\u001a\u00020\u0005H&\u00a2\u0006\u0002\u0010*J\u001d\u0010+\u001a\u00020,2\u0006\u0010\u0010\u001a\u00028\u00002\u0006\u0010)\u001a\u00020\u0005H&\u00a2\u0006\u0002\u0010-J\u0010\u0010.\u001a\u00020\u00182\u0006\u0010/\u001a\u00020\u0014H\u0002J\u0015\u00100\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00028\u0000H&\u00a2\u0006\u0002\u00101J3\u00102\u001a\u0002H\u001d\"\u0004\b\u0001\u0010\u001d2\u0006\u0010\u0015\u001a\u00020\u00162\n\u00103\u001a\u0006\u0012\u0002\b\u0003042\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u001f\u00a2\u0006\u0002\u00105J\u0018\u00106\u001a\u000607j\u0002`82\n\u00109\u001a\u000607j\u0002`8H\u0002J!\u0010:\u001a\u0002H\u001d\"\u0004\b\u0001\u0010\u001d2\f\u0010;\u001a\b\u0012\u0004\u0012\u0002H\u001d0<H\u0002\u00a2\u0006\u0002\u0010=J\u0010\u0010>\u001a\u00020\u00052\u0006\u0010/\u001a\u00020\u0014H\u0002J\u0014\u0010?\u001a\u000607j\u0002`82\u0006\u0010@\u001a\u00020AH\u0002R\u0011\u0010\t\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000b\u00a8\u0006C"}, d2={"Ljetbrains/youtrack/integration/vcs/rest/VcsRestClient;", "P", "Ljetbrains/youtrack/integration/persistence/XdVcsChangeProcessor;", "", "url", "", "sslKey", "Ljetbrains/youtrack/core/ssl/XdStorageEntry;", "(Ljava/lang/String;Ljetbrains/youtrack/core/ssl/XdStorageEntry;)V", "landingUrl", "getLandingUrl", "()Ljava/lang/String;", "getSslKey", "()Ljetbrains/youtrack/core/ssl/XdStorageEntry;", "getUrl", "createHook", "changesProcessor", "hookReceiverId", "(Ljetbrains/youtrack/integration/persistence/XdVcsChangeProcessor;Ljava/lang/String;)Ljava/lang/String;", "delete", "Ljavax/ws/rs/core/Response;", "builder", "Ljavax/ws/rs/client/Invocation$Builder;", "deleteHook", "", "creds", "Ljetbrains/youtrack/integration/github/persistence/CredentialsDto;", "(Ljetbrains/youtrack/integration/persistence/XdVcsChangeProcessor;Ljetbrains/youtrack/integration/github/persistence/CredentialsDto;)V", "get", "T", "clazz", "Ljava/lang/Class;", "(Ljavax/ws/rs/client/Invocation$Builder;Ljava/lang/Class;)Ljava/lang/Object;", "generic", "Ljavax/ws/rs/core/GenericType;", "(Ljavax/ws/rs/client/Invocation$Builder;Ljavax/ws/rs/core/GenericType;)Ljava/lang/Object;", "getBranches", "", "path", "getCommit", "Ljetbrains/youtrack/integration/vcs/CommonChangeDTO;", "hash", "(Ljetbrains/youtrack/integration/persistence/XdVcsChangeProcessor;Ljava/lang/String;)Ljetbrains/youtrack/integration/vcs/CommonChangeDTO;", "isCommitThere", "", "(Ljetbrains/youtrack/integration/persistence/XdVcsChangeProcessor;Ljava/lang/String;)Z", "logResponse", "response", "ping", "(Ljetbrains/youtrack/integration/persistence/XdVcsChangeProcessor;)V", "post", "entity", "Ljavax/ws/rs/client/Entity;", "(Ljavax/ws/rs/client/Invocation$Builder;Ljavax/ws/rs/client/Entity;Ljava/lang/Class;)Ljava/lang/Object;", "processException", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "e", "request", "doIt", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "responseEntityToString", "wrapProcessingException", "pe", "Ljavax/ws/rs/ProcessingException;", "Companion", "youtrack-github-integration"})
public abstract class VcsRestClient<P extends XdVcsChangeProcessor> {
    @NotNull
    private final String url;
    @Nullable
    private final XdStorageEntry sslKey;
    private static final int TIMEOUT = 300;
    @Nullable
    private static final String WEB_HOOKS_BASE_URL;
    public static final Companion Companion;

    @NotNull
    public abstract String createHook(@NotNull P var1, @NotNull String var2);

    public abstract void deleteHook(@NotNull P var1, @NotNull CredentialsDto var2);

    @Nullable
    public abstract CommonChangeDTO getCommit(@NotNull P var1, @NotNull String var2);

    public abstract boolean isCommitThere(@NotNull P var1, @NotNull String var2);

    public abstract void ping(@NotNull P var1);

    @NotNull
    public abstract List<String> getBranches(@NotNull CredentialsDto var1, @NotNull String var2);

    public final <T> T get(@NotNull Invocation.Builder builder, @NotNull Class<T> clazz) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        return this.request((Function0)new Function0<T>(builder, clazz){
            final /* synthetic */ Invocation.Builder $builder;
            final /* synthetic */ Class $clazz;

            public final T invoke() {
                return (T)this.$builder.get(this.$clazz);
            }
            {
                this.$builder = builder;
                this.$clazz = clazz;
                super(0);
            }
        });
    }

    public final <T> T get(@NotNull Invocation.Builder builder, @NotNull GenericType<T> generic) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        Intrinsics.checkParameterIsNotNull(generic, (String)"generic");
        return this.request((Function0)new Function0<T>(builder, generic){
            final /* synthetic */ Invocation.Builder $builder;
            final /* synthetic */ GenericType $generic;

            public final T invoke() {
                return (T)this.$builder.get(this.$generic);
            }
            {
                this.$builder = builder;
                this.$generic = genericType;
                super(0);
            }
        });
    }

    public final <T> T post(@NotNull Invocation.Builder builder, @NotNull Entity<?> entity, @NotNull Class<T> clazz) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        Intrinsics.checkParameterIsNotNull(entity, (String)"entity");
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        return this.request((Function0)new Function0<T>(builder, entity, clazz){
            final /* synthetic */ Invocation.Builder $builder;
            final /* synthetic */ Entity $entity;
            final /* synthetic */ Class $clazz;

            public final T invoke() {
                return (T)this.$builder.post(this.$entity, this.$clazz);
            }
            {
                this.$builder = builder;
                this.$entity = entity;
                this.$clazz = clazz;
                super(0);
            }
        });
    }

    @NotNull
    public final Response delete(@NotNull Invocation.Builder builder) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        Object t = this.request((Function0)new Function0<Response>(builder){
            final /* synthetic */ Invocation.Builder $builder;

            public final Response invoke() {
                Response response = this.$builder.delete();
                Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"builder.delete()");
                return response;
            }
            {
                this.$builder = builder;
                super(0);
            }
        });
        Intrinsics.checkExpressionValueIsNotNull(t, (String)"request { builder.delete() }");
        return (Response)t;
    }

    private final <T> T request(Function0<? extends T> doIt) {
        try {
            return (T)doIt.invoke();
        }
        catch (RuntimeException e) {
            throw (Throwable)this.processException(e);
        }
    }

    private final RuntimeException processException(RuntimeException e) {
        RuntimeException runtimeException;
        if (e instanceof WebApplicationException) {
            Response response = ((WebApplicationException)((Object)e)).getResponse();
            Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"e.response");
            this.logResponse(response);
            runtimeException = new JerseyClientExceptionWrapper((WebApplicationException)((Object)e));
        } else {
            runtimeException = e instanceof ProcessingException ? this.wrapProcessingException((ProcessingException)e) : e;
        }
        return runtimeException;
    }

    private final void logResponse(Response response) {
        Set headersEntrySet = response.getHeaders().entrySet();
        String headersString2 = CollectionsKt.joinToString$default((Iterable)headersEntrySet, (CharSequence)"\n", null, null, (int)0, null, (Function1)logResponse.headersString.1.INSTANCE, (int)30, null);
        Companion.getLogger().debug((Function0)new Function0<String>(this, response, headersString2){
            final /* synthetic */ VcsRestClient this$0;
            final /* synthetic */ Response $response;
            final /* synthetic */ String $headersString;

            @NotNull
            public final String invoke() {
                return "Status: " + this.$response.getStatus() + "\nHeaders:\n" + this.$headersString + "\nbody:\n" + VcsRestClient.access$responseEntityToString(this.this$0, this.$response);
            }
            {
                this.this$0 = vcsRestClient;
                this.$response = response;
                this.$headersString = string;
                super(0);
            }
        });
    }

    private final String responseEntityToString(Response response) {
        response.bufferEntity();
        InputStream responseBodyStream = (InputStream)response.readEntity(InputStream.class);
        StringWriter writer = new StringWriter();
        try {
            IOUtils.copy((InputStream)responseBodyStream, (Writer)writer);
        }
        catch (IOException e) {
            Companion.getLogger().warn((Throwable)e, (Function0)responseEntityToString.1.INSTANCE);
        }
        response.bufferEntity();
        String string = writer.getBuffer().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"writer.buffer.toString()");
        return string;
    }

    @NotNull
    public final String getLandingUrl() {
        String url;
        CharSequence charSequence = WEB_HOOKS_BASE_URL;
        String string = url = charSequence == null || charSequence.length() == 0 ? BeansKt.getXdNotificationsConfig().getBaseUrl() : WEB_HOOKS_BASE_URL;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return StringsKt.removeSuffix((String)string, (CharSequence)"/");
    }

    private final RuntimeException wrapProcessingException(ProcessingException pe) {
        Throwable cause = pe.getCause();
        return cause instanceof UnknownHostException || cause instanceof MessageBodyProviderNotFoundException ? (RuntimeException)new JerseyClientExceptionWrapper(pe) : (RuntimeException)pe;
    }

    @NotNull
    public final String getUrl() {
        return this.url;
    }

    @Nullable
    public final XdStorageEntry getSslKey() {
        return this.sslKey;
    }

    public VcsRestClient(@NotNull String url, @Nullable XdStorageEntry sslKey) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        this.url = url;
        this.sslKey = sslKey;
    }

    static {
        Companion = new Companion(null);
        TIMEOUT = 300;
        WEB_HOOKS_BASE_URL = System.getProperty("jetbrains.youtrack.webHooksBaseUrl");
    }

    public static final /* synthetic */ String access$responseEntityToString(VcsRestClient $this, Response response) {
        return $this.responseEntityToString(response);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Ljetbrains/youtrack/integration/vcs/rest/VcsRestClient$Companion;", "Lmu/KLogging;", "()V", "TIMEOUT", "", "WEB_HOOKS_BASE_URL", "", "getWEB_HOOKS_BASE_URL", "()Ljava/lang/String;", "youtrack-github-integration"})
    public static final class Companion
    extends KLogging {
        @Nullable
        public final String getWEB_HOOKS_BASE_URL() {
            return WEB_HOOKS_BASE_URL;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

