/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.integration.vcs.rest.bitbucket;

import java.io.IOException;
import java.net.URI;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import jetbrains.exodus.database.TransientEntityStore;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.l10n.YouTrackLocalizer;
import jetbrains.youtrack.core.ssl.XdStorageEntry;
import jetbrains.youtrack.integration.Localization;
import jetbrains.youtrack.integration.github.BeansKt;
import jetbrains.youtrack.integration.github.persistence.CredentialsDto;
import jetbrains.youtrack.integration.github.persistence.XdBitBucketChangesProcessor;
import jetbrains.youtrack.integration.github.persistence.XdVcsHostingChangesProcessor;
import jetbrains.youtrack.integration.vcs.CommonChangeDTO;
import jetbrains.youtrack.integration.vcs.VcsUtils;
import jetbrains.youtrack.integration.vcs.rest.JerseyClientExceptionWrapper;
import jetbrains.youtrack.integration.vcs.rest.VcsRestClient;
import jetbrains.youtrack.integration.vcs.rest.VcsRestClientKt;
import jetbrains.youtrack.integration.vcs.rest.bitbucket.BitBucket20Branch;
import jetbrains.youtrack.integration.vcs.rest.bitbucket.BitBucket20Commit;
import jetbrains.youtrack.integration.vcs.rest.bitbucket.BitBucket20Hook;
import jetbrains.youtrack.integration.vcs.rest.bitbucket.BitBucket20Page;
import jetbrains.youtrack.integration.vcs.rest.bitbucket.BitBucket20ReferenceState;
import jetbrains.youtrack.integration.vcs.rest.bitbucket.BitBucketRest;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Charsets;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 )2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001)B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J,\u0010\u000e\u001a\n \u000b*\u0004\u0018\u00010\u000f0\u000f2\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00042\b\u0010\u0013\u001a\u0004\u0018\u00010\u0004H\u0002J\u0018\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0004H\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00040\u001a2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u0004H\u0016J\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u0004H\u0016J.\u0010\u001c\u001a\u0004\u0018\u00010\u001f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00042\b\u0010\u0013\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0004H\u0002J.\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0!2\u0006\u0010\u0015\u001a\u00020\u00022\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020\u0004J\u0018\u0010&\u001a\u00020'2\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u0004H\u0016J\u0010\u0010(\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0002H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\n \u000b*\u0004\u0018\u00010\u00040\u0004*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006*"}, d2={"Ljetbrains/youtrack/integration/vcs/rest/bitbucket/BitBucketRest;", "Ljetbrains/youtrack/integration/vcs/rest/VcsRestClient;", "Ljetbrains/youtrack/integration/github/persistence/XdBitBucketChangesProcessor;", "url", "", "sslKey", "Ljetbrains/youtrack/core/ssl/XdStorageEntry;", "(Ljava/lang/String;Ljetbrains/youtrack/core/ssl/XdStorageEntry;)V", "wr", "Ljavax/ws/rs/client/WebTarget;", "encodedHookId", "kotlin.jvm.PlatformType", "getEncodedHookId", "(Ljetbrains/youtrack/integration/github/persistence/XdBitBucketChangesProcessor;)Ljava/lang/String;", "addHeaders", "Ljavax/ws/rs/client/Invocation$Builder;", "creds", "Ljetbrains/youtrack/integration/github/persistence/CredentialsDto;", "login", "password", "createHook", "changesProcessor", "hookReceiverId", "deleteHook", "", "getBranches", "", "path", "getCommit", "Ljetbrains/youtrack/integration/vcs/CommonChangeDTO;", "hash", "Ljetbrains/youtrack/integration/vcs/rest/bitbucket/BitBucket20Commit;", "getCommitsRange", "", "prevState", "Ljetbrains/youtrack/integration/vcs/rest/bitbucket/BitBucket20ReferenceState;", "lastCommit", "branch", "isCommitThere", "", "ping", "Companion", "youtrack-github-integration"})
public final class BitBucketRest
extends VcsRestClient<XdBitBucketChangesProcessor> {
    private WebTarget wr;
    private static final int MAX_TRUNCATED_COMMITS_TO_LOAD = 2000;
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> getBranches(@NotNull CredentialsDto creds, @NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)creds, (String)"creds");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        WebTarget wr = this.wr.path("api/2.0/repositories/" + path + "/refs/branches");
        try {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            BitBucket20Page bitBucket20Page;
            GenericType<BitBucket20Page<BitBucket20Branch>> pageGeneric2 = new GenericType<BitBucket20Page<BitBucket20Branch>>(){};
            try {
                WebTarget webTarget = wr;
                Intrinsics.checkExpressionValueIsNotNull((Object)webTarget, (String)"wr");
                bitBucket20Page = (BitBucket20Page)this.addHeaders(webTarget, creds).get((GenericType)pageGeneric2);
            }
            catch (WebApplicationException e) {
                YouTrackLocalizer youTrackLocalizer = jetbrains.youtrack.api.l10n.BeansKt.getLocalizer();
                Object[] objectArray = new Object[1];
                Response response = e.getResponse();
                Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"e.response");
                Response.StatusType statusType = response.getStatusInfo();
                Intrinsics.checkExpressionValueIsNotNull((Object)statusType, (String)"e.response.statusInfo");
                objectArray[0] = statusType.getReasonPhrase();
                throw (Throwable)new RuntimeException(youTrackLocalizer.localizedMsg("BitBucketRest.Call_to_BitBucket_failed_with_status_{0}", objectArray));
            }
            BitBucket20Page firstPage = bitBucket20Page;
            Iterable iterable = $receiver$iv = (Iterable)firstPage.getValues();
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                BitBucket20Branch bitBucket20Branch = (BitBucket20Branch)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string = it.getName();
                collection.add(string);
            }
            List branches2 = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
            String nextPageLink = firstPage.getNext();
            while (nextPageLink != null) {
                Collection<String> collection;
                void $receiver$iv$iv2;
                void $receiver$iv2;
                Object it;
                URI uri = new URI(nextPageLink);
                WebTarget target = this.wr.path(uri.getPath());
                List list2 = URLEncodedUtils.parse((URI)uri, (Charset)Charsets.UTF_8);
                Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"URLEncodedUtils.parse(uri, Charsets.UTF_8)");
                Iterable $receiver$iv3 = list2;
                for (Object element$iv : $receiver$iv3) {
                    it = (NameValuePair)element$iv;
                    boolean bl = false;
                    NameValuePair nameValuePair = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)nameValuePair, (String)"it");
                    target = target.queryParam(nameValuePair.getName(), new Object[]{it.getValue()});
                }
                WebTarget webTarget = target;
                Intrinsics.checkExpressionValueIsNotNull((Object)webTarget, (String)"target");
                Object object = this.addHeaders(webTarget, creds).get((GenericType)pageGeneric2);
                BitBucket20Page page = (BitBucket20Page)object;
                boolean bl = false;
                nextPageLink = page.getNext();
                it = page.getValues();
                List list3 = branches2;
                void $i$f$forEach = $receiver$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv2) {
                    void it2;
                    BitBucket20Branch bitBucket20Branch = (BitBucket20Branch)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl2 = false;
                    String string = it2.getName();
                    collection.add(string);
                }
                collection = (List)destination$iv$iv2;
                list3.addAll((Collection)collection);
            }
            return branches2;
        }
        catch (WebApplicationException e) {
            throw (Throwable)new JerseyClientExceptionWrapper(e);
        }
        catch (UnknownHostException uhe) {
            throw (Throwable)new JerseyClientExceptionWrapper(new ProcessingException((Throwable)uhe));
        }
        catch (IOException e) {
            throw (Throwable)new RuntimeException(e);
        }
    }

    private final Invocation.Builder addHeaders(WebTarget wr, CredentialsDto creds) {
        Invocation.Builder builder = this.addHeaders(wr, creds.getLogin(), creds.getPassword());
        Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"addHeaders(wr, creds.login, creds.password)");
        return builder;
    }

    private final Invocation.Builder addHeaders(WebTarget wr, String login, String password) {
        String string = login + ':' + password;
        StringBuilder stringBuilder = new StringBuilder().append("Basic ");
        String string2 = "Authorization";
        Invocation.Builder builder = VcsRestClientKt.getStandardHeaders(wr);
        Charset charset = Charsets.UTF_8;
        String string3 = string;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string3.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        return builder.header(string2, (Object)stringBuilder.append(Base64.encodeBase64String((byte[])byArray2)).toString());
    }

    @Override
    public void ping(@NotNull XdBitBucketChangesProcessor changesProcessor) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)changesProcessor), (String)"changesProcessor");
        String fullPath = "api/2.0/repositories/" + changesProcessor.getPath() + "/hooks/" + this.getEncodedHookId(changesProcessor);
        WebTarget webTarget = this.wr.path(fullPath);
        Intrinsics.checkExpressionValueIsNotNull((Object)webTarget, (String)"wr.path(fullPath)");
        Invocation.Builder builder = this.addHeaders(webTarget, changesProcessor.getLogin(), changesProcessor.getPassword());
        Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"addHeaders(wr.path(fullP\u2026hangesProcessor.password)");
        this.get(builder, BitBucket20Hook.class);
    }

    @Override
    public boolean isCommitThere(@NotNull XdBitBucketChangesProcessor changesProcessor, @NotNull String hash) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)changesProcessor), (String)"changesProcessor");
        Intrinsics.checkParameterIsNotNull((Object)hash, (String)"hash");
        String string = changesProcessor.getPath();
        if (string == null) {
            throw (Throwable)new IllegalArgumentException("No project id is available, nowhere to add");
        }
        String path = string;
        return this.getCommit(changesProcessor.getLogin(), changesProcessor.getPassword(), path, hash) != null;
    }

    @Override
    @Nullable
    public CommonChangeDTO getCommit(@NotNull XdBitBucketChangesProcessor changesProcessor, @NotNull String hash) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)changesProcessor), (String)"changesProcessor");
        Intrinsics.checkParameterIsNotNull((Object)hash, (String)"hash");
        String string = changesProcessor.getPath();
        if (string == null) {
            throw (Throwable)new IllegalArgumentException("No project id is available, nowhere to add");
        }
        String path = string;
        BitBucket20Commit bitBucket20Commit = this.getCommit(changesProcessor.getLogin(), changesProcessor.getPassword(), path, hash);
        if (bitBucket20Commit == null) {
            return null;
        }
        BitBucket20Commit commit = bitBucket20Commit;
        return BeansKt.getBitBucketService().toDto((XdVcsHostingChangesProcessor)changesProcessor, commit, false);
    }

    @Override
    public void deleteHook(@NotNull XdBitBucketChangesProcessor changesProcessor, @NotNull CredentialsDto creds) {
        WebTarget wr;
        Intrinsics.checkParameterIsNotNull((Object)((Object)changesProcessor), (String)"changesProcessor");
        Intrinsics.checkParameterIsNotNull((Object)creds, (String)"creds");
        WebTarget webTarget = wr = this.wr.path("api/2.0/repositories/" + changesProcessor.getPath() + "/hooks/" + this.getEncodedHookId(changesProcessor));
        Intrinsics.checkExpressionValueIsNotNull((Object)webTarget, (String)"wr");
        this.delete(this.addHeaders(webTarget, creds));
    }

    @Override
    @NotNull
    public String createHook(@NotNull XdBitBucketChangesProcessor changesProcessor, @NotNull String hookReceiverId) {
        BitBucket20Hook bitBucket20Hook;
        Intrinsics.checkParameterIsNotNull((Object)((Object)changesProcessor), (String)"changesProcessor");
        Intrinsics.checkParameterIsNotNull((Object)hookReceiverId, (String)"hookReceiverId");
        String fullPath = "api/2.0/repositories/" + changesProcessor.getPath() + "/hooks";
        BitBucket20Hook $receiver = bitBucket20Hook = new BitBucket20Hook();
        boolean bl = false;
        $receiver.setUrl(this.getLandingUrl() + "/rest/vcsHooksReceiver/bitbucket20?apiKey=" + hookReceiverId);
        $receiver.setActive(true);
        $receiver.setEvents(CollectionsKt.listOf((Object)"repo:push"));
        $receiver.setDescription((String)Localization.INSTANCE.getBitbucketHookDescription().invoke((Object)changesProcessor.getProject().getName()));
        BitBucket20Hook request = bitBucket20Hook;
        WebTarget webTarget = this.wr.path(fullPath);
        Intrinsics.checkExpressionValueIsNotNull((Object)webTarget, (String)"wr.path(fullPath)");
        Invocation.Builder builder = this.addHeaders(webTarget, changesProcessor.getCredentials());
        Entity entity = Entity.json((Object)request);
        Intrinsics.checkExpressionValueIsNotNull((Object)entity, (String)"javax.ws.rs.client.Entity.json(request)");
        String string = this.post(builder, entity, BitBucket20Hook.class).getUuid();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return string;
    }

    private final String getEncodedHookId(@NotNull XdBitBucketChangesProcessor $receiver) {
        return URLEncoder.encode($receiver.getHookId(), StandardCharsets.UTF_8.name());
    }

    private final BitBucket20Commit getCommit(String login, String password, String path, String hash) {
        return (BitBucket20Commit)VcsRestClientKt.getCommit(path, hash, (Function0)new Function0<BitBucket20Commit>(this, path, hash, login, password){
            final /* synthetic */ BitBucketRest this$0;
            final /* synthetic */ String $path;
            final /* synthetic */ String $hash;
            final /* synthetic */ String $login;
            final /* synthetic */ String $password;

            @NotNull
            public final BitBucket20Commit invoke() {
                WebTarget webTarget = BitBucketRest.access$getWr$p(this.this$0).path("api/2.0/repositories/" + this.$path + "/commit/" + this.$hash);
                Intrinsics.checkExpressionValueIsNotNull((Object)webTarget, (String)"wr.path(\"api/2.0/repositories/$path/commit/$hash\")");
                Invocation.Builder builder = BitBucketRest.access$addHeaders(this.this$0, webTarget, this.$login, this.$password);
                Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"addHeaders(wr.path(\"api/\u2026$hash\"), login, password)");
                return this.this$0.get(builder, BitBucket20Commit.class);
            }
            {
                this.this$0 = bitBucketRest;
                this.$path = string;
                this.$hash = string2;
                this.$login = string3;
                this.$password = string4;
                super(0);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<BitBucket20Commit> getCommitsRange(@NotNull XdBitBucketChangesProcessor changesProcessor, @Nullable BitBucket20ReferenceState prevState, @NotNull BitBucket20Commit lastCommit, @NotNull String branch) {
        Object object;
        void foundStop;
        void foundStart;
        Long l;
        BitBucket20Commit prevCommit;
        Intrinsics.checkParameterIsNotNull((Object)((Object)changesProcessor), (String)"changesProcessor");
        Intrinsics.checkParameterIsNotNull((Object)lastCommit, (String)"lastCommit");
        Intrinsics.checkParameterIsNotNull((Object)branch, (String)"branch");
        ArrayList commits = new ArrayList();
        GenericType<BitBucket20Page<BitBucket20Commit>> pageGeneric2 = new GenericType<BitBucket20Page<BitBucket20Commit>>(){};
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = false;
        Ref.BooleanRef booleanRef2 = new Ref.BooleanRef();
        booleanRef2.element = false;
        BitBucket20ReferenceState bitBucket20ReferenceState = prevState;
        BitBucket20Commit bitBucket20Commit = prevCommit = bitBucket20ReferenceState != null ? bitBucket20ReferenceState.getTarget() : null;
        if (bitBucket20Commit != null) {
            BitBucket20Commit bitBucket20Commit2;
            BitBucket20Commit it = bitBucket20Commit2 = bitBucket20Commit;
            boolean bl = false;
            l = VcsUtils.toDatetime((String)prevCommit.getDate(), (String)"yyyy-MM-dd'T'HH:mm:ssXXX");
        } else {
            l = null;
        }
        Long prevStateDate = l;
        Long lastTruncatedCommitDate = VcsUtils.toDatetime((String)lastCommit.getDate(), (String)"yyyy-MM-dd'T'HH:mm:ssXXX");
        VcsRestClient.Companion.getLogger().trace((Function0)new Function0<String>(lastCommit){
            final /* synthetic */ BitBucket20Commit $lastCommit;

            @NotNull
            public final String invoke() {
                return "Last truncated commit is : " + this.$lastCommit.getHash();
            }
            {
                this.$lastCommit = bitBucket20Commit;
                super(0);
            }
        });
        VcsRestClient.Companion.getLogger().trace((Function0)new Function0<String>(prevState){
            final /* synthetic */ BitBucket20ReferenceState $prevState;

            @NotNull
            public final String invoke() {
                StringBuilder stringBuilder = new StringBuilder().append("Previous state hash is : ");
                Object object = this.$prevState;
                if (object == null || (object = ((BitBucket20ReferenceState)object).getTarget()) == null || (object = ((BitBucket20Commit)object).getHash()) == null) {
                    object = " null, so we are to load all commits from new created branch";
                }
                return stringBuilder.append((String)object).toString();
            }
            {
                this.$prevState = bitBucket20ReferenceState;
                super(0);
            }
        });
        Function1 loadCommitsFromPage2 = (Function1)new Function1<BitBucket20Page<BitBucket20Commit>, Unit>((Ref.BooleanRef)foundStart, lastCommit, prevStateDate, lastTruncatedCommitDate, (Ref.BooleanRef)foundStop, prevCommit, commits, prevState){
            final /* synthetic */ Ref.BooleanRef $foundStart;
            final /* synthetic */ BitBucket20Commit $lastCommit;
            final /* synthetic */ Long $prevStateDate;
            final /* synthetic */ Long $lastTruncatedCommitDate;
            final /* synthetic */ Ref.BooleanRef $foundStop;
            final /* synthetic */ BitBucket20Commit $prevCommit;
            final /* synthetic */ ArrayList $commits;
            final /* synthetic */ BitBucket20ReferenceState $prevState;

            public final void invoke(@NotNull BitBucket20Page<BitBucket20Commit> commitsPage) {
                Intrinsics.checkParameterIsNotNull(commitsPage, (String)"commitsPage");
                for (BitBucket20Commit commit : commitsPage.getValues()) {
                    VcsRestClient.Companion.getLogger().trace((Function0)new Function0<String>(commit){
                        final /* synthetic */ BitBucket20Commit $commit;

                        @NotNull
                        public final String invoke() {
                            return "Checking commit " + this.$commit.getHash() + ", " + this.$commit.getDate() + ", " + this.$commit.getMessage();
                        }
                        {
                            this.$commit = bitBucket20Commit;
                            super(0);
                        }
                    });
                    if (!this.$foundStart.element) {
                        if (Intrinsics.areEqual((Object)commit.getHash(), (Object)this.$lastCommit.getHash())) {
                            VcsRestClient.Companion.getLogger().info("Found start commit " + this.$lastCommit.getHash());
                            this.$foundStart.element = true;
                            continue;
                        }
                        Long commitDate = VcsUtils.toDatetime((String)commit.getDate(), (String)"yyyy-MM-dd'T'HH:mm:ssXXX");
                        if (this.$foundStart.element) continue;
                        long l = commitDate;
                        Long l2 = this.$prevStateDate;
                        long l3 = l2 != null ? l2 : Long.MIN_VALUE;
                        Long l4 = this.$lastTruncatedCommitDate;
                        Intrinsics.checkExpressionValueIsNotNull((Object)l4, (String)"lastTruncatedCommitDate");
                        if (l >= Math.max(l3, l4)) continue;
                        VcsRestClient.Companion.getLogger().error("Failed to find first commit lastCommit in bitbucket");
                        this.$foundStop.element = true;
                        break;
                    }
                    if (this.$prevCommit != null) {
                        if (Intrinsics.areEqual((Object)commit.getHash(), (Object)this.$prevCommit.getHash()) ^ true) {
                            long l = VcsUtils.toDatetime((String)this.$prevCommit.getDate(), (String)"yyyy-MM-dd'T'HH:mm:ssXXX");
                            Long l5 = this.$prevStateDate;
                            if (l5 == null) {
                                Intrinsics.throwNpe();
                            }
                            if (l >= l5) {
                                this.$commits.add(commit);
                                continue;
                            }
                        }
                        if (Intrinsics.areEqual((Object)commit.getHash(), (Object)this.$prevCommit.getHash())) {
                            VcsRestClient.Companion.getLogger().trace((Function0)new Function0<String>(this){
                                final /* synthetic */ getCommitsRange.loadCommitsFromPage.1 this$0;

                                @NotNull
                                public final String invoke() {
                                    return "Found prev reference hash " + this.this$0.$prevCommit.getHash();
                                }
                                {
                                    this.this$0 = var1_1;
                                    super(0);
                                }
                            });
                        } else {
                            VcsRestClient.Companion.getLogger().trace((Function0)new Function0<String>(this, commit){
                                final /* synthetic */ getCommitsRange.loadCommitsFromPage.1 this$0;
                                final /* synthetic */ BitBucket20Commit $commit;

                                @NotNull
                                public final String invoke() {
                                    BitBucket20Commit bitBucket20Commit = this.this$0.$prevState.getTarget();
                                    return "Found commit date is lower than previous ref date (" + this.$commit.getDate() + " is lower than " + (bitBucket20Commit != null ? bitBucket20Commit.getDate() : null) + ')';
                                }
                                {
                                    this.this$0 = var1_1;
                                    this.$commit = bitBucket20Commit;
                                    super(0);
                                }
                            });
                        }
                        this.$foundStop.element = true;
                        break;
                    }
                    this.$commits.add(commit);
                }
            }
            {
                this.$foundStart = booleanRef;
                this.$lastCommit = bitBucket20Commit;
                this.$prevStateDate = l;
                this.$lastTruncatedCommitDate = l2;
                this.$foundStop = booleanRef2;
                this.$prevCommit = bitBucket20Commit2;
                this.$commits = arrayList;
                this.$prevState = bitBucket20ReferenceState;
                super(1);
            }
        };
        BitBucketRest bitBucketRest = this;
        boolean $i$f$transactional = false;
        Object object2 = object = TransientEntityStore.DefaultImpls.transactional$default((TransientEntityStore)DnqUtils.getTransientStore(), (boolean)false, null, (boolean)false, (Function1)((Function1)new Function1<TransientStoreSession, Invocation.Builder>(this, changesProcessor, branch){
            final /* synthetic */ BitBucketRest this$0;
            final /* synthetic */ XdBitBucketChangesProcessor $changesProcessor$inlined;
            final /* synthetic */ String $branch$inlined;
            {
                this.this$0 = bitBucketRest;
                this.$changesProcessor$inlined = xdBitBucketChangesProcessor;
                this.$branch$inlined = string;
                super(1);
            }

            public final Invocation.Builder invoke(@NotNull TransientStoreSession it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                boolean bl = false;
                WebTarget webTarget = BitBucketRest.access$getWr$p(this.this$0).path("api/2.0/repositories/" + this.$changesProcessor$inlined.getPath() + "/commits/" + this.$branch$inlined);
                Intrinsics.checkExpressionValueIsNotNull((Object)webTarget, (String)"this.wr.path(\"api/2.0/re\u2026r.path}/commits/$branch\")");
                return BitBucketRest.access$addHeaders(this.this$0, webTarget, this.$changesProcessor$inlined.getLogin(), this.$changesProcessor$inlined.getPassword());
            }
        }), (int)7, null);
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"transactional {\n        \u2026ssword)\n                }");
        BitBucket20Page page = (BitBucket20Page)bitBucketRest.get((Invocation.Builder)object2, (GenericType)pageGeneric2);
        VcsRestClient.Companion.getLogger().info("Loading first commits page");
        loadCommitsFromPage2.invoke((Object)page);
        int pageNumber = 1;
        while (page.getNext() != null && !foundStop.element && commits.size() < MAX_TRUNCATED_COMMITS_TO_LOAD) {
            void target;
            VcsRestClient.Companion.getLogger().info("Loading next commits page " + ++pageNumber);
            URI uri = new URI(page.getNext());
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = this.wr.path(uri.getPath());
            List list2 = URLEncodedUtils.parse((URI)uri, (Charset)Charsets.UTF_8);
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"URLEncodedUtils.parse(uri, Charsets.UTF_8)");
            Iterable $receiver$iv = list2;
            for (Object element$iv : $receiver$iv) {
                NameValuePair it = (NameValuePair)element$iv;
                boolean bl = false;
                WebTarget webTarget = (WebTarget)target.element;
                NameValuePair nameValuePair = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)nameValuePair, (String)"it");
                target.element = webTarget.queryParam(nameValuePair.getName(), new Object[]{it.getValue()});
            }
            bitBucketRest = this;
            boolean $i$f$transactional2 = false;
            Object object3 = object = TransientEntityStore.DefaultImpls.transactional$default((TransientEntityStore)DnqUtils.getTransientStore(), (boolean)false, null, (boolean)false, (Function1)((Function1)new Function1<TransientStoreSession, Invocation.Builder>(this, (Ref.ObjectRef)target, changesProcessor){
                final /* synthetic */ BitBucketRest this$0;
                final /* synthetic */ Ref.ObjectRef $target$inlined;
                final /* synthetic */ XdBitBucketChangesProcessor $changesProcessor$inlined;
                {
                    this.this$0 = bitBucketRest;
                    this.$target$inlined = objectRef;
                    this.$changesProcessor$inlined = xdBitBucketChangesProcessor;
                    super(1);
                }

                public final Invocation.Builder invoke(@NotNull TransientStoreSession it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    boolean bl = false;
                    WebTarget webTarget = (WebTarget)this.$target$inlined.element;
                    Intrinsics.checkExpressionValueIsNotNull((Object)webTarget, (String)"target");
                    return BitBucketRest.access$addHeaders(this.this$0, webTarget, this.$changesProcessor$inlined.getLogin(), this.$changesProcessor$inlined.getPassword());
                }
            }), (int)7, null);
            Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"transactional {\n        \u2026rd)\n                    }");
            page = (BitBucket20Page)bitBucketRest.get((Invocation.Builder)object3, (GenericType)pageGeneric2);
            loadCommitsFromPage2.invoke((Object)page);
        }
        if (!foundStop.element && commits.size() >= MAX_TRUNCATED_COMMITS_TO_LOAD) {
            VcsRestClient.Companion.getLogger().info("Truncated commits size exceeded max allowed number of " + MAX_TRUNCATED_COMMITS_TO_LOAD);
        }
        return commits;
    }

    public BitBucketRest(@NotNull String url, @Nullable XdStorageEntry sslKey) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        super(url, sslKey);
        WebTarget webTarget = VcsRestClientKt.buildWebTarget(url, sslKey);
        Intrinsics.checkExpressionValueIsNotNull((Object)webTarget, (String)"buildWebTarget(url, sslKey)");
        this.wr = webTarget;
    }

    static {
        MAX_TRUNCATED_COMMITS_TO_LOAD = 2000;
    }

    public static final /* synthetic */ Invocation.Builder access$addHeaders(BitBucketRest $this, WebTarget wr, String login, String password) {
        return $this.addHeaders(wr, login, password);
    }

    public static final /* synthetic */ WebTarget access$getWr$p(BitBucketRest $this) {
        return $this.wr;
    }

    public static final /* synthetic */ void access$setWr$p(BitBucketRest $this, WebTarget webTarget) {
        $this.wr = webTarget;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Ljetbrains/youtrack/integration/vcs/rest/bitbucket/BitBucketRest$Companion;", "", "()V", "MAX_TRUNCATED_COMMITS_TO_LOAD", "", "getMAX_TRUNCATED_COMMITS_TO_LOAD", "()I", "youtrack-github-integration"})
    public static final class Companion {
        public final int getMAX_TRUNCATED_COMMITS_TO_LOAD() {
            return MAX_TRUNCATED_COMMITS_TO_LOAD;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

