/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.integration.vcs.rest.github;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;
import jetbrains.charisma.user.XdApiKey;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.IListSequence;
import jetbrains.mps.internal.collections.runtime.ISelector;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.youtrack.core.ssl.SSLContextFactoryKt;
import jetbrains.youtrack.core.ssl.XdStorageEntry;
import jetbrains.youtrack.integration.github.BeansKt;
import jetbrains.youtrack.integration.github.persistence.CredentialsDto;
import jetbrains.youtrack.integration.github.persistence.XdGithubChangesProcessor;
import jetbrains.youtrack.integration.github.persistence.XdVcsHostingChangesProcessor;
import jetbrains.youtrack.integration.vcs.CommonChangeDTO;
import jetbrains.youtrack.integration.vcs.rest.VcsRestClient;
import jetbrains.youtrack.integration.vcs.rest.github.ExtendedRepositoryService;
import jetbrains.youtrack.integration.vcs.rest.github.GitHubException;
import jetbrains.youtrack.integration.vcs.rest.github.WebHook;
import jetbrains.youtrack.integration.vcs.service.GitHubService;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.egit.github.core.Commit;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.Repository;
import org.eclipse.egit.github.core.RepositoryBranch;
import org.eclipse.egit.github.core.RepositoryCommit;
import org.eclipse.egit.github.core.RepositoryHook;
import org.eclipse.egit.github.core.UserPlan;
import org.eclipse.egit.github.core.client.DateFormatter;
import org.eclipse.egit.github.core.client.EventFormatter;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.client.RequestException;
import org.eclipse.egit.github.core.event.Event;
import org.eclipse.egit.github.core.service.CommitService;
import org.eclipse.egit.github.core.service.RepositoryService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 -2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002-.B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004H\u0002J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u0004H\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0004H\u0002J\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u00172\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0004H\u0016J\u0012\u0010\u0019\u001a\u00020\t2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0004H\u0002J\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u0004H\u0016J\u0012\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0004H\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u0014\u001a\u00020\u0002H\u0002J\u0012\u0010#\u001a\u00020$2\b\u0010 \u001a\u0004\u0018\u00010\u0004H\u0002J\u0018\u0010%\u001a\u00020&2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u0004H\u0016J\u0010\u0010'\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u0010\u0010(\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020*H\u0002J\f\u0010+\u001a\u00020\u000f*\u00020,H\u0002\u00a8\u0006/"}, d2={"Ljetbrains/youtrack/integration/vcs/rest/github/GitHubRest;", "Ljetbrains/youtrack/integration/vcs/rest/VcsRestClient;", "Ljetbrains/youtrack/integration/github/persistence/XdGithubChangesProcessor;", "url", "", "sslKey", "Ljetbrains/youtrack/core/ssl/XdStorageEntry;", "(Ljava/lang/String;Ljetbrains/youtrack/core/ssl/XdStorageEntry;)V", "createClient", "Lorg/eclipse/egit/github/core/client/GitHubClient;", "githubUrl", "createHook", "changesProcessor", "hookReceiverId", "deleteHook", "", "creds", "Ljetbrains/youtrack/integration/github/persistence/CredentialsDto;", "doGetCommit", "Lorg/eclipse/egit/github/core/RepositoryCommit;", "repo", "sha", "getBranches", "", "path", "getClient", "oauthToken", "getCommit", "Ljetbrains/youtrack/integration/vcs/CommonChangeDTO;", "hash", "getCommitService", "Lorg/eclipse/egit/github/core/service/CommitService;", "token", "getHook", "Lorg/eclipse/egit/github/core/RepositoryHook;", "getRepositoryService", "Lorg/eclipse/egit/github/core/service/RepositoryService;", "isCommitThere", "", "ping", "throwNoAdminException", "e", "Lorg/eclipse/egit/github/core/client/RequestException;", "setup", "Ljava/net/HttpURLConnection;", "Companion", "GitHubCli", "youtrack-github-integration"})
public final class GitHubRest
extends VcsRestClient<XdGithubChangesProcessor> {
    @NotNull
    private static final String HOOK_NAME = "web";
    @NotNull
    private static final String COMMTITTERS = "committers";
    @NotNull
    private static final String BRANCH = "branch";
    private static Log log;
    public static final Companion Companion;

    private final void throwNoAdminException(RequestException e) {
        String string = jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("GitHubRest.You_do_not_have_admin_permission_on_the_repository", new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"localizer.localizedMsg(\"\u2026ssion_on_the_repository\")");
        throw (Throwable)new GitHubException(string, e);
    }

    @Override
    @NotNull
    public List<String> getBranches(@NotNull CredentialsDto creds, @NotNull String path) throws GitHubException {
        Intrinsics.checkParameterIsNotNull((Object)creds, (String)"creds");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        log.info((Object)new Function0<Unit>(path){
            final /* synthetic */ String $path;

            public final void invoke() {
                GitHubRest.Companion.getLog().info((Object)("Retrieving branches from " + this.$path));
            }
            {
                this.$path = string;
                super(0);
            }
        });
        RepositoryService service = this.getRepositoryService(creds.getToken());
        try {
            List branches2 = service.getBranches((IRepositoryIdProvider)service.getRepository(GitHubRest.Companion.getOwner(path), GitHubRest.Companion.getName(path)));
            IListSequence iListSequence = ListSequence.fromList((List)((List)ListSequence.fromListWithValues((List)new ArrayList(), (Iterable)branches2))).select((_FunctionTypes._return_P1_E0)new ISelector<RepositoryBranch, String>(){

                @NotNull
                public String select(@NotNull RepositoryBranch it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    String string = it.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.name");
                    return string;
                }
            }).toListSequence();
            Intrinsics.checkExpressionValueIsNotNull((Object)iListSequence, (String)"ListSequence.fromList(Li\u2026      }).toListSequence()");
            return (List)iListSequence;
        }
        catch (IOException exception) {
            throw (Throwable)new GitHubException(exception);
        }
    }

    private final RepositoryHook getHook(XdGithubChangesProcessor repo) {
        long l;
        WebHook webHook;
        XdApiKey xdApiKey = repo.getApiKey();
        String key = xdApiKey != null ? xdApiKey.getKey() : null;
        WebHook $receiver = webHook = new WebHook();
        boolean bl = false;
        $receiver.setName(HOOK_NAME);
        $receiver.setActive(repo.getEnabled());
        WebHook webHook2 = $receiver;
        String string = repo.getHookId();
        if (string != null) {
            String string2 = string;
            WebHook webHook3 = webHook2;
            long l2 = Long.parseLong(string2);
            webHook2 = webHook3;
            l = l2;
        } else {
            l = 0L;
        }
        webHook2.setId(l);
        $receiver.setConfig(MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"url", (Object)(this.getLandingUrl() + "/rest/vcsHooksReceiver/github?apiKey=" + key)), TuplesKt.to((Object)"content_type", (Object)"json"), TuplesKt.to((Object)"insecure_ssl", (Object)"1"), TuplesKt.to((Object)"secret", (Object)key)}));
        $receiver.setEvents(new String[]{"push", "pull_request"});
        return webHook;
    }

    private final RepositoryService getRepositoryService(String token) {
        return new ExtendedRepositoryService(this.getClient(token));
    }

    private final CommitService getCommitService(String token) {
        return new CommitService(this.getClient(token));
    }

    private final GitHubClient getClient(String oauthToken) {
        GitHubClient gitHubClient;
        GitHubClient $receiver = gitHubClient = this.createClient(this.getUrl());
        boolean bl = false;
        $receiver.setOAuth2Token(oauthToken);
        return gitHubClient;
    }

    private final GitHubClient createClient(String githubUrl) {
        try {
            URL url = new URL(githubUrl);
            String host = url.getHost();
            return Intrinsics.areEqual((Object)host, (Object)"github.com") || Intrinsics.areEqual((Object)host, (Object)"gist.github.com") ? (GitHubClient)new GitHubClient(this, "api.github.com"){
                final /* synthetic */ GitHubRest this$0;

                protected HttpURLConnection createConnection(@NotNull String url) throws IOException {
                    HttpURLConnection httpURLConnection;
                    Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
                    HttpURLConnection $receiver = httpURLConnection = super.createConnection(url);
                    boolean bl = false;
                    GitHubRest.access$setup(this.this$0, $receiver);
                    return httpURLConnection;
                }
                {
                    this.this$0 = $outer;
                    super($super_call_param$1);
                }
            } : (GitHubClient)new GitHubCli(url);
        }
        catch (MalformedURLException ex) {
            throw (Throwable)new RuntimeException("Invalid github url");
        }
    }

    private final RepositoryCommit doGetCommit(XdGithubChangesProcessor repo, String sha) {
        RepositoryCommit repositoryCommit;
        CommitService commitService = this.getCommitService(repo.getOauthToken());
        try {
            repositoryCommit = commitService.getCommit(new IRepositoryIdProvider(repo){
                final /* synthetic */ XdGithubChangesProcessor $repo;

                @Nullable
                public final String generateId() {
                    return this.$repo.getPath();
                }
                {
                    this.$repo = xdGithubChangesProcessor;
                }
            }, sha);
        }
        catch (IOException exception) {
            if (exception instanceof RequestException && ((RequestException)exception).getStatus() != 404) {
                repo.logException(exception, "Exception when getting a github commit " + sha + " in " + repo.getPath(), false, false);
            }
            repositoryCommit = null;
        }
        return repositoryCommit;
    }

    private final void setup(@NotNull HttpURLConnection $receiver) throws IOException {
        $receiver.setConnectTimeout(10000);
        $receiver.setReadTimeout(100000);
    }

    @Override
    @NotNull
    public String createHook(@NotNull XdGithubChangesProcessor changesProcessor, @NotNull String hookReceiverId) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)changesProcessor), (String)"changesProcessor");
        Intrinsics.checkParameterIsNotNull((Object)hookReceiverId, (String)"hookReceiverId");
        try {
            RepositoryHook result;
            RepositoryService service = this.getRepositoryService(changesProcessor.getOauthToken());
            Repository repository = service.getRepository(GitHubRest.Companion.getOwner(changesProcessor), GitHubRest.Companion.getName(changesProcessor));
            RepositoryHook repositoryHook = result = service.createHook((IRepositoryIdProvider)repository, this.getHook(changesProcessor));
            Intrinsics.checkExpressionValueIsNotNull((Object)repositoryHook, (String)"result");
            return String.valueOf(repositoryHook.getId());
        }
        catch (RequestException e) {
            if (e.getStatus() == 404) {
                this.throwNoAdminException(e);
            }
            throw (Throwable)new GitHubException((Exception)((Object)e));
        }
        catch (IOException ex) {
            throw (Throwable)new GitHubException(ex);
        }
    }

    @Override
    public void deleteHook(@NotNull XdGithubChangesProcessor changesProcessor, @NotNull CredentialsDto creds) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)changesProcessor), (String)"changesProcessor");
        Intrinsics.checkParameterIsNotNull((Object)creds, (String)"creds");
        changesProcessor.logInfo("Deleting a hook");
        RepositoryService service = this.getRepositoryService(creds.getToken());
        try {
            service.deleteHook((IRepositoryIdProvider)service.getRepository(GitHubRest.Companion.getOwner(changesProcessor), GitHubRest.Companion.getName(changesProcessor)), Integer.parseInt(changesProcessor.getHookId()));
        }
        catch (IOException exception) {
            throw (Throwable)new GitHubException(exception);
        }
    }

    @Override
    @Nullable
    public CommonChangeDTO getCommit(@NotNull XdGithubChangesProcessor changesProcessor, @NotNull String hash) {
        Commit commit;
        Intrinsics.checkParameterIsNotNull((Object)((Object)changesProcessor), (String)"changesProcessor");
        Intrinsics.checkParameterIsNotNull((Object)hash, (String)"hash");
        RepositoryCommit repositoryCommit = this.doGetCommit(changesProcessor, hash);
        if (repositoryCommit == null) {
            return null;
        }
        RepositoryCommit rc = repositoryCommit;
        Commit $receiver = commit = rc.getCommit();
        boolean bl = false;
        $receiver.setSha(rc.getSha());
        Commit commit2 = commit;
        GitHubService gitHubService = BeansKt.getGitHubService();
        XdVcsHostingChangesProcessor xdVcsHostingChangesProcessor = changesProcessor;
        Commit commit3 = commit2;
        Intrinsics.checkExpressionValueIsNotNull((Object)commit3, (String)"commit");
        return gitHubService.toDto(xdVcsHostingChangesProcessor, commit3, false);
    }

    @Override
    public boolean isCommitThere(@NotNull XdGithubChangesProcessor changesProcessor, @NotNull String hash) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)changesProcessor), (String)"changesProcessor");
        Intrinsics.checkParameterIsNotNull((Object)hash, (String)"hash");
        return this.doGetCommit(changesProcessor, hash) != null;
    }

    @Override
    public void ping(@NotNull XdGithubChangesProcessor changesProcessor) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)changesProcessor), (String)"changesProcessor");
        changesProcessor.logInfo("Listing available hooks");
        try {
            RepositoryService service = this.getRepositoryService(changesProcessor.getOauthToken());
            Repository repository = service.getRepository(GitHubRest.Companion.getOwner(changesProcessor), GitHubRest.Companion.getName(changesProcessor));
            service.getHooks((IRepositoryIdProvider)repository);
        }
        catch (RequestException e) {
            if (e.getStatus() == 404) {
                this.throwNoAdminException(e);
            }
            throw (Throwable)new GitHubException((Exception)((Object)e));
        }
        catch (IOException ex) {
            throw (Throwable)new GitHubException(ex);
        }
    }

    public GitHubRest(@NotNull String url, @Nullable XdStorageEntry sslKey) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        super(url, sslKey);
    }

    static {
        Companion = new Companion(null);
        HOOK_NAME = HOOK_NAME;
        COMMTITTERS = COMMTITTERS;
        BRANCH = BRANCH;
        log = LogFactory.getLog(GitHubRest.class);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\tH\u0014\u00a8\u0006\n"}, d2={"Ljetbrains/youtrack/integration/vcs/rest/github/GitHubRest$GitHubCli;", "Lorg/eclipse/egit/github/core/client/GitHubClient;", "url", "Ljava/net/URL;", "(Ljetbrains/youtrack/integration/vcs/rest/github/GitHubRest;Ljava/net/URL;)V", "buildGson", "Lcom/google/gson/Gson;", "createConnection", "Ljava/net/HttpURLConnection;", "", "youtrack-github-integration"})
    public final class GitHubCli
    extends GitHubClient {
        @NotNull
        protected HttpURLConnection createConnection(@NotNull String url) throws IOException {
            HttpURLConnection httpURLConnection;
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            HttpURLConnection $receiver = httpURLConnection = super.createConnection(url);
            boolean bl = false;
            if ($receiver instanceof HttpsURLConnection) {
                ((HttpsURLConnection)$receiver).setSSLSocketFactory(SSLContextFactoryKt.createSSLContext((XdStorageEntry)GitHubRest.this.getSslKey()).getSocketFactory());
            }
            GitHubRest.this.setup($receiver);
            HttpURLConnection httpURLConnection2 = httpURLConnection;
            Intrinsics.checkExpressionValueIsNotNull((Object)httpURLConnection2, (String)"super.createConnection(u\u2026    setup()\n            }");
            return httpURLConnection2;
        }

        private final Gson buildGson() {
            GsonBuilder gsonBuilder;
            GsonBuilder $receiver = gsonBuilder = new GsonBuilder();
            boolean bl = false;
            $receiver.registerTypeAdapter((Type)((Object)Date.class), (Object)new DateFormatter());
            $receiver.registerTypeAdapter((Type)((Object)Event.class), (Object)new EventFormatter());
            $receiver.setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES);
            $receiver.serializeNulls();
            $receiver.setExclusionStrategies(new ExclusionStrategy[]{new ExclusionStrategy(){

                public boolean shouldSkipField(@NotNull FieldAttributes p0) {
                    Intrinsics.checkParameterIsNotNull((Object)p0, (String)"p0");
                    return false;
                }

                public boolean shouldSkipClass(@NotNull Class<?> c) {
                    Intrinsics.checkParameterIsNotNull(c, (String)"c");
                    return Intrinsics.areEqual(c, UserPlan.class);
                }
            }});
            Gson gson = gsonBuilder.create();
            Intrinsics.checkExpressionValueIsNotNull((Object)gson, (String)"GsonBuilder().apply {\n  \u2026})\n            }.create()");
            return gson;
        }

        public GitHubCli(URL url) {
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            super(url.getHost(), url.getPort(), url.getProtocol());
            this.gson = this.buildGson();
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0012\u0010\u0012\u001a\u00020\u00042\b\u0010\u0015\u001a\u0004\u0018\u00010\u0004H\u0002J\u0010\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0012\u0010\u0016\u001a\u00020\u00042\b\u0010\u0015\u001a\u0004\u0018\u00010\u0004H\u0002J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u00182\u0006\u0010\u0015\u001a\u00020\u0004H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\"\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0019"}, d2={"Ljetbrains/youtrack/integration/vcs/rest/github/GitHubRest$Companion;", "", "()V", "BRANCH", "", "getBRANCH", "()Ljava/lang/String;", "COMMTITTERS", "getCOMMTITTERS", "HOOK_NAME", "getHOOK_NAME", "log", "Lorg/apache/commons/logging/Log;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/apache/commons/logging/Log;", "setLog", "(Lorg/apache/commons/logging/Log;)V", "getName", "repo", "Ljetbrains/youtrack/integration/github/persistence/XdGithubChangesProcessor;", "repoPath", "getOwner", "splitAndCheck", "", "youtrack-github-integration"})
    public static final class Companion {
        @NotNull
        public final String getHOOK_NAME() {
            return HOOK_NAME;
        }

        @NotNull
        public final String getCOMMTITTERS() {
            return COMMTITTERS;
        }

        @NotNull
        public final String getBRANCH() {
            return BRANCH;
        }

        protected final Log getLog() {
            return log;
        }

        protected final void setLog(Log log) {
            GitHubRest.log = log;
        }

        private final String getOwner(XdGithubChangesProcessor repo) {
            return this.getOwner(repo.getPath());
        }

        private final String getName(XdGithubChangesProcessor repo) {
            return this.getName(repo.getPath());
        }

        private final String getOwner(String repoPath) {
            String string = repoPath;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            return this.splitAndCheck(string).get(0);
        }

        private final String getName(String repoPath) {
            String string = repoPath;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            return this.splitAndCheck(string).get(1);
        }

        private final List<String> splitAndCheck(String repoPath) throws IllegalArgumentException {
            List segments = StringsKt.split$default((CharSequence)repoPath, (String[])new String[]{"/"}, (boolean)false, (int)0, (int)6, null);
            if (segments.size() != 2) {
                throw (Throwable)new IllegalArgumentException("Invalid repository path format: " + repoPath);
            }
            return segments;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

