/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.integration.vcs.rest.gitlab;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import jetbrains.charisma.misc.DocumentationLink;
import jetbrains.mps.gtext.runtime.BaseHtmlStringUtil;
import jetbrains.mps.internationalization.runtime.Localization;
import jetbrains.mps.internationalization.runtime.LocalizationObject;
import jetbrains.mps.webr.runtime.templateComponent.LocalizedLogicException;
import jetbrains.youtrack.core.ssl.XdStorageEntry;
import jetbrains.youtrack.integration.github.BeansKt;
import jetbrains.youtrack.integration.github.persistence.CredentialsDto;
import jetbrains.youtrack.integration.github.persistence.XdGitLabChangesProcessor;
import jetbrains.youtrack.integration.github.persistence.XdVcsHostingChangesProcessor;
import jetbrains.youtrack.integration.vcs.CommonChangeDTO;
import jetbrains.youtrack.integration.vcs.rest.JerseyClientExceptionWrapper;
import jetbrains.youtrack.integration.vcs.rest.VcsRestClient;
import jetbrains.youtrack.integration.vcs.rest.VcsRestClientKt;
import jetbrains.youtrack.integration.vcs.rest.gitlab.GitLabBranch;
import jetbrains.youtrack.integration.vcs.rest.gitlab.GitLabBranches;
import jetbrains.youtrack.integration.vcs.rest.gitlab.GitLabCommit;
import jetbrains.youtrack.integration.vcs.rest.gitlab.GitLabGroup;
import jetbrains.youtrack.integration.vcs.rest.gitlab.GitLabGroups;
import jetbrains.youtrack.integration.vcs.rest.gitlab.GitLabHook;
import jetbrains.youtrack.integration.vcs.rest.gitlab.GitLabProject;
import jetbrains.youtrack.integration.vcs.rest.gitlab.GitLabProjects;
import jetbrains.youtrack.integration.vcs.rest.gitlab.GitLabRest;
import jetbrains.youtrack.integration.vcs.rest.gitlab.GitLabUser;
import jetbrains.youtrack.integration.vcs.rest.gitlab.GitLabUsers;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0004J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0004J\"\u0010\u0014\u001a\n \u0018*\u0004\u0018\u00010\u00150\u00152\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0004H\u0004J\u0018\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u0004H\u0016J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u001e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00040 2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010!\u001a\u00020\u0004H\u0016J\u001a\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u001b\u001a\u00020\u00022\u0006\u0010$\u001a\u00020\u0004H\u0016J$\u0010\"\u001a\u0004\u0018\u00010%2\b\u0010\u0019\u001a\u0004\u0018\u00010\u00042\u0006\u0010&\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u0004H\u0002J\u001c\u0010'\u001a\u0004\u0018\u00010\u00042\b\u0010\u0019\u001a\u0004\u0018\u00010\u00042\u0006\u0010!\u001a\u00020\u0004H\u0002J\u0018\u0010(\u001a\u00020)2\u0006\u0010\u001b\u001a\u00020\u00022\u0006\u0010$\u001a\u00020\u0004H\u0016J\u0010\u0010*\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u0002H\u0016R\u0014\u0010\b\u001a\u00020\u00048TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006+"}, d2={"Ljetbrains/youtrack/integration/vcs/rest/gitlab/GitLabRest;", "Ljetbrains/youtrack/integration/vcs/rest/VcsRestClient;", "Ljetbrains/youtrack/integration/github/persistence/XdGitLabChangesProcessor;", "url", "", "sslKey", "Ljetbrains/youtrack/core/ssl/XdStorageEntry;", "(Ljava/lang/String;Ljetbrains/youtrack/core/ssl/XdStorageEntry;)V", "apiPrefix", "getApiPrefix", "()Ljava/lang/String;", "wr", "Ljavax/ws/rs/client/WebTarget;", "getWr", "()Ljavax/ws/rs/client/WebTarget;", "setWr", "(Ljavax/ws/rs/client/WebTarget;)V", "addCommonSearchParams", "wt", "search", "addHeaders", "Ljavax/ws/rs/client/Invocation$Builder;", "creds", "Ljetbrains/youtrack/integration/github/persistence/CredentialsDto;", "kotlin.jvm.PlatformType", "token", "createHook", "changesProcessor", "hookReceiverId", "deleteHook", "", "getBranches", "", "path", "getCommit", "Ljetbrains/youtrack/integration/vcs/CommonChangeDTO;", "hash", "Ljetbrains/youtrack/integration/vcs/rest/gitlab/GitLabCommit;", "projectId", "getRepoId", "isCommitThere", "", "ping", "youtrack-github-integration"})
public class GitLabRest
extends VcsRestClient<XdGitLabChangesProcessor> {
    @NotNull
    private WebTarget wr;

    @NotNull
    protected final WebTarget getWr() {
        return this.wr;
    }

    protected final void setWr(@NotNull WebTarget webTarget) {
        Intrinsics.checkParameterIsNotNull((Object)webTarget, (String)"<set-?>");
        this.wr = webTarget;
    }

    @NotNull
    protected String getApiPrefix() {
        return "api/v3";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> getBranches(@NotNull CredentialsDto creds, @NotNull String path) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)creds, (String)"creds");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        WebTarget webTarget = this.wr.path(this.getApiPrefix() + "/projects/" + path + "/repository/branches");
        Intrinsics.checkExpressionValueIsNotNull((Object)webTarget, (String)"wr.path(\"$apiPrefix/proj\u2026ath/repository/branches\")");
        GitLabBranches branches2 = this.get(this.addHeaders(webTarget, creds), GitLabBranches.class);
        Iterable iterable = $receiver$iv = (Iterable)branches2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            GitLabBranch gitLabBranch = (GitLabBranch)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getName();
            collection.add(string);
        }
        return CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv));
    }

    private final String getRepoId(String token, String path) {
        GitLabProject project;
        block22: {
            Object it;
            String groupFullName;
            List pathSegments;
            block18: {
                pathSegments = StringsKt.split$default((CharSequence)path, (String[])new String[]{"/"}, (boolean)false, (int)0, (int)6, null);
                project = null;
                Collection collection = pathSegments;
                if (collection.size() == 2) {
                    try {
                        Iterator iterator;
                        block19: {
                            VcsRestClient.Companion.getLogger().info((Function0)new Function0<String>(path){
                                final /* synthetic */ String $path;

                                @NotNull
                                public final String invoke() {
                                    return "Trying to retrieve " + this.$path + " as a user owned project";
                                }
                                {
                                    this.$path = string;
                                    super(0);
                                }
                            });
                            String username = (String)CollectionsKt.first((List)pathSegments);
                            WebTarget webTarget = this.wr.path(this.getApiPrefix() + "/users").queryParam("username", new Object[]{username});
                            Intrinsics.checkExpressionValueIsNotNull((Object)webTarget, (String)"wr.path(\"$apiPrefix/user\u2026ram(\"username\", username)");
                            Invocation.Builder builder = this.addHeaders(webTarget, token);
                            Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"addHeaders(wr.path(\"$api\u2026rname\", username), token)");
                            GitLabUsers users = this.get(builder, GitLabUsers.class);
                            if (users.isEmpty()) {
                                VcsRestClient.Companion.getLogger().info((Function0)getRepoId.2.INSTANCE);
                                break block18;
                            }
                            Collection collection2 = users;
                            if (collection2.size() > 1) {
                                VcsRestClient.Companion.getLogger().info((Function0)new Function0<String>(username){
                                    final /* synthetic */ String $username;

                                    @NotNull
                                    public final String invoke() {
                                        return "Retrieved more than one users with username " + this.$username;
                                    }
                                    {
                                        this.$username = string;
                                        super(0);
                                    }
                                });
                                break block18;
                            }
                            Long userId = ((GitLabUser)CollectionsKt.first((List)users)).getId();
                            WebTarget webTarget2 = this.wr.path(this.getApiPrefix() + "/users/" + userId + "/projects");
                            Intrinsics.checkExpressionValueIsNotNull((Object)webTarget2, (String)"wr.path(\"$apiPrefix/users/$userId/projects\")");
                            Invocation.Builder builder2 = this.addHeaders(this.addCommonSearchParams(webTarget2, (String)CollectionsKt.last((List)pathSegments)), token);
                            Intrinsics.checkExpressionValueIsNotNull((Object)builder2, (String)"addHeaders(addCommonSear\u2026hSegments.last()), token)");
                            GitLabProjects glps = this.get(builder2, GitLabProjects.class);
                            VcsRestClient.Companion.getLogger().info((Function0)new Function0<String>(glps){
                                final /* synthetic */ GitLabProjects $glps;

                                @NotNull
                                public final String invoke() {
                                    return "Retrieved a whole lot of " + this.$glps.size() + " project infos";
                                }
                                {
                                    this.$glps = gitLabProjects;
                                    super(0);
                                }
                            });
                            Iterable $receiver$iv = glps;
                            for (Iterator element$iv : $receiver$iv) {
                                GitLabProject it2 = (GitLabProject)((Object)element$iv);
                                boolean bl = false;
                                if (!StringsKt.equals((String)it2.getPath_with_namespace(), (String)path, (boolean)true)) continue;
                                iterator = element$iv;
                                break block19;
                            }
                            iterator = null;
                        }
                        project = (GitLabProject)((Object)iterator);
                        if (project == null) {
                            VcsRestClient.Companion.getLogger().error((Function0)new Function0<String>(path){
                                final /* synthetic */ String $path;

                                @NotNull
                                public final String invoke() {
                                    return "Found no matching project among retrieved. Will try to treat " + this.$path + " as a group project";
                                }
                                {
                                    this.$path = string;
                                    super(0);
                                }
                            });
                        }
                    }
                    catch (Exception e) {
                        if (e instanceof JerseyClientExceptionWrapper && ((JerseyClientExceptionWrapper)e).getCode() == Response.Status.NOT_FOUND.getStatusCode()) {
                            VcsRestClient.Companion.getLogger().info((Function0)new Function0<String>(path){
                                final /* synthetic */ String $path;

                                @NotNull
                                public final String invoke() {
                                    return "Received 404, thus " + this.$path + " seems to be a group project";
                                }
                                {
                                    this.$path = string;
                                    super(0);
                                }
                            });
                        }
                        VcsRestClient.Companion.getLogger().info((Throwable)e, (Function0)new Function0<String>(path){
                            final /* synthetic */ String $path;

                            @NotNull
                            public final String invoke() {
                                return "Received an unknown error will try to treat " + this.$path + " as a group project";
                            }
                            {
                                this.$path = string;
                                super(0);
                            }
                        });
                    }
                }
            }
            if (project != null) {
                return project.getId();
            }
            VcsRestClient.Companion.getLogger().info((Function0)new Function0<String>(path){
                final /* synthetic */ String $path;

                @NotNull
                public final String invoke() {
                    return "Trying to retrieve " + this.$path + " as a group owned project";
                }
                {
                    this.$path = string;
                    super(0);
                }
            });
            VcsRestClient.Companion.getLogger().info((Function0)getRepoId.10.INSTANCE);
            try {
                GitLabGroup foundGroup;
                Object v7;
                Object $receiver$iv;
                block20: {
                    Iterator element$iv;
                    VcsRestClient.Companion.getLogger().info((Function0)new Function0<String>(path){
                        final /* synthetic */ String $path;

                        @NotNull
                        public final String invoke() {
                            return "Trying to retrieve " + this.$path + " as a group owned project, by getting group id";
                        }
                        {
                            this.$path = string;
                            super(0);
                        }
                    });
                    groupFullName = CollectionsKt.joinToString$default((Iterable)CollectionsKt.dropLast((List)pathSegments, (int)1), (CharSequence)"/", null, null, (int)0, null, null, (int)62, null);
                    String groupName = (String)CollectionsKt.last((List)CollectionsKt.dropLast((List)pathSegments, (int)1));
                    WebTarget webTarget = this.wr.path(this.getApiPrefix() + "/groups");
                    Intrinsics.checkExpressionValueIsNotNull((Object)webTarget, (String)"wr.path(\"$apiPrefix/groups\")");
                    Invocation.Builder builder = this.addHeaders(this.addCommonSearchParams(webTarget, groupName), token);
                    Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"addHeaders(addCommonSear\u2026ups\"), groupName), token)");
                    GitLabGroups gitlabGroups = this.get(builder, GitLabGroups.class);
                    VcsRestClient.Companion.getLogger().info((Function0)new Function0<String>(gitlabGroups){
                        final /* synthetic */ GitLabGroups $gitlabGroups;

                        @NotNull
                        public final String invoke() {
                            return "Retrieved a whole lot of " + this.$gitlabGroups.size() + " groups infos";
                        }
                        {
                            this.$gitlabGroups = gitLabGroups;
                            super(0);
                        }
                    });
                    $receiver$iv = gitlabGroups;
                    element$iv = $receiver$iv.iterator();
                    while (element$iv.hasNext()) {
                        Object element$iv2 = element$iv.next();
                        GitLabGroup it3 = (GitLabGroup)element$iv2;
                        boolean bl = false;
                        if (!(Intrinsics.areEqual((Object)it3.getFullPath(), (Object)groupFullName) && Intrinsics.areEqual((Object)it3.getName(), (Object)groupName))) continue;
                        v7 = element$iv2;
                        break block20;
                    }
                    v7 = null;
                }
                GitLabGroup gitLabGroup = foundGroup = (GitLabGroup)v7;
                if (gitLabGroup != null) {
                    it = $receiver$iv = gitLabGroup;
                    boolean bl = false;
                    VcsRestClient.Companion.getLogger().info((Function0)new Function0<String>((GitLabGroup)it){
                        final /* synthetic */ GitLabGroup $it;

                        @NotNull
                        public final String invoke() {
                            return "Found group owning a project with id " + this.$it.getId();
                        }
                        {
                            this.$it = gitLabGroup;
                            super(0);
                        }
                    });
                }
                GitLabGroup gitLabGroup2 = foundGroup;
                groupFullName = gitLabGroup2 != null ? gitLabGroup2.getId() : null;
            }
            catch (Exception e) {
                VcsRestClient.Companion.getLogger().info((Throwable)e, (Function0)new Function0<String>(pathSegments){
                    final /* synthetic */ List $pathSegments;

                    @NotNull
                    public final String invoke() {
                        return "Failed to find group in gitlab by " + CollectionsKt.joinToString$default((Iterable)CollectionsKt.dropLast((List)this.$pathSegments, (int)1), (CharSequence)"/", null, null, (int)0, null, null, (int)62, null);
                    }
                    {
                        this.$pathSegments = list2;
                        super(0);
                    }
                });
                groupFullName = null;
            }
            String groupId2 = groupFullName;
            try {
                Object v13;
                block21: {
                    String string = groupId2;
                    if (string == null) {
                        string = CollectionsKt.joinToString$default((Iterable)CollectionsKt.dropLast((List)pathSegments, (int)1), (CharSequence)"%2F", null, null, (int)0, null, null, (int)62, null);
                    }
                    groupFullName = string;
                    WebTarget webTarget = this.wr.path(this.getApiPrefix() + "/groups/" + groupFullName + "/projects");
                    Intrinsics.checkExpressionValueIsNotNull((Object)webTarget, (String)"wr.path(\"$apiPrefix/grou\u2026$groupFullName/projects\")");
                    Invocation.Builder builder = this.addHeaders(this.addCommonSearchParams(webTarget, (String)CollectionsKt.last((List)pathSegments)), token);
                    Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"addHeaders(addCommonSear\u2026hSegments.last()), token)");
                    GitLabProjects glps = this.get(builder, GitLabProjects.class);
                    VcsRestClient.Companion.getLogger().info((Function0)new Function0<String>(glps){
                        final /* synthetic */ GitLabProjects $glps;

                        @NotNull
                        public final String invoke() {
                            return "Retrieved a whole lot of " + this.$glps.size() + " project infos";
                        }
                        {
                            this.$glps = gitLabProjects;
                            super(0);
                        }
                    });
                    Iterable $receiver$iv = glps;
                    for (Object element$iv : $receiver$iv) {
                        it = (GitLabProject)element$iv;
                        boolean bl = false;
                        if (!StringsKt.equals((String)((GitLabProject)it).getPath_with_namespace(), (String)path, (boolean)true)) continue;
                        v13 = element$iv;
                        break block21;
                    }
                    v13 = null;
                }
                project = v13;
                if (project == null) {
                    VcsRestClient.Companion.getLogger().error((Function0)new Function0<String>(path){
                        final /* synthetic */ String $path;

                        @NotNull
                        public final String invoke() {
                            return "Found no project matching " + this.$path + " among retrieved";
                        }
                        {
                            this.$path = string;
                            super(0);
                        }
                    });
                }
            }
            catch (Exception e) {
                VcsRestClient.Companion.getLogger().info((Throwable)e, (Function0)new Function0<String>(path){
                    final /* synthetic */ String $path;

                    @NotNull
                    public final String invoke() {
                        return "Received an error while trying to retrieve " + this.$path + " as a group project";
                    }
                    {
                        this.$path = string;
                        super(0);
                    }
                });
                if (!(e instanceof JerseyClientExceptionWrapper)) break block22;
                throw (Throwable)e;
            }
        }
        GitLabProject gitLabProject = project;
        return gitLabProject != null ? gitLabProject.getId() : null;
    }

    @NotNull
    public final WebTarget addCommonSearchParams(@NotNull WebTarget wt, @NotNull String search) {
        Intrinsics.checkParameterIsNotNull((Object)wt, (String)"wt");
        Intrinsics.checkParameterIsNotNull((Object)search, (String)"search");
        WebTarget webTarget = wt.queryParam("search", new Object[]{search}).queryParam("simple", new Object[]{"true"}).queryParam("per_page", new Object[]{"100"});
        Intrinsics.checkExpressionValueIsNotNull((Object)webTarget, (String)"wt.queryParam(\"search\", \u2026yParam(\"per_page\", \"100\")");
        return webTarget;
    }

    private final GitLabCommit getCommit(String token, String projectId, String hash) {
        return (GitLabCommit)VcsRestClientKt.getCommit(projectId, hash, (Function0)new Function0<GitLabCommit>(this, projectId, hash, token){
            final /* synthetic */ GitLabRest this$0;
            final /* synthetic */ String $projectId;
            final /* synthetic */ String $hash;
            final /* synthetic */ String $token;

            @NotNull
            public final GitLabCommit invoke() {
                WebTarget webTarget = this.this$0.getWr().path(this.this$0.getApiPrefix() + "/projects/" + this.$projectId + "/repository/commits/" + this.$hash);
                Intrinsics.checkExpressionValueIsNotNull((Object)webTarget, (String)"wr.path(\"$apiPrefix/proj\u2026epository/commits/$hash\")");
                Invocation.Builder builder = this.this$0.addHeaders(webTarget, this.$token);
                Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"addHeaders(wr.path(\"$api\u2026y/commits/$hash\"), token)");
                return this.this$0.get(builder, GitLabCommit.class);
            }
            {
                this.this$0 = gitLabRest;
                this.$projectId = string;
                this.$hash = string2;
                this.$token = string3;
                super(0);
            }
        });
    }

    protected final Invocation.Builder addHeaders(@NotNull WebTarget wr, @Nullable String token) {
        Intrinsics.checkParameterIsNotNull((Object)wr, (String)"wr");
        return VcsRestClientKt.getStandardHeaders(wr).header("PRIVATE-TOKEN", (Object)token);
    }

    @Override
    @NotNull
    public String createHook(@NotNull XdGitLabChangesProcessor changesProcessor, @NotNull String hookReceiverId) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)changesProcessor), (String)"changesProcessor");
        Intrinsics.checkParameterIsNotNull((Object)hookReceiverId, (String)"hookReceiverId");
        try {
            if (changesProcessor.getId() == null) {
                String string = changesProcessor.getPath();
                if (string == null) {
                    throw (Throwable)new IllegalArgumentException("No url for changes processor");
                }
                changesProcessor.setId(this.getRepoId(changesProcessor.getToken(), string));
                if (changesProcessor.getId() == null) {
                    throw (Throwable)new LocalizedLogicException((Localization)new LocalizationObject("GitLabChangesProcessor.The_specified_URL_does_not_point_to_a_GitLab_repository", new Object[0]));
                }
            }
            String url = this.getLandingUrl() + "/rest/vcsHooksReceiver/gitlab?apiKey=" + hookReceiverId;
            WebTarget webTarget = this.wr.path(this.getApiPrefix() + "/projects/" + changesProcessor.getId() + "/hooks");
            Intrinsics.checkExpressionValueIsNotNull((Object)webTarget, (String)"wr.path(\"$apiPrefix/proj\u2026ngesProcessor.id}/hooks\")");
            Invocation.Builder builder = this.addHeaders(webTarget, changesProcessor.getToken());
            Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"addHeaders(wr.path(\"$api\u2026, changesProcessor.token)");
            Entity entity = Entity.entity((Object)("push_events=true&url=" + url), (String)"application/x-www-form-urlencoded");
            Intrinsics.checkExpressionValueIsNotNull((Object)entity, (String)"javax.ws.rs.client.Entit\u2026LICATION_FORM_URLENCODED)");
            return String.valueOf(this.post(builder, entity, GitLabHook.class).getId());
        }
        catch (JerseyClientExceptionWrapper e) {
            if (e.getCode() == 422) {
                throw (Throwable)new LocalizedLogicException((Localization)new LocalizationObject("GitLabChangesProcessor.Received_the_following_error_when_creating_a_hook_{0}_The_most_probable_reason_is_described_{1}", new Object[]{e.getLocalizedMessage(), BaseHtmlStringUtil.html((Object)jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("GitLabChangesProcessor.{0}here{1}", new Object[]{"<a href='" + DocumentationLink.ROOT.getUrl() + "/Integration-with-GitLab.html#422-unprocessable-entity' class=\"ring-link\">", "</>"}))}));
            }
            if (e.getCode() == 404) {
                throw (Throwable)new LocalizedLogicException((Localization)new LocalizationObject("GitLabChangesProcessor.Received_{0}_from_GitLab_server_Please_make_sure_the_URL_is_correct_and_the_user_has_access_to_the_repository", new Object[]{"NOT_FOUND"}));
            }
            throw (Throwable)new LocalizedLogicException((Localization)new LocalizationObject("GitLabChangesProcessor.Received_the_following_error_when_creating_a_hook_{0}", new Object[]{e.getLocalizedMessage()}));
        }
    }

    @NotNull
    protected final Invocation.Builder addHeaders(@NotNull WebTarget wr, @NotNull CredentialsDto creds) {
        Intrinsics.checkParameterIsNotNull((Object)wr, (String)"wr");
        Intrinsics.checkParameterIsNotNull((Object)creds, (String)"creds");
        Invocation.Builder builder = this.addHeaders(wr, creds.getToken());
        Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"addHeaders(wr, creds.token)");
        return builder;
    }

    @Override
    public void deleteHook(@NotNull XdGitLabChangesProcessor changesProcessor, @NotNull CredentialsDto creds) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)changesProcessor), (String)"changesProcessor");
        Intrinsics.checkParameterIsNotNull((Object)creds, (String)"creds");
        WebTarget webTarget = this.wr.path(this.getApiPrefix() + "/projects/" + changesProcessor.getId() + "/hooks/" + changesProcessor.getHookId());
        Intrinsics.checkExpressionValueIsNotNull((Object)webTarget, (String)"wr.path(\"$apiPrefix/proj\u2026hangesProcessor.hookId}\")");
        Invocation.Builder builder = this.addHeaders(webTarget, creds.getToken());
        Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"addHeaders(wr.path(\"$api\u2026r.hookId}\"), creds.token)");
        this.delete(builder);
    }

    @Override
    @Nullable
    public CommonChangeDTO getCommit(@NotNull XdGitLabChangesProcessor changesProcessor, @NotNull String hash) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)changesProcessor), (String)"changesProcessor");
        Intrinsics.checkParameterIsNotNull((Object)hash, (String)"hash");
        String string = changesProcessor.getId();
        if (string == null) {
            throw (Throwable)new IllegalArgumentException("No project id is available, nowhere to add");
        }
        String projectId = string;
        GitLabCommit gitLabCommit = this.getCommit(changesProcessor.getToken(), projectId, hash);
        if (gitLabCommit == null) {
            return null;
        }
        GitLabCommit commit = gitLabCommit;
        return BeansKt.getGitLabService().toDto((XdVcsHostingChangesProcessor)changesProcessor, commit, false);
    }

    @Override
    public boolean isCommitThere(@NotNull XdGitLabChangesProcessor changesProcessor, @NotNull String hash) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)changesProcessor), (String)"changesProcessor");
        Intrinsics.checkParameterIsNotNull((Object)hash, (String)"hash");
        String string = changesProcessor.getToken();
        String string2 = changesProcessor.getId();
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        return this.getCommit(string, string2, hash) != null;
    }

    @Override
    public void ping(@NotNull XdGitLabChangesProcessor changesProcessor) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)changesProcessor), (String)"changesProcessor");
        WebTarget webTarget = this.wr.path(this.getApiPrefix() + "/projects/" + changesProcessor.getId() + "/hooks");
        Intrinsics.checkExpressionValueIsNotNull((Object)webTarget, (String)"wr.path(\"$apiPrefix/proj\u2026ngesProcessor.id}/hooks\")");
        Invocation.Builder builder = this.addHeaders(webTarget, changesProcessor.getToken());
        Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"addHeaders(wr.path(\"$api\u2026, changesProcessor.token)");
        this.get(builder, (GenericType)new GenericType<List<? extends GitLabHook>>(){});
    }

    public GitLabRest(@NotNull String url, @Nullable XdStorageEntry sslKey) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        super(url, sslKey);
        WebTarget webTarget = VcsRestClientKt.buildWebTarget(url, sslKey);
        Intrinsics.checkExpressionValueIsNotNull((Object)webTarget, (String)"buildWebTarget(url, sslKey)");
        this.wr = webTarget;
    }
}

