/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.integration.vcs.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jetbrains.charisma.persistence.customfields.BeansKt;
import jetbrains.charisma.persistent.UserActionJobContainer;
import jetbrains.exodus.database.TransientEntityStore;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.integration.github.persistence.XdBitBucketChangesProcessor;
import jetbrains.youtrack.integration.github.persistence.XdVcsHostingChangesProcessor;
import jetbrains.youtrack.integration.persistence.XdNoUserReason;
import jetbrains.youtrack.integration.persistence.XdVcsChange;
import jetbrains.youtrack.integration.persistence.XdVcsChangeProcessor;
import jetbrains.youtrack.integration.service.UserResolution;
import jetbrains.youtrack.integration.service.VcsService;
import jetbrains.youtrack.integration.vcs.CommonChangeDTO;
import jetbrains.youtrack.integration.vcs.dtos.BitBucketChangeDTO;
import jetbrains.youtrack.integration.vcs.rest.bitbucket.BitBucket20Changes;
import jetbrains.youtrack.integration.vcs.rest.bitbucket.BitBucket20Commit;
import jetbrains.youtrack.integration.vcs.rest.bitbucket.BitBucket20ReferenceState;
import jetbrains.youtrack.integration.vcs.rest.bitbucket.BitBucket20Repository;
import jetbrains.youtrack.integration.vcs.rest.bitbucket.BitBucket20User;
import jetbrains.youtrack.integration.vcs.rest.bitbucket.BitBucketRest;
import jetbrains.youtrack.integration.vcs.service.BitBucketService;
import jetbrains.youtrack.integration.vcs.service.BitBucketService$processTruncatedPayload$1$$special$;
import jetbrains.youtrack.integration.vcs.service.VcsHostingService;
import jetbrains.youtrack.persistent.XdUser;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

@Service(value="bitBucketService")
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 $2 \u0012\u0004\u0012\u00020\u0002\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0004\u0012\u00020\u00060\u0001:\u0001$B\u0005\u00a2\u0006\u0002\u0010\u0007J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0013\u001a\u00020\tH\u0002J\u001c\u0010\u0014\u001a\u00020\t2\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u0014J\"\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u00172\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u0014J&\u0010\u0018\u001a\u0004\u0018\u00010\t2\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u0006\u0010\u000f\u001a\u00020\u0002H\u0014J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0002H\u0014J\u0010\u0010\u001c\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0006H\u0014J,\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000f\u001a\u00020\u00022\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u0006\u0010\u001f\u001a\u00020\tH\u0016J\u0018\u0010 \u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0006H\u0016J\u0010\u0010!\u001a\u00020\r2\u0006\u0010\"\u001a\u00020#H\u0016R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006%"}, d2={"Ljetbrains/youtrack/integration/vcs/service/BitBucketService;", "Ljetbrains/youtrack/integration/vcs/service/VcsHostingService;", "Ljetbrains/youtrack/integration/github/persistence/XdBitBucketChangesProcessor;", "Lkotlin/Pair;", "Ljetbrains/youtrack/integration/vcs/rest/bitbucket/BitBucket20Changes;", "Ljetbrains/youtrack/integration/vcs/rest/bitbucket/BitBucket20Repository;", "Ljetbrains/youtrack/integration/vcs/rest/bitbucket/BitBucket20Commit;", "()V", "integrationType", "", "getIntegrationType", "()Ljava/lang/String;", "createDto", "Ljetbrains/youtrack/integration/vcs/dtos/BitBucketChangeDTO;", "commit", "processor", "userResolution", "Ljetbrains/youtrack/integration/service/UserResolution;", "extractEmail", "rawAuthor", "getBranch", "payload", "getCommits", "", "getRepositoryPath", "getRest", "Ljetbrains/youtrack/integration/vcs/rest/bitbucket/BitBucketRest;", "changesProcessor", "getVersion", "processTruncatedPayload", "", "branch", "resolveUser", "toDto", "vcsChange", "Ljetbrains/youtrack/integration/persistence/XdVcsChange;", "Companion", "youtrack-github-integration"})
public final class BitBucketService
extends VcsHostingService<XdBitBucketChangesProcessor, Pair<? extends BitBucket20Changes, ? extends BitBucket20Repository>, BitBucket20Commit> {
    @NotNull
    private final String integrationType = "BitBucket";
    private static final Pattern EMAIL_PATTERN;
    public static final Companion Companion;

    @NotNull
    public String getIntegrationType() {
        return this.integrationType;
    }

    @Override
    @NotNull
    protected String getBranch(@NotNull Pair<? extends BitBucket20Changes, ? extends BitBucket20Repository> payload) {
        Intrinsics.checkParameterIsNotNull(payload, (String)"payload");
        Object object = ((BitBucket20Changes)payload.getFirst()).getNew();
        if (object == null || (object = ((BitBucket20ReferenceState)object).getName()) == null) {
            object = "master";
        }
        return object;
    }

    @Override
    @Nullable
    protected String getRepositoryPath(@NotNull Pair<? extends BitBucket20Changes, ? extends BitBucket20Repository> payload, @NotNull XdBitBucketChangesProcessor processor2) {
        Intrinsics.checkParameterIsNotNull(payload, (String)"payload");
        Intrinsics.checkParameterIsNotNull((Object)((Object)processor2), (String)"processor");
        return ((BitBucket20Repository)payload.getSecond()).getFullName();
    }

    @Override
    @NotNull
    protected List<BitBucket20Commit> getCommits(@NotNull Pair<? extends BitBucket20Changes, ? extends BitBucket20Repository> payload) {
        List<BitBucket20Commit> list2;
        Intrinsics.checkParameterIsNotNull(payload, (String)"payload");
        List<BitBucket20Commit> commits = list2 = ((BitBucket20Changes)payload.getFirst()).getCommits();
        boolean bl = false;
        String branch = this.getBranch(payload);
        Iterable $receiver$iv = commits;
        for (Object element$iv : $receiver$iv) {
            BitBucket20Commit it = (BitBucket20Commit)element$iv;
            boolean bl2 = false;
            it.setBranch(branch);
        }
        return list2;
    }

    @Override
    public void processTruncatedPayload(@NotNull XdBitBucketChangesProcessor processor2, @NotNull Pair<? extends BitBucket20Changes, ? extends BitBucket20Repository> payload, @NotNull String branch) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)processor2), (String)"processor");
        Intrinsics.checkParameterIsNotNull(payload, (String)"payload");
        Intrinsics.checkParameterIsNotNull((Object)branch, (String)"branch");
        if (((BitBucket20Changes)payload.getFirst()).getTruncated()) {
            VcsService.Companion.getLogger().info("Webhook commits were truncated, starting job to load them");
            UserActionJobContainer userActionJobContainer = BeansKt.getUserActionJobContainer();
            Runnable runnable = new Runnable(this, processor2, payload, branch){
                final /* synthetic */ BitBucketService this$0;
                final /* synthetic */ XdBitBucketChangesProcessor $processor;
                final /* synthetic */ Pair $payload;
                final /* synthetic */ String $branch;

                public final void run() {
                    boolean $i$f$transactional = false;
                    BitBucketRest rest = (BitBucketRest)TransientEntityStore.DefaultImpls.transactional$default((TransientEntityStore)DnqUtils.getTransientStore(), (boolean)false, null, (boolean)false, (Function1)((Function1)new Function1<TransientStoreSession, BitBucketRest>(this){
                        final /* synthetic */ processTruncatedPayload.1 this$0;
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }

                        public final BitBucketRest invoke(@NotNull TransientStoreSession it) {
                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                            boolean bl = false;
                            return this.this$0.this$0.getRest(this.this$0.$processor);
                        }
                    }), (int)7, null);
                    Collection<BitBucket20Commit> commits = rest.getCommitsRange(this.$processor, ((BitBucket20Changes)this.$payload.getFirst()).getOld(), (BitBucket20Commit)CollectionsKt.last(((BitBucket20Changes)this.$payload.getFirst()).getCommits()), this.$branch);
                    VcsService.Companion.getLogger().info("Loaded " + commits.size() + " commits that were truncated");
                    boolean $i$f$transactional2 = false;
                    TransientEntityStore.DefaultImpls.transactional$default((TransientEntityStore)DnqUtils.getTransientStore(), (boolean)false, null, (boolean)false, (Function1)((Function1)new Function1<TransientStoreSession, Unit>(this, commits){
                        final /* synthetic */ processTruncatedPayload.1 this$0;
                        final /* synthetic */ Collection $commits$inlined;
                        {
                            this.this$0 = var1_1;
                            this.$commits$inlined = collection;
                            super(1);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final Unit invoke(@NotNull TransientStoreSession it) {
                            void finished;
                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                            boolean bl = false;
                            Ref.BooleanRef booleanRef = new Ref.BooleanRef();
                            booleanRef.element = false;
                            this.this$0.$processor.process((Function1)new Function1<XdVcsChangeProcessor, List<? extends CommonChangeDTO>>((Ref.BooleanRef)finished, this){
                                final /* synthetic */ Ref.BooleanRef $finished;
                                final /* synthetic */ processTruncatedPayload$1$$special$$inlined$transactional$2 this$0;
                                {
                                    this.$finished = booleanRef;
                                    this.this$0 = var2_2;
                                    super(1);
                                }

                                /*
                                 * WARNING - void declaration
                                 */
                                @NotNull
                                public final List<CommonChangeDTO> invoke(@NotNull XdVcsChangeProcessor it) {
                                    List list2;
                                    void $receiver$iv$iv;
                                    Iterable $receiver$iv;
                                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                                    if (this.$finished.element) {
                                        return CollectionsKt.emptyList();
                                    }
                                    Iterable iterable = $receiver$iv = (Iterable)this.this$0.$commits$inlined;
                                    Collection destination$iv$iv = new ArrayList<E>();
                                    void $receiver$iv$iv$iv = $receiver$iv$iv;
                                    Iterator<T> iterator = $receiver$iv$iv$iv.iterator();
                                    while (iterator.hasNext()) {
                                        CommonChangeDTO commonChangeDTO;
                                        T element$iv$iv$iv;
                                        T element$iv$iv = element$iv$iv$iv = iterator.next();
                                        BitBucket20Commit it2 = (BitBucket20Commit)element$iv$iv;
                                        boolean bl = false;
                                        BitBucket20Commit bitBucket20Commit = it2;
                                        XdVcsHostingChangesProcessor xdVcsHostingChangesProcessor = this.this$0.this$0.$processor;
                                        BitBucketService bitBucketService = this.this$0.this$0.this$0;
                                        BitBucket20Commit it3 = bitBucket20Commit;
                                        boolean bl2 = false;
                                        it3.setBranch(this.this$0.this$0.$branch);
                                        BitBucket20Commit bitBucket20Commit2 = bitBucket20Commit;
                                        if (bitBucketService.toDto(xdVcsHostingChangesProcessor, bitBucket20Commit2, true) == null) continue;
                                        CommonChangeDTO it$iv$iv = commonChangeDTO;
                                        destination$iv$iv.add(it$iv$iv);
                                    }
                                    List $receiver = list2 = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
                                    boolean bl = false;
                                    this.$finished.element = true;
                                    return list2;
                                }
                            });
                            return Unit.INSTANCE;
                        }
                    }), (int)7, null);
                }
                {
                    this.this$0 = bitBucketService;
                    this.$processor = xdBitBucketChangesProcessor;
                    this.$payload = pair;
                    this.$branch = string;
                }
            };
            StringBuilder stringBuilder = new StringBuilder().append("Loading truncated comments for push ");
            BitBucket20ReferenceState bitBucket20ReferenceState = ((BitBucket20Changes)payload.getFirst()).getNew();
            if (bitBucket20ReferenceState == null) {
                Intrinsics.throwNpe();
            }
            BitBucket20Commit bitBucket20Commit = bitBucket20ReferenceState.getTarget();
            if (bitBucket20Commit == null) {
                Intrinsics.throwNpe();
            }
            userActionJobContainer.getOrCreateJob(runnable, stringBuilder.append(bitBucket20Commit.getHash()).toString(), new Entity[]{processor2.getEntity()});
        }
    }

    @NotNull
    protected BitBucketChangeDTO createDto(@NotNull BitBucket20Commit commit, @NotNull XdBitBucketChangesProcessor processor2, @NotNull UserResolution userResolution) {
        Intrinsics.checkParameterIsNotNull((Object)commit, (String)"commit");
        Intrinsics.checkParameterIsNotNull((Object)((Object)processor2), (String)"processor");
        Intrinsics.checkParameterIsNotNull((Object)userResolution, (String)"userResolution");
        XdUser xdUser = userResolution.getUser();
        Object object = xdUser != null ? xdUser.getEntity() : null;
        XdNoUserReason xdNoUserReason = userResolution.getNoUserReason();
        Object object2 = xdNoUserReason != null ? xdNoUserReason.getEntity() : null;
        Entity entity = processor2.getEntity();
        String string = userResolution.getVcsUser();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return new BitBucketChangeDTO(null, (Entity)object, (Entity)object2, commit, entity, string);
    }

    @Override
    @NotNull
    protected String getVersion(@NotNull BitBucket20Commit commit) {
        Intrinsics.checkParameterIsNotNull((Object)commit, (String)"commit");
        return commit.getHash();
    }

    @NotNull
    public BitBucketChangeDTO toDto(@NotNull XdVcsChange vcsChange) {
        BitBucketChangeDTO bitBucketChangeDTO;
        Intrinsics.checkParameterIsNotNull((Object)vcsChange, (String)"vcsChange");
        BitBucketChangeDTO $receiver = bitBucketChangeDTO = new BitBucketChangeDTO();
        boolean bl = false;
        this.tweakChangeDto(vcsChange, $receiver);
        $receiver.id = vcsChange.getVersion();
        return bitBucketChangeDTO;
    }

    @Override
    @NotNull
    public UserResolution resolveUser(@NotNull XdBitBucketChangesProcessor processor2, @NotNull BitBucket20Commit commit) {
        String fromEmail;
        String string;
        CharSequence charSequence;
        Intrinsics.checkParameterIsNotNull((Object)((Object)processor2), (String)"processor");
        Intrinsics.checkParameterIsNotNull((Object)commit, (String)"commit");
        BitBucket20User bitBucket20User = commit.getAuthor().getUser();
        String author = bitBucket20User != null ? bitBucket20User.getNickname() : null;
        String rawAuthor = commit.getAuthor().getRaw();
        CharSequence charSequence2 = rawAuthor;
        if (charSequence2 == null || charSequence2.length() == 0) {
            return new UserResolution(null, author, XdNoUserReason.Companion.getBITBUCKET_NO_USER_INFO_PROVIDED());
        }
        String string2 = rawAuthor;
        if (string2 != null) {
            charSequence = string2;
            String it = charSequence;
            boolean bl = false;
            string = this.extractEmail(it);
        } else {
            string = fromEmail = null;
        }
        if (fromEmail == null || (charSequence = (CharSequence)fromEmail).length() == 0) {
            return new UserResolution(null, author, XdNoUserReason.Companion.getBITBUCKET_NO_RAW_EMAIL());
        }
        return this.resolveUser((XdVcsHostingChangesProcessor)processor2, author, fromEmail, XdNoUserReason.Companion.getBITBUCKET_NO_USER_FOUND_IN_YOUTRACK(), XdNoUserReason.Companion.getBITBUCKET_USER_NOT_UNIQUE(), XdNoUserReason.Companion.getVCS_NOT_IN_COMMITTERS_GROUP());
    }

    @NotNull
    protected BitBucketRest getRest(@NotNull XdBitBucketChangesProcessor changesProcessor) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)changesProcessor), (String)"changesProcessor");
        return new BitBucketRest(changesProcessor.getServer().getUrl(), changesProcessor.getServer().getSslKey());
    }

    private final String extractEmail(String rawAuthor) {
        Matcher matcher = EMAIL_PATTERN.matcher(rawAuthor);
        return matcher.find() ? matcher.group() : null;
    }

    static {
        Companion = new Companion(null);
        EMAIL_PATTERN = Pattern.compile("(([a-z0-9!#$%&'*+/=?^_`{|}~.-]+)@[a-z0-9]([a-z0-9-]*[a-z0-9])?(\\.[a-z0-9]([a-z0-9-]*[a-z0-9])?)*)", 2);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ljetbrains/youtrack/integration/vcs/service/BitBucketService$Companion;", "", "()V", "EMAIL_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "youtrack-github-integration"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

