/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.integration.vcs.service;

import java.util.List;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.youtrack.integration.github.persistence.XdGithubChangesProcessor;
import jetbrains.youtrack.integration.github.persistence.XdVcsHostingChangesProcessor;
import jetbrains.youtrack.integration.persistence.XdNoUserReason;
import jetbrains.youtrack.integration.persistence.XdVcsChange;
import jetbrains.youtrack.integration.service.UserResolution;
import jetbrains.youtrack.integration.vcs.dtos.GitHubChangeDTO;
import jetbrains.youtrack.integration.vcs.rest.VcsRestClient;
import jetbrains.youtrack.integration.vcs.rest.github.GitHubPushPayload;
import jetbrains.youtrack.integration.vcs.rest.github.GitHubRepository;
import jetbrains.youtrack.integration.vcs.rest.github.GitHubRest;
import jetbrains.youtrack.integration.vcs.service.VcsHostingService;
import jetbrains.youtrack.persistent.XdUser;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.egit.github.core.Commit;
import org.eclipse.egit.github.core.CommitUser;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service(value="gitHubService")
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\u0005\u00a2\u0006\u0002\u0010\u0005J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0003H\u0014J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u00152\u0006\u0010\u0013\u001a\u00020\u0003H\u0014J\u0018\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0002H\u0014J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0002H\u0014J\u0010\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0004H\u0014J\u0018\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0004H\u0016J\u0010\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00078TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u001f"}, d2={"Ljetbrains/youtrack/integration/vcs/service/GitHubService;", "Ljetbrains/youtrack/integration/vcs/service/VcsHostingService;", "Ljetbrains/youtrack/integration/github/persistence/XdGithubChangesProcessor;", "Ljetbrains/youtrack/integration/vcs/rest/github/GitHubPushPayload;", "Lorg/eclipse/egit/github/core/Commit;", "()V", "integrationType", "", "getIntegrationType", "()Ljava/lang/String;", "systemPropertyName", "getSystemPropertyName", "createDto", "Ljetbrains/youtrack/integration/vcs/dtos/GitHubChangeDTO;", "commit", "processor", "userResolution", "Ljetbrains/youtrack/integration/service/UserResolution;", "getBranch", "payload", "getCommits", "", "getRepositoryPath", "getRest", "Ljetbrains/youtrack/integration/vcs/rest/VcsRestClient;", "changesProcessor", "getVersion", "resolveUser", "toDto", "vcsChange", "Ljetbrains/youtrack/integration/persistence/XdVcsChange;", "youtrack-github-integration"})
public final class GitHubService
extends VcsHostingService<XdGithubChangesProcessor, GitHubPushPayload, Commit> {
    @NotNull
    private final String integrationType = "GitHub";

    @NotNull
    public String getIntegrationType() {
        return this.integrationType;
    }

    @Override
    @NotNull
    protected String getBranch(@NotNull GitHubPushPayload payload) {
        Intrinsics.checkParameterIsNotNull((Object)payload, (String)"payload");
        String string = payload.getRef();
        if (string == null) {
            string = "";
        }
        return string;
    }

    @Override
    @NotNull
    protected String getRepositoryPath(@NotNull GitHubPushPayload payload, @NotNull XdGithubChangesProcessor processor2) {
        Intrinsics.checkParameterIsNotNull((Object)payload, (String)"payload");
        Intrinsics.checkParameterIsNotNull((Object)((Object)processor2), (String)"processor");
        Object object = payload.getRepository();
        if (object == null || (object = ((GitHubRepository)object).getFullName()) == null) {
            object = "";
        }
        return object;
    }

    @Override
    @NotNull
    protected List<Commit> getCommits(@NotNull GitHubPushPayload payload) {
        Intrinsics.checkParameterIsNotNull((Object)payload, (String)"payload");
        List list2 = payload.getCommits();
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    @NotNull
    protected GitHubChangeDTO createDto(@NotNull Commit commit, @NotNull XdGithubChangesProcessor processor2, @NotNull UserResolution userResolution) {
        Intrinsics.checkParameterIsNotNull((Object)commit, (String)"commit");
        Intrinsics.checkParameterIsNotNull((Object)((Object)processor2), (String)"processor");
        Intrinsics.checkParameterIsNotNull((Object)userResolution, (String)"userResolution");
        XdUser xdUser = userResolution.getUser();
        XdNoUserReason xdNoUserReason = userResolution.getNoUserReason();
        return new GitHubChangeDTO(null, (Entity)(xdUser != null ? xdUser.getEntity() : null), (Entity)(xdNoUserReason != null ? xdNoUserReason.getEntity() : null), null, commit, processor2.getEntity());
    }

    @NotNull
    public GitHubChangeDTO toDto(@NotNull XdVcsChange vcsChange) {
        GitHubChangeDTO gitHubChangeDTO;
        Intrinsics.checkParameterIsNotNull((Object)vcsChange, (String)"vcsChange");
        GitHubChangeDTO $receiver = gitHubChangeDTO = new GitHubChangeDTO();
        boolean bl = false;
        this.tweakChangeDto(vcsChange, $receiver);
        $receiver.id = vcsChange.getVersion();
        return gitHubChangeDTO;
    }

    @Override
    @NotNull
    protected String getVersion(@NotNull Commit commit) {
        Intrinsics.checkParameterIsNotNull((Object)commit, (String)"commit");
        String string = commit.getSha();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"commit.sha");
        return string;
    }

    @Override
    @NotNull
    public UserResolution resolveUser(@NotNull XdGithubChangesProcessor processor2, @NotNull Commit commit) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)processor2), (String)"processor");
        Intrinsics.checkParameterIsNotNull((Object)commit, (String)"commit");
        CommitUser commitUser = commit.getAuthor();
        if (commitUser == null) {
            return new UserResolution(null, null, XdNoUserReason.Companion.getGITHUB_NO_USER_INFO_PROVIDED());
        }
        CommitUser author = commitUser;
        String authorEmail = author.getEmail();
        CharSequence charSequence = authorEmail;
        if (charSequence == null || charSequence.length() == 0) {
            return new UserResolution(null, author.getName(), XdNoUserReason.Companion.getGITHUB_NO_EMAIL());
        }
        return this.resolveUser((XdVcsHostingChangesProcessor)processor2, author.getName(), authorEmail, XdNoUserReason.Companion.getGITHUB_NO_USER_FOUND_IN_YOUTRACK(), XdNoUserReason.Companion.getGITHUB_USER_NOT_UNIQUE(), XdNoUserReason.Companion.getVCS_NOT_IN_COMMITTERS_GROUP());
    }

    @Override
    @NotNull
    protected VcsRestClient<XdGithubChangesProcessor> getRest(@NotNull XdGithubChangesProcessor changesProcessor) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)changesProcessor), (String)"changesProcessor");
        return new GitHubRest(changesProcessor.getServer().getUrl(), changesProcessor.getServer().getSslKey());
    }

    @NotNull
    protected String getSystemPropertyName() {
        return "jetbrains.youtrack.disableGithubIntegration";
    }
}

